/*
 * Decompiled with CFR 0.152.
 */
package aterm.pure;

import aterm.AFun;
import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import aterm.ATermPlaceholder;
import aterm.Visitor;
import aterm.pure.ATermImpl;
import aterm.pure.PureFactory;
import java.util.List;
import java.util.Vector;
import jjtraveler.VisitFailure;
import shared.SharedObject;

class ATermListImpl
extends ATermImpl
implements ATermList {
    ATerm first;
    ATermList next;
    int length;

    ATermListImpl() {
    }

    public int getType() {
        return 4;
    }

    protected void init(int hashCode, ATermList annos, ATerm first, ATermList next) {
        super.init(hashCode, annos);
        this.first = first;
        this.next = next;
        this.length = first == null && next == null ? 0 : 1 + next.getLength();
    }

    protected void initHashCode(ATermList annos, ATerm first, ATermList next) {
        this.first = first;
        this.next = next;
        this.internSetAnnotations(annos);
        this.setHashCode(this.hashFunction());
        this.length = first == null && next == null ? 0 : 1 + next.getLength();
    }

    public SharedObject duplicate() {
        ATermListImpl clone = new ATermListImpl();
        clone.init(this.hashCode(), this.getAnnotations(), this.first, this.next);
        return clone;
    }

    public boolean equivalent(SharedObject obj) {
        ATermList peer;
        if (super.equivalent(obj) && (peer = (ATermList)((Object)obj)).getLength() == this.length) {
            return peer.getFirst().equals(this.first) && peer.getNext().equals(this.next);
        }
        return false;
    }

    protected boolean match(ATerm pattern, List list) {
        if (pattern == null) {
            System.err.println("???");
        }
        if (pattern.getType() == 4) {
            ATermAppl appl;
            ATerm ph_type;
            ATermList l = (ATermList)pattern;
            if (l == PureFactory.empty) {
                return this == PureFactory.empty;
            }
            if (l.getFirst().getType() == 5 && (ph_type = ((ATermPlaceholder)l.getFirst()).getPlaceholder()).getType() == 3 && (appl = (ATermAppl)ph_type).getName().equals("list") && appl.getArguments().isEmpty()) {
                list.add(this);
                return true;
            }
            if (!this.isEmpty()) {
                List submatches = this.first.match(l.getFirst());
                if (submatches == null) {
                    return false;
                }
                list.addAll(submatches);
                submatches = this.next.match(l.getNext());
                if (submatches == null) {
                    return false;
                }
                list.addAll(submatches);
                return true;
            }
            return l.isEmpty();
        }
        return super.match(pattern, list);
    }

    public ATerm make(List args) {
        if (this.first == null) {
            return this;
        }
        ATerm head = this.first.make(args);
        ATermList tail = (ATermList)this.next.make(args);
        if (this.isListPlaceHolder(this.first)) {
            return head;
        }
        return this.getPureFactory().makeList(head, tail);
    }

    private boolean isListPlaceHolder(ATerm pattern) {
        ATermAppl appl;
        AFun afun;
        ATerm type;
        return pattern.getType() == 5 && (type = ((ATermPlaceholder)pattern).getPlaceholder()).getType() == 3 && (afun = (appl = (ATermAppl)type).getAFun()).getName().equals("list") && afun.getArity() == 0 && !afun.isQuoted();
    }

    public boolean isEmpty() {
        return this == PureFactory.empty;
    }

    public int getLength() {
        return this.length;
    }

    public ATerm getFirst() {
        return this.first;
    }

    public ATermList getNext() {
        return this.next;
    }

    public ATerm getLast() {
        ATermList cur = this;
        while (cur.getNext() != PureFactory.empty) {
            cur = cur.getNext();
        }
        return cur.getFirst();
    }

    public int indexOf(ATerm el, int start) {
        if (start < 0) {
            start += this.length + 1;
        }
        if (start > this.length) {
            throw new IllegalArgumentException("start (" + start + ") > length of list (" + this.length + ")");
        }
        ATermList cur = this;
        int i = 0;
        while (i < start) {
            cur = cur.getNext();
            ++i;
        }
        while (cur != PureFactory.empty && cur.getFirst() != el) {
            cur = cur.getNext();
            ++i;
        }
        return cur == PureFactory.empty ? -1 : i;
    }

    public int lastIndexOf(ATerm el, int start) {
        int result;
        if (start < 0) {
            start += this.length + 1;
        }
        if (start > this.length) {
            throw new IllegalArgumentException("start (" + start + ") > length of list (" + this.length + ")");
        }
        if (start > 0 && (result = this.next.lastIndexOf(el, start - 1)) >= 0) {
            return result + 1;
        }
        if (this.first == el) {
            return 0;
        }
        return -1;
    }

    public ATermList concat(ATermList rhs) {
        if (this.isEmpty()) {
            return rhs;
        }
        if (this.next == PureFactory.empty) {
            return this.getPureFactory().makeList(this.first, rhs);
        }
        return this.getPureFactory().makeList(this.first, this.next.concat(rhs));
    }

    public ATermList append(ATerm el) {
        return this.concat(this.getPureFactory().makeList(el, PureFactory.empty));
    }

    public ATerm elementAt(int index) {
        if (index < 0 || index > this.length) {
            throw new IllegalArgumentException("illegal list index: " + index);
        }
        ATermList cur = this;
        int i = 0;
        while (i < index) {
            cur = cur.getNext();
            ++i;
        }
        return cur.getFirst();
    }

    public ATermList remove(ATerm el) {
        if (this.first == el) {
            return this.next;
        }
        ATermList result = this.next.remove(el);
        if (result == this.next) {
            return this;
        }
        return this.getPureFactory().makeList(this.first, result);
    }

    public ATermList removeElementAt(int index) {
        if (index < 0 || index > this.length) {
            throw new IllegalArgumentException("illegal list index: " + index);
        }
        if (index == 0) {
            return this.next;
        }
        return this.getPureFactory().makeList(this.first, this.next.removeElementAt(index - 1));
    }

    public ATermList removeAll(ATerm el) {
        if (this.first == el) {
            return this.next.removeAll(el);
        }
        ATermList result = this.next.removeAll(el);
        if (result == this.next) {
            return this;
        }
        return this.getPureFactory().makeList(this.first, result);
    }

    public ATermList insert(ATerm el) {
        return this.getPureFactory().makeList(el, this);
    }

    public ATermList insertAt(ATerm el, int i) {
        if (i < 0 || i > this.length) {
            throw new IllegalArgumentException("illegal list index: " + i);
        }
        if (i == 0) {
            return this.insert(el);
        }
        return this.getPureFactory().makeList(this.first, this.next.insertAt(el, i - 1));
    }

    public ATermList getPrefix() {
        if (this == PureFactory.empty) {
            return this;
        }
        ATermList cur = this;
        Vector<ATerm> elems = new Vector<ATerm>();
        while (true) {
            ATermList next;
            if ((next = cur.getNext()) == PureFactory.empty) {
                cur = PureFactory.empty;
                int i = elems.size() - 1;
                while (i >= 0) {
                    cur = cur.insert((ATerm)elems.get(i));
                    --i;
                }
                return cur;
            }
            elems.add(cur.getFirst());
            cur = cur.getNext();
        }
    }

    public ATermList getSlice(int start, int end) {
        int size = end - start;
        ATermList result = PureFactory.empty;
        Vector<ATerm> buffer = new Vector<ATerm>(size);
        ATermList list = this;
        int i = 0;
        while (i < start) {
            list = list.getNext();
            ++i;
        }
        i = 0;
        while (i < size) {
            buffer.add(list.getFirst());
            list = list.getNext();
            ++i;
        }
        --i;
        while (i >= 0) {
            result = result.insert((ATerm)buffer.get(i));
            --i;
        }
        return result;
    }

    public ATermList replace(ATerm el, int i) {
        if (i < 0 || i > this.length) {
            throw new IllegalArgumentException("illegal list index: " + i);
        }
        Vector<ATerm> buffer = new Vector<ATerm>(i);
        ATermList cur = this;
        int lcv = 0;
        while (lcv < i) {
            buffer.add(cur.getFirst());
            cur = cur.getNext();
            ++lcv;
        }
        cur = cur.getNext();
        cur = cur.insert(el);
        --lcv;
        while (lcv >= 0) {
            cur = cur.insert((ATerm)buffer.get(lcv));
            --lcv;
        }
        return cur;
    }

    public ATermList reverse() {
        ATermList cur = this;
        ATermList reverse = this.getPureFactory().makeList();
        while (!cur.isEmpty()) {
            reverse = reverse.insert(cur.getFirst());
            cur = cur.getNext();
        }
        return reverse;
    }

    public ATerm dictGet(ATerm key) {
        if (this.isEmpty()) {
            return null;
        }
        ATermList pair = (ATermList)this.first;
        if (key.equals(pair.getFirst())) {
            return pair.getNext().getFirst();
        }
        return this.next.dictGet(key);
    }

    public ATermList dictPut(ATerm key, ATerm value) {
        if (this.isEmpty()) {
            ATermList pair = this.getPureFactory().makeList(key, this.getPureFactory().makeList(value));
            return this.getPureFactory().makeList(pair);
        }
        ATermList pair = (ATermList)this.first;
        if (key.equals(pair.getFirst())) {
            pair = this.getPureFactory().makeList(key, this.getPureFactory().makeList(value));
            return this.getPureFactory().makeList(pair, this.next);
        }
        return this.getPureFactory().makeList(this.first, this.next.dictPut(key, value), this.getAnnotations());
    }

    public ATermList dictRemove(ATerm key) {
        if (this.isEmpty()) {
            return this;
        }
        ATermList pair = (ATermList)this.first;
        if (key.equals(pair.getFirst())) {
            return this.next;
        }
        return this.getPureFactory().makeList(this.first, this.next.dictRemove(key), this.getAnnotations());
    }

    public ATerm setAnnotations(ATermList annos) {
        return this.getPureFactory().makeList(this.first, this.next, annos);
    }

    public void accept(Visitor v) throws VisitFailure {
        v.visitList(this);
    }

    public int getNrSubTerms() {
        return this.length;
    }

    public ATerm getSubTerm(int index) {
        return this.elementAt(index);
    }

    public ATerm setSubTerm(int index, ATerm t) {
        return this.replace(t, index);
    }

    private int hashFunction() {
        int a = -1640531527;
        int b = -1640531527;
        int c = 3;
        a += this.getAnnotations().hashCode() << 16;
        a += this.next.hashCode() << 8;
        a += this.first.hashCode();
        a -= b;
        a -= c;
        b -= c;
        b -= (a ^= c >> 13);
        c -= a;
        c -= (b ^= a << 8);
        a -= b;
        a -= (c ^= b >> 13);
        b -= c;
        b -= (a ^= c >> 12);
        c -= a;
        c -= (b ^= a << 16);
        a -= b;
        a -= (c ^= b >> 5);
        b -= c;
        b -= (a ^= c >> 3);
        c -= a;
        c -= (b ^= a << 10);
        return c ^= b >> 15;
    }
}

