/*
 * Decompiled with CFR 0.152.
 */
package jjtraveler.test;

import jjtraveler.VisitFailure;
import jjtraveler.Visitable;
import jjtraveler.test.NodeVisitor;

public class Node
implements Visitable {
    Node[] kids;
    int nodeID;
    static int nodeCounter = 0;

    public static Node factory(Node[] kids) {
        Node result = new Node(kids, nodeCounter);
        ++nodeCounter;
        return result;
    }

    public static void reset() {
        nodeCounter = 0;
    }

    public Node(Node[] kids, int nodeID) {
        this.kids = kids;
        this.nodeID = nodeID;
    }

    public Node() {
        this.kids = new Node[0];
        this.nodeID = nodeCounter++;
    }

    public Node(Node[] kids) {
        this.kids = kids;
        this.nodeID = nodeCounter++;
    }

    public Node accept(NodeVisitor v) throws VisitFailure {
        return v.visitNode(this);
    }

    public int getChildCount() {
        return this.kids.length;
    }

    public Visitable getChildAt(int i) {
        return this.kids[i];
    }

    public Visitable setChildAt(int i, Visitable child) {
        this.kids[i] = (Node)child;
        return this;
    }

    public String toString() {
        return "Node-" + this.nodeID;
    }
}

