/*
 * Decompiled with CFR 0.152.
 */
package test;

import aterm.AFun;
import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermFactory;
import aterm.ATermInt;
import aterm.ATermList;
import aterm.ATermReal;
import aterm.pure.PureFactory;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;

public class Test2 {
    ATermFactory factory;
    String srcdir;

    public static final void main(String[] args) throws IOException {
        Test2 pureSuite = new Test2(new PureFactory(), args[0]);
        pureSuite.testAll();
    }

    public Test2(ATermFactory factory, String srcdir) {
        this.factory = factory;
        this.srcdir = srcdir;
    }

    void test_assert(boolean condition) {
        if (!condition) {
            throw new RuntimeException("assertion failed.");
        }
    }

    public void testMakeInt() {
        ATermInt[] term = new ATermInt[]{this.factory.makeInt(3), this.factory.makeInt(3)};
        this.test_assert(term[0].getType() == 1);
        this.test_assert(term[0].getInt() == 3);
        this.test_assert(term[0] == term[1]);
        System.out.println("toString: " + term[0]);
        this.test_assert(term[0].toString().equals("3"));
        List result = term[0].match("3");
        this.test_assert(result != null);
        this.test_assert(result.size() == 0);
        result = term[0].match("<int>");
        this.test_assert(result != null);
        this.test_assert(result.size() == 1);
        System.out.println("pass: testMakeInt");
    }

    public void testMakeReal() {
        ATermReal[] term = new ATermReal[]{this.factory.makeReal(Math.PI), this.factory.makeReal(Math.PI)};
        this.test_assert(term[0].getType() == 2);
        this.test_assert(term[0].getReal() == Math.PI);
        this.test_assert(term[0] == term[1]);
        List result = term[0].match("<real>");
        this.test_assert(result != null);
        this.test_assert(result.size() == 1);
        this.test_assert(result.get(0).equals(new Double(Math.PI)));
        System.out.println("pass: testMakeReal");
    }

    public void testMakeAppl() {
        AFun[] symmies = new AFun[4];
        ATermAppl[] apples = new ATermAppl[16];
        symmies[0] = this.factory.makeAFun("f0", 0, false);
        symmies[1] = this.factory.makeAFun("f1", 1, false);
        symmies[2] = this.factory.makeAFun("f6", 6, false);
        symmies[3] = this.factory.makeAFun("f10", 10, false);
        apples[0] = this.factory.makeAppl(symmies[0]);
        this.test_assert(this.factory.makeAppl(symmies[0]) == apples[0]);
        apples[1] = this.factory.makeAppl(symmies[1], apples[0]);
        this.test_assert(this.factory.makeAppl(symmies[1], apples[0]) == apples[1]);
        apples[2] = this.factory.makeAppl(symmies[1], apples[1]);
        apples[3] = this.factory.makeAppl(symmies[1], apples[0]);
        apples[4] = this.factory.makeAppl(symmies[2], apples[0], apples[0], apples[1], apples[0], apples[0], apples[1]);
        ATerm[] args = new ATerm[]{apples[0], apples[1], apples[0], apples[1], apples[0], apples[1], apples[0], apples[1], apples[0], apples[1]};
        apples[5] = this.factory.makeAppl(symmies[3], args);
        apples[6] = apples[2].setArgument(apples[0], 0);
        this.test_assert(apples[6].equals(apples[1]));
        this.test_assert(apples[1].equals(apples[3]));
        this.test_assert(!apples[2].equals(apples[1]));
        this.test_assert(!apples[2].equals(apples[6]));
        this.test_assert(!apples[1].equals(apples[2]));
        this.test_assert(!apples[2].equals(apples[3]));
        this.test_assert(!apples[0].equals(apples[1]));
        System.out.println("pass: TestMakeAppl");
    }

    public void testDict() {
        ATerm value;
        ATerm key;
        ATermList dict = this.factory.makeList();
        int i = 0;
        while (i < 5) {
            key = this.factory.parse("key" + i);
            value = this.factory.parse("value" + i);
            dict = dict.dictPut(key, value);
            ++i;
        }
        key = this.factory.parse("key3");
        value = this.factory.parse("value3");
        this.test_assert(dict.dictGet(key).equals(value));
    }

    public void testAnnos() {
        ATerm value;
        ATerm key;
        ATerm t = this.factory.parse("f");
        int i = 0;
        while (i < 5) {
            key = this.factory.parse("key" + i);
            value = this.factory.parse("value" + i);
            t = t.setAnnotation(key, value);
            ++i;
        }
        key = this.factory.parse("key3");
        value = this.factory.parse("value3");
        this.test_assert(t.getAnnotation(key).equals(value));
        t = t.removeAnnotation(key);
        this.test_assert(t.getAnnotation(key) == null);
    }

    public void testParser() {
        this.factory.parse("f");
        this.factory.parse("f(1)");
        this.factory.parse("f(1,2)");
        this.factory.parse("[]");
        this.factory.parse("[1]");
        this.factory.parse("[1,2]");
        this.factory.parse("<x>");
        this.factory.parse("3.14");
        this.factory.parse("f(\"x y z\"(),<abc(31)>,[])");
        this.factory.parse("home([<name(\"\",String)>,<phone(\"\",PhoneNumber)>])");
        this.factory.parse("[ a , b ]");
        this.factory.parse("f(a){[x,y],[1,2]}");
        this.factory.parse("[(),(a)]");
        System.out.println("parser tests ok.");
    }

    public void testList() {
        ATermList list = (ATermList)this.factory.parse("[1,2,3]");
        ATermList result = list.remove(this.factory.parse("2"));
        this.test_assert(result.equals(this.factory.parse("[1,3]")));
        list = (ATermList)this.factory.parse("[1,2,3]");
        result = list.replace(this.factory.parse("99"), 1);
        this.test_assert(result.equals(this.factory.parse("[1,99,3]")));
        list = this.factory.makeList();
        result = list.append(this.factory.parse("1"));
        this.test_assert(result.equals(this.factory.parse("[1]")));
        list = (ATermList)this.factory.parse("[]");
        result = this.factory.makeList();
        this.test_assert(result.equals(list));
        System.out.println("pass: testList");
    }

    public void testFiles() throws IOException {
        ATerm t1 = this.factory.readFromFile(String.valueOf(this.srcdir) + "/test.trm");
        System.out.println("done reading test.trm");
        ATerm t2 = this.factory.readFromFile(String.valueOf(this.srcdir) + "/test.taf");
        System.out.println("done reading test.taf");
        PrintStream stream = new PrintStream(new FileOutputStream("test.trm2"));
        t1.writeToTextFile(stream);
        stream.println();
        stream.close();
        System.out.println("done writing test.trm2");
        stream = new PrintStream(new FileOutputStream("test.taf2"));
        t1.writeToSharedTextFile(stream);
        stream.close();
        System.out.println("done writing test.taf2");
        this.test_assert(t1.equals(t2));
    }

    public void testMatch() {
        ATerm t = this.factory.parse("node(\"Pico-eval\",box,182,21,62,26)");
        List result = t.match("node(<str>,<fun>,<int>,<int>,<int>,<int>)");
        this.test_assert(result != null);
        t = this.factory.parse("f(1,2,3)");
        result = t.match("f(1,2,3)");
        this.test_assert(result != null);
        System.out.println("pass: testMatch");
    }

    public void testAll() throws IOException {
        this.testMakeInt();
        this.testMakeReal();
        this.testMakeAppl();
        this.testDict();
        this.testAnnos();
        this.testParser();
        this.testList();
        this.testFiles();
        this.testMatch();
    }
}

