/*
 * Decompiled with CFR 0.152.
 */
package test;

import aterm.AFun;
import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermFactory;
import aterm.pure.PureFactory;
import java.util.List;

public class TestFibInterpreted {
    private ATermFactory factory;
    private AFun zero;
    private AFun suc;
    private AFun plus;
    private AFun fib;
    private ATermAppl tzero;
    private ATerm fail;
    private ATerm[] lhs;
    private ATerm[] rhs;

    public static final void main(String[] args) {
        TestFibInterpreted t = new TestFibInterpreted(new PureFactory());
        t.initRules();
        t.test1(5);
    }

    public TestFibInterpreted(ATermFactory factory) {
        this.factory = factory;
        this.zero = factory.makeAFun("zero", 0, false);
        this.suc = factory.makeAFun("suc", 1, false);
        this.plus = factory.makeAFun("plus", 2, false);
        this.fib = factory.makeAFun("fib", 1, false);
        this.tzero = factory.makeAppl(this.zero);
        this.fail = factory.parse("fail");
    }

    public void initRules() {
        this.lhs = new ATerm[10];
        this.rhs = new ATerm[10];
        int ruleNumber = 0;
        this.lhs[ruleNumber] = this.factory.parse("fib(zero)");
        this.rhs[ruleNumber] = this.factory.parse("suc(zero)");
        this.lhs[++ruleNumber] = this.factory.parse("fib(suc(zero))");
        this.rhs[ruleNumber] = this.factory.parse("suc(zero)");
        this.lhs[++ruleNumber] = this.factory.parse("fib(suc(suc(<term>)))");
        this.rhs[ruleNumber] = this.factory.parse("plus(fib(<term>),fib(suc(<term>)))");
        this.lhs[++ruleNumber] = this.factory.parse("plus(zero,<term>)");
        this.rhs[ruleNumber] = this.factory.parse("<term>");
        this.lhs[++ruleNumber] = this.factory.parse("plus(suc(<term>),<term>)");
        this.rhs[ruleNumber] = this.factory.parse("plus(<term>,suc(<term>))");
        this.lhs[++ruleNumber] = this.factory.parse("suc(<term>)");
        this.rhs[ruleNumber] = this.factory.parse("suc(<term>)");
        this.lhs[++ruleNumber] = this.factory.parse("plus(<term>,<term>)");
        this.rhs[ruleNumber] = this.factory.parse("plus(<term>,<term>)");
        ++ruleNumber;
    }

    public ATerm oneStep(ATerm subject) {
        int ruleNumber = 0;
        List list = subject.match(this.lhs[ruleNumber]);
        if (list != null) {
            return this.rhs[ruleNumber];
        }
        if ((list = subject.match(this.lhs[++ruleNumber])) != null) {
            return this.rhs[ruleNumber];
        }
        if ((list = subject.match(this.lhs[++ruleNumber])) != null) {
            ATerm X = (ATerm)list.get(0);
            list.add(X);
            return this.factory.make(this.rhs[ruleNumber], list);
        }
        if ((list = subject.match(this.lhs[++ruleNumber])) != null) {
            return this.factory.make(this.rhs[ruleNumber], list);
        }
        if ((list = subject.match(this.lhs[++ruleNumber])) != null) {
            return this.factory.make(this.rhs[ruleNumber], list);
        }
        if ((list = subject.match(this.lhs[++ruleNumber])) != null) {
            ATerm X = (ATerm)list.get(0);
            ATerm Xp = this.oneStep(X);
            if (Xp.equals(this.fail)) {
                return this.fail;
            }
            list.clear();
            list.add(Xp);
            return this.factory.make(this.rhs[ruleNumber], list);
        }
        if ((list = subject.match(this.lhs[++ruleNumber])) != null) {
            ATerm X = (ATerm)list.get(0);
            ATerm Xp = this.oneStep(X);
            if (Xp.equals(this.fail)) {
                ATerm Y = (ATerm)list.get(1);
                ATerm Yp = this.oneStep(Y);
                if (Yp.equals(this.fail)) {
                    return this.fail;
                }
                list.clear();
                list.add(X);
                list.add(Yp);
                return this.factory.make(this.rhs[ruleNumber], list);
            }
            ATerm Y = (ATerm)list.get(1);
            list.clear();
            list.add(Xp);
            list.add(Y);
            return this.factory.make(this.rhs[ruleNumber], list);
        }
        ++ruleNumber;
        return this.fail;
    }

    public ATerm oneStepInnermost(ATerm subject) {
        List list = subject.match(this.lhs[0]);
        if (list != null) {
            return this.rhs[0];
        }
        list = subject.match(this.lhs[1]);
        if (list != null) {
            return this.rhs[1];
        }
        list = subject.match(this.lhs[2]);
        if (list != null) {
            ATerm X = (ATerm)list.get(0);
            ATerm X1 = this.normalize(this.factory.makeAppl(this.fib, X));
            ATerm X2 = this.normalize(this.factory.makeAppl(this.fib, this.factory.makeAppl(this.suc, X)));
            return this.factory.makeAppl(this.plus, X1, X2);
        }
        list = subject.match(this.lhs[3]);
        if (list != null) {
            return (ATerm)list.get(0);
        }
        list = subject.match(this.lhs[4]);
        if (list != null) {
            return this.factory.make(this.rhs[4], list);
        }
        return this.fail;
    }

    public ATerm normalize(ATerm t) {
        ATerm s = t;
        while (!(s = this.oneStep(t = s)).equals(this.fail)) {
        }
        return t;
    }

    public void test1(int n) {
        ATermAppl N = this.tzero;
        int i = 0;
        while (i < n) {
            N = this.factory.makeAppl(this.suc, N);
            ++i;
        }
        ATermAppl tfib = this.factory.makeAppl(this.fib, N);
        this.normalize(tfib);
    }
}

