/*
 * Decompiled with CFR 0.152.
 */
package com.lre.graph;

import com.lre.graph.Edge;
import com.lre.utils.Util;
import java.util.Vector;

public class Vertex
implements Cloneable {
    private String name;
    private Vector edgeList;

    public Vertex(String s) {
        this.name = s;
        this.edgeList = new Vector();
    }

    public Object clone() {
        Vertex v = new Vertex(new String(this.name));
        Vector<Object> edges = new Vector<Object>();
        int i = 0;
        while (i < this.edgeList.size()) {
            edges.addElement(((Edge)this.edgeList.elementAt(i)).clone());
            ++i;
        }
        v.edgeList = edges;
        return v;
    }

    public String getName() {
        return this.name;
    }

    public void addEdge(Edge e) {
        this.edgeList.addElement(e);
    }

    public int countEdges() {
        return this.edgeList.size();
    }

    public Edge getEdgeAt(int i) {
        return (Edge)this.edgeList.elementAt(i);
    }

    public boolean matches(Vertex v) {
        if (this.name.equals(v.getName())) {
            return this.edgesMatch(v);
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Vertex) {
            return ((Vertex)obj).matches(this);
        }
        return false;
    }

    public boolean hasNeighbor(Vertex v) {
        int i = 0;
        while (i < this.countEdges()) {
            Edge e = this.getEdgeAt(i);
            if (e.getTarget().equals(v)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasNeighbor(Vertex v, String edgeName) {
        int i = 0;
        while (i < this.countEdges()) {
            Edge e = this.getEdgeAt(i);
            if (e.getTarget().equals(v) && e.getLabel().equals(edgeName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Vector listNeighbors() {
        Vector<Vertex> v = new Vector<Vertex>();
        int i = 0;
        while (i < this.countEdges()) {
            Edge e = this.getEdgeAt(i);
            if (!v.contains(e.getTarget())) {
                v.addElement(e.getTarget());
            }
            ++i;
        }
        return v;
    }

    public boolean similar(Vertex v) {
        return this.edgesMatch(v);
    }

    private boolean edgesMatch(Vertex v) {
        if (v.countEdges() != this.countEdges()) {
            return false;
        }
        int count = 0;
        int[] matched = new int[]{};
        int i = 0;
        while (i < v.countEdges()) {
            int j = 0;
            while (j < this.countEdges()) {
                if (v.getEdgeAt(i).equals(this.getEdgeAt(j)) && !Util.isInArray(j, matched)) {
                    ++count;
                    Util.addToIntArray(j, matched);
                    break;
                }
                ++j;
            }
            ++i;
        }
        return count == this.countEdges();
    }

    public boolean isLeaf() {
        return this.edgeList.size() == 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name);
        int i = 0;
        while (i < this.countEdges()) {
            sb.append("\n\t" + this.getEdgeAt(i).getLabel() + " --> " + this.getEdgeAt(i).getTarget().getName());
            ++i;
        }
        return sb.toString();
    }
}

