/*
 * Decompiled with CFR 0.152.
 */
package com.lre.graph;

import com.lre.graph.Vertex;
import java.util.Vector;

public class VertexClass {
    private Vector vertices;
    private int num;

    public VertexClass(int n) {
        this.num = n;
        this.vertices = new Vector();
    }

    public VertexClass(int n, Vector v) {
        this.num = n;
        this.vertices = v;
    }

    public void addVertexToClass(Vertex v) {
        this.vertices.addElement(v);
    }

    public boolean isInClass(Vertex v) {
        int i = 0;
        while (i < this.vertices.size()) {
            Vertex curr = (Vertex)this.vertices.elementAt(i);
            if (curr.matches(v)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean matches(VertexClass vc) {
        int j;
        if (vc.getNum() != this.getNum()) {
            return false;
        }
        if (vc.getVertices().size() != this.getVertices().size()) {
            return false;
        }
        boolean match = true;
        Vector<Vertex> oneUnmatched = new Vector<Vertex>();
        Vector twoUnmatched = (Vector)vc.getVertices().clone();
        int i = 0;
        while (i < this.getVertices().size()) {
            boolean matchCurr = false;
            Vertex local = (Vertex)this.getVertices().elementAt(i);
            j = 0;
            while (j < vc.getVertices().size()) {
                Vertex other = (Vertex)vc.getVertices().elementAt(j);
                if (local.matches(other)) {
                    twoUnmatched.remove(other);
                    matchCurr = true;
                    break;
                }
                ++j;
            }
            if (!matchCurr) {
                oneUnmatched.addElement(local);
            }
            ++i;
        }
        if (oneUnmatched.size() == 0 && twoUnmatched.size() == 0) {
            return true;
        }
        i = 0;
        while (i < oneUnmatched.size()) {
            Vertex one = (Vertex)oneUnmatched.elementAt(i);
            boolean matchCurr = false;
            j = 0;
            while (j < twoUnmatched.size()) {
                Vertex two = (Vertex)twoUnmatched.elementAt(j);
                if (one.similar(two)) {
                    matchCurr = true;
                    break;
                }
                ++j;
            }
            if (!matchCurr) {
                return false;
            }
            ++i;
        }
        return match;
    }

    public int getNum() {
        return this.num;
    }

    public Vector getVertices() {
        return this.vertices;
    }
}

