/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.ATermUtils;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.OWLReasoner;

public class ABoxQuery {
    public static boolean DEBUG = false;
    private static String FINALIZED = "FINAL";
    private static int LEAVES = 0;
    private static int CONFLUENTS = 1;
    private static int LOOPS = 2;
    private static int VARIABLES = 4;
    private static int BOUNDLOOPS = LOOPS | CONFLUENTS;
    private static int UNBOUNDLOOPS = BOUNDLOOPS | VARIABLES;
    private Hashtable varmap = new Hashtable();
    private int prime = 0;
    private OWLReasoner reasoner = new OWLReasoner();
    private ABox abox = null;
    private ABox qbox = null;
    private HashSet variables = new HashSet();
    int count = 0;
    int sub = 0;

    public ABoxQuery() {
        this(null);
    }

    public ABoxQuery(ABox abox) {
        this(abox, new ABox());
    }

    public ABoxQuery(ABox abox, ABox qbox) {
        this.setQuery(qbox);
        this.setData(abox);
    }

    private boolean isVariable(ATerm x) {
        return this.variables.contains(x);
    }

    private void defineNode(ATermAppl a) {
        if (a.getName().charAt(0) == '?' && !this.isVariable((ATerm)a)) {
            this.variables.add(a);
            this.qbox.addNode((ATerm)a);
            this.qbox.addType((ATerm)a, ATermUtils.QUERYVAR);
        } else if (!this.qbox.isNode((ATerm)a)) {
            this.qbox.addNode((ATerm)a);
        }
    }

    public void addTriple(String s, String p, String o) {
        this.addTriple(ATermUtils.makeTermAppl(s), ATermUtils.makeTermAppl(p), ATermUtils.makeTermAppl(o));
    }

    public void addTriple(ATermAppl s, ATermAppl p, ATermAppl o) {
        if (p.getName().equals(RDF.type.getURI())) {
            this.defineNode(s);
            this.qbox.addType((ATerm)s, (ATerm)o);
        } else {
            if (p.getName().equals(OWL.sameAs.getURI())) {
                throw new RuntimeException("owl:sameAs is not supported in ABoxQuery");
            }
            if (p.getName().equals(OWL.differentFrom.getURI())) {
                throw new RuntimeException("owl:differentFrom is not supported in ABoxQuery");
            }
            if (p.getName().startsWith(RDF.getURI()) || p.getName().startsWith("http://www.w3.org/2002/07/owl#") || p.getName().startsWith(RDFS.getURI())) {
                throw new RuntimeException("Predicates that belong to [RDF, RDFS, OWL] namespaces cannot be used in ABoxQuery: " + p);
            }
            if (p.getName().charAt(0) == '?') {
                throw new RuntimeException("Variable predicates cannot be used in ABoxQuery");
            }
            this.defineNode(s);
            this.defineNode(o);
            this.qbox.rbox.addObjectRole((ATerm)p);
            this.qbox.addEdge((ATerm)p, (ATerm)s, (ATerm)o);
        }
    }

    public void setData(ABox abox) {
        this.abox = abox;
        this.reasoner.setABox(abox);
    }

    public void setQuery(ABox qbox) {
        this.qbox = qbox;
    }

    public Vector runQuery() throws Exception {
        Vector results = null;
        if (this.abox == null) {
            throw new RuntimeException("No data is set for query!");
        }
        this.reasoner.realize();
        this.qbox = (ABox)this.qbox.clone();
        try {
            if (this.simpleQuery(this.qbox)) {
                results = new Vector();
            }
        }
        catch (UnboundVarException e) {
            if (DEBUG) {
                System.out.println(e);
            }
            results = this.query(this.qbox, e.varname, this.abox.getNodes());
        }
        return results;
    }

    private Vector query(ABox qbox, ATerm variable, Collection canidates) throws Exception {
        Vector results = null;
        Iterator nodeIter = canidates.iterator();
        while (nodeIter.hasNext()) {
            Node replacementNode = (Node)nodeIter.next();
            ATerm a = replacementNode.getName();
            this.varmap.put(variable, a);
            List types = replacementNode.getAtomic();
            System.out.println(String.valueOf(++this.count) + ") Checking " + a + " for " + variable);
            if (DEBUG) {
                System.out.println("Checking: " + this.varmap);
            }
            try {
                if (!this.simpleQuery(qbox)) continue;
                if (results == null) {
                    results = new Vector();
                }
                results.add(this.varmap.clone());
            }
            catch (UnboundVarException e) {
                Vector nodeResults;
                if (DEBUG) {
                    System.out.println(e);
                }
                if ((nodeResults = this.query(qbox, e.varname, this.abox.getNodes())) == null) continue;
                if (results == null) {
                    results = nodeResults;
                    continue;
                }
                results.addAll(nodeResults);
            }
        }
        this.varmap.remove(variable);
        return results;
    }

    public boolean simpleQuery(ABox qbox) throws UnboundVarException {
        boolean retval = true;
        ATermList queries = this.rollQuery((ABox)qbox.clone());
        while (!queries.isEmpty()) {
            ATermAppl query = (ATermAppl)queries.getFirst();
            if (DEBUG) {
                System.out.println("Query:" + query);
            }
            System.out.println("Sat test " + this.sub++);
            if (!this.abox.isSatisfiable((ATerm)query)) {
                if (DEBUG) {
                    System.out.println("True!");
                }
            } else {
                if (DEBUG) {
                    System.out.println("False!");
                }
                retval = false;
                break;
            }
            retval = true;
            queries = queries.getNext();
        }
        return retval;
    }

    private ATermList rollQuery(ABox qbox) throws UnboundVarException {
        Hashtable<String, ATermList> rolledParts = new Hashtable<String, ATermList>();
        rolledParts.put(FINALIZED, ATermUtils.makeList());
        while (qbox.getNodes().size() > 0) {
            if (this.rollLeaves(qbox, rolledParts) || this.rollConfluents(qbox, rolledParts) || this.rollBoundLoops(qbox, rolledParts)) continue;
            this.rollUnboundLoops(qbox, rolledParts);
        }
        return (ATermList)rolledParts.get(FINALIZED);
    }

    private boolean rollLeaves(ABox qbox, Hashtable rolledParts) throws UnboundVarException {
        return this.rollEnds(qbox, rolledParts, LEAVES);
    }

    private boolean rollConfluents(ABox qbox, Hashtable rolledParts) throws UnboundVarException {
        return this.rollEnds(qbox, rolledParts, CONFLUENTS);
    }

    private boolean rollBoundLoops(ABox qbox, Hashtable rolledParts) throws UnboundVarException {
        return this.rollEnds(qbox, rolledParts, BOUNDLOOPS);
    }

    private boolean rollUnboundLoops(ABox qbox, Hashtable rolledParts) throws UnboundVarException {
        return this.rollEnds(qbox, rolledParts, UNBOUNDLOOPS);
    }

    private boolean rollEnds(ABox qbox, Hashtable rolledParts, int mode) throws UnboundVarException {
        boolean retval = false;
        ATermList nodesToRemove = ATermUtils.makeList();
        Iterator nodeIter = qbox.getNodes().iterator();
        while (nodeIter.hasNext()) {
            Node node = (Node)nodeIter.next();
            ATermAppl replacementName = null;
            ATermAppl conjunct = null;
            EdgeList edgesIn = new EdgeList();
            boolean nodeIsUnboundVariable = false;
            boolean nodeIsBoundVariable = false;
            boolean nodeIsFinalPart = false;
            if ((mode & LOOPS) == 0 && !node.isLeaf()) continue;
            if (node.hasType(ATermUtils.QUERYVAR) || this.varmap.containsKey(node.getName())) {
                nodeIsBoundVariable = true;
                if (!this.varmap.containsKey(node.getName())) {
                    throw new UnboundVarException("Variable " + node.getName() + " must be bound because of type.", node.getName());
                }
                replacementName = (ATermAppl)this.varmap.get(node.getName());
            } else if (((ATermAppl)node.getName()).getName().startsWith("_anon")) {
                if (!node.isLeaf()) {
                    if ((mode & VARIABLES) != 0) continue;
                    throw new UnboundVarException("Variable " + node.getName() + " must be bound because of loop.", node.getName());
                }
                nodeIsUnboundVariable = true;
            }
            Vector parents = this.findEdgesIn(qbox, node);
            int p = 0;
            while (p < parents.size()) {
                edgesIn.addEdgeList(((Node)parents.get(0)).getEdges(node.getName()));
                ++p;
            }
            if (edgesIn.size() > 1 && (mode & CONFLUENTS) != 0) continue;
            if (edgesIn.size() == 0) {
                if (nodeIsUnboundVariable) {
                    throw new UnboundVarException("Variable " + node.getName() + " must be bound because it is the final part in a query.", node.getName());
                }
                nodeIsFinalPart = true;
            }
            Iterator typeIter = node.getTypes().iterator();
            while (typeIter.hasNext()) {
                ATermAppl type = (ATermAppl)typeIter.next();
                if (type == ATermUtils.QUERYVAR) continue;
                if (node.getNominals().contains(type)) {
                    if (nodeIsFinalPart || nodeIsUnboundVariable) continue;
                    if (nodeIsBoundVariable) {
                        type = ATermUtils.makeValue((ATerm)replacementName);
                    }
                }
                conjunct = conjunct == null ? type : (ATermAppl)ATermUtils.makeAnd((ATerm)conjunct, (ATerm)type);
            }
            if (rolledParts.containsKey(node.getName())) {
                ATermAppl parts = (ATermAppl)rolledParts.get(node.getName());
                conjunct = conjunct == null ? parts : (ATermAppl)ATermUtils.makeAnd((ATerm)conjunct, (ATerm)parts);
            }
            if (conjunct == null) {
                conjunct = (ATermAppl)ATermUtils.TOP;
            }
            if (!nodeIsFinalPart) {
                if (nodeIsUnboundVariable && edgesIn.size() > 1) {
                    throw new UnboundVarException("Variable " + node.getName() + " must be bound because of multiple incoming edges.", node.getName());
                }
                Iterator edgeIter = edgesIn.iterator();
                while (edgeIter.hasNext()) {
                    Edge edge = (Edge)edgeIter.next();
                    ATermAppl roll = ATermUtils.makeSomeValues(edge.name, (ATerm)conjunct);
                    if (rolledParts.containsKey(edge.from)) {
                        ATermAppl prevRolls = (ATermAppl)rolledParts.get(edge.from);
                        roll = (ATermAppl)ATermUtils.makeAnd((ATerm)roll, (ATerm)prevRolls);
                    }
                    rolledParts.put(qbox.getNode(edge.from).getName(), roll);
                }
            } else {
                ATermList finalList;
                conjunct = ATermUtils.makeNot((ATerm)conjunct);
                if (nodeIsBoundVariable) {
                    ATermAppl type = ATermUtils.makeValue((ATerm)replacementName);
                    conjunct = (ATermAppl)ATermUtils.makeAnd((ATerm)type, (ATerm)conjunct);
                } else {
                    Iterator nominalIterator = node.getNominals().iterator();
                    while (nominalIterator.hasNext()) {
                        ATermAppl nominal = (ATermAppl)nominalIterator.next();
                        conjunct = (ATermAppl)ATermUtils.makeAnd((ATerm)nominal, (ATerm)conjunct);
                    }
                }
                conjunct = (ATermAppl)ATermUtils.simplify((ATerm)conjunct);
                if (rolledParts.containsKey(FINALIZED)) {
                    finalList = (ATermList)rolledParts.get(FINALIZED);
                    finalList = finalList.insert((ATerm)conjunct);
                } else {
                    finalList = ATermUtils.makeList((ATerm)conjunct);
                }
                rolledParts.put(FINALIZED, finalList);
            }
            nodesToRemove = nodesToRemove.insert(node.getName());
            retval = true;
        }
        qbox.removeNodes(nodesToRemove);
        return retval;
    }

    private Vector findEdgesIn(ABox qbox, Node child) {
        Vector<Node> parents = new Vector<Node>();
        Iterator iter = qbox.getNodes().iterator();
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            EdgeList edgelist = node.getEdges(child.getName());
            if (edgelist == null) continue;
            parents.add(node);
        }
        return parents;
    }

    public class UnboundVarException
    extends Exception {
        public ATerm varname = null;

        public UnboundVarException(String msg, ATerm name) {
            super(msg);
            this.varname = name;
        }
    }
}

