/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import java.io.PrintWriter;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.ATermUtils;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.OWLParser;
import org.mindswap.pellet.OWLReasoner;
import org.mindswap.pellet.OutputFormatter;
import org.mindswap.pellet.TBox;
import org.mindswap.pellet.TermDefinition;

public class Classify {
    public static boolean DEBUG = false;
    OWLReasoner reasoner = null;
    int numClasses = 0;
    int TOP = -1;
    int BOTTOM = -1;
    ATerm[] classes = null;
    boolean[] classified = null;
    int[] sameAs = null;
    static final byte UNKNOWN = 0;
    static final byte YES = 1;
    static final byte NO = 2;
    byte[][] subclass = null;
    byte[][] pruned = null;
    Vector[] instances = null;
    BitSet[] instanceTypes = null;
    static final String[] chars = new String[]{"?", "+", "-"};
    static final String INDENT = "  ";
    static boolean showFullURIs = false;
    public static final int TREE = 0;
    public static final int TABLE = 1;
    public static final int RDF = 2;

    public Classify(OWLReasoner reasoner) {
        this(reasoner, false);
    }

    public Classify(OWLReasoner reasoner, boolean classifyRoles) {
        this.reasoner = reasoner;
        this.numClasses = reasoner.getABox().tbox.classes.size() + 2;
        if (DEBUG) {
            System.out.print("Creating data structures for " + this.numClasses + " classes...");
        }
        this.TOP = this.numClasses - 2;
        this.BOTTOM = this.numClasses - 1;
        this.classes = new ATerm[this.numClasses];
        this.classified = new boolean[this.numClasses];
        this.sameAs = new int[this.numClasses];
        reasoner.getABox().tbox.classes.toArray(this.classes);
        this.classes[this.TOP] = ATermUtils.TOP;
        this.classes[this.BOTTOM] = ATermUtils.BOTTOM;
        this.subclass = new byte[this.numClasses][this.numClasses];
        this.pruned = new byte[this.numClasses][this.numClasses];
        if (DEBUG) {
            System.out.println("done");
        }
        if (DEBUG) {
            System.out.println("Init subsumption table...");
        }
        this.init();
        if (DEBUG) {
            this.printStats(this.subclass);
        }
        if (DEBUG) {
            System.out.println("Starting classification...");
        }
        int i = 0;
        while (i < this.TOP) {
            this.classify(i, new Vector());
            ++i;
        }
        i = 0;
        while (i < this.numClasses) {
            int same = this.sameAs[i];
            if (this.sameAs[i] != i) {
                int j = 0;
                while (j < this.numClasses) {
                    this.subclass[i][j] = this.subclass[same][j];
                    this.subclass[j][i] = this.subclass[j][same];
                    ++j;
                }
            }
            ++i;
        }
        if (DEBUG) {
            this.printStats(this.subclass);
            this.printStats(this.pruned);
        }
        if (DEBUG) {
            System.out.println("Satisifiabillity Test Count: " + ABox.satisfiabilityCount);
        }
    }

    public void realize() {
        if (this.instances != null) {
            return;
        }
        this.instances = new Vector[this.numClasses];
        this.instanceTypes = new BitSet[this.numClasses];
        Iterator i = this.reasoner.getABox().getNodeIterator();
        while (i.hasNext()) {
            Node x = (Node)i.next();
            if (DEBUG) {
                System.out.println("Realizing " + OWLParser.getLocalName(x.getNameStr()) + " ");
            }
            this.realize(x.getName(), ATermUtils.TOP);
        }
    }

    private boolean realize(ATerm x, ATerm c) {
        boolean realized = false;
        if (DEBUG) {
            System.out.println("Check " + OWLParser.getLocalName(((ATermAppl)c).getName()) + " ");
        }
        if (this.reasoner.isType(x, c)) {
            Iterator subs = this.getImmediateSubClasses(c).iterator();
            while (subs.hasNext()) {
                ATerm d = (ATerm)subs.next();
                boolean bl = realized = realized || this.realize(x, d);
            }
            if (!realized) {
                int i = this.index(c);
                if (this.instances[i] == null) {
                    this.instances[i] = new Vector();
                }
                this.instances[i].add(x);
                realized = true;
            }
        }
        return realized;
    }

    private void init() {
        int i = 0;
        while (i < this.numClasses) {
            this.subclass[i][i] = 2;
            this.classified[i] = false;
            this.sameAs[i] = i;
            ++i;
        }
        i = 0;
        while (i < this.numClasses) {
            TBox[] tbox = new TBox[]{this.reasoner.getABox().tbox.Tu, this.reasoner.getABox().tbox.Tg};
            int t = 0;
            while (t < tbox.length) {
                TermDefinition td = tbox[t].getTD(this.classes[i]);
                if (td != null) {
                    ATermAppl c;
                    if (td.samelist != null) {
                        int j = 0;
                        while (j < td.samelist.size()) {
                            c = (ATermAppl)td.samelist.get(j);
                            this.preclassify(i, c, true);
                            ++j;
                        }
                    }
                    if (td.sub != null) {
                        ATermList subs = ATermUtils.andToList((ATermAppl)td.sub.getArgument(1));
                        while (!subs.isEmpty()) {
                            c = (ATermAppl)subs.getFirst();
                            this.preclassify(i, c, false);
                            subs = subs.getNext();
                        }
                    }
                }
                ++t;
            }
            ++i;
        }
        if (DEBUG) {
            this.printStats(this.subclass);
        }
        i = 0;
        while (i < this.numClasses - 2) {
            this.subclass[i][this.TOP] = 1;
            if (this.subclass[i][this.BOTTOM] == 0) {
                if (DEBUG) {
                    System.out.print(String.valueOf(i + 1) + ") Satisfiability testing for " + OWLParser.getLocalName(this.classes[i].toString()) + " ");
                }
                long time = System.currentTimeMillis();
                boolean isSatisfiable = this.reasoner.isSatisfiable(this.classes[i]);
                time = System.currentTimeMillis() - time;
                if (DEBUG) {
                    System.out.print(String.valueOf(isSatisfiable) + " (" + time + "ms)");
                }
                int n = this.subclass[i][this.BOTTOM] = isSatisfiable ? 2 : 1;
                if (!isSatisfiable) {
                    this.classified[i] = true;
                    this.sameAs[i] = this.BOTTOM;
                }
                if (ABox.USE_CACHING) {
                    if (DEBUG) {
                        System.out.print("...negation ");
                    }
                    time = System.currentTimeMillis();
                    isSatisfiable = this.reasoner.isSatisfiable((ATerm)ATermUtils.makeNot(this.classes[i]));
                    time = System.currentTimeMillis() - time;
                    if (DEBUG) {
                        System.out.println(String.valueOf(isSatisfiable) + " (" + time + "ms)");
                    }
                } else if (DEBUG) {
                    System.out.println();
                }
            }
            this.subclass[this.BOTTOM][i] = 1;
            ++i;
        }
        this.subclass[this.BOTTOM][this.TOP] = 1;
        this.classified[this.BOTTOM] = true;
        this.classified[this.TOP] = true;
    }

    private void preclassify(int i, ATermAppl c, boolean isSame) {
        if (ATermUtils.isPrimitive((ATerm)c) && !c.toString().startsWith("_anon")) {
            int k = this.index((ATerm)c);
            this.mark(i, k);
            if (isSame) {
                this.mark(k, i);
            }
        } else if (c.getAFun().equals((Object)ATermUtils.ANDFUN)) {
            ATermList conj = (ATermList)c.getArgument(0);
            while (!conj.isEmpty()) {
                this.preclassify(i, (ATermAppl)conj.getFirst(), false);
                conj = conj.getNext();
            }
        } else if (isSame && c.getAFun().equals((Object)ATermUtils.ORFUN)) {
            ATermList disj = ATermUtils.orToList(c);
            while (!disj.isEmpty()) {
                ATerm d = disj.getFirst();
                if (!ATermUtils.isPrimitive(d)) continue;
                this.mark(this.index(d), i);
            }
        } else {
            ATerm negation = ATermUtils.getNegatedPrimitive((ATerm)c);
            if (negation != null) {
                this.unmark(i, this.index(negation));
            }
        }
    }

    private Vector search(boolean topSearch, int c, int x, Vector visited) {
        Vector<Integer> posSucc = new Vector<Integer>();
        visited.add(new Integer(x));
        int y = 0;
        while (y < this.TOP) {
            if (this.classified[y]) {
                if (topSearch && this.pruned[y][x] == 1) {
                    if (this.isSubclassOf(c, y)) {
                        posSucc.add(new Integer(y));
                    }
                } else if (!topSearch && this.pruned[x][y] == 1 && this.isSubclassOf(y, c)) {
                    posSucc.add(new Integer(y));
                }
            }
            ++y;
        }
        Vector<Integer> result = new Vector<Integer>();
        if (posSucc.isEmpty()) {
            result.add(new Integer(x));
        } else {
            Iterator i = posSucc.iterator();
            while (i.hasNext()) {
                Integer y2 = (Integer)i.next();
                if (visited.contains(y2)) continue;
                result.addAll(this.search(topSearch, c, y2, visited));
            }
        }
        return result;
    }

    private void classify(int i, Vector list) {
        int j;
        int j2;
        if (this.classified[i]) {
            return;
        }
        Integer o = new Integer(i);
        if (list.contains(o)) {
            return;
        }
        list.add(o);
        if (DEBUG) {
            System.out.println("Classify " + i + " " + this.getClassName(i) + "...");
        }
        int j3 = 0;
        while (j3 < this.TOP) {
            if (this.subclass[i][j3] == 1) {
                this.classify(j3, list);
            }
            ++j3;
        }
        Vector supers = this.search(true, i, this.TOP, new Vector());
        if (supers.size() == 1 && this.isSubclassOf(j2 = ((Integer)supers.firstElement()).intValue(), i)) {
            if (DEBUG) {
                System.out.println(String.valueOf(i) + " is same as " + j2);
            }
            this.sameAs[i] = j2;
            this.classified[i] = true;
            return;
        }
        Vector subs = this.search(false, i, this.BOTTOM, new Vector());
        Iterator i1 = supers.iterator();
        while (i1.hasNext()) {
            int j4 = (Integer)i1.next();
            this.pruned[i][j4] = 1;
        }
        Iterator i2 = subs.iterator();
        while (i2.hasNext()) {
            j = (Integer)i2.next();
            this.pruned[j][i] = 1;
        }
        i1 = supers.iterator();
        while (i1.hasNext()) {
            j = (Integer)i1.next();
            i2 = subs.iterator();
            while (i2.hasNext()) {
                int k = (Integer)i2.next();
                this.pruned[k][j] = 2;
            }
        }
        this.classified[i] = true;
    }

    private int index(ATerm c) {
        int i = 0;
        while (i < this.numClasses) {
            if (this.classes[i].equals((Object)c)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void mark(int i, int j) {
        if (i == j) {
            return;
        }
        if (this.subclass[i][j] == 1) {
            return;
        }
        if (this.subclass[i][j] == 2) {
            throw new RuntimeException("marking unmarked cells [" + i + "," + j + "] " + this.classes[i] + " " + this.classes[j]);
        }
        this.subclass[i][j] = 1;
        int k = 0;
        while (k < this.numClasses) {
            if (this.subclass[j][k] == 1) {
                this.mark(i, k);
            }
            ++k;
        }
        k = 0;
        while (k < this.numClasses) {
            if (this.subclass[k][i] == 1) {
                this.mark(k, j);
            }
            ++k;
        }
    }

    private void unmark(int i, int j) {
        if (this.subclass[i][j] == 2) {
            return;
        }
        if (this.subclass[i][j] == 1) {
            throw new RuntimeException("unmarking marked cells [" + i + "," + j + "] " + this.classes[i] + " " + this.classes[j]);
        }
        this.subclass[i][j] = 2;
        int k = 0;
        while (k < this.numClasses) {
            if (this.subclass[k][j] == 1) {
                this.unmark(i, k);
            }
            ++k;
        }
        k = 0;
        while (k < this.numClasses) {
            if (this.subclass[i][k] == 1) {
                this.unmark(k, j);
            }
            ++k;
        }
    }

    private boolean isSubclassOf(int i, int j) {
        boolean result;
        if (this.subclass[i][j] == 0) {
            long time = System.currentTimeMillis();
            result = this.reasoner.getABox().isSubclassOf(this.classes[i], this.classes[j]);
            if (result) {
                this.mark(i, j);
            } else {
                this.unmark(i, j);
            }
        } else {
            result = this.subclass[i][j] == 1;
        }
        return result;
    }

    public Vector getImmediateInstances(ATerm c) {
        return this.getInstances(c, false);
    }

    public Vector getInstances(ATerm c) {
        return this.getInstances(c, true);
    }

    public Vector getInstances(ATerm c, boolean getAll) {
        if (this.instances == null) {
            return null;
        }
        Vector result = new Vector();
        int i = this.index(c);
        if (i == -1) {
            throw new RuntimeException(c + " is an unknown class!");
        }
        if (this.instances[i] != null) {
            result.addAll(this.instances[i]);
        }
        if (getAll) {
            Vector subs = this.getSubClasses(this.classes[i]);
            int j = 0;
            while (j < subs.size()) {
                ATerm sub = (ATerm)subs.get(j);
                result.addAll(this.getInstances(sub));
                ++j;
            }
        }
        return result;
    }

    public boolean isSubclassOf(ATerm x, ATerm y) {
        int i = this.index(x);
        int j = this.index(y);
        if (i == -1) {
            throw new RuntimeException(x + " is an unknown class!");
        }
        if (j == -1) {
            throw new RuntimeException(y + " is an unknown class!");
        }
        return this.subclass[i][j] == 1;
    }

    public Vector getImmediateSubClasses(ATerm c) {
        return this.getSubClasses(c, false);
    }

    public Vector getSubClasses(ATerm c) {
        return this.getSubClasses(c, true);
    }

    public Vector getSubClasses(ATerm c, boolean getAll) {
        Vector<ATerm> result = new Vector<ATerm>();
        byte[][] sub = getAll ? this.subclass : this.pruned;
        int i = this.index(c);
        if (i == -1) {
            throw new RuntimeException(c + " is an unknown class!");
        }
        int j = 0;
        while (j < this.numClasses) {
            if (sub[j][i] == 1) {
                result.add(this.classes[j]);
            }
            ++j;
        }
        result.addAll(this.getSameClasses(c));
        return result;
    }

    public Vector getSuperClasses(ATerm c) {
        return this.getSuperClasses(c, false);
    }

    public Vector getImmediateSuperClasses(ATerm c) {
        return this.getSuperClasses(c, true);
    }

    public Vector getSuperClasses(ATerm c, boolean getAll) {
        Vector<ATerm> result = new Vector<ATerm>();
        byte[][] sub = getAll ? this.subclass : this.pruned;
        int i = this.index(c);
        byte[] test = sub[i];
        if (i == -1) {
            throw new RuntimeException(c + " is an unknown class!");
        }
        int j = 0;
        while (j < this.numClasses) {
            if (sub[i][j] == 1) {
                result.add(this.classes[j]);
            }
            ++j;
        }
        result.addAll(this.getSameClasses(c));
        return result;
    }

    public Vector getSameClasses(ATerm c) {
        Vector<ATerm> result = new Vector<ATerm>();
        int i = this.index(c);
        if (i == -1) {
            throw new RuntimeException(c + " is an unknown class!");
        }
        int same = this.sameAs[i];
        int j = 0;
        while (j < this.numClasses) {
            if (i != j && this.sameAs[j] == same) {
                result.add(this.classes[j]);
            }
            ++j;
        }
        return result;
    }

    private boolean subclass(int i, int j) {
        return this.subclass[i][j] == 1;
    }

    public void print() {
        this.print(0);
    }

    public void print(int format) {
        this.print(new OutputFormatter(), format);
    }

    public void print(OutputFormatter out, int format) {
        out.println();
        switch (format) {
            case 0: {
                this.printTree(out.getWriter(), out.isFormatHTML());
                break;
            }
            case 1: {
                this.printTable(out.getWriter(), out.isFormatHTML());
                break;
            }
            case 2: {
                out.printTag("<pre>");
                this.printRDF(out.getWriter());
                out.printTag("</pre>");
                break;
            }
            default: {
                out.println("Don't know how to print classification in this format");
            }
        }
        out.println();
        out.flush();
        if (DEBUG) {
            this.printStats();
        }
    }

    private void printRDF(PrintWriter out) {
        boolean remember = showFullURIs;
        showFullURIs = true;
        out.println("&lt;rdf:RDF");
        out.println("  xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"");
        out.println("  xmlns:rdfs=\"http://www.w3.org/2000/01/rdf-schema#\"&gt;");
        int i = 0;
        while (i < this.numClasses - 2) {
            out.println("&lt;rdf:Description rdf:about=\"" + this.getClassName(i) + "\"&gt;");
            int index = this.sameAs[i];
            int j = 0;
            while (j < this.numClasses - 2) {
                if (index != j && this.pruned[index][j] == 1) {
                    out.println("  &lt;rdfs:subClassOf rdf:resource=\"" + this.getClassName(j) + "\"/&gt;");
                }
                ++j;
            }
            out.println("&lt;/rdf:Description&gt;");
            ++i;
        }
        out.println("&lt;/rdf:RDF&gt;");
        showFullURIs = remember;
    }

    private void printTable(PrintWriter out, boolean formatHTML) {
        byte[][] sub = this.pruned;
        if (formatHTML) {
            out.println("<br><table border=0>");
            out.println("<tr><td><b>Class</b></td><td><b>Super classes</b></td><td><b>Subclasses</b></td></tr>");
        }
        int i = 0;
        while (i < this.numClasses - 2) {
            if (formatHTML) {
                out.print("<tr><td>");
                this.printNode(out, i);
                out.print("</td><td>");
            } else {
                out.print("[");
                this.printNode(out, i);
                out.print("] super-concepts(");
            }
            int j = 0;
            while (j < this.numClasses) {
                if (i != j && sub[i][j] == 1) {
                    out.print(String.valueOf(this.getClassName(j)) + " ");
                }
                ++j;
            }
            if (formatHTML) {
                out.print("</td><td>");
            } else {
                out.print(") sub-concepts(");
            }
            j = 0;
            while (j < this.numClasses) {
                if (i != j && sub[j][i] == 1) {
                    out.print(String.valueOf(this.getClassName(j)) + " ");
                }
                ++j;
            }
            if (formatHTML) {
                out.println("</td></tr>");
            } else {
                out.println(")");
            }
            ++i;
        }
        if (formatHTML) {
            out.print("</table><br>");
        }
    }

    private void printTree(PrintWriter out, boolean formatHTML) {
        if (formatHTML) {
            out.println("<ul>");
        }
        this.printTree(out, this.TOP, "", formatHTML);
        if (formatHTML) {
            out.println("</ul>");
        }
        int i = 0;
        while (i < this.numClasses - 2) {
            if (this.sameAs[i] == this.BOTTOM) {
                if (formatHTML) {
                    out.println("<ul><li>");
                }
                this.printNode(out, this.BOTTOM);
                if (!formatHTML) break;
                out.println("</li></ul>");
                break;
            }
            ++i;
        }
    }

    private void printTree(PrintWriter out, int i, String indent, boolean formatHTML) {
        if (this.sameAs[i] == this.BOTTOM || this.sameAs[i] != i) {
            return;
        }
        if (formatHTML) {
            out.print("<li>");
        } else {
            out.print(indent);
        }
        this.printNode(out, i);
        if (formatHTML) {
            out.println("</li>");
        } else {
            out.println();
        }
        if (formatHTML) {
            out.print("<ul>");
        }
        Vector subs = this.getImmediateSubClasses(this.classes[i]);
        Collections.sort(subs, ATermUtils.stringComparator);
        int j = 0;
        while (j < subs.size()) {
            this.printTree(out, this.index((ATerm)subs.get(j)), String.valueOf(indent) + INDENT, formatHTML);
            ++j;
        }
        if (formatHTML) {
            out.print("</ul>");
        }
    }

    private void printNode(PrintWriter out, int i) {
        out.print(this.getClassName(i));
        int sameCount = 0;
        int j = 0;
        while (j < this.numClasses - 2) {
            if (i != j && this.sameAs[j] == i) {
                if (sameCount == 0) {
                    out.print(" (= ");
                } else {
                    out.print(", ");
                }
                out.print(this.getClassName(j));
                ++sameCount;
            }
            ++j;
        }
        if (sameCount > 0) {
            out.print(")");
        }
        if (this.instances != null && this.instances[i] != null) {
            out.print(" - (");
            Iterator ins = this.instances[i].iterator();
            while (ins.hasNext()) {
                ATerm x = (ATerm)ins.next();
                out.print(OWLParser.getLocalName(((ATermAppl)x).getName()));
                if (!ins.hasNext()) continue;
                out.print(", ");
            }
            out.print(")");
        }
    }

    private String getClassName(int i) {
        if (showFullURIs) {
            return this.getFullClassName(i);
        }
        return this.getShortClassName(i);
    }

    private String getShortClassName(int i) {
        if (i == this.TOP) {
            return "owl:Thing";
        }
        if (i == this.BOTTOM) {
            return "owl:Nothing";
        }
        return OWLParser.getLocalName(this.classes[i].toString());
    }

    private String getFullClassName(int i) {
        if (i == this.TOP) {
            return "http://www.w3.org/2002/07/owl#Thing";
        }
        if (i == this.BOTTOM) {
            return "http://www.w3.org/2002/07/owl#Nothing";
        }
        return ((ATermAppl)this.classes[i]).getName();
    }

    private void printStats(byte[][] subclass) {
        int size = this.numClasses * this.numClasses;
        int known = 0;
        int positive = 0;
        int i = 0;
        while (i < this.numClasses) {
            int j = 0;
            while (j < this.numClasses) {
                if (subclass[i][j] != 0) {
                    ++known;
                }
                if (subclass[i][j] == 1) {
                    ++positive;
                }
                ++j;
            }
            ++i;
        }
        System.out.println("Size: " + size + " Known: " + known + " Positive: " + positive);
    }

    public void printStats() {
        this.printStats(this.subclass);
        System.out.println("Num of Classes: " + this.numClasses + " Pairs: " + this.numClasses * this.numClasses + " Subsumption Count: " + ABox.satisfiabilityCount);
    }

    private void printArray(byte[][] subclass, boolean all) {
        int known = 0;
        System.out.println();
        int i = 0;
        while (i < this.numClasses) {
            if (all || this.classified[i]) {
                StringBuffer name = new StringBuffer(String.valueOf(i) + " " + this.getClassName(i));
                name.append("              ");
                name.setLength(15);
                name.append(" ");
                System.out.print(name.toString());
                int j = 0;
                while (j < this.numClasses) {
                    if (all || this.classified[j]) {
                        System.out.print(String.valueOf(chars[subclass[i][j]]) + " ");
                        if (subclass[i][j] != 0) {
                            ++known;
                        }
                    }
                    ++j;
                }
                System.out.println("");
            }
            ++i;
        }
        System.out.println("Known: " + known);
    }
}

