/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import org.mindswap.pellet.ATermUtils;
import org.mindswap.pellet.Datatype;
import org.mindswap.pellet.IntervalList;
import org.mindswap.pellet.UnsupportedFeatureException;

public class DatatypeReasoner {
    public static final String XSD_URI = "http://www.w3.org/2001/XMLSchema#";
    public static final String RDF_URI = RDF.getURI();
    public static final long NegInf = Long.MIN_VALUE;
    public static final long PosInf = Long.MAX_VALUE;
    private Hashtable typeMapping = new Hashtable();
    private static HashSet notSupported = new HashSet();

    DatatypeReasoner() {
    }

    public static void supportAll() {
        notSupported = new HashSet();
    }

    public static void dontSupport(String dt) {
        notSupported.add(dt);
    }

    public static boolean isSupported(String dt) {
        return !notSupported.contains(dt);
    }

    public void defineDatatype(String name, Datatype dt) {
        this.typeMapping.put(name, dt);
    }

    public void removeDatatype(String name) {
        this.typeMapping.remove(name);
    }

    public Datatype mapRDFDatatype(String rdfURI) {
        if (!rdfURI.startsWith(RDF_URI)) {
            return null;
        }
        String dtName = rdfURI.substring(RDF_URI.length());
        if (dtName.equals("Literal")) {
            return new Datatype.DTLiteral();
        }
        if (dtName.equals("XMLLiteral")) {
            return new Datatype.DTXMLLiteral();
        }
        return null;
    }

    public Datatype mapXSDDatatype(String xsdURI) {
        if (!xsdURI.startsWith(XSD_URI)) {
            return null;
        }
        String dtName = xsdURI.substring(XSD_URI.length());
        if (dtName.equals("integer")) {
            return new Datatype.DTInteger(Long.MIN_VALUE, Long.MAX_VALUE);
        }
        if (dtName.equals("nonPositiveInteger")) {
            return new Datatype.DTInteger(Long.MIN_VALUE, 0L);
        }
        if (dtName.equals("negativeInteger")) {
            return new Datatype.DTInteger(Long.MIN_VALUE, -1L);
        }
        if (dtName.equals("nonNegativeInteger")) {
            return new Datatype.DTInteger(0L, Long.MAX_VALUE);
        }
        if (dtName.equals("positiveInteger")) {
            return new Datatype.DTInteger(1L, Long.MAX_VALUE);
        }
        if (dtName.equals("long")) {
            return new Datatype.DTInteger(Long.MIN_VALUE, Long.MAX_VALUE);
        }
        if (dtName.equals("int")) {
            return new Datatype.DTInteger(Integer.MIN_VALUE, Integer.MAX_VALUE);
        }
        if (dtName.equals("short")) {
            return new Datatype.DTInteger(-32768L, 32767L);
        }
        if (dtName.equals("byte")) {
            return new Datatype.DTInteger(-128L, 127L);
        }
        if (dtName.equals("unsignedByte")) {
            return new Datatype.DTInteger(0L, 255L);
        }
        if (dtName.equals("unsignedShort")) {
            return new Datatype.DTInteger(0L, 65535L);
        }
        if (dtName.equals("unsignedInt")) {
            return new Datatype.DTInteger(0L, 0xFFFFFFFFL);
        }
        if (dtName.equals("unsignedLong")) {
            return new Datatype.DTInteger(0L, -1L);
        }
        if (dtName.equals("string")) {
            return new Datatype.DTString();
        }
        if (dtName.equals("boolean")) {
            return new Datatype.DTBoolean();
        }
        if (dtName.equals("anyURI")) {
            return new Datatype.DTAnyURI();
        }
        if (dtName.equals("date")) {
            return new Datatype.DTDateTime();
        }
        if (dtName.equals("dateTime")) {
            return new Datatype.DTDateTime();
        }
        if (dtName.equals("float")) {
            return new Datatype.DTFloat();
        }
        if (dtName.equals("double")) {
            return new Datatype.DTFloat();
        }
        if (dtName.equals("time")) {
            return new Datatype.DTDateTime();
        }
        if (dtName.equals("decimal")) {
            return new Datatype.DTString();
        }
        if (dtName.equals("base64Binary")) {
            return new Datatype.DTBinary();
        }
        if (dtName.equals("hex64Binary")) {
            return new Datatype.DTBinary();
        }
        if (dtName.equals("duration")) {
            return new Datatype.DTDuration();
        }
        if (dtName.equals("gYearMonth")) {
            return new Datatype.DTDateTime();
        }
        if (dtName.equals("gYear")) {
            return new Datatype.DTDateTime();
        }
        if (dtName.equals("gMonthDay")) {
            return new Datatype.DTDateTime();
        }
        if (dtName.equals("gDay")) {
            return new Datatype.DTDateTime();
        }
        if (dtName.equals("gMonth")) {
            return new Datatype.DTDateTime();
        }
        if (dtName.equals("normalizedString")) {
            return new Datatype.DTString();
        }
        if (dtName.equals("token")) {
            return new Datatype.DTString();
        }
        if (dtName.equals("language")) {
            return new Datatype.DTString();
        }
        if (dtName.equals("NMTOKEN")) {
            return new Datatype.DTString();
        }
        if (dtName.equals("Name")) {
            return new Datatype.DTString();
        }
        if (dtName.equals("NCName")) {
            return new Datatype.DTString();
        }
        throw new UnsupportedFeatureException("Unknown XSD datatype " + dtName);
    }

    public Datatype mapDatatype(ATerm dt) {
        if (dt instanceof ATermAppl) {
            Datatype ret;
            ATermAppl datatype = (ATermAppl)dt;
            if (datatype.getAFun().equals((Object)ATermUtils.DTFUN)) {
                String dtName = ((ATermAppl)datatype.getArgument(0)).getName();
                Datatype result = (Datatype)this.typeMapping.get(dtName);
                if (!DatatypeReasoner.isSupported(dtName)) {
                    result = new Datatype();
                }
                if (result == null) {
                    result = this.mapXSDDatatype(dtName);
                }
                if (result == null) {
                    result = this.mapRDFDatatype(dtName);
                }
                return result;
            }
            if (datatype.getAFun().equals((Object)ATermUtils.NOTFUN) && (ret = this.mapDatatype(datatype.getArgument(0))) != null) {
                ret.negate();
                return ret;
            }
        }
        return null;
    }

    public Datatype mapDatatype(String dtName) {
        return this.mapDatatype((ATerm)ATermUtils.makeDatatype(dtName));
    }

    public boolean isDatatype(String dtName) {
        return this.mapDatatype((ATerm)ATermUtils.makeDatatype(dtName)) != null;
    }

    boolean isEmpty(Datatype[] datatypes, String value) {
        int i = 0;
        while (i < datatypes.length) {
            boolean patternMatch;
            Datatype.DTString dt = (Datatype.DTString)datatypes[i];
            if (value != null && dt.pattern != null && (patternMatch = value.matches(dt.pattern)) == dt.negated) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean isEmpty(Datatype[] datatypes, Boolean value) {
        Boolean b = null;
        int i = 0;
        while (i < datatypes.length) {
            Datatype.DTBoolean dt = (Datatype.DTBoolean)datatypes[i];
            if (dt.value != null) {
                if (b == null) {
                    b = dt.value;
                } else if (b.booleanValue() != dt.value.booleanValue()) {
                    return true;
                }
            }
            ++i;
        }
        if (value == null) {
            return false;
        }
        return b != null && value.booleanValue() != b.booleanValue();
    }

    private IntervalList getIntegerConjunction(Datatype[] datatypes) {
        IntervalList result = new IntervalList(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        int i = 0;
        while (i < datatypes.length) {
            IntervalList normalized;
            Datatype.DTInteger dt = (Datatype.DTInteger)datatypes[i];
            if (dt.negated) {
                normalized = new IntervalList(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
                normalized.removeIntervalList(dt.values);
            } else {
                normalized = new IntervalList(dt.values);
            }
            IntervalList original = new IntervalList(result);
            result = new IntervalList();
            Iterator it = normalized.iterator();
            while (it.hasNext()) {
                IntervalList.Interval interval = (IntervalList.Interval)it.next();
                IntervalList o = new IntervalList(original);
                o.restrictToInterval(interval);
                result.addIntervalList(o);
            }
            ++i;
        }
        return result;
    }

    boolean isEmpty(Datatype[] datatypes, Number value) {
        IntervalList conjunction = this.getIntegerConjunction(datatypes);
        if (value == null) {
            return conjunction.isEmpty();
        }
        return !conjunction.contains(value.longValue());
    }

    int getIntegerMaxCount(Datatype[] datatypes) {
        IntervalList conjunction = this.getIntegerConjunction(datatypes);
        return conjunction.count();
    }

    boolean isEmpty(ATerm[] dt, Object value) {
        if (dt.length == 0) {
            return false;
        }
        Class<?> dtType = null;
        Datatype[] datatypes = new Datatype[dt.length];
        int i = 0;
        while (i < dt.length) {
            if (ATermUtils.isNominal(dt[i])) {
                ATermAppl lit = (ATermAppl)((ATermAppl)dt[i]).getArgument(0);
                String val = ((ATermAppl)lit.getArgument(0)).getName();
                String dtName = lit.getArgument(2).toString();
                if (dtName != null) {
                    datatypes[i] = this.mapXSDDatatype(dtName);
                }
                if (datatypes[i] == null) {
                    datatypes[i] = new Datatype.DTLiteral(val);
                } else {
                    datatypes[i].setValue(val);
                }
            } else {
                datatypes[i] = this.mapDatatype(dt[i]);
                if (dtType == null) {
                    dtType = datatypes[i].getClass();
                } else if (!datatypes[i].getClass().equals(dtType)) {
                    return true;
                }
            }
            ++i;
        }
        if (datatypes[0] instanceof Datatype.DTInteger) {
            return this.isEmpty(datatypes, (Number)value);
        }
        if (datatypes[0] instanceof Datatype.DTString) {
            return this.isEmpty(datatypes, (String)value);
        }
        return false;
    }

    long getMaxCount(ATerm[] dt) {
        if (dt.length == 0) {
            return Integer.MAX_VALUE;
        }
        Class<?> dtType = null;
        Datatype[] datatypes = new Datatype[dt.length];
        int i = 0;
        while (i < dt.length) {
            if (dt[i].equals((Object)ATermUtils.BOTTOM)) {
                return 0L;
            }
            if (ATermUtils.isNominal(dt[i])) {
                ATermAppl lit = (ATermAppl)((ATermAppl)dt[i]).getArgument(0);
                String val = lit.getArgument(0).toString();
                String dtName = lit.getArgument(1).toString();
                datatypes[i] = new Datatype.DTLiteral(val);
            } else {
                datatypes[i] = this.mapDatatype(dt[i]);
                if (datatypes[i] == null) {
                    System.out.println("here");
                }
                if (dtType == null) {
                    dtType = datatypes[i].getClass();
                } else if (!datatypes[i].getClass().equals(dtType)) {
                    return 0L;
                }
            }
            ++i;
        }
        if (datatypes[0] instanceof Datatype.DTInteger) {
            return this.getIntegerMaxCount(datatypes);
        }
        return Integer.MAX_VALUE;
    }
}

