/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import java.util.BitSet;
import java.util.Vector;

public class DifferentFrom {
    BitSet[] table = null;

    public DifferentFrom(int n) {
        if (n == 0) {
            this.table = null;
            return;
        }
        this.table = new BitSet[n - 1];
        int i = 0;
        while (i < n) {
            this.table[i] = new BitSet(i + 1);
            ++i;
        }
    }

    public Object clone() {
        DifferentFrom x = new DifferentFrom(0);
        if (this.table != null) {
            x.table = new BitSet[this.table.length];
            int i = 0;
            while (i < this.table.length) {
                x.table[i] = (BitSet)this.table[i].clone();
                ++i;
            }
        }
        return x;
    }

    public void incrementSize() {
        if (this.table == null) {
            this.table = new BitSet[0];
        } else {
            BitSet[] b = new BitSet[this.table.length + 1];
            System.arraycopy(this.table, 0, b, 0, this.table.length);
            b[this.table.length] = new BitSet(this.table.length);
            this.table = b;
        }
    }

    public Vector getDifferentFrom(int x) {
        int i;
        Vector<Integer> v = new Vector<Integer>();
        if (x > 0) {
            i = 0;
            while (i < x) {
                if (this.table[x - 1].get(i)) {
                    v.add(new Integer(i));
                }
                ++i;
            }
        }
        i = x;
        while (i < this.table.length) {
            if (this.table[i].get(x)) {
                v.add(new Integer(i + 1));
            }
            ++i;
        }
        return v;
    }

    public boolean isDifferentFrom(int x, int y) {
        if (x > y) {
            return this.table[x - 1].get(y);
        }
        if (x == y) {
            return false;
        }
        return this.table[y - 1].get(x);
    }

    public void setDifferentFrom(int x, int y) {
        if (x > y) {
            this.table[x - 1].set(y);
        } else {
            if (x == y) {
                throw new RuntimeException("Attempting to set inequality for an element itself");
            }
            this.table[y - 1].set(x);
        }
    }

    public String toString() {
        String diffs = "";
        int i = 0;
        while (i < this.table.length + 1) {
            diffs = String.valueOf(diffs) + this.getDifferentFrom(i);
            ++i;
        }
        diffs = String.valueOf(diffs) + " | ";
        i = 0;
        while (i < this.table.length) {
            diffs = String.valueOf(diffs) + this.table[i];
            ++i;
        }
        return diffs;
    }
}

