/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class IntervalList
implements Serializable {
    private final List intervals;

    public IntervalList(double start, double end) {
        this.intervals = new LinkedList();
        this.intervals.add(new Interval(start, end));
    }

    public IntervalList() {
        this.intervals = new LinkedList();
    }

    public IntervalList(IntervalList il) {
        this.intervals = new LinkedList(il.intervals);
    }

    public boolean isEmpty() {
        return this.intervals.size() == 0;
    }

    public double min() {
        if (this.intervals.size() == 0) {
            return Double.NaN;
        }
        return ((Interval)this.intervals.get(0)).start();
    }

    public double max() {
        if (this.intervals.size() == 0) {
            return Double.NaN;
        }
        return ((Interval)this.intervals.get(this.intervals.size() - 1)).end();
    }

    public int count() {
        double count = 0.0;
        ListIterator iter = this.intervals.listIterator();
        while (iter.hasNext()) {
            Interval i = (Interval)iter.next();
            count += (double)i.count();
        }
        if (count > 2.147483647E9) {
            return Integer.MAX_VALUE;
        }
        return (int)count;
    }

    private void canonicalize() {
        Collections.sort(this.intervals);
        ListIterator<Interval> iter = this.intervals.listIterator();
        if (!iter.hasNext()) {
            return;
        }
        Interval currentElement = (Interval)iter.next();
        while (iter.hasNext()) {
            Interval lastElement = currentElement;
            if (!lastElement.overlaps(currentElement = (Interval)iter.next())) continue;
            Interval newElement = lastElement.merge(currentElement);
            iter.remove();
            iter.previous();
            iter.remove();
            iter.add(newElement);
            currentElement = newElement;
        }
    }

    public void addInterval(double start, double end) {
        this.addIntervalInternal(start, end);
        this.canonicalize();
    }

    private void addIntervalInternal(double start, double end) {
        this.intervals.add(new Interval(start, end));
    }

    public void removeInterval(double start, double end) {
        this.removeIntervalInternal(start, end);
        this.canonicalize();
    }

    private void removeIntervalInternal(double start, double end) {
        ListIterator<Interval> iter = this.intervals.listIterator();
        Interval toRemove = new Interval(start, end);
        while (iter.hasNext()) {
            Interval curr = (Interval)iter.next();
            if (!curr.overlaps(toRemove)) continue;
            if (start > curr.start()) {
                if (end < curr.end()) {
                    iter.remove();
                    iter.add(new Interval(curr.start(), start - 1.0));
                    iter.add(new Interval(end + 1.0, curr.end()));
                    continue;
                }
                iter.remove();
                iter.add(new Interval(curr.start(), start - 1.0));
                continue;
            }
            if (end < curr.end()) {
                iter.remove();
                iter.add(new Interval(end + 1.0, curr.end()));
                continue;
            }
            iter.remove();
        }
    }

    public void addIntervalList(IntervalList il) {
        Iterator iter = il.intervals.iterator();
        while (iter.hasNext()) {
            Interval i = (Interval)iter.next();
            this.addIntervalInternal(i.start(), i.end());
        }
        this.canonicalize();
    }

    public void removeIntervalList(IntervalList il) {
        Iterator iter = il.intervals.iterator();
        while (iter.hasNext()) {
            Interval i = (Interval)iter.next();
            this.removeIntervalInternal(i.start(), i.end());
        }
        this.canonicalize();
    }

    public void restrictToInterval(double start, double end) {
        this.restrictToInterval(new Interval(start, end));
    }

    public void restrictToInterval(Interval i) {
        ListIterator<Interval> iter = this.intervals.listIterator();
        while (iter.hasNext()) {
            Interval curr = (Interval)iter.next();
            if (curr.overlaps(i)) {
                iter.set(curr.restrictTo(i));
                continue;
            }
            iter.remove();
        }
    }

    public boolean restrictSubIntervalLength(double length) {
        boolean changed = false;
        ListIterator<Interval> iter = this.intervals.listIterator();
        while (iter.hasNext()) {
            Interval curr = (Interval)iter.next();
            Interval n = curr.restrictLength(length);
            if (n.equals(curr)) continue;
            changed = true;
            iter.set(n);
        }
        return changed;
    }

    public Iterator iterator() {
        return Collections.unmodifiableList(this.intervals).iterator();
    }

    public boolean equals(Object o) {
        if (o instanceof IntervalList) {
            IntervalList il = (IntervalList)o;
            return this.intervals.equals(il.intervals);
        }
        return false;
    }

    public int hashCode() {
        return this.intervals.hashCode();
    }

    public String toString() {
        return this.intervals.toString();
    }

    public boolean contains(double value) {
        ListIterator iter = this.intervals.listIterator();
        while (iter.hasNext()) {
            Interval curr = (Interval)iter.next();
            if (!curr.contains(value)) continue;
            return true;
        }
        return false;
    }

    public static class Interval
    implements Comparable,
    Serializable {
        public final double start;
        public final double end;

        public Interval(double start, double end) {
            if (Double.isNaN(start) || Double.isNaN(end)) {
                throw new IllegalArgumentException();
            }
            if (end < start) {
                System.out.println("start = " + start);
                System.out.println("end   = " + end);
                throw new IllegalArgumentException();
            }
            this.start = start;
            this.end = end;
        }

        public double start() {
            return this.start;
        }

        public double end() {
            return this.end;
        }

        public int count() {
            double count = this.end - this.start + 1.0;
            if (count > 2.147483647E9) {
                return Integer.MAX_VALUE;
            }
            return (int)count;
        }

        private boolean overlaps(Interval i) {
            if (this.start <= i.start) {
                return !(i.start > this.end);
            }
            return i.overlaps(this);
        }

        private Interval merge(Interval i) {
            if (this.overlaps(i)) {
                if (this.start <= i.start) {
                    return new Interval(this.start, i.end > this.end ? i.end : this.end);
                }
                return i.merge(this);
            }
            throw new IllegalArgumentException();
        }

        private Interval restrictLength(double length) {
            if (!Double.isInfinite(this.start) && !Double.isInfinite(this.end) && this.end - this.start > length) {
                return new Interval(this.start, this.start + length);
            }
            if (!Double.isInfinite(this.start) && Double.isInfinite(this.end)) {
                return new Interval(this.start, this.start + length);
            }
            return this;
        }

        private Interval restrictTo(Interval i) {
            if (!this.overlaps(i)) {
                throw new IllegalArgumentException();
            }
            return new Interval(this.start > i.start ? this.start : i.start, this.end < i.end ? this.end : i.end);
        }

        public int compareTo(Object o) {
            Interval i = (Interval)o;
            if (this.start < i.start) {
                return -1;
            }
            if (this.start > i.start) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (o instanceof Interval) {
                Interval i = (Interval)o;
                if (i == this) {
                    return true;
                }
                return this.start == i.start && this.end == i.end;
            }
            return false;
        }

        public int hashCode() {
            return new Double(this.start).hashCode();
        }

        public String toString() {
            return "[" + this.start + " - " + this.end + "]";
        }

        public boolean contains(double value) {
            return this.start <= value && value <= this.end;
        }
    }
}

