/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.mindswap.pellet.ATermUtils;
import org.mindswap.pellet.DependencySet;

public class Literal {
    ATerm name;
    Object value;
    String language;
    int index;
    int branch;
    private Hashtable depends;
    ArrayList datatypes;

    public Literal(ATerm name, Object value, int branch) {
        this(name, value, branch, null);
    }

    public Literal(ATerm name, Object value, int branch, String language) {
        this.name = name;
        this.value = value;
        this.language = language;
        this.branch = branch;
        this.initTypes();
    }

    private void initTypes() {
        this.datatypes = new ArrayList();
        this.depends = new Hashtable();
    }

    public Object clone() {
        Literal n = new Literal(this.name, this.value, this.branch, this.language);
        n.index = this.index;
        n.datatypes = (ArrayList)this.datatypes.clone();
        n.depends = (Hashtable)this.depends.clone();
        return n;
    }

    public DependencySet getDepends(ATerm c) {
        return (DependencySet)this.depends.get(c);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addType(ATerm c, DependencySet d) {
        if (this.depends.containsKey(c)) {
            throw new RuntimeException("Concept " + c + " exists with a dependency set " + this.depends.get(c) + " " + this.hasType(c) + " " + this + "  " + this.depends);
        }
        this.depends.put(c, d);
        if (!(c instanceof ATermAppl)) throw new RuntimeException("Invalid datatype " + c);
        ATermAppl a = (ATermAppl)c;
        if (a.getAFun().equals((Object)ATermUtils.ANDFUN)) {
            ATermList conj = ATermUtils.andToList(a);
            while (!conj.isEmpty()) {
                this.addType(conj.getFirst(), d);
                conj = conj.getNext();
            }
            return;
        } else {
            if (a.equals((Object)ATermUtils.TOP)) {
                return;
            }
            if (a.equals((Object)ATermUtils.BOTTOM) || a.getAFun().equals((Object)ATermUtils.DTFUN) || a.getAFun().equals((Object)ATermUtils.NOTFUN)) {
                this.datatypes.add(c);
                return;
            } else {
                if (!a.getAFun().equals((Object)ATermUtils.VALUEFUN)) throw new RuntimeException("Invalid datatype " + c);
                this.datatypes.add(c);
                String val = a.getArgument(0).toString();
                if (this.value != null) return;
                this.value = val;
            }
        }
    }

    public void removeType(ATerm c) {
        this.datatypes.remove(c);
        this.depends.remove(c);
    }

    public boolean hasType(ATerm c) {
        if (c instanceof ATermAppl) {
            ATermAppl a = (ATermAppl)c;
            if (a.getAFun().equals((Object)ATermUtils.ANDFUN)) {
                ATermList conj = ATermUtils.andToList(a);
                while (!conj.isEmpty()) {
                    if (!this.hasType(conj.getFirst())) {
                        return false;
                    }
                    conj = conj.getNext();
                }
                return true;
            }
            if (a.equals((Object)ATermUtils.TOP)) {
                return true;
            }
            if (a.equals((Object)ATermUtils.BOTTOM) || a.getAFun().equals((Object)ATermUtils.DTFUN) || a.getAFun().equals((Object)ATermUtils.NOTFUN) || a.getAFun().equals((Object)ATermUtils.VALUEFUN)) {
                return this.datatypes.contains(c);
            }
            throw new RuntimeException("Invalid datatype " + c);
        }
        throw new RuntimeException("Invalid datatype " + c);
    }

    public List getTypes() {
        ArrayList types = new ArrayList();
        types.addAll(this.datatypes);
        return types;
    }

    public void removeTypes() {
        this.initTypes();
    }

    public List getDatatypes() {
        return this.datatypes;
    }

    public Object getValue() {
        return this.value;
    }

    public ATerm getName() {
        return this.name;
    }

    public String toString() {
        return String.valueOf(this.datatypes.toString());
    }
}

