/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.ATermUtils;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;

public class Node {
    private ATerm name;
    private String nameStr;
    public Hashtable depends;
    private int index;
    private int branch;
    private Hashtable edges;
    private Hashtable reverseEdges;
    private LinkedList atomic;
    private LinkedList conjunctions;
    private LinkedList disjunctions;
    private LinkedList someValues;
    private LinkedList allValues;
    private LinkedList minCardinality;
    private LinkedList maxCardinality;
    private LinkedList negations;
    private LinkedList nominals;
    Vector deletedEdges = new Vector();
    Vector deletedReverseEdges = new Vector();
    DeletedTypes deletedTypes = null;

    Node(ATerm n, int i, int b) {
        this.name = n;
        this.nameStr = ((ATermAppl)n).getName();
        this.depends = new Hashtable();
        this.index = i;
        this.branch = b;
        this.edges = new Hashtable();
        this.reverseEdges = new Hashtable();
        this.deletedEdges = new Vector();
        this.initTypes();
    }

    private void initTypes() {
        this.atomic = new LinkedList();
        this.conjunctions = new LinkedList();
        this.disjunctions = new LinkedList();
        this.someValues = new LinkedList();
        this.allValues = new LinkedList();
        this.minCardinality = new LinkedList();
        this.maxCardinality = new LinkedList();
        this.negations = new LinkedList();
        this.nominals = new LinkedList();
        this.depends = new Hashtable();
    }

    public Object clone() {
        Node n = new Node(this.name, this.index, this.branch);
        n.atomic = (LinkedList)this.atomic.clone();
        n.conjunctions = (LinkedList)this.conjunctions.clone();
        n.disjunctions = (LinkedList)this.disjunctions.clone();
        n.someValues = (LinkedList)this.someValues.clone();
        n.allValues = (LinkedList)this.allValues.clone();
        n.minCardinality = (LinkedList)this.minCardinality.clone();
        n.maxCardinality = (LinkedList)this.maxCardinality.clone();
        n.negations = (LinkedList)this.negations.clone();
        n.nominals = (LinkedList)this.nominals.clone();
        n.depends = new Hashtable(this.depends);
        n.edges = new Hashtable(this.edges);
        n.reverseEdges = new Hashtable(this.reverseEdges);
        return n;
    }

    public void addType(ATerm c, DependencySet d) {
        if (this.depends.containsKey(c)) {
            throw new RuntimeException("Concept " + c + " exists with a dependency set " + this.depends.get(c) + " " + this.hasType(c) + " " + this + "  " + this.depends);
        }
        this.depends.put(c, d);
        if (ATermUtils.isPrimitive(c)) {
            this.atomic.add(c);
        } else {
            ATermAppl a = (ATermAppl)c;
            if (a.getAFun().equals((Object)ATermUtils.ANDFUN)) {
                this.conjunctions.add(c);
                ATermList cs = (ATermList)a.getArgument(0);
                while (!cs.isEmpty()) {
                    ATerm conj = cs.getFirst();
                    if (!this.hasType(conj)) {
                        this.addType(conj, d);
                    }
                    cs = cs.getNext();
                }
            } else if (a.getAFun().equals((Object)ATermUtils.ALLFUN)) {
                this.allValues.add(c);
            } else if (a.getAFun().equals((Object)ATermUtils.MINFUN)) {
                this.minCardinality.add(c);
            } else if (a.getAFun().equals((Object)ATermUtils.NOTFUN)) {
                ATerm x = ATermUtils.getNegated((ATerm)a);
                if (ATermUtils.isAnd(x)) {
                    this.disjunctions.add(c);
                } else if (ATermUtils.isAllValues(x)) {
                    this.someValues.add(c);
                } else if (ATermUtils.isMin(x)) {
                    this.maxCardinality.add(c);
                } else {
                    this.negations.add(c);
                }
            } else if (a.getAFun().equals((Object)ATermUtils.VALUEFUN)) {
                this.nominals.add(c);
            } else if (a.getAFun().equals((Object)ATermUtils.DTFUN)) {
                this.negations.add(ATermUtils.BOTTOM);
                this.depends.put(ATermUtils.BOTTOM, d);
            } else {
                System.err.println("Warning: Unknown class constructor - " + c);
                this.negations.add(ATermUtils.BOTTOM);
                this.depends.put(ATermUtils.BOTTOM, d);
            }
        }
    }

    public void removeType(ATerm c) {
        this.depends.remove(c);
        if (ATermUtils.isPrimitive(c)) {
            this.atomic.remove(c);
        } else {
            ATermAppl a = (ATermAppl)c;
            if (a.getAFun().equals((Object)ATermUtils.ANDFUN)) {
                this.conjunctions.remove(c);
            } else if (a.getAFun().equals((Object)ATermUtils.ALLFUN)) {
                this.allValues.remove(c);
            } else if (a.getAFun().equals((Object)ATermUtils.MINFUN)) {
                this.minCardinality.remove(c);
            } else if (a.getAFun().equals((Object)ATermUtils.NOTFUN)) {
                ATerm x = ATermUtils.getNegated((ATerm)a);
                if (ATermUtils.isAnd(x)) {
                    this.disjunctions.remove(c);
                } else if (ATermUtils.isAllValues(x)) {
                    this.someValues.remove(c);
                } else if (ATermUtils.isMin(x)) {
                    this.maxCardinality.remove(c);
                } else {
                    this.negations.remove(c);
                }
            } else if (a.getAFun().equals((Object)ATermUtils.VALUEFUN)) {
                this.nominals.remove(c);
            } else {
                throw new RuntimeException("Invalid concept " + c);
            }
        }
    }

    public boolean hasType(ATerm c) {
        return this.depends.containsKey(c);
    }

    public DependencySet getDepends(ATerm c) {
        return (DependencySet)this.depends.get(c);
    }

    public List getTypes() {
        LinkedList types = new LinkedList();
        types.addAll(this.atomic);
        types.addAll(this.conjunctions);
        types.addAll(this.disjunctions);
        types.addAll(this.someValues);
        types.addAll(this.allValues);
        types.addAll(this.minCardinality);
        types.addAll(this.maxCardinality);
        types.addAll(this.negations);
        types.addAll(this.nominals);
        return types;
    }

    public void removeTypes(int branch) {
        this.deletedTypes = new DeletedTypes(this.getTypes(), this.depends, branch);
        this.initTypes();
    }

    public Set getSuccessors() {
        return this.edges.keySet();
    }

    public Set getPredecessors() {
        return this.reverseEdges.keySet();
    }

    public void addEmptyEdge(ATerm x) {
        this.edges.put(x, new EdgeList());
    }

    public void addEmptyReverseEdge(ATerm x) {
        this.reverseEdges.put(x, new EdgeList());
    }

    public void addReverseEdge(Edge edge) {
        ATerm x = edge.from;
        EdgeList e = (EdgeList)this.reverseEdges.get(x);
        if (e == null) {
            e = new EdgeList();
            this.reverseEdges.put(x, e);
        }
        e.addEdge(edge);
    }

    public void addEdge(Edge edge) {
        ATerm x = edge.to;
        EdgeList e = (EdgeList)this.edges.get(x);
        if (e == null) {
            e = new EdgeList();
            this.edges.put(x, e);
        }
        e.addEdge(edge);
    }

    public Hashtable getEdgeMappings() {
        return this.edges;
    }

    public EdgeList getEdges(ATerm x) {
        return (EdgeList)this.edges.get(x);
    }

    public EdgeList getEdges() {
        EdgeList l = new EdgeList();
        Iterator allEdges = this.edges.values().iterator();
        while (allEdges.hasNext()) {
            EdgeList edges = (EdgeList)allEdges.next();
            if (edges == null) continue;
            l.addEdgeList(edges);
        }
        return l;
    }

    public EdgeList getReverseEdges() {
        EdgeList l = new EdgeList();
        Iterator allEdges = this.reverseEdges.values().iterator();
        while (allEdges.hasNext()) {
            EdgeList edges = (EdgeList)allEdges.next();
            if (edges == null) continue;
            l.addEdgeList(edges);
        }
        return l;
    }

    public void restore(int branch) {
        DeletedEdges de;
        DependencySet d;
        Edge e;
        Iterator j;
        ATerm c;
        if (ABox.DEBUG) {
            System.out.println("Node " + this.name);
        }
        Iterator<Object> i = null;
        if (this.deletedTypes != null) {
            i = this.deletedTypes.types.iterator();
            while (i.hasNext()) {
                c = (ATerm)i.next();
                if (this.hasType(c)) continue;
                if (ABox.DEBUG) {
                    System.out.println("Restoring deleted type - add " + this.name + " " + c);
                }
                this.addType(c, (DependencySet)this.deletedTypes.depends.get(c));
                DependencySet dependencySet = this.getDepends(c);
            }
        }
        i = this.getTypes().iterator();
        while (i.hasNext()) {
            c = (ATerm)i.next();
            DependencySet d2 = this.getDepends(c);
            if (d2.branch <= branch) continue;
            if (ABox.DEBUG) {
                System.out.println("Restoring added type - remove " + this.name + " " + c + " " + d2 + " " + d2.branch + " > " + branch);
            }
            this.removeType(c);
        }
        i = this.edges.values().iterator();
        while (i.hasNext()) {
            EdgeList edges = (EdgeList)i.next();
            j = edges.iterator();
            while (j.hasNext()) {
                e = (Edge)j.next();
                d = e.depends;
                if (d.branch <= branch) continue;
                if (ABox.DEBUG) {
                    System.out.println("Restoring added edge - delete " + e.name + " " + e.to);
                }
                j.remove();
            }
        }
        i = this.deletedEdges.iterator();
        while (i.hasNext()) {
            de = (DeletedEdges)i.next();
            EdgeList edges = de.edges;
            if (de.branch <= branch) continue;
            i.remove();
            Iterator j2 = de.edges.iterator();
            while (j2.hasNext()) {
                Edge e2 = (Edge)j2.next();
                DependencySet d3 = e2.depends;
                if (d3.branch > branch) continue;
                if (ABox.DEBUG) {
                    System.out.println("Restoring deleted edge - add " + e2.name + " " + e2.to + " " + d3 + " " + de.branch + " > " + branch);
                }
                this.addEdge(e2);
            }
        }
        i = this.deletedReverseEdges.iterator();
        while (i.hasNext()) {
            de = (DeletedEdges)i.next();
            if (de.branch <= branch) continue;
            i.remove();
            j = de.edges.iterator();
            while (j.hasNext()) {
                e = (Edge)j.next();
                d = e.depends;
                if (d.branch > branch) continue;
                this.addReverseEdge(e);
            }
        }
    }

    public void removeEdge(ATerm x) {
        this.removeEdge(x, -1);
    }

    public void removeEdge(ATerm x, int b) {
        EdgeList e = (EdgeList)this.edges.remove(x);
        if (b > -1) {
            this.deletedEdges.add(new DeletedEdges(e, b));
        }
    }

    public void removeReverseEdge(ATerm x, int b) {
        EdgeList e = (EdgeList)this.reverseEdges.remove(x);
        this.deletedReverseEdges.add(new DeletedEdges(e, b));
    }

    public boolean hasEdge(ATerm r, ATerm x) {
        EdgeList edges = this.getEdges(x);
        return edges != null && edges.hasEdge(r);
    }

    public boolean hasEdgeR(ATerm r) {
        Iterator allEdges = this.edges.values().iterator();
        while (allEdges.hasNext()) {
            EdgeList edges = (EdgeList)allEdges.next();
            if (!edges.hasEdge(r)) continue;
            return true;
        }
        return false;
    }

    public List getAllValues() {
        return this.allValues;
    }

    public List getAtomic() {
        return this.atomic;
    }

    public List getConjunctions() {
        return this.conjunctions;
    }

    public List getDisjunctions() {
        return this.disjunctions;
    }

    public List getMaxCardinality() {
        return this.maxCardinality;
    }

    public List getMinCardinality() {
        return this.minCardinality;
    }

    public ATerm getName() {
        return this.name;
    }

    public String getNameStr() {
        return this.nameStr;
    }

    public List getNegations() {
        return this.negations;
    }

    public List getNominals() {
        return this.nominals;
    }

    public List getSomeValues() {
        return this.someValues;
    }

    public boolean isLeaf() {
        return this.edges.size() == 0;
    }

    public String toString() {
        return String.valueOf(this.atomic.toString()) + this.negations.toString() + this.someValues.toString() + this.allValues.toString() + this.minCardinality.toString() + this.maxCardinality.toString() + this.nominals.toString() + this.conjunctions.toString() + this.disjunctions.toString() + "; **" + this.edges + "**";
    }

    public int getIndex() {
        return this.index;
    }

    class DeletedEdges {
        EdgeList edges;
        int branch;

        DeletedEdges(EdgeList e, int b) {
            this.edges = e;
            this.branch = b;
        }
    }

    class DeletedTypes {
        Hashtable depends;
        List types;
        int branch;

        DeletedTypes(List t, Hashtable d, int b) {
            this.types = t;
            this.depends = d;
            this.branch = b;
        }
    }
}

