/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.AFun;
import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFException;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.lre.graph.Graph;
import com.lre.graph.UndirectedGraph;
import com.lre.graph.Vertex;
import java.net.URI;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.ATermUtils;
import org.mindswap.pellet.Datatype;
import org.mindswap.pellet.DatatypeReasoner;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.OWLReasoner;
import org.mindswap.pellet.Pellet;
import org.mindswap.pellet.TBox;
import org.mindswap.pellet.TermDefinition;
import org.mindswap.pellet.UnsupportedFeatureException;

public class OWLParser {
    public static boolean DEBUG = false;
    public static String BASE_URI = "http://temp/";
    public static boolean LOAD_IMPORTS = true;
    public static int MAX_CARD_VALUE = 1000;
    public static boolean SHOW_INFO = true;
    public static boolean USE_LOCAL_NAME = false;
    public static boolean USE_QNAME = false;
    public static boolean PRINT_SIZE = false;
    public static boolean NO_ANON_CLASSES = false;
    public static Hashtable nsPrefix = new Hashtable();
    static final List RESTRICTION_PROPS = Arrays.asList(OWL.onProperty, OWL.hasValue, OWL.allValuesFrom, OWL.someValuesFrom, OWL.minCardinality, OWL.maxCardinality, OWL.cardinality);
    static final List RDFS_PROPS = Arrays.asList("subClassOf", "subPropertyOf", "domain", "range", "label", "comment", "isDefinedBy", "seeAlso");
    Hashtable lists = new Hashtable();
    Hashtable restrictions = new Hashtable();
    HashSet classes = new HashSet();
    HashSet mDataranges = new HashSet();
    ATermList tboxAxioms = ATermUtils.makeList();
    ABox abox = null;
    static Model model = ModelFactory.createDefaultModel();
    static boolean canOutputDL = false;
    static Model missingTriples = ModelFactory.createDefaultModel();
    public static boolean THROW_UNSUPPORTED_EXCEPTIONS = false;
    public static boolean SKIP_REASONING = false;
    private static OWLParser parser = new OWLParser();
    public static String level = "Lite";
    public static HashSet nonLite = new HashSet();
    public static HashSet nonDL = new HashSet();
    public static HashSet nonOWL = new HashSet();
    public static HashSet unsupportedFeatures = new HashSet();
    public static HashSet warnings = new HashSet();
    private HashSet mUsedBnodes = new HashSet();
    private Graph mDisjointWithGraph = new Graph();
    private boolean mCheckStructureSharing = false;
    private Graph mEquivalentClassGraph = new Graph();
    private HashSet mVisitedNodes = new HashSet();

    private OWLParser() {
        this.mUsedBnodes = new HashSet();
        this.mDisjointWithGraph = new Graph();
        this.mEquivalentClassGraph = new Graph();
        this.mVisitedNodes = new HashSet();
        nsPrefix.put(RDF.getURI(), "rdf");
        nsPrefix.put(RDFS.getURI(), "rdfs");
        nsPrefix.put("http://www.w3.org/2002/07/owl#", "owl");
    }

    private ATermList createList(Resource r) {
        ATerm first;
        if (r.equals((Object)RDF.nil)) {
            return ATermUtils.makeList();
        }
        Resource theFirst = null;
        try {
            theFirst = r.getProperty(RDF.first).getResource();
        }
        catch (Exception ex) {
            theFirst = model.createResource(r.getProperty(RDF.first).getObject().toString());
        }
        if (theFirst.isAnon() && this.mCheckStructureSharing) {
            if (this.mUsedBnodes.contains(theFirst.toString())) {
                nonDL.add("Structure sharing is not permitted in OWL DL " + theFirst.toString());
                canOutputDL = false;
            } else {
                this.mUsedBnodes.add(theFirst.toString());
            }
        }
        if (this.restrictions.containsKey(first = this.node2term(r.getProperty(RDF.first).getObject()))) {
            first = (ATerm)this.restrictions.get(first);
        }
        Resource rest = (Resource)r.getProperty(RDF.rest).getObject();
        return ATermUtils.makeList(first, this.createList(rest));
    }

    private boolean check(Resource orig, Resource curr) {
        if (curr == null || curr.isAnon()) {
            if (curr != null && orig.equals((Object)curr)) {
                return false;
            }
            StmtIterator sIter = (curr != null ? curr : orig).listProperties();
            while (sIter.hasNext()) {
                Statement stmt = sIter.nextStatement();
                Property pred = stmt.getPredicate();
                RDFNode obj = stmt.getObject();
                if (pred.equals((Object)OWL.intersectionOf) || pred.equals((Object)OWL.unionOf)) {
                    if (this.checkList(orig, (Resource)obj)) continue;
                    nonDL.add("Cycle in class description detected for: " + stmt.getSubject().toString());
                    return false;
                }
                if (!orig.equals((Object)obj)) continue;
                if (pred.equals((Object)OWL.equivalentClass)) {
                    nonLite.add("Cycle in class description detected for: " + stmt.getSubject().toString());
                } else {
                    nonDL.add("Cycle in class description detected for: " + stmt.getSubject().toString());
                }
                return false;
            }
            return true;
        }
        return true;
    }

    private boolean checkList(Resource orig, Resource theList) {
        Vector<Resource> v = new Vector<Resource>();
        Resource theFirst = theList.getProperty(RDF.first).getResource();
        Resource theRest = theList.getProperty(RDF.rest).getResource();
        v.add(theFirst);
        while (!theRest.equals((Object)RDF.nil)) {
            theFirst = theRest.getProperty(RDF.first).getResource();
            theRest = theRest.getProperty(RDF.rest).getResource();
            v.add(theFirst);
        }
        int i = 0;
        while (i < v.size()) {
            Resource elem = (Resource)v.elementAt(i);
            if (elem.isAnon()) {
                if (orig.equals((Object)elem)) {
                    return false;
                }
                if (elem.hasProperty(OWL.intersectionOf)) {
                    if (elem.getProperty(OWL.intersectionOf).getResource().equals((Object)theList)) {
                        return false;
                    }
                    return this.checkList(orig, elem.getProperty(OWL.intersectionOf).getResource());
                }
                if (elem.hasProperty(OWL.unionOf)) {
                    if (elem.getProperty(OWL.unionOf).getResource().equals((Object)theList)) {
                        return false;
                    }
                    return this.checkList(orig, elem.getProperty(OWL.unionOf).getResource());
                }
            }
            ++i;
        }
        return true;
    }

    private void processTypes() throws UnsupportedFeatureException {
        String problem;
        String previousDefinition;
        Resource s;
        StmtIterator i = model.listStatements(null, RDF.first, null);
        block2: while (i.hasNext()) {
            Statement stmt = i.nextStatement();
            StmtIterator si = model.listStatements(null, null, (RDFNode)stmt.getSubject());
            while (si.hasNext()) {
                Statement aStmt = si.nextStatement();
                if (aStmt.getPredicate().equals((Object)RDF.first) || aStmt.getPredicate().equals((Object)RDF.rest)) continue;
                s = stmt.getSubject();
                this.lists.put(s, this.createList(s));
                this.mCheckStructureSharing = false;
                continue block2;
            }
        }
        i = model.listStatements(null, RDF.type, null);
        Vector<Statement> processLater = new Vector<Statement>();
        while (i.hasNext()) {
            Statement stmt = i.nextStatement();
            Resource s2 = stmt.getSubject();
            Property p = stmt.getPredicate();
            Resource o = stmt.getResource();
            ATerm st = this.node2term((RDFNode)s2);
            ATerm pt = this.node2term((RDFNode)p);
            ATerm ot = this.node2term((RDFNode)o);
            if (s2.isAnon() && !this.check(s2, null)) {
                canOutputDL = false;
            }
            if (o.equals((Object)OWL.Class)) {
                if (!this.isClass(st)) {
                    previousDefinition = this.isIndividual(st) ? "n individual" : " property";
                    problem = st + " is defined both as a class and a" + previousDefinition;
                    nonDL.add(problem);
                    unsupportedFeatures.add(problem);
                }
                this.addClass(st);
                continue;
            }
            if (o.equals((Object)RDFS.Class)) {
                processLater.add(stmt);
                continue;
            }
            if (o.equals((Object)RDFS.Datatype)) {
                this.abox.dtReasoner.defineDatatype(s2.toString(), new Datatype());
                this.print("datatype(" + s2 + ")");
                continue;
            }
            if (o.equals((Object)OWL.Thing)) {
                if (!this.isIndividual(st)) {
                    previousDefinition = this.isClass(st) ? "class" : "property";
                    problem = st + " is defined both as an individual and a " + previousDefinition;
                    nonDL.add(problem);
                    unsupportedFeatures.add(problem);
                }
                if (!this.abox.isNode(st)) {
                    this.abox.addNode(st);
                }
                this.abox.addType(st, ATermUtils.TOP);
                continue;
            }
            if (o.equals((Object)RDF.List)) continue;
            if (o.equals((Object)OWL.Restriction)) {
                this.restrictions.put(s2, st);
                if (model.listStatements(null, null, (RDFNode)s2).hasNext()) continue;
                nonLite.add("An EquivalentClass construct with only one description is not allowed in OWL Lite");
                canOutputDL = false;
                continue;
            }
            if (o.equals((Object)OWL.AllDifferent)) continue;
            if (o.equals((Object)OWL.ObjectProperty)) {
                if (!this.isProperty(st)) {
                    previousDefinition = this.isIndividual(st) ? "n individual" : " class";
                    problem = st + " is defined both as an onbject property and a" + previousDefinition;
                    nonDL.add(problem);
                    unsupportedFeatures.add(problem);
                    continue;
                }
                this.abox.rbox.addObjectRole(st);
                this.print("object-property(" + st + ")");
                continue;
            }
            if (o.equals((Object)OWL.DatatypeProperty)) {
                if (!this.isProperty(st)) {
                    previousDefinition = this.isIndividual(st) ? "n individual" : " class";
                    problem = st + " is defined both as a datatype property and a" + previousDefinition;
                    nonDL.add(problem);
                    unsupportedFeatures.add(problem);
                }
                this.abox.rbox.addDatatypeRole(st);
                this.print("datatype-property(" + st + ")");
                continue;
            }
            if (o.equals((Object)OWL.AnnotationProperty)) {
                if (!this.isProperty(st)) {
                    previousDefinition = this.isIndividual(st) ? "n individual" : " class";
                    problem = st + " is defined both as aa annotation property and a" + previousDefinition;
                    nonDL.add(problem);
                    unsupportedFeatures.add(problem);
                }
                this.abox.rbox.addAnnotationRole(st);
                this.print("annotation-property(" + st + ")");
                continue;
            }
            if (o.equals((Object)RDF.Property)) {
                processLater.add(stmt);
                continue;
            }
            if (o.equals((Object)OWL.TransitiveProperty)) {
                processLater.add(stmt);
                continue;
            }
            if (o.equals((Object)OWL.SymmetricProperty)) {
                processLater.add(stmt);
                continue;
            }
            if (o.equals((Object)OWL.FunctionalProperty)) {
                processLater.add(stmt);
                continue;
            }
            if (o.equals((Object)OWL.InverseFunctionalProperty)) {
                processLater.add(stmt);
                continue;
            }
            if (o.equals((Object)OWL.Ontology)) {
                if (this.isOntology(s2)) continue;
                this.addOntology(s2);
                if (!DEBUG) continue;
                System.out.println("(ontology " + s2 + ")");
                continue;
            }
            if (o.equals((Object)OWL.DataRange)) {
                this.mDataranges.add(st);
                Resource dataValuesR = s2.getProperty(OWL.oneOf).getResource();
                ATermList list = this.createList(dataValuesR);
                long[] dataValues = new long[list.getLength()];
                int k = 0;
                ATermList l = list;
                while (!l.isEmpty()) {
                    ATerm c = l.getFirst();
                    ATerm value = ((ATermAppl)c).getArgument(0);
                    try {
                        long longValue = Long.parseLong(value.toString());
                        dataValues[k++] = longValue;
                    }
                    catch (Exception e) {
                        unsupportedFeatures.add("owl:DataRange is only supported for integers. " + value + " is not an integer");
                    }
                    l = l.getNext();
                }
                Datatype.DTInteger dt = new Datatype.DTInteger(dataValues);
                String dtName = s2.toString();
                this.abox.dtReasoner.defineDatatype(dtName, dt);
                this.print("(datarange " + dtName);
                continue;
            }
            if (!o.isAnon() && o.getURI().startsWith("http://www.w3.org/2002/07/owl#") && !o.equals((Object)OWL.Thing) && !o.equals((Object)OWL.Nothing)) {
                unsupportedFeatures.add(o + " does not belong to OWL namespace");
                nonDL.add(o + " does not belong to OWL namespace");
                continue;
            }
            if (!this.isIndividual(st)) {
                previousDefinition = this.isClass(st) ? "class" : "property";
                problem = st + " is defined both as an individual and a " + previousDefinition;
                nonDL.add(problem);
                unsupportedFeatures.add(problem);
            }
            processLater.add(stmt);
            if (!this.abox.isNode(st)) {
                this.abox.addNode(st);
            }
            this.abox.addType(st, ot);
            this.print("type(" + st + " " + ot + ")");
        }
        int j = 0;
        while (j < processLater.size()) {
            Statement stmt = (Statement)processLater.elementAt(j);
            s = stmt.getSubject();
            Property p = stmt.getPredicate();
            Resource o = stmt.getResource();
            ATerm st = this.node2term((RDFNode)s);
            ATerm obj = this.node2term((RDFNode)o);
            if (o.equals((Object)RDFS.Class)) {
                if (!this.classes.contains(st) && !this.isRestriction(st)) {
                    nonDL.add("Use of rdfs:Class is forbidden in OWL DL: " + s);
                    warnings.add("Possibly using wrong vocabulary (rdfs:Class instead of owl:Class) " + s);
                    this.classes.add(st);
                }
            } else if (o.equals((Object)OWL.FunctionalProperty)) {
                if (!this.isProperty(st)) {
                    previousDefinition = this.isIndividual(st) ? "n individual" : " class";
                    problem = st + " is defined both as a property and a" + previousDefinition;
                    nonDL.add(problem);
                    unsupportedFeatures.add(problem);
                } else {
                    if (!this.abox.rbox.isRole(st)) {
                        this.abox.rbox.addObjectRole(st);
                        nonDL.add(st + " is not defined as an object or datatype property. Assuming it is an object property");
                        warnings.add("Assuming " + st + " is an object property");
                        this.addMissingTriple(s, RDF.type, OWL.ObjectProperty);
                    }
                    this.abox.rbox.addFunctionalRole(st);
                    this.print("functional(" + st + ")");
                }
            } else if (o.equals((Object)OWL.InverseFunctionalProperty)) {
                if (this.abox.rbox.isDatatypeRole(st) || this.abox.rbox.isAnnotationRole(st)) {
                    previousDefinition = this.abox.rbox.isDatatypeRole(st) ? " datatype" : "n annotation";
                    problem = st + " is defined both as a" + previousDefinition + " property and as InverseFunctionalProperty";
                    nonDL.add(problem);
                    unsupportedFeatures.add(problem);
                } else {
                    if (!this.abox.rbox.isRole(st)) {
                        this.abox.rbox.addObjectRole(st);
                    }
                    this.abox.rbox.addInverseFunctionalRole(st);
                    this.print("inv-functional(" + st + ")");
                }
            } else if (o.equals((Object)OWL.TransitiveProperty)) {
                if (this.abox.rbox.isDatatypeRole(st) || this.abox.rbox.isAnnotationRole(st)) {
                    previousDefinition = this.abox.rbox.isDatatypeRole(st) ? " datatype" : "n annotation";
                    problem = st + " is defined both as a" + previousDefinition + " property and as a TransitiveProperty";
                    nonDL.add(problem);
                    unsupportedFeatures.add(problem);
                } else {
                    if (!this.abox.rbox.isRole(st)) {
                        this.abox.rbox.addObjectRole(st);
                    }
                    this.abox.rbox.addTransitiveRole(st);
                    this.print("transitive-role(" + st + ")");
                }
            } else if (o.equals((Object)OWL.SymmetricProperty)) {
                if (this.abox.rbox.isDatatypeRole(st) || this.abox.rbox.isAnnotationRole(st)) {
                    previousDefinition = this.abox.rbox.isDatatypeRole(st) ? " datatype" : "n annotation";
                    problem = st + " is defined both as a" + previousDefinition + " property and as a SymmetricProperty";
                    nonDL.add(problem);
                    unsupportedFeatures.add(problem);
                } else {
                    if (!this.abox.rbox.isRole(st)) {
                        this.abox.rbox.addObjectRole(st);
                    }
                    this.abox.rbox.addInverseRole(st, st);
                    this.print("inverse-role(" + st + " " + st + ")");
                }
            } else if (o.equals((Object)RDF.Property)) {
                if (!this.isProperty(st)) {
                    previousDefinition = this.isIndividual(st) ? "n individual" : " class";
                    problem = st + " is defined both as a property and a" + previousDefinition;
                    nonDL.add(problem);
                    unsupportedFeatures.add(problem);
                } else if (!this.abox.isRole(st)) {
                    nonDL.add(st + " is defined with rdf:Property assuming it is an ObjectProperty");
                    warnings.add(st + " is defined with rdf:Property assuming it is an ObjectProperty");
                    this.addMissingTriple(s, RDF.type, OWL.ObjectProperty);
                    this.abox.rbox.addObjectRole(st);
                    this.print("plain-role(" + st + ")");
                }
            } else {
                this.isClass(obj, true);
            }
            ++j;
        }
        Enumeration e = this.restrictions.keys();
        while (e.hasMoreElements()) {
            Resource prop;
            ATerm target;
            Object key = e.nextElement();
            Resource res = (Resource)key;
            ATermAppl rest = (ATermAppl)this.restrictions.get(key);
            if (!res.hasProperty(OWL.onProperty) || this.abox.rbox.isRole(target = this.node2term((RDFNode)(prop = res.getProperty(OWL.onProperty).getResource())))) continue;
            nonDL.add("Target of owl:onProperty should be defined as a property in OWL DL (" + target + ")");
            this.isProperty(target, true, "object");
            this.addMissingTriple(prop, RDF.type, OWL.ObjectProperty);
        }
    }

    private ATerm createMinCardinality(ATerm p, int cardinality) throws UnsupportedFeatureException {
        if (cardinality == 0) {
            return ATermUtils.TOP;
        }
        if (cardinality < 0) {
            unsupportedFeatures.add("owl:minCardinality with a negative value is invalid");
        } else if (cardinality > MAX_CARD_VALUE) {
            unsupportedFeatures.add("cardinality restriction greater than " + MAX_CARD_VALUE + " is not supported");
        }
        return ATermUtils.makeMin(p, cardinality);
    }

    private ATerm createMaxCardinality(ATerm p, int cardinality) throws UnsupportedFeatureException {
        if (cardinality < 0) {
            unsupportedFeatures.add("owl:maxCardinality with a negative value is invalid");
        } else if (cardinality > MAX_CARD_VALUE) {
            unsupportedFeatures.add("cardinality restriction greater than " + MAX_CARD_VALUE + " is not supported");
        }
        return ATermUtils.makeMax(p, cardinality);
    }

    private ATerm createRestriction(Resource s) throws UnsupportedFeatureException {
        ATerm aTerm;
        block29: {
            aTerm = ATermUtils.BOTTOM;
            Resource p = null;
            StmtIterator si = s.listProperties(OWL.onProperty);
            if (si.hasNext()) {
                p = si.nextStatement().getResource();
                if (si.hasNext()) {
                    canOutputDL = false;
                    nonDL.add("Multiple onProperty triples for the same restriction!");
                }
            } else {
                nonDL.add("A restriction without a owl:onProperty triple!");
                unsupportedFeatures.add("A restriction without a owl:onProperty triple!");
                return aTerm;
            }
            ATerm pt = this.node2term((RDFNode)p);
            if (!this.isProperty(pt)) {
                System.err.println("NOT A PROP FOR ON PROP!!!!");
            } else if (!s.isAnon()) {
                unsupportedFeatures.add("Restrictions should be anonymous in OWL DL!");
                nonDL.add("Restrictions should be anonymous in OWL DL! Restriction " + s + " is not anonymous.");
            } else if (s.hasProperty(OWL.hasValue)) {
                nonLite.add("owl:hasValue construct is used");
                RDFNode o = s.getProperty(OWL.hasValue).getObject();
                ATerm ot = this.node2term(o);
                ATermAppl nominal = ATermUtils.makeValue(ot);
                aTerm = ATermUtils.makeSomeValues(pt, (ATerm)nominal);
                this.abox.nominals.add(ot);
            } else if (s.hasProperty(OWL.allValuesFrom)) {
                Resource o = (Resource)s.getProperty(OWL.allValuesFrom).getObject();
                ATerm ot = this.node2term((RDFNode)o);
                aTerm = ATermUtils.makeAllValues(pt, ot);
            } else if (s.hasProperty(OWL.someValuesFrom)) {
                Resource o = (Resource)s.getProperty(OWL.someValuesFrom).getObject();
                ATerm ot = this.node2term((RDFNode)o);
                aTerm = ATermUtils.makeSomeValues(pt, ot);
            } else if (s.hasProperty(OWL.minCardinality)) {
                try {
                    int cardinality = s.getProperty(OWL.minCardinality).getInt();
                    if (cardinality > 1) {
                        nonLite.add("owl:minCardinality restriction with a number greater than 1 " + cardinality);
                    }
                    aTerm = this.createMinCardinality(pt, cardinality);
                }
                catch (RDFException ex) {
                    nonDL.add("owl:minCardinality restriction is not an integer");
                    unsupportedFeatures.add("Min Cardinality should be specified as a number");
                }
            } else if (s.hasProperty(OWL.maxCardinality)) {
                try {
                    int cardinality = s.getProperty(OWL.maxCardinality).getInt();
                    if (cardinality > 1) {
                        nonLite.add("owl:maxCardinality restriction with a number greater than 1 " + cardinality);
                    }
                    aTerm = this.createMaxCardinality(pt, cardinality);
                }
                catch (Exception ex) {
                    nonDL.add("owl:maxCardinality restriction is not an integer");
                    unsupportedFeatures.add("Max Cardinality should be specified as a number");
                }
            } else if (s.hasProperty(OWL.cardinality)) {
                try {
                    int cardinality = s.getProperty(OWL.cardinality).getInt();
                    if (cardinality > 1) {
                        nonLite.add("owl:cardinality restriction with a number greater than 1 " + cardinality);
                    }
                    if (cardinality == 0) {
                        aTerm = this.createMaxCardinality(pt, cardinality);
                        break block29;
                    }
                    aTerm = ATermUtils.makeAnd(this.createMinCardinality(pt, cardinality), this.createMaxCardinality(pt, cardinality));
                }
                catch (RDFException ex) {
                    nonDL.add("owl:cardinality restriction is not an integer");
                    unsupportedFeatures.add("owl:cardinality restriction is not an integer");
                }
            } else {
                unsupportedFeatures.add("There is an invalid restriction definition");
            }
        }
        return aTerm;
    }

    public static String getLocalName(String uri) {
        int index = uri.indexOf("#");
        if (index == -1) {
            index = uri.lastIndexOf("/");
        }
        if (index == -1) {
            return uri;
        }
        return uri.substring(index + 1);
    }

    public static String getNameSpace(String uri) {
        int index = uri.indexOf("#");
        if (index == -1) {
            index = uri.lastIndexOf("/");
        }
        if (index == -1) {
            return uri;
        }
        return uri.substring(0, index);
    }

    public static String getFilePart(String uri) {
        try {
            URI u = URI.create(uri);
            uri = u.getPath();
        }
        catch (Exception e) {
            canOutputDL = true;
            warnings.add(String.valueOf(uri) + " is not a valid URI!");
            return "http://invalid/uri/";
        }
        int begin = uri.lastIndexOf("/");
        int end = uri.lastIndexOf(".");
        if (end == -1 || begin > end) {
            end = uri.length();
        }
        return uri.substring(begin + 1, end);
    }

    protected ATerm node2term(RDFNode node) {
        ATermAppl aTerm = null;
        if (node.equals(OWL.Thing)) {
            return ATermUtils.TOP;
        }
        if (node.equals(OWL.Nothing)) {
            return ATermUtils.BOTTOM;
        }
        if (this.abox.dtReasoner.isDatatype(node.toString())) {
            aTerm = ATermUtils.makeDatatype(node.toString());
        } else if (node instanceof Resource) {
            Resource r = (Resource)node;
            if (r.getModel() != null && r.hasProperty(OWL.onProperty)) {
                aTerm = this.createRestriction(r);
            } else if (r.isAnon()) {
                if (NO_ANON_CLASSES) {
                    if (r.hasProperty(OWL.intersectionOf)) {
                        ATermList list = this.createList(r.getProperty(OWL.intersectionOf).getResource());
                        aTerm = ATermUtils.makeAnd(list);
                    } else if (r.hasProperty(OWL.unionOf)) {
                        ATermList list = this.createList(r.getProperty(OWL.unionOf).getResource());
                        aTerm = ATermUtils.makeOr(list);
                    } else if (r.hasProperty(OWL.oneOf)) {
                        ATermList list = this.createList(r.getProperty(OWL.oneOf).getResource());
                        ATermList result = ATermUtils.makeList();
                        ATermList l = list;
                        while (!l.isEmpty()) {
                            ATerm c = l.getFirst();
                            ATermAppl nominal = ATermUtils.makeValue(c);
                            result = result.insert((ATerm)nominal);
                            l = l.getNext();
                        }
                        aTerm = ATermUtils.makeOr(result);
                    } else if (r.hasProperty(OWL.complementOf)) {
                        ATerm complement = this.node2term((RDFNode)r.getProperty(OWL.complementOf).getResource());
                        aTerm = ATermUtils.makeNot(complement);
                    } else {
                        aTerm = ATermUtils.makeTermAppl("_anon" + r.toString());
                    }
                } else {
                    aTerm = ATermUtils.makeTermAppl("_anon" + r.toString());
                }
            } else {
                aTerm = ATermUtils.makeTermAppl(OWLParser.getFriendlyName(r.getURI()));
            }
        } else {
            com.hp.hpl.jena.rdf.model.Literal l = (com.hp.hpl.jena.rdf.model.Literal)node;
            String dt = l.getDatatypeURI();
            if (dt == null) {
                dt = "";
            }
            aTerm = ATermUtils.makeLiteral(l.getString(), l.getLanguage(), dt);
        }
        return aTerm;
    }

    private void addClass(ATerm c) {
        if (ATermUtils.isPrimitive(c)) {
            this.classes.add(c);
            this.print("class(" + c + ")");
        }
    }

    private void addSubClass(ATerm c1, ATerm c2) {
        if (!c1.equals((Object)c2)) {
            this.tboxAxioms = this.tboxAxioms.insert((ATerm)ATermUtils.makeSub(c1, c2));
            this.print("sub(" + c1 + ", " + c2 + ")");
        }
    }

    private void addSameClass(ATerm c1, ATerm c2) {
        if (!c1.equals((Object)c2)) {
            this.tboxAxioms = this.tboxAxioms.insert((ATerm)ATermUtils.makeSame(c1, c2));
            this.print("same(" + c1 + ", " + c2 + ")");
        }
    }

    public static String getFullUri(String qname) {
        int index = qname.indexOf(":");
        if (index == -1) {
            return qname;
        }
        String local = qname.substring(index + 1);
        String prefix = qname.substring(1, index);
        String ns = "http://www.example.org/example";
        Iterator it = nsPrefix.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String u = (String)entry.getKey();
            String p = (String)entry.getValue();
            if (!prefix.equals(p)) continue;
            ns = u;
            break;
        }
        return String.valueOf(ns) + "#" + local;
    }

    public static String getFriendlyName(String fullURI) {
        String uri = String.valueOf(OWLParser.getNameSpace(fullURI)) + "#";
        String local = OWLParser.getLocalName(fullURI);
        String prefix = (String)nsPrefix.get(uri);
        if (USE_LOCAL_NAME) {
            return local;
        }
        if (!USE_QNAME) {
            return fullURI;
        }
        if (prefix == null) {
            prefix = OWLParser.getFilePart(fullURI);
            if (nsPrefix.containsValue(prefix)) {
                int count = 2;
                String newPrefix = String.valueOf(prefix) + "." + count;
                while (nsPrefix.contains(newPrefix)) {
                    newPrefix = String.valueOf(prefix) + "." + ++count;
                }
                prefix = newPrefix;
            }
            nsPrefix.put(uri, prefix);
        }
        return String.valueOf(prefix) + ":" + local;
    }

    private boolean isInvalidOWLTerm(Resource r) {
        return !r.isAnon() && r.getURI().startsWith("http://www.w3.org/2002/07/owl#") && !r.equals((Object)OWL.AllDifferent) && !r.equals((Object)OWL.allValuesFrom) && !r.equals((Object)OWL.AnnotationProperty) && !r.equals((Object)OWL.backwardCompatibleWith) && !r.equals((Object)OWL.cardinality) && !r.equals((Object)OWL.Class) && !r.equals((Object)OWL.comment) && !r.equals((Object)OWL.complementOf) && !r.equals((Object)RDFS.Datatype) && !r.equals((Object)OWL.DatatypeProperty) && !r.equals((Object)OWL.DeprecatedClass) && !r.equals((Object)OWL.DeprecatedProperty) && !r.equals((Object)OWL.differentFrom) && !r.equals((Object)OWL.disjointWith) && !r.equals((Object)OWL.distinctMembers) && !r.equals((Object)OWL.domain) && !r.equals((Object)OWL.equivalentClass) && !r.equals((Object)OWL.equivalentProperty) && !r.equals((Object)OWL.FunctionalProperty) && !r.equals((Object)OWL.hasValue) && !r.equals((Object)OWL.imports) && !r.equals((Object)OWL.incompatibleWith) && !r.equals((Object)OWL.intersectionOf) && !r.equals((Object)OWL.InverseFunctionalProperty) && !r.equals((Object)OWL.inverseOf) && !r.equals((Object)OWL.label) && !r.equals((Object)OWL.List) && !r.equals((Object)OWL.Literal) && !r.equals((Object)OWL.maxCardinality) && !r.equals((Object)OWL.minCardinality) && !r.equals((Object)OWL.nil) && !r.equals((Object)OWL.Nothing) && !r.equals((Object)OWL.ObjectProperty) && !r.equals((Object)OWL.oneOf) && !r.equals((Object)OWL.onProperty) && !r.equals((Object)OWL.Ontology) && !r.equals((Object)OWL.priorVersion) && !r.equals((Object)OWL.range) && !r.equals((Object)OWL.Restriction) && !r.equals((Object)OWL.sameAs) && !r.equals((Object)OWL.someValuesFrom) && !r.equals((Object)OWL.subClassOf) && !r.equals((Object)OWL.subPropertyOf) && !r.equals((Object)OWL.SymmetricProperty) && !r.equals((Object)OWL.Thing) && !r.equals((Object)OWL.TransitiveProperty) && !r.equals((Object)OWL.type) && !r.equals((Object)OWL.unionOf) && !r.equals((Object)OWL.versionInfo);
    }

    private void processTriples() throws UnsupportedFeatureException {
        this.mDisjointWithGraph = new Graph();
        StmtIterator i = model.listStatements();
        while (i.hasNext()) {
            String previousDefinition;
            Resource r;
            ATerm c;
            ATermList list;
            ATermList result;
            ATermAppl complement;
            ATerm disjunction;
            ATermList l;
            ATermList list2;
            Statement stmt = (Statement)i.next();
            Resource s = stmt.getSubject();
            Property p = stmt.getPredicate();
            RDFNode o = stmt.getObject();
            if (o instanceof Resource && ((Resource)o).isAnon() && (p.equals((Object)OWL.complementOf) || p.equals((Object)RDF.type) || p.equals((Object)OWL.someValuesFrom) || p.equals((Object)OWL.allValuesFrom))) {
                if (this.mUsedBnodes.contains(o.toString())) {
                    canOutputDL = false;
                    nonDL.add("Structure sharing is not permitted in OWL DL");
                } else {
                    this.mUsedBnodes.add(o.toString());
                }
            }
            ATerm st = this.node2term((RDFNode)s);
            ATerm pt = this.node2term((RDFNode)p);
            ATerm ot = this.node2term(o);
            if (this.isInvalidOWLTerm((Resource)p)) {
                nonDL.add(pt + " is an invalid OWL construct");
                String localName = p.getLocalName();
                if (RDFS_PROPS.contains(localName)) {
                    warnings.add("owl:" + localName + " is not valid, using rdfs:" + localName + " instead");
                    p = ResourceFactory.createProperty((String)RDFS.getURI(), (String)localName);
                    canOutputDL = false;
                } else {
                    unsupportedFeatures.add(pt + " is an invalid OWL construct");
                    continue;
                }
            }
            if (p.equals((Object)RDF.type)) continue;
            if (RESTRICTION_PROPS.contains(p)) {
                if (s.hasProperty(RDF.type, (RDFNode)OWL.Restriction)) continue;
                canOutputDL = false;
                nonDL.add("The property " + p + " is used with a subject which is not a restriction");
                continue;
            }
            if (p.equals((Object)OWL.intersectionOf)) {
                if (this.isClass(st) && s.isAnon()) {
                    nonLite.add("owl:intersectionOf triples cannot have an anonymous subject in OWL Lite");
                }
                l = list2 = (ATermList)this.lists.get(o);
                while (!l.isEmpty()) {
                    ATerm c2 = l.getFirst();
                    if (!this.isClass(c2, true)) {
                        nonDL.add("owl:intersectionOf list includes an element which is not a class " + c2);
                        unsupportedFeatures.add("owl:intersectionOf list includes an element which is not a class " + c2);
                    }
                    l = l.getNext();
                }
                ATerm conjunction = ATermUtils.makeAnd(list2);
                this.addSameClass(st, conjunction);
                continue;
            }
            if (p.equals((Object)OWL.unionOf)) {
                l = list2 = (ATermList)this.lists.get(o);
                while (!l.isEmpty()) {
                    ATerm c3 = l.getFirst();
                    if (!this.isClass(c3, true)) {
                        nonDL.add("owl:unionOf list includes an element which is not a class " + c3);
                        unsupportedFeatures.add("owl:unionOf list includes an element which is not a class " + c3);
                    }
                    l = l.getNext();
                }
                disjunction = ATermUtils.makeOr(list2);
                nonLite.add("owl:unionOf construct is used " + stmt);
                this.addSameClass(st, disjunction);
                continue;
            }
            if (p.equals((Object)OWL.complementOf)) {
                if (!this.isClass(st, true) || !this.isClass(ot, true)) {
                    unsupportedFeatures.add("Subject and object of owl:complementOf should be a class " + stmt);
                }
                nonLite.add("owl:complementOf construct is used " + stmt);
                complement = ATermUtils.makeNot(ot);
                this.addSameClass(st, (ATerm)complement);
                continue;
            }
            if (p.equals((Object)OWL.subClassOf)) {
                if (!this.isClass(st, true) || !this.isClass(ot, true)) {
                    unsupportedFeatures.add("Subject and object of owl:subClassOf should be a class " + stmt);
                }
                this.addSubClass(st, ot);
                continue;
            }
            if (p.equals((Object)OWL.equivalentClass)) {
                if (!this.isClass(st, true) || !this.isClass(ot, true)) {
                    unsupportedFeatures.add("Subject and object of owl:equivalentClass should be a class " + stmt);
                }
                this.addSameClass(st, ot);
                this.addToGraph(this.mEquivalentClassGraph, stmt);
                continue;
            }
            if (p.equals((Object)OWL.disjointWith)) {
                if (!this.isClass(st, true) || !this.isClass(ot, true)) {
                    unsupportedFeatures.add("Subject and object of owl:disjointWith should be a class " + stmt);
                }
                complement = ATermUtils.makeNot(ot);
                this.addSubClass(st, (ATerm)complement);
                nonLite.add("Use of the owl:disjointWith construct is forbidden in OWL Lite documents");
                this.addToGraph(this.mDisjointWithGraph, stmt);
                continue;
            }
            if (p.equals((Object)OWL.equivalentProperty)) {
                if (!this.isProperty(st, true) || !this.isProperty(ot, true)) {
                    unsupportedFeatures.add("Subject and object of owl:equivalentProperty should be a class " + stmt);
                    continue;
                }
                if (this.abox.rbox.isObjectRole(ot) && !this.abox.rbox.isObjectRole(st) || this.abox.rbox.isDatatypeRole(ot) && !this.abox.rbox.isDatatypeRole(st)) {
                    unsupportedFeatures.add("For an owl:EquivalentProperty axiom both properties should be either object or datatype " + stmt);
                    continue;
                }
                this.abox.rbox.addSubRole(st, ot);
                this.print("sub-role(" + st + " " + ot + ")");
                this.abox.rbox.addSubRole(ot, st);
                this.print("sub-role(" + ot + " " + st + ")");
                continue;
            }
            if (p.equals((Object)OWL.subPropertyOf)) {
                if (!this.isProperty(st, true) || !this.isProperty(ot, true)) {
                    unsupportedFeatures.add("Subject and object of owl:equivalentProperty should be a class " + stmt);
                    continue;
                }
                if (this.abox.rbox.isObjectRole(ot) && !this.abox.rbox.isObjectRole(st) || this.abox.rbox.isDatatypeRole(ot) && !this.abox.rbox.isDatatypeRole(st)) {
                    unsupportedFeatures.add("For an owl:subPropertyOf axiom both properties should be either object or datatype " + stmt);
                    continue;
                }
                this.abox.rbox.addSubRole(st, ot);
                this.print("sub-role(" + st + " " + ot + ")");
                continue;
            }
            if (p.equals((Object)OWL.inverseOf)) {
                if (!this.isProperty(st, true) || !this.isProperty(ot, true)) {
                    unsupportedFeatures.add("Subject and object of owl:equivalentProperty should be a class " + stmt);
                }
                this.abox.rbox.addInverseRole(st, ot);
                this.print("inverse-role(" + st + " " + ot + ")");
                continue;
            }
            if (p.equals((Object)OWL.sameAs) || p.equals((Object)OWL.sameIndividualAs)) {
                if (!this.isIndividual(st, true) || !this.isIndividual(ot, true)) {
                    unsupportedFeatures.add("Subject and object of owl:sameAs should be an individual " + stmt);
                    nonDL.add("owl:sameAs is used for class definition");
                    continue;
                }
                this.abox.addSame(st, ot);
                this.print("same(" + st + " " + ot + ")");
                continue;
            }
            if (p.equals((Object)OWL.differentFrom)) {
                if (!this.isIndividual(st, true) || !this.isIndividual(ot, true)) {
                    unsupportedFeatures.add("Subject and object of owl:differentFrom should be an individual " + stmt);
                    nonDL.add("owl:differentFrom is used for class definition");
                    continue;
                }
                this.abox.addDifferent(st, ot);
                this.print("different(" + st + " " + ot + ")");
                continue;
            }
            if (p.equals((Object)RDFS.domain)) {
                if (s.getNameSpace().equals(RDF.getURI()) || s.getNameSpace().equals("http://www.w3.org/2002/07/owl#")) {
                    unsupportedFeatures.add("Defining a domain restriction on built-in property " + p + " is not supported");
                    continue;
                }
                if (!this.isProperty(st, true) || !this.isClass(ot, true)) {
                    unsupportedFeatures.add("rdfs:domain should have a property in subject and a class in object position " + stmt);
                    continue;
                }
                this.abox.rbox.addDomainRestriction(st, ot);
                this.print("domain(" + st + " " + ot + ")");
                continue;
            }
            if (p.equals((Object)RDFS.range)) {
                if (s.isAnon()) {
                    unsupportedFeatures.add("Defining a range restriction on an anonymous node " + stmt);
                    continue;
                }
                if (s.getNameSpace().equals(RDF.getURI()) || s.getNameSpace().equals("http://www.w3.org/2002/07/owl#")) {
                    unsupportedFeatures.add("Defining a range restriction on built-in property " + p + " is not supported");
                    continue;
                }
                String sd = this.getDefinition(st);
                String od = this.getDefinition(ot);
                if (sd.equals("Undefined")) {
                    if (od.equals("Datatype")) {
                        this.isProperty(st, true, "datatype");
                    } else if (od.equals("Class")) {
                        this.isProperty(st, true, "object");
                    } else if (od.equals("Undefined")) {
                        this.isProperty(st, true, "object");
                        this.isClass(ot, true);
                    } else {
                        unsupportedFeatures.add(st + " has undefined range " + stmt);
                    }
                } else if (od.equals("Undefined")) {
                    if (sd.equals("ObjectProperty")) {
                        this.isClass(ot, true);
                    } else if (sd.equals("DatatypeProperty")) {
                        Resource r2 = (Resource)o;
                        this.abox.dtReasoner.defineDatatype(ot.toString(), new Datatype());
                        ot = this.node2term((RDFNode)r2);
                        nonDL.add(r2 + " is an unknown datatype " + stmt);
                        warnings.add("Assuming " + ot + " is a datatype");
                        this.addMissingTriple(r2, RDF.type, RDFS.Datatype);
                    } else {
                        unsupportedFeatures.add(st + " is neither a datatype nor an onbjetc property but has a range " + stmt);
                    }
                }
                sd = this.getDefinition(st);
                od = this.getDefinition(ot);
                if (sd.equals("DatatypeProperty") && od.equals("Datatype") || sd.equals("ObjectProperty") && od.equals("Class")) {
                    this.abox.rbox.addRangeRestriction(st, ot);
                    this.print("range(" + st + " " + ot + ")");
                    continue;
                }
                nonDL.add(String.valueOf(sd) + " cannot have an rdfs:range declaration");
                unsupportedFeatures.add(String.valueOf(sd) + " cannot have an rdfs:range declaration" + stmt);
                continue;
            }
            if (p.equals((Object)OWL.distinctMembers)) {
                result = new Vector();
                ATermList l2 = list = (ATermList)this.lists.get(o);
                while (!l2.isEmpty()) {
                    c = l2.getFirst();
                    if (!this.isIndividual(c, true)) {
                        nonDL.add("owl:AllDifferent list includes an element which is not an individual" + c);
                        unsupportedFeatures.add("owl:AllDifferent list includes an element which is not an individual " + c);
                    } else {
                        result.add(c);
                    }
                    l2 = l2.getNext();
                }
                int k = 0;
                while (k < result.size()) {
                    int j = k + 1;
                    while (j < result.size()) {
                        this.abox.addDifferent((ATerm)result.get(k), (ATerm)result.get(j));
                        this.print("different(" + result.get(k) + " " + result.get(j) + ")");
                        ++j;
                    }
                    ++k;
                }
                continue;
            }
            if (p.equals((Object)OWL.oneOf)) {
                nonLite.add("owl:oneOf construct is used " + stmt);
                result = ATermUtils.makeList();
                if (this.isDatatype(st)) continue;
                this.isClass(st, true);
                if (!o.equals(OWL.nil)) {
                    ATermList l3 = list = (ATermList)this.lists.get(o);
                    while (!l3.isEmpty()) {
                        c = l3.getFirst();
                        if (!this.isIndividual(c, true) && !this.isLiteral(c)) {
                            nonDL.add("owl:oneOf list includes an element which is not an individual " + c);
                            unsupportedFeatures.add("owl:oneOf list includes an element which is not an individual " + c);
                        }
                        this.abox.nominals.add(c);
                        result = result.insert((ATerm)ATermUtils.makeValue(c));
                        l3 = l3.getNext();
                    }
                }
                disjunction = ATermUtils.makeOr(result);
                this.addSameClass(st, disjunction);
                continue;
            }
            if (p.equals((Object)OWL.imports)) {
                r = (Resource)o;
                if (!this.isOntology(r)) {
                    nonDL.add(s + " is importing an ontology " + o + " which is not specified as an owl:Ontology");
                    warnings.add("Assuming " + o + " is an owl:Ontology");
                    this.addMissingTriple(r, RDF.type, OWL.Ontology);
                }
                if (this.isOntology(s)) continue;
                nonDL.add(s + " has a value for owl:imports property but is node defined as an owl:Ontology");
                warnings.add("Assuming " + s + " is an owl:Ontology");
                this.addMissingTriple(s, RDF.type, OWL.Ontology);
                continue;
            }
            if (p.equals((Object)RDF.first)) {
                if (!s.equals((Object)RDF.nil)) continue;
                canOutputDL = false;
                nonDL.add("rdf:nil cannot have a rdf:first element.");
                continue;
            }
            if (p.equals((Object)RDF.rest)) {
                if (s.equals((Object)RDF.nil)) {
                    canOutputDL = false;
                    nonDL.add("rdf:nil cannot have a rdf:rest element.");
                }
                if (this.abox.isNode(pt)) continue;
                this.abox.addNode(pt);
                continue;
            }
            if (this.abox.rbox.isOntologyRole(pt)) {
                Hashtable props;
                Vector<RDFNode> propList;
                r = (Resource)o;
                if (!this.isOntology(s)) {
                    this.addOntology(s);
                    nonDL.add("An OntologyProperty " + p + " is used with a subject " + s + " that is not an Ontology");
                    nonDL.add("Assuming " + s + " is an Ontology");
                    this.addMissingTriple(s, RDF.type, OWL.Ontology);
                }
                if (!this.isOntology(r)) {
                    this.addOntology(r);
                    nonDL.add("An OntologyProperty " + p + " is used with an object " + o + " that is not an Ontology");
                    nonDL.add("Assuming " + s + " is an Ontology");
                    this.addMissingTriple(r, RDF.type, OWL.Ontology);
                }
                if ((propList = (Vector<RDFNode>)(props = this.getOntologyDefinition(s)).get(p)) == null) {
                    propList = new Vector<RDFNode>();
                }
                propList.add(o);
                props.put(p, propList);
                continue;
            }
            if (p.getURI().startsWith("http://www.w3.org/2002/07/owl#") && !this.isProperty(this.node2term((RDFNode)p))) {
                unsupportedFeatures.add(p + " does not belong to OWL namespace");
                nonDL.add(p + " does not belong to OWL namespace");
                continue;
            }
            if (this.abox.rbox.isAnnotationRole(pt)) continue;
            String propType = "object";
            if (!this.isIndividual(st)) {
                propType = "annotation";
            }
            if (this.isLiteral(ot)) {
                propType = "datatype";
            }
            if (!this.isProperty(pt, true, propType)) {
                unsupportedFeatures.add("In a statement predicate should be a property " + stmt);
                continue;
            }
            if (this.abox.rbox.isDatatypeRole(pt)) {
                if (!this.isIndividual(st, true)) {
                    previousDefinition = this.isClass(st) ? "class" : "property";
                    unsupportedFeatures.add("A " + previousDefinition + " cannot be used as an individual " + stmt);
                    continue;
                }
                if (!this.isLiteral(ot)) {
                    unsupportedFeatures.add("A DatatypeProperty should have a literal value " + stmt);
                    continue;
                }
                com.hp.hpl.jena.rdf.model.Literal l4 = (com.hp.hpl.jena.rdf.model.Literal)o;
                String dt = l4.getDatatypeURI();
                Object value = l4.getValue();
                ATerm name = this.abox.createUniqueName();
                Literal lit = this.abox.addLiteral(name, value);
                ATerm litName = lit.getName();
                if (dt != null) {
                    if (!this.abox.dtReasoner.isDatatype(dt)) {
                        this.abox.dtReasoner.defineDatatype(dt, new Datatype());
                        nonDL.add(String.valueOf(dt) + " is an unknown datatype " + stmt);
                        warnings.add("Assuming " + dt + " is a datatype");
                        this.addMissingTriple(ResourceFactory.createResource((String)dt), RDF.type, OWL.Datatype);
                    } else if (DatatypeReasoner.isSupported(dt)) {
                        this.abox.addLiteralType(litName, (ATerm)ATermUtils.makeDatatype(dt), DependencySet.initial);
                    } else {
                        lit.value = null;
                    }
                }
                this.abox.addEdge(pt, st, litName);
                this.print("edge(" + pt + " " + st + " " + value + ")");
                continue;
            }
            if (!this.isIndividual(st, true)) {
                previousDefinition = this.isClass(st) ? "class" : "property";
                unsupportedFeatures.add("A " + previousDefinition + " cannot be used as an individual " + stmt);
                continue;
            }
            if (this.isLiteral(ot)) {
                unsupportedFeatures.add("Literal values are only allowed for datatype properties " + stmt);
                continue;
            }
            if (!this.isIndividual(ot, true)) {
                nonDL.add("Object value for an ObjectProperty should be an individual " + stmt);
                unsupportedFeatures.add("Object value for an ObjectProperty should be an individual " + stmt);
                continue;
            }
            this.abox.addEdge(pt, st, ot);
            this.print("edge(" + pt + " " + st + " " + ot + ")");
        }
        Enumeration enumeration = this.mEquivalentClassGraph.getVertexKeys();
        while (enumeration.hasMoreElements()) {
            String key = enumeration.nextElement().toString();
            if (this.mDisjointWithGraph.getVertex(key) != null && key.startsWith("anon")) {
                nonDL.add("Cannot share bnodes between owl:equivalentClass and owl:disjointWith nodes.");
                canOutputDL = false;
                continue;
            }
            if (!key.startsWith("anon") || !this.mUsedBnodes.contains(key.substring(key.indexOf("anon") + 4))) continue;
            canOutputDL = false;
            nonDL.add("Structure sharing not permitted for " + key.substring(key.indexOf("anon") + 4) + " via owl:equivalentClass.");
        }
        this.doDisjointCheck();
    }

    private void addToGraph(Graph theGraph, Statement stmt) {
        Resource s = stmt.getSubject();
        Property p = stmt.getPredicate();
        RDFNode o = stmt.getObject();
        Vertex start = null;
        Vertex end = null;
        if (theGraph.getVertex(String.valueOf(s.isAnon() ? "anon" : "") + s.toString()) == null) {
            start = new Vertex(String.valueOf(s.isAnon() ? "anon" : "") + s.toString());
            theGraph.addVertex(start);
        } else {
            start = theGraph.getVertex(String.valueOf(s.isAnon() ? "anon" : "") + s.toString());
        }
        if (theGraph.getVertex(String.valueOf(o instanceof Resource && ((Resource)o).isAnon() ? "anon" : "") + o.toString()) == null) {
            end = new Vertex(String.valueOf(o instanceof Resource && ((Resource)o).isAnon() ? "anon" : "") + o.toString());
            theGraph.addVertex(end);
        } else {
            end = theGraph.getVertex(String.valueOf(o instanceof Resource && ((Resource)o).isAnon() ? "anon" : "") + o.toString());
        }
        theGraph.connect(start, end, p.toString());
    }

    private Vector splitGraph(Graph g, String edge) {
        Vector<Graph> graphs = new Vector<Graph>();
        Enumeration e = g.getVertexKeys();
        HashSet<String> seen = new HashSet<String>();
        while (e.hasMoreElements()) {
            String key = e.nextElement().toString();
            if (seen.contains(key)) continue;
            Vertex aVert = g.getVertex(key);
            boolean inserted = false;
            int i = 0;
            while (i < graphs.size()) {
                Graph gg = (Graph)graphs.elementAt(i);
                Enumeration enumeration = gg.getVertexKeys();
                while (enumeration.hasMoreElements()) {
                    String s = enumeration.nextElement().toString();
                    if (!aVert.hasNeighbor(gg.getVertex(s), edge)) continue;
                    inserted = true;
                    gg.addVertex(aVert);
                    break;
                }
                if (inserted) break;
                ++i;
            }
            if (!inserted) {
                Vector neighbors = this.collectNodes(aVert, true);
                Graph aGraph = new Graph();
                aGraph.addVertex(aVert);
                int i2 = 0;
                while (i2 < neighbors.size()) {
                    Vertex v = (Vertex)neighbors.elementAt(i2);
                    seen.add(v.getName());
                    aGraph.addVertex(v);
                    ++i2;
                }
                graphs.add(aGraph);
            }
            if (seen.size() == g.numVertices()) break;
        }
        return graphs;
    }

    private void doDisjointCheck() {
        if (this.mDisjointWithGraph.numVertices() == 0) {
            return;
        }
        Vector allGraphs = this.splitGraph(this.mDisjointWithGraph, OWL.disjointWith.toString());
        int i = 0;
        while (i < allGraphs.size()) {
            if (!this.checkGraph((Graph)allGraphs.elementAt(i))) {
                return;
            }
            ++i;
        }
    }

    private boolean checkGraph(Graph theGraph) {
        int j;
        Enumeration enumeration = theGraph.getVertexKeys();
        boolean invalid = false;
        while (enumeration.hasMoreElements()) {
            String key = enumeration.nextElement().toString();
            Vertex vert = theGraph.getVertex(key);
            if (!vert.getName().startsWith("anon")) {
                Enumeration e = theGraph.getVertexKeys();
                while (e.hasMoreElements()) {
                    String s = e.nextElement().toString();
                    Vertex vt = theGraph.getVertex(s);
                    if (vt.equals(vert) || vt.getName().startsWith("anon") || vert.hasNeighbor(vt, OWL.disjointWith.toString()) || vt.hasNeighbor(vert, OWL.disjointWith.toString())) continue;
                    nonDL.add("Badly connected subgraph: No connection exists between " + vt.getName() + " and " + vert.getName());
                    canOutputDL = false;
                    return false;
                }
                continue;
            }
            Vector allNodes = this.collectNodes(vert, false);
            allNodes.add(vert);
            int i = 0;
            while (i < allNodes.size()) {
                Vertex firstVert = (Vertex)allNodes.elementAt(i);
                j = 0;
                while (j < allNodes.size()) {
                    Vertex secondVert = (Vertex)allNodes.elementAt(j);
                    if (!firstVert.equals(secondVert) && !firstVert.hasNeighbor(secondVert, OWL.disjointWith.toString())) {
                        invalid = true;
                    }
                    ++j;
                }
                if (invalid) break;
                ++i;
            }
            if (invalid) break;
        }
        if (invalid) {
            UndirectedGraph g = new UndirectedGraph();
            Enumeration anEnum = theGraph.getVertexKeys();
            while (anEnum.hasMoreElements()) {
                Vertex theVertex = theGraph.getVertex(anEnum.nextElement().toString());
                Vertex copy = null;
                if (g.getVertex(theVertex.getName()) != null) {
                    copy = g.getVertex(theVertex.getName());
                } else {
                    copy = new Vertex(theVertex.getName());
                    g.addVertex(copy);
                }
                Vector v = theVertex.listNeighbors();
                j = 0;
                while (j < v.size()) {
                    Vertex neighbor = (Vertex)v.elementAt(j);
                    Vertex target = null;
                    if (g.getVertex(neighbor.getName()) != null) {
                        target = g.getVertex(neighbor.getName());
                    } else {
                        target = new Vertex(neighbor.getName());
                        g.addVertex(target);
                    }
                    g.connect(copy, target, OWL.disjointWith.toString());
                    ++j;
                }
            }
            if (this.isConnected(g, OWL.disjointWith.toString())) {
                invalid = false;
            } else {
                nonDL.add("The owl:disjointWith edges in the graph form undirected complete subgraphs which share blank nodes, this is not within OWL DL");
                canOutputDL = false;
            }
        }
        Enumeration e = this.mDisjointWithGraph.getVertexKeys();
        while (e.hasMoreElements()) {
            String aKey = e.nextElement().toString();
            if (!aKey.startsWith("anon")) continue;
            if (this.mUsedBnodes.contains(aKey = aKey.substring(aKey.indexOf("anon") + 4))) {
                nonDL.add("Structure sharing violation: DisjointWith case!");
                canOutputDL = false;
                return false;
            }
            this.mUsedBnodes.add(aKey);
        }
        return invalid;
    }

    private boolean isConnected(Graph g, String theEdge) {
        Enumeration e = g.getVertexKeys();
        while (e.hasMoreElements()) {
            Vertex firstVert = g.getVertex(e.nextElement().toString());
            Enumeration enumeration = g.getVertexKeys();
            while (enumeration.hasMoreElements()) {
                Vertex secondVert = g.getVertex(enumeration.nextElement().toString());
                if (firstVert.equals(secondVert) || firstVert.hasNeighbor(secondVert, theEdge)) continue;
                return false;
            }
        }
        return true;
    }

    private Vector collectNodes(Vertex vert, boolean all) {
        this.mVisitedNodes = new HashSet();
        return this.collectNodesR(vert, all);
    }

    private Vector collectNodesR(Vertex vert, boolean all) {
        if (this.mVisitedNodes.contains(vert.getName())) {
            return new Vector();
        }
        this.mVisitedNodes.add(vert.getName());
        Vector nodes = new Vector();
        Vector neighbors = vert.listNeighbors();
        int i = 0;
        while (i < neighbors.size()) {
            Vector moreNodes;
            Vertex v = (Vertex)neighbors.elementAt(i);
            if (!this.mVisitedNodes.contains(v.getName()) && (all || v.getName().startsWith("anon"))) {
                moreNodes = this.collectNodesR(v, all);
                if (!moreNodes.contains(v)) {
                    moreNodes.add(v);
                }
            } else {
                return nodes;
            }
            moreNodes.removeAll(nodes);
            nodes.addAll(moreNodes);
            ++i;
        }
        return nodes;
    }

    private void addMissingTriple(Resource s, Property p, Resource o) {
        if (s.isAnon() || p.isAnon() || o.isAnon()) {
            canOutputDL = false;
        } else {
            missingTriples.add(ResourceFactory.createStatement((Resource)s, (Property)p, (RDFNode)o));
        }
    }

    private void addMissingTriple(ATerm s, Property p, Resource o) {
        String st = s.toString();
        if (st.startsWith("_anon")) {
            canOutputDL = false;
        } else {
            this.addMissingTriple(ResourceFactory.createResource((String)OWLParser.getFullUri(st)), p, o);
        }
    }

    boolean isDefinedClass(ATerm c) {
        return c.equals((Object)ATermUtils.TOP) || c.equals((Object)ATermUtils.BOTTOM) || this.classes.contains(c) || this.isRestriction(c) || this.isComplexClass(c);
    }

    boolean isDefinedIndividual(ATerm i) {
        return this.abox.isNode(i);
    }

    String getDefinition(ATerm x) {
        if (this.isDefinedClass(x)) {
            return "Class";
        }
        if (this.isDefinedIndividual(x)) {
            return "Individual";
        }
        if (this.isDatatype(x)) {
            return "Datatype";
        }
        if (this.abox.rbox.isDatatypeRole(x)) {
            return "DatatypeProperty";
        }
        if (this.abox.rbox.isObjectRole(x)) {
            return "ObjectProperty";
        }
        if (this.abox.rbox.isAnnotationRole(x)) {
            return "AnnotationProperty";
        }
        if (this.abox.rbox.isOntologyRole(x)) {
            return "OntologyProperty";
        }
        return "Undefined";
    }

    boolean isDatatype(ATerm c) {
        return ATermUtils.isDatatype(c);
    }

    boolean isRestriction(ATerm c) {
        return this.restrictions.contains(c) || this.restrictions.containsKey(c);
    }

    boolean isClass(ATerm c) {
        return this.isClass(c, false);
    }

    boolean isClass(ATerm c, boolean assertTrue) {
        if (c.equals((Object)ATermUtils.TOP) || c.equals((Object)ATermUtils.BOTTOM)) {
            return true;
        }
        if (this.isDatatype(c)) {
            return false;
        }
        if (this.classes.contains(c) || this.isRestriction(c)) {
            return true;
        }
        if (this.isComplexClass(c)) {
            return true;
        }
        if (this.abox.isNode(c) || this.abox.isRole(c)) {
            return false;
        }
        if (assertTrue) {
            warnings.add("Assuming " + c + " is a class");
            nonDL.add("Warning: Assuming " + c + " is a class");
            this.classes.add(c);
            this.addMissingTriple(c, RDF.type, OWL.Class);
        }
        return true;
    }

    boolean isComplexClass(ATerm c) {
        if (c instanceof ATermAppl) {
            ATermAppl a = (ATermAppl)c;
            AFun f = a.getAFun();
            return f.equals((Object)ATermUtils.ALLFUN) || f.equals((Object)ATermUtils.SOMEFUN) || f.equals((Object)ATermUtils.MAXFUN) || f.equals((Object)ATermUtils.MINFUN) || f.equals((Object)ATermUtils.ANDFUN) || f.equals((Object)ATermUtils.ORFUN) || f.equals((Object)ATermUtils.NOTFUN) || f.equals((Object)ATermUtils.VALUEFUN);
        }
        return false;
    }

    boolean isLiteral(ATerm l) {
        return l instanceof ATermAppl && ((ATermAppl)l).getAFun().equals((Object)ATermUtils.LITFUN);
    }

    boolean isIndividual(ATerm i) {
        return this.isIndividual(i, false);
    }

    boolean isIndividual(ATerm i, boolean assertTrue) {
        if (this.abox.isNode(i)) {
            return true;
        }
        if (this.classes.contains(i) || this.abox.isRole(i) || this.isLiteral(i)) {
            return false;
        }
        if (assertTrue) {
            warnings.add("Assuming " + i + " is an individual");
            nonDL.add("Warning: Assuming " + i + " is an individual");
            this.abox.addNode(i);
            this.addMissingTriple(i, RDF.type, OWL.Thing);
        }
        return true;
    }

    boolean isProperty(ATerm p) {
        return this.isProperty(p, false, null);
    }

    boolean isProperty(ATerm p, boolean assertTrue) {
        return this.isProperty(p, assertTrue, "object");
    }

    boolean isProperty(ATerm p, boolean assertTrue, String type) {
        if (this.abox.isRole(p)) {
            return true;
        }
        if (this.classes.contains(p) || this.abox.isNode(p)) {
            return false;
        }
        if (assertTrue) {
            if (type.equals("object")) {
                warnings.add("Assuming " + p + " is an object property");
                nonDL.add("Assuming " + p + " is an object property");
                this.abox.rbox.addObjectRole(p);
                this.addMissingTriple(p, RDF.type, OWL.ObjectProperty);
            } else if (type.equals("datatype")) {
                warnings.add("Assuming " + p + " is a datatype property");
                nonDL.add("Assuming " + p + " is a datatype property");
                this.abox.rbox.addDatatypeRole(p);
                this.addMissingTriple(p, RDF.type, OWL.DatatypeProperty);
            } else if (type.equals("annotation")) {
                warnings.add("Assuming " + p + " is an annotation property");
                nonDL.add("Assuming " + p + " is an annotation property");
                this.abox.rbox.addAnnotationRole(p);
                this.addMissingTriple(p, RDF.type, OWL.AnnotationProperty);
            } else {
                throw new RuntimeException("Internal error: Invalid parameter for isProperty function");
            }
        }
        return true;
    }

    Hashtable getOntologyDefinition(Resource o) {
        if (!o.toString().endsWith("#")) {
            o = ResourceFactory.createResource((String)(o + "#"));
        }
        return (Hashtable)this.abox.ontologies.get(o);
    }

    void addOntology(Resource o) {
        if (!o.toString().endsWith("#")) {
            o = ResourceFactory.createResource((String)(o + "#"));
        }
        this.abox.ontologies.put(o, new Hashtable());
    }

    boolean isOntology(Resource o) {
        if (!o.toString().endsWith("#")) {
            o = ResourceFactory.createResource((String)(o + "#"));
        }
        return this.abox.ontologies.containsKey(o);
    }

    public static ABox readFile(String url) throws Exception {
        OWLReasoner reasoner = new OWLReasoner();
        reasoner.loadOntology(url);
        return reasoner.getABox();
    }

    public static void parse(Model m, ABox a) throws UnsupportedFeatureException {
        parser.processModel(m, a);
    }

    private void initABox() {
        this.abox.ontologies.put(ResourceFactory.createResource((String)"http://www.w3.org/2002/07/owl#"), new Hashtable());
        this.abox.rbox.addAnnotationRole(this.node2term((RDFNode)RDFS.label));
        this.abox.rbox.addAnnotationRole(this.node2term((RDFNode)RDFS.comment));
        this.abox.rbox.addAnnotationRole(this.node2term((RDFNode)RDFS.seeAlso));
        this.abox.rbox.addAnnotationRole(this.node2term((RDFNode)RDFS.isDefinedBy));
        this.abox.rbox.addAnnotationRole(this.node2term((RDFNode)OWL.versionInfo));
        this.abox.rbox.addOntologyRole(this.node2term((RDFNode)OWL.backwardCompatibleWith));
        this.abox.rbox.addOntologyRole(this.node2term((RDFNode)OWL.priorVersion));
        this.abox.rbox.addOntologyRole(this.node2term((RDFNode)OWL.incompatibleWith));
    }

    private void processModel(Model m, ABox a) throws UnsupportedFeatureException {
        canOutputDL = true;
        this.abox = a;
        model = m;
        this.initABox();
        this.lists = new Hashtable();
        this.restrictions = new Hashtable();
        this.tboxAxioms = a.tboxAxioms;
        nonLite = new HashSet();
        nonDL = new HashSet();
        unsupportedFeatures = new HashSet();
        warnings = new HashSet();
        missingTriples = ModelFactory.createDefaultModel();
        Pellet.timers.resetTimer("Preprocessing");
        Pellet.timers.resetTimer("Processing");
        this.print("Process types");
        this.processTypes();
        this.print("Process triples");
        this.processTriples();
        Pellet.timers.stopTimer("Processing");
        if (!SKIP_REASONING) {
            long t = System.currentTimeMillis();
            if (!this.abox.rbox.isConsistent()) {
                unsupportedFeatures.add("Object, datatype, annotation and ontology properties should be disjoint!");
            }
            this.abox.rbox.computeRoleHierarchy();
            t = System.currentTimeMillis() - t;
            Pellet.timers.resetTimer("TBox");
            this.abox.tbox = TBox.oldSplit(this.tboxAxioms);
            Pellet.timers.stopTimer("TBox");
            ATermList UC = null;
            if (PRINT_SIZE) {
                System.out.println("Tu is (" + this.abox.tbox.Tu.size() + ")");
                System.out.println("Tg was " + (this.abox.tbox.Tg.isEmpty() ? "empty" : "(" + this.abox.tbox.Tg.size() + ")"));
            }
            if (ABox.USE_ABSORPTION) {
                Pellet.timers.resetTimer("Absorbtion");
                this.abox.tbox.absorb();
                Pellet.timers.stopTimer("Absorbtion");
            }
            if (!this.abox.tbox.Tg.isEmpty()) {
                UC = this.abox.tbox.Tg.internalize();
                if (UC.getLength() == 1) {
                    UC = (ATermList)ATermUtils.normalize((ATerm)UC);
                } else {
                    ATermAppl and = (ATermAppl)ATermUtils.makeAnd(this.abox.tbox.Tg.internalize());
                    UC = ATermUtils.isAnd((ATerm)(and = (ATermAppl)ATermUtils.normalize((ATerm)and))) ? (ATermList)and.getArgument(0) : ATermUtils.makeList((ATerm)and);
                }
                this.abox.UC = UC;
            }
            Hashtable<ATerm, TermDefinition> termhash = new Hashtable<ATerm, TermDefinition>();
            Iterator it = this.abox.tbox.Tu.termhash.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                ATerm name = (ATerm)entry.getKey();
                TermDefinition td = (TermDefinition)entry.getValue();
                if (td.sub != null) {
                    td.sub = td.sub.setArgument(ATermUtils.normalize(td.sub.getArgument(1)), 1);
                }
                Vector<ATermAppl> sames = new Vector<ATermAppl>();
                Iterator e = td.samelist.iterator();
                while (e.hasNext()) {
                    ATermAppl appl = (ATermAppl)e.next();
                    ATerm norm = ATermUtils.normalize(appl.getArgument(1));
                    appl = appl.setArgument(norm, 1);
                    sames.add(appl);
                }
                td.samelist = sames;
                termhash.put(name, td);
            }
            this.abox.tbox.Tu.termhash = termhash;
            if (DEBUG) {
                System.out.println("Tu is " + this.abox.tbox.Tg.size() + ")");
                ATermList l = this.abox.tbox.Tu.toList();
                while (!l.isEmpty()) {
                    System.out.println(l.getFirst());
                    l = l.getNext();
                }
                System.out.println("Tg is " + this.abox.tbox.Tg.size() + ")");
                l = this.abox.tbox.Tg.toList();
                while (!l.isEmpty()) {
                    System.out.println(l.getFirst());
                    l = l.getNext();
                }
                if (UC != null) {
                    System.out.println("UC is (" + UC.getLength() + "): ");
                    l = UC;
                    while (!l.isEmpty()) {
                        System.out.println(l.getFirst());
                        l = l.getNext();
                    }
                }
            }
            if (PRINT_SIZE) {
                System.out.println("Tg is " + (this.abox.tbox.Tg.isEmpty() ? "empty" : "(" + this.abox.tbox.Tg.size() + ")"));
                if (UC != null) {
                    System.out.println("UC is (" + UC.getLength() + ")");
                }
                System.out.println("Global is (" + this.abox.globalRestrictions.getLength() + ")");
                System.out.println("Domain is (" + this.abox.domainRestrictions.size() + ")");
                System.out.println("ABox is (" + this.abox.nodes.size() + ")");
            }
            this.abox.globalRestrictions = this.abox.rbox.getGlobalRestrictions();
            this.abox.domainRestrictions = this.abox.rbox.getDomainRestrictions();
            this.classes.remove(ATermUtils.TOP);
            this.abox.tbox.classes = new HashSet();
            Iterator i = this.classes.iterator();
            while (i.hasNext()) {
                Object c = i.next();
                if (c.toString().startsWith("_anon")) continue;
                this.abox.tbox.classes.add(c);
            }
            if (DEBUG) {
                System.out.println("tbox\n" + this.abox.tbox);
            }
        }
        Pellet.timers.stopTimer("Preprocessing");
        this.abox.level = nonDL.size() > 0 ? "Full" : (nonLite.size() > 0 ? "DL" : "Lite");
        level = this.abox.level;
        if (SHOW_INFO) {
            Iterator w = warnings.iterator();
            while (w.hasNext()) {
                System.err.println("Warning: " + w.next());
            }
        }
        if (DEBUG) {
            OWLParser.printInfo();
            Iterator iter = nonDL.iterator();
            while (iter.hasNext()) {
                System.err.println(iter.next());
            }
            iter = unsupportedFeatures.iterator();
            while (iter.hasNext()) {
                System.out.println("*" + iter.next());
            }
        }
        canOutputDL &= unsupportedFeatures.size() == 0 && nonDL.size() > 0 && missingTriples.size() > 0L;
        if (THROW_UNSUPPORTED_EXCEPTIONS && unsupportedFeatures.size() > 0) {
            throw new UnsupportedFeatureException("Unsupported feature: " + unsupportedFeatures.iterator().next());
        }
    }

    public static void printInfo() {
        Iterator iter;
        System.out.println("<b>Level</b> : " + level + "<br>");
        if (nonDL.size() > 0) {
            System.out.println("<p><b>Non OWL-DL features used</b><br>");
            iter = nonDL.iterator();
            while (iter.hasNext()) {
                System.out.println(iter.next() + "<br>");
            }
        }
        if (nonLite.size() > 0) {
            System.out.println("<p><b>Non OWL-Lite features used</b><br>");
            iter = nonLite.iterator();
            while (iter.hasNext()) {
                System.out.println(iter.next() + "<br>");
            }
        }
        if (unsupportedFeatures.size() > 0) {
            System.out.println("<p><b>The following features are not supported by Pellet</b><br>");
            iter = unsupportedFeatures.iterator();
            while (iter.hasNext()) {
                System.out.println(iter.next() + "<br>");
            }
        }
    }

    private void print(String s) {
        if (DEBUG) {
            System.out.println(s);
        }
    }
}

