/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import java.util.Vector;
import org.mindswap.pellet.ABoxQuery;
import org.mindswap.pellet.OWLParser;
import org.mindswap.pellet.OWLReasoner;

public class OWLQuery {
    OWLReasoner reasoner = new OWLReasoner();

    OWLQuery(String inputFile) throws Exception {
        this.reasoner.loadOntology(OWLQuery.getFileName(inputFile));
        if (!this.reasoner.isConsistent()) {
            throw new Exception("Dataset isn't consistent!");
        }
    }

    Vector query(String queryFile) throws Exception {
        ABoxQuery q = new ABoxQuery(this.reasoner.getABox());
        q.setQuery(OWLParser.readFile(OWLQuery.getFileName(queryFile)));
        return q.runQuery();
    }

    public static String getFileName(String name) {
        if (name.startsWith("http:") || name.startsWith("ftp:") || name.startsWith("file:")) {
            return name;
        }
        return "file:" + name;
    }

    public static void main(String[] args) throws Exception {
        OWLQuery q = new OWLQuery(args[0]);
        Vector results = q.query(args[1]);
        if (results != null) {
            System.out.println("Query is consistent!");
            System.out.println("Results: " + results);
        } else {
            System.out.println("Query is inconsistent!");
        }
    }
}

