/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import com.lre.utils.Util;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.mindswap.pellet.OWLParser;
import org.mindswap.pellet.TestVocabulary;
import org.mindswap.pellet.UnsupportedFeatureException;

public class OWLSpeciesValidator {
    public static boolean DEBUG = false;
    static boolean useLocal = false;
    static String base = useLocal ? "file://C/Mindswap/owl-test/" : "http://www.w3.org/2002/03owlt/editors-draft/draft/";
    static final List TYPES = Arrays.asList(TestVocabulary.NotOwlFeatureTest, TestVocabulary.PositiveEntailmentTest, TestVocabulary.NegativeEntailmentTest, TestVocabulary.TrueTest, TestVocabulary.OWLforOWLTest, TestVocabulary.ConsistencyTest, TestVocabulary.InconsistencyTest, TestVocabulary.ImportEntailmentTest, TestVocabulary.ImportLevelTest);
    static final List LEVELS = Arrays.asList(TestVocabulary.Lite, TestVocabulary.DL, TestVocabulary.Full);
    static String allTests = String.valueOf(base) + "Manifest.rdf";
    private static final String[] AT_RISK = new String[]{"http://www.w3.org/2002/03owlt/I5.26/Manifest001#test", "http://www.w3.org/2002/03owlt/I5.26/Manifest002#test", "http://www.w3.org/2002/03owlt/I5.26/Manifest003#test", "http://www.w3.org/2002/03owlt/I5.26/Manifest004#test", "http://www.w3.org/2002/03owlt/I5.26/Manifest005#test", "http://www.w3.org/2002/03owlt/I5.26/Manifest006#test"};
    private static final String[] NEW_TESTS = new String[]{"http://www.w3.org/2002/03owlt/I5.26/Manifest006#test"};

    public static final void main(String[] args) {
        String manifestFile = allTests;
        OWLSpeciesValidator owlTest = new OWLSpeciesValidator();
        owlTest.doTest2(manifestFile);
    }

    private void testList(String[] uris) {
        OWLParser.THROW_UNSUPPORTED_EXCEPTIONS = false;
        OWLParser.SKIP_REASONING = true;
        Vector<String> incorrectCases = new Vector<String>();
        int numIncorrect = 0;
        int numTests = 0;
        int testCount = 1;
        long start = System.currentTimeMillis();
        int i = 0;
        while (i < uris.length) {
            Model m = ModelFactory.createDefaultModel();
            m.read(uris[i], "");
            StmtIterator sIter = m.listStatements(null, RDF.type, null);
            Resource testCase = null;
            while (sIter.hasNext()) {
                Statement stmt = sIter.nextStatement();
                if (!TYPES.contains(stmt.getObject())) continue;
                testCase = stmt.getSubject();
                break;
            }
            Statement statusStmt = testCase.getProperty(TestVocabulary.status);
            RDFNode testStatus = statusStmt.getObject();
            if (!testStatus.equals(TestVocabulary.Obsoleted)) {
                System.out.println("Test Case: " + testCount++);
                System.out.println("Name: " + testCase);
                System.out.println();
                Property[] docList = new Property[]{TestVocabulary.premiseDocument, TestVocabulary.inputDocument, TestVocabulary.conclusionDocument};
                int j = 0;
                while (j < docList.length) {
                    if (testCase.hasProperty(docList[j])) {
                        String inputFile = testCase.getProperty(docList[j]).getObject().toString();
                        String inputLevel = testCase.getProperty(docList[j]).getProperty(TestVocabulary.level).getObject().toString();
                        System.out.println("Document: " + inputFile);
                        System.out.println("Document Level: " + inputLevel.substring(inputLevel.lastIndexOf("#") + 1));
                        ++numTests;
                        try {
                            String aLevel = this.getFileLevel(inputFile);
                            System.out.print("Level : " + aLevel);
                            if (aLevel == null || !inputLevel.endsWith(aLevel)) {
                                System.out.print(" (WRONG)");
                                ++numIncorrect;
                                incorrectCases.addElement(String.valueOf(testCount - 1) + ": " + inputFile);
                            }
                            System.out.println("\n");
                        }
                        catch (Exception ex) {
                            ++numIncorrect;
                            incorrectCases.addElement(String.valueOf(testCount - 1) + ": " + inputFile);
                            System.out.println(" (WRONG)\n");
                            ex.printStackTrace(System.out);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        long total = System.currentTimeMillis() - start;
        System.out.println("Final Statistics");
        System.out.println("Total Test Cases: " + (testCount - 1));
        System.out.println("Total Tests Conducted: " + numTests);
        System.out.println("Total Passed: " + (numTests - numIncorrect));
        System.out.println("Total Failed: " + numIncorrect);
        System.out.println("Percent: " + (float)(numTests - numIncorrect) / (float)numTests * 100.0f);
        System.out.println("Total Time (in seconds): " + total / 1000L);
        System.out.println();
        System.out.println("List of failed cases: ");
        int i2 = 0;
        while (i2 < incorrectCases.size()) {
            System.out.println(incorrectCases.elementAt(i2).toString());
            ++i2;
        }
    }

    private String getFileLevel(String inputFile) {
        inputFile = this.getFileName(inputFile);
        try {
            String aLevel = OWLParser.readFile((String)inputFile).level;
            return aLevel;
        }
        catch (UnsupportedFeatureException ufe) {
            System.err.println("File has unsupported features");
        }
        catch (Exception e) {
            System.err.println("Exception " + e);
            e.printStackTrace();
        }
        return "Unknown";
    }

    private String getRDFHead() {
        StringBuffer sb = new StringBuffer();
        sb.append("<rdf:RDF \n");
        sb.append("  xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" \n");
        sb.append("  xmlns:rdfs=\"http://www.w3.org/2000/01/rdf-schema#\" \n");
        sb.append("  xmlns:results=\"http://www.w3.org/2002/03owlt/resultsOntology#\" \n");
        sb.append("  xmlns=\"http://www.w3.org/1999/xhtml\" \n");
        sb.append("  xml:base=\"http://www.mindswap.org/2003/pellet\">\n\n");
        sb.append("<rdf:Description rdf:about=\"#pellet\">\n");
        sb.append("\t<rdfs:label>Pellet</rdfs:label>\n");
        sb.append("</rdf:Description>\n");
        return sb.toString();
    }

    public void doTest2(String manifestFile) {
        OWLParser.THROW_UNSUPPORTED_EXCEPTIONS = false;
        OWLParser.SKIP_REASONING = true;
        Vector<String> incorrectCases = new Vector<String>();
        int numIncorrect = 0;
        int numTests = 0;
        System.out.println("Reading manifest file " + manifestFile);
        System.out.println();
        Model manifestModel = ModelFactory.createDefaultModel();
        manifestModel.read(manifestFile, "");
        int testCount = 1;
        StmtIterator sIter = manifestModel.listStatements(null, RDF.type, null);
        long start = System.currentTimeMillis();
        StringBuffer rdf = new StringBuffer(this.getRDFHead());
        while (sIter.hasNext()) {
            String aLevel;
            String inputFile;
            Resource testCase;
            Statement statusStmt;
            RDFNode testStatus;
            Statement stmt = sIter.nextStatement();
            if (!TYPES.contains(stmt.getObject()) || (testStatus = (statusStmt = (testCase = stmt.getSubject()).getProperty(TestVocabulary.status)).getObject()).equals(TestVocabulary.Obsoleted)) continue;
            if (useLocal && (testCount == 81 || testCount == 140)) {
                ++testCount;
                continue;
            }
            System.out.println("Test Case: " + testCount++);
            System.out.println("Name: " + testCase);
            System.out.println();
            boolean ranATest = false;
            boolean passed = true;
            if (testCase.hasProperty(TestVocabulary.premiseDocument)) {
                inputFile = testCase.getProperty(TestVocabulary.premiseDocument).getObject().toString();
                try {
                    ranATest = true;
                    String premiseLevel = testCase.getProperty(TestVocabulary.premiseDocument).getProperty(TestVocabulary.level).getObject().toString();
                    System.out.println("Premise Document: " + inputFile);
                    System.out.println("Premise Level: " + premiseLevel.substring(premiseLevel.lastIndexOf("#") + 1));
                    ++numTests;
                    aLevel = this.getFileLevel(inputFile);
                    System.out.print("Level : " + aLevel);
                    if (aLevel == null || !premiseLevel.endsWith(aLevel)) {
                        System.out.print(" (WRONG)");
                        ++numIncorrect;
                        incorrectCases.addElement(String.valueOf(testCount - 1) + ": " + inputFile);
                        passed = false;
                    }
                    System.out.println("\n");
                }
                catch (Exception ex) {
                    ++numIncorrect;
                    incorrectCases.addElement(String.valueOf(testCount - 1) + ": " + inputFile);
                    System.out.println(" (WRONG)\n");
                    ex.printStackTrace(System.out);
                    passed = false;
                }
            }
            if (testCase.hasProperty(TestVocabulary.inputDocument)) {
                ranATest = true;
                inputFile = testCase.getProperty(TestVocabulary.inputDocument).getObject().toString();
                String inputLevel = testCase.getProperty(TestVocabulary.inputDocument).getProperty(TestVocabulary.level).getObject().toString();
                System.out.println("Input Document: " + inputFile);
                System.out.println("Input Level: " + inputLevel.substring(inputLevel.lastIndexOf("#") + 1));
                ++numTests;
                try {
                    aLevel = this.getFileLevel(inputFile);
                    System.out.print("Level : " + aLevel);
                    if (aLevel == null || !inputLevel.endsWith(aLevel)) {
                        System.out.print(" (WRONG)");
                        ++numIncorrect;
                        passed = false;
                        incorrectCases.addElement(String.valueOf(testCount - 1) + ": " + inputFile);
                    }
                    System.out.println("\n");
                }
                catch (Exception ex) {
                    ++numIncorrect;
                    incorrectCases.addElement(String.valueOf(testCount - 1) + ": " + inputFile);
                    System.out.println(" (WRONG)\n");
                    ex.printStackTrace(System.out);
                    passed = false;
                }
            }
            if (testCase.hasProperty(TestVocabulary.conclusionDocument)) {
                ranATest = true;
                inputFile = testCase.getProperty(TestVocabulary.conclusionDocument).getObject().toString();
                String conclusionLevel = testCase.getProperty(TestVocabulary.conclusionDocument).getProperty(TestVocabulary.level).getObject().toString();
                System.out.println("Conclusion Document: " + inputFile);
                System.out.println("Conclusion Level: " + conclusionLevel.substring(conclusionLevel.lastIndexOf("#") + 1));
                ++numTests;
                try {
                    aLevel = this.getFileLevel(inputFile);
                    System.out.print("Level : " + aLevel);
                    if (aLevel == null || !conclusionLevel.endsWith(aLevel)) {
                        System.out.print(" (WRONG)");
                        ++numIncorrect;
                        incorrectCases.addElement(String.valueOf(testCount - 1) + ": " + inputFile);
                        passed = false;
                    }
                    System.out.println("\n");
                }
                catch (Exception ex) {
                    ++numIncorrect;
                    passed = false;
                    incorrectCases.addElement(String.valueOf(testCount - 1) + ": " + inputFile);
                    System.out.println(" (WRONG)\n");
                    ex.printStackTrace(System.out);
                }
            }
            if (!ranATest) {
                System.out.println("No tests run for this case!");
            }
            System.out.println("-----------------------------");
            if (!passed) {
                rdf.append("<results:FailingRun>\n");
                rdf.append("\t<results:system rdf:resource=\"#pellet\"/>\n");
                rdf.append("\t<results:output rdf:resource=\"http://www.mindswap.org/2003/pellet/test.shtml\"/>\n");
                rdf.append("\t<results:test rdf:parseType=\"Resource\">\n");
                rdf.append("\t\t<results:syntacticLevelTestFrom rdf:resource=\"" + testCase.toString() + "\"/>\n");
                rdf.append("\t</results:test>\n");
                rdf.append("</results:FailingRun>\n\n");
                continue;
            }
            rdf.append("<results:PassingRun>\n");
            rdf.append("\t<results:system rdf:resource=\"#pellet\"/>\n");
            rdf.append("\t<results:output rdf:resource=\"http://www.mindswap.org/2003/pellet/test.shtml\"/>\n");
            rdf.append("\t<results:test rdf:parseType=\"Resource\">\n");
            rdf.append("\t\t<results:syntacticLevelTestFrom rdf:resource=\"" + testCase.toString() + "\"/>\n");
            rdf.append("\t</results:test>\n");
            rdf.append("</results:PassingRun>\n\n");
        }
        long total = System.currentTimeMillis() - start;
        rdf.append("</rdf:RDF>");
        try {
            Util.saveStringToFile(rdf.toString(), "syntax_results.rdf");
        }
        catch (Exception statusStmt) {
            // empty catch block
        }
        System.out.println("Final Statistics");
        System.out.println("Total Test Cases: " + (testCount - 1));
        System.out.println("Total Tests Conducted: " + numTests);
        System.out.println("Total Passed: " + (numTests - numIncorrect));
        System.out.println("Total Failed: " + numIncorrect);
        System.out.println("Percent: " + (float)(numTests - numIncorrect) / (float)numTests * 100.0f);
        System.out.println("Total Time (in seconds): " + total / 1000L);
        System.out.println();
        System.out.println("List of failed cases: ");
        int i = 0;
        while (i < incorrectCases.size()) {
            System.out.println(incorrectCases.elementAt(i).toString());
            ++i;
        }
    }

    String getFileName(String fileName) {
        if (useLocal) {
            fileName = String.valueOf(base) + fileName.substring(1 + fileName.substring(1, fileName.lastIndexOf("/") - 1).lastIndexOf("/")) + ".rdf";
        }
        return fileName;
    }
}

