/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashSet;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Classify;
import org.mindswap.pellet.OWLParser;
import org.mindswap.pellet.OWLReasoner;
import org.mindswap.pellet.OutputFormatter;
import org.mindswap.pellet.Pellet;
import org.mindswap.pellet.Timers;
import org.mindswap.pellet.UnsupportedFeatureException;

public class Pellet
extends Thread {
    public static boolean DEBUG = false;
    public static Timers timers = new Timers();
    String inFile = null;
    String coFile = null;
    String inString = null;
    String coString = null;
    String inFormat = null;
    String coFormat = null;
    String outFile = null;
    String queryFile = null;
    String classifyFormat = "NONE";
    boolean checkConsistency = true;
    boolean realize = false;
    boolean unsat = false;
    boolean formatHTML = false;
    boolean quiet = false;
    int timeout = 30;

    public static final void main(String[] args) throws Exception {
        Pellet pellet = new Pellet();
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (arg.equalsIgnoreCase("-help")) {
                Pellet.usage();
                System.exit(0);
            } else if (arg.equalsIgnoreCase("-classify")) {
                pellet.setClassifyFormat(args[++i]);
            } else if (arg.equalsIgnoreCase("-inputFile")) {
                pellet.setInFile(Pellet.toURI(args[++i]));
            } else if (arg.equalsIgnoreCase("-inputFormat")) {
                pellet.setInFormat(args[++i]);
            } else if (arg.equalsIgnoreCase("-inputString")) {
                pellet.setInString(args[++i]);
            } else if (arg.equalsIgnoreCase("-conclusionsFile")) {
                pellet.setCoFile(Pellet.toURI(args[++i]));
            } else if (arg.equalsIgnoreCase("-conclusionsFormat")) {
                pellet.setCoFormat(args[++i]);
            } else if (arg.equalsIgnoreCase("-conclusionsString")) {
                pellet.setCoString(args[++i]);
            } else if (arg.equalsIgnoreCase("-queryFile")) {
                pellet.setQueryFile(Pellet.toURI(args[++i]));
            } else if (arg.equalsIgnoreCase("-outputDL")) {
                pellet.setOutFile(args[++i]);
            } else if (arg.equalsIgnoreCase("-timeout")) {
                pellet.setTimeout(Integer.parseInt(args[++i]));
            } else if (arg.equalsIgnoreCase("-html")) {
                pellet.setFormatHTML(true);
            } else if (arg.equalsIgnoreCase("-text")) {
                pellet.setFormatHTML(false);
            } else if (arg.equalsIgnoreCase("-quick")) {
                pellet.setConsistency(false);
            } else if (arg.equalsIgnoreCase("-unsat")) {
                pellet.setUnsat(true);
            } else if (arg.equalsIgnoreCase("-quiet")) {
                pellet.setQuiet(true);
            } else if (arg.equalsIgnoreCase("-debug")) {
                String which;
                if ((which = args[++i]).equals("parser")) {
                    OWLParser.DEBUG = true;
                } else if (which.equals("abox")) {
                    ABox.DEBUG = true;
                } else if (which.equals("reasoner")) {
                    OWLReasoner.DEBUG = true;
                } else if (which.equals("classify")) {
                    Classify.DEBUG = true;
                } else if (which.equals("classify")) {
                    DEBUG = true;
                } else if (which.equals("all")) {
                    ABox.DEBUG = true;
                    OWLParser.DEBUG = true;
                    OWLReasoner.DEBUG = true;
                    Classify.DEBUG = true;
                    DEBUG = true;
                } else {
                    System.err.println("Invalid debug option");
                    Pellet.usage();
                    System.exit(1);
                }
            } else {
                System.err.println("Unrecognized option: " + arg);
                Pellet.usage();
                System.exit(1);
            }
            ++i;
        }
        pellet.start();
        int timeout = 90;
        pellet.join(timeout * 1000);
        if (pellet.isAlive()) {
            System.out.println("Timeout after " + timeout + " seconds");
            System.exit(0);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        block70: {
            block73: {
                block71: {
                    block72: {
                        out = new OutputFormatter(this.formatHTML);
                        OWLParser.SHOW_INFO = false;
                        consistent = "Unknown";
                        if (this.inFile != null) {
                            if (this.inString != null) {
                                throw new RuntimeException("Both an input url and text is given.");
                            }
                        } else if (this.inString == null) {
                            System.err.println("No input file is given!");
                            Pellet.usage();
                            System.exit(1);
                        }
                        if (this.coFile != null && this.coString != null) {
                            throw new RuntimeException("Both a conclusions url and text is given.");
                        }
                        reasoner = new OWLReasoner();
                        if (this.inFile != null) {
                            out.printBold("Input file: ").printLink(this.inFile).println();
                        } else {
                            out.printBold("Input file: ").println("Text area");
                        }
                        out.flush();
                        Pellet.timers.startTimer("totalTime");
                        try {
                            test = new .TestThread(this, reasoner);
                            test.start();
                            test.join(this.timeout * 1000);
                            if (test.e != null) {
                                throw test.e;
                            }
                            if (test.isAlive()) {
                                consistent = "Unknown (Timeout after " + this.timeout + " seconds)";
                            } else if (this.checkConsistency) {
                                consistent = reasoner.isConsistent() != false ? "Yes" : "No";
                            }
                        }
                        catch (UnsupportedFeatureException e) {
                            consistent = "Unsupported";
                        }
                        catch (Exception e) {
                            out.printParagraph().println("The following error occured:");
                            out.println(e);
                            e.printStackTrace(out.getWriter());
                            out.println("Please contact the system administrator.");
                            out.flush();
                            System.exit(0);
                        }
                        out.printBold("Level: ").println(OWLParser.level);
                        if (this.checkConsistency) {
                            out.printBold("Consistent: ").print(consistent).println();
                        }
                        out.flush();
                        isConsistent = null;
                        if (consistent.equals("Yes")) {
                            isConsistent = Boolean.TRUE;
                        } else if (consistent.equals("No")) {
                            isConsistent = Boolean.FALSE;
                        }
                        try {
                            if (this.outFile != null) {
                                if (isConsistent == null) {
                                    out.printParagraph().println("Consistency check failed. I'm refusing to convert it to OWL DL!");
                                } else if (OWLParser.nonDL.size() == 0) {
                                    out.printParagraph().println("The file level is already " + OWLParser.level + "! No output file is created!");
                                } else if (OWLParser.unsupportedFeatures.size() > 0) {
                                    out.printParagraph().println("There are unsupported feature in the input document, cannot generate DL version!");
                                } else if (!OWLParser.canOutputDL) {
                                    System.out.println("Output: This ontology cannot be converted to OWL DL!");
                                } else {
                                    f = new FileOutputStream(this.outFile);
                                    OWLParser.model.union(OWLParser.missingTriples).write((OutputStream)f);
                                    out.printParagraph().println("DL version of the ontolgy is saved at " + this.outFile);
                                }
                            }
                        }
                        catch (UnsupportedFeatureException e) {
                            out.printParagraph().println("Conclusions has unsupported features!");
                        }
                        catch (Exception e) {
                            out.printParagraph().println("The following error occured while checking conclusions:");
                            out.println(e);
                            e.printStackTrace(out.getWriter());
                            out.println("Please contact the system administrator.");
                            System.exit(0);
                        }
                        out.flush();
                        try {
                            if (this.coFile != null || this.coString != null) {
                                if (isConsistent == null) {
                                    out.printParagraph().println("Consistency check failed. Cannot check entailments!");
                                } else if (isConsistent.booleanValue()) {
                                    isEntailed = this.coFile != null ? reasoner.isEntailed(this.coFile, this.coFormat) : reasoner.isEntailed(new ByteArrayInputStream(this.coString.getBytes()), this.coFormat);
                                    out.printBold("Entailed: ").print(isEntailed).println();
                                } else {
                                    out.printBold("Entailed: ").print("Entailments cannot be checked for an inconsistent ontology").println();
                                }
                            }
                        }
                        catch (UnsupportedFeatureException e) {
                            out.printParagraph().println("Conclusions has unsupported features!");
                        }
                        catch (Exception e) {
                            out.printParagraph().println("The following error occured while checking conclusions:");
                            out.println(e);
                            e.printStackTrace(out.getWriter());
                            out.println("Please contact the system administrator.");
                            System.exit(0);
                        }
                        out.flush();
                        this.classifyFormat = this.classifyFormat.toLowerCase();
                        if (this.classifyFormat.equals("none")) break block71;
                        if (isConsistent != null) break block72;
                        out.printParagraph().printBold("Classification").println();
                        out.printParagraph().println("Consistency check failed. Cannot do classification!");
                        break block73;
                    }
                    if (!isConsistent.booleanValue()) ** GOTO lbl152
                    reasoner.classify();
                    if (this.realize) {
                        reasoner.realize();
                    }
                    out.printBold("Time: ").println(Pellet.getTimeInfo(false));
                    out.printParagraph().printBold("Classification");
                    if (this.classifyFormat.equals("tree")) {
                        reasoner.getClassification().print(out, 0);
                    } else if (this.classifyFormat.equals("table")) {
                        reasoner.getClassification().print(out, 1);
                    } else if (this.classifyFormat.equals("rdf")) {
                        reasoner.getClassification().print(out, 2);
                    } else {
                        throw new RuntimeException("Invalid format to display classification");
lbl152:
                        // 1 sources

                        out.printParagraph().printBold("Classification").println();
                        out.println("Classification cannot be done for inconsistent ontologies");
                    }
                    break block73;
                }
                if (isConsistent != null && isConsistent.booleanValue() && this.unsat) {
                    unsat = new HashSet<ATerm>();
                    if (Pellet.DEBUG) {
                        System.out.println("Check satisfiability for " + reasoner.getABox().tbox.classes.size() + " classes");
                    }
                    Pellet.timers.startTimer("Unsatisfiability");
                    i = reasoner.getABox().tbox.classes.iterator();
                    while (i.hasNext()) {
                        c = (ATerm)i.next();
                        if (Pellet.DEBUG) {
                            System.out.print("Satisfiability test for " + OWLParser.getLocalName(c.toString()));
                        }
                        singleTime = System.currentTimeMillis();
                        if (!reasoner.isSatisfiable(c)) {
                            unsat.add(c);
                        }
                        if (!Pellet.DEBUG) continue;
                        System.out.println(" done in " + (System.currentTimeMillis() - singleTime) + "ms");
                    }
                    Pellet.timers.stopTimer("Unsatisfiability");
                    out.printBold("Time: ").println(Pellet.getTimeInfo(false));
                    out.printParagraph().printBold("Unsatisfiable Concepts").println();
                    if (!unsat.isEmpty()) {
                        i = unsat.iterator();
                        while (i.hasNext()) {
                            out.println(i.next());
                        }
                    } else {
                        out.println("All concepts are satisfiable");
                    }
                } else {
                    out.printBold("Time: ").println(Pellet.getTimeInfo(false));
                }
            }
            if (!this.quiet) {
                if (OWLParser.warnings.size() > 0) {
                    out.printParagraph().printBold("Warnings").println();
                    w = OWLParser.warnings.iterator();
                    while (w.hasNext()) {
                        out.println("Warning: " + w.next());
                    }
                }
                if (OWLParser.unsupportedFeatures.size() > 0) {
                    out.printParagraph().printBold("The following features are not supported by Pellet").println();
                    iter = OWLParser.unsupportedFeatures.iterator();
                    while (iter.hasNext()) {
                        out.println(iter.next());
                    }
                }
                if (OWLParser.nonDL.size() > 0) {
                    out.printParagraph().printBold("Non OWL-DL features used").println();
                    iter = OWLParser.nonDL.iterator();
                    while (iter.hasNext()) {
                        out.println(iter.next());
                    }
                }
                if (OWLParser.nonLite.size() > 0) {
                    out.printParagraph().printBold("Non OWL-Lite features used").println();
                    iter = OWLParser.nonLite.iterator();
                    while (iter.hasNext()) {
                        out.println(iter.next());
                    }
                }
                if (OWLParser.nonDL.size() > 0) {
                    out.printParagraph().printBold("Add the following statements to make this document OWL DL").println();
                    if (OWLParser.unsupportedFeatures.size() == 0) {
                        out.printTag("<plaintext>");
                        try {
                            if (OWLParser.canOutputDL) {
                                OWLParser.missingTriples.write((Writer)out.getWriter());
                            } else {
                                out.println("This document cannot be converted to OWL DL!");
                            }
                            break block70;
                        }
                        catch (Exception e) {
                            out.print("Following error occured whe trying to print the missing triples " + e);
                            e.printStackTrace();
                            si = OWLParser.missingTriples.listStatements();
                            ** while (si.hasNext())
                        }
lbl-1000:
                        // 1 sources

                        {
                            System.err.println(si.next());
                            continue;
lbl248:
                            // 1 sources

                            break block70;
                        }
                    }
                    out.printTag("There are unsupported features in the input document. It cannot be converted to OWL DL.");
                }
            }
        }
        out.flush();
    }

    public static String toURI(String fileName) throws Exception {
        if (fileName.startsWith("http://") || fileName.startsWith("file://")) {
            return fileName;
        }
        File localFile = new File(fileName);
        if (!localFile.exists()) {
            throw new FileNotFoundException(String.valueOf(localFile.getAbsolutePath()) + " is not found");
        }
        return localFile.toURL().toExternalForm();
    }

    public static String getTimeInfo(boolean detailed) {
        timers.stopTimer("totalTime");
        String timeInfo = String.valueOf(Pellet.timers.getTimer((String)"totalTime").totalTime) + " ms (";
        if (detailed) {
            timeInfo = String.valueOf(timeInfo) + Pellet.getTimerString("Loading");
            timeInfo = String.valueOf(timeInfo) + Pellet.getTimerString("Processing");
            timeInfo = String.valueOf(timeInfo) + Pellet.getTimerString("TBox");
            timeInfo = String.valueOf(timeInfo) + Pellet.getTimerString("Absorption");
            timeInfo = String.valueOf(timeInfo) + Pellet.getTimerString("Consistency");
            timeInfo = String.valueOf(timeInfo) + Pellet.getTimerString("Entailment");
            timeInfo = String.valueOf(timeInfo) + Pellet.getTimerString("Unsatisfiability");
            timeInfo = String.valueOf(timeInfo) + Pellet.getTimerString("Classification");
            timeInfo = String.valueOf(timeInfo) + Pellet.getTimerString("Realization");
        } else {
            timeInfo = String.valueOf(timeInfo) + Pellet.getTimerString("Loading");
            timeInfo = String.valueOf(timeInfo) + Pellet.getTimerString("Preprocessing");
            timeInfo = String.valueOf(timeInfo) + Pellet.getTimerString("Consistency");
            timeInfo = String.valueOf(timeInfo) + Pellet.getTimerString("Entailment");
            timeInfo = String.valueOf(timeInfo) + Pellet.getTimerString("Unsatisfiability");
            timeInfo = String.valueOf(timeInfo) + Pellet.getTimerString("Classification");
            timeInfo = String.valueOf(timeInfo) + Pellet.getTimerString("Realization");
        }
        timeInfo = String.valueOf(timeInfo) + ")";
        return timeInfo;
    }

    private static String getTimerString(String name) {
        String info = "";
        Timers.Timer t = timers.getTimer(name);
        if (t != null) {
            info = String.valueOf(name) + ": " + t.totalTime + " ";
        }
        return info;
    }

    public void setClassifyFormat(String string) {
        this.classifyFormat = string;
    }

    public void setCoFile(String string) {
        this.coFile = string;
    }

    public void setCoFormat(String string) {
        this.coFormat = string;
    }

    public void setCoString(String string) {
        this.coString = string;
    }

    public void setFormatHTML(boolean b) {
        this.formatHTML = b;
    }

    public void setInFile(String string) {
        this.inFile = string;
    }

    public void setInFormat(String string) {
        this.inFormat = string;
    }

    public void setInString(String string) {
        this.inString = string;
    }

    public void setOutFile(String string) {
        this.outFile = string;
    }

    public void setQueryFile(String string) {
        this.queryFile = string;
    }

    public void setTimeout(int i) {
        this.timeout = i;
    }

    public void setQuiet(boolean b) {
        this.quiet = b;
    }

    public void setConsistency(boolean b) {
        this.checkConsistency = b;
    }

    public void setRealize(boolean b) {
        this.realize = b;
    }

    public void setUnsat(boolean b) {
        this.unsat = b;
    }

    static void usage() {
        System.out.println("Pellet - OWL DL Reasoner");
        System.out.println("For the OWL ontologies Pellet provides options find the ontology level");
        System.out.println("(Lite, DL, FULL), check consistency, find unsatisfiable concepts, ");
        System.out.println("display class hierarchy, save OWL Full ontologies as OWL DL, ");
        System.out.println("check if triples in another ontology is entailed by the input");
        System.out.println("ontology");
        System.out.println("");
        System.out.println("Usage: java Pellet [-inputFile file]");
        System.out.println("   -inputFile file           Input ontology, a uri or a local file");
        System.out.println("   -inputString string       A string representation of the input file");
        System.out.println("   -inputFormat format       Format of the input file, ");
        System.out.println("                             one of [RDF/XML, N3, NTRIPLES]");
        System.out.println("   -quick              \t     Find ontology level, don't check consistency");
        System.out.println("   -unsat              \t     Find the unsatisfiable classes in the ontology");
        System.out.println("   -classify format          Classify the ontology and display the hierachy in");
        System.out.println("                             one of the formats [TREE, TABLE, RDF]");
        System.out.println("   -conclusionsFile file     Check if all the triples in this ontology is");
        System.out.println("                             entailed by the input ontology");
        System.out.println("   -conclusionsString string A string representation of the conclusions file");
        System.out.println("   -conclusionsFormat format Format of the conclusions file,");
        System.out.println("                             one of [RDF/XML, N3, NTRIPLES]");
        System.out.println("   -outputDL file            If the input file is OWL Full then save it in the");
        System.out.println("                             file as OWL DL file by adding missing type triples");
        System.out.println("   -timeout time             Timeout after <time> seconds");
        System.out.println("   -quiet              \t     Don't print warning messages");
        System.out.println("   -help              \t     Print this message");
    }
}

