/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.util.Properties;
import org.mindswap.pellet.Pellet;

public class PelletCGI {
    public static void main(String[] args) {
        PelletCGI.printHeader();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            String queryString = in.readLine();
            Properties params = PelletCGI.parseArgs(queryString);
            Pellet pellet = new Pellet();
            pellet.setFormatHTML(true);
            pellet.setTimeout(60);
            pellet.setInFile(params.getProperty("inputFile"));
            pellet.setInFormat(params.getProperty("inputFormat"));
            pellet.setInString(params.getProperty("inputString"));
            pellet.setCoFile(params.getProperty("conclusionsFile"));
            pellet.setCoFormat(params.getProperty("conclusionsFormat"));
            pellet.setCoString(params.getProperty("conclusionsString"));
            pellet.setClassifyFormat(params.getProperty("classifyFormat"));
            pellet.setConsistency(params.getProperty("Consistency") != null);
            pellet.setUnsat(params.getProperty("Unsat") != null);
            pellet.setRealize(params.getProperty("Realize") != null);
            pellet.start();
            int timeout = 90;
            pellet.join(timeout * 1000);
            if (pellet.isAlive()) {
                System.out.println("Timeout after " + timeout + " seconds");
                System.exit(0);
            }
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace(System.out);
            System.out.flush();
        }
        PelletCGI.printFooter();
    }

    public static Properties parseArgs(String queryString) throws Exception {
        Properties props = new Properties();
        String[] params = queryString.split("&");
        int i = 0;
        while (i < params.length) {
            String[] p = params[i].split("=");
            if (p.length == 2) {
                props.setProperty(p[0], URLDecoder.decode(p[1], "ISO-8859-1"));
            }
            ++i;
        }
        return props;
    }

    public static void printHeader() {
        System.out.println("Content-type: text/html\n\n");
        System.out.println("<H1>Results</H1>");
    }

    public static void printFooter() {
    }

    private static void printFile(String fileName) {
        try {
            String base = "/data/users/www/html/mindswap";
            BufferedReader in = new BufferedReader(new FileReader("/data/users/www/html/mindswap" + fileName));
            String line = in.readLine();
            while (line != null) {
                System.out.println(line);
                line = in.readLine();
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        System.out.flush();
    }
}

