/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermFactory;
import aterm.ATermList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import org.mindswap.pellet.ATermUtils;
import org.mindswap.pellet.Role;

public class RBox {
    static ATermFactory factory = ATermUtils.getFactory();
    Hashtable roles = new Hashtable();
    boolean consistent = true;
    Hashtable domainRestrictions = null;

    public Role getRole(ATerm r) {
        return (Role)this.roles.get(r);
    }

    public boolean isConsistent() {
        return this.consistent;
    }

    public void addObjectRole(ATerm r) {
        Role role = this.getRole(r);
        if (role == null) {
            role = new Role(r, 1);
            ATermAppl invR = ATermUtils.makeInv(r);
            role.inverse = invR;
            this.roles.put(r, role);
            Role invRole = new Role((ATerm)invR, 1);
            invRole.inverse = r;
            this.roles.put(invR, invRole);
        } else if (role.getType() != 0 && role.getType() != 1) {
            System.err.println(r + " is defined both as an ObjectProperty and a " + role.getTypeName() + "Property");
            this.consistent = false;
        }
    }

    public void addDatatypeRole(ATerm r) {
        Role role = this.getRole(r);
        if (role == null) {
            role = new Role(r, 2);
            this.roles.put(r, role);
        } else if (role.getType() != 0 && role.getType() != 2) {
            System.err.println(r + " is defined both as a DatatypeProperty and a " + role.getTypeName() + "Property");
            this.consistent = false;
        }
    }

    public void addAnnotationRole(ATerm r) {
        Role role = this.getRole(r);
        if (role == null) {
            role = new Role(r, 3);
            role.inverse = ATermUtils.makeInv(r);
            this.roles.put(r, role);
        } else if (role.getType() != 0 && role.getType() != 3) {
            System.err.println(r + "is defined both as an AnnotationProperty and a " + role.getTypeName() + "Property");
            this.consistent = false;
        }
    }

    public void addOntologyRole(ATerm r) {
        Role role = this.getRole(r);
        if (role == null) {
            role = new Role(r, 4);
            role.inverse = ATermUtils.makeInv(r);
            this.roles.put(r, role);
        } else if (role.getType() != 0 && role.getType() != 4) {
            System.err.println(r + "is defined both as an OntologyProperty and a " + role.getTypeName() + "Property");
            this.consistent = false;
        }
    }

    public void addTransitiveRole(ATerm r) {
        Role role = this.getRole(r);
        if (role != null && role.getType() == 1) {
            role.setTransitive(true);
        } else {
            System.err.println(r + "is defined both as a TransitiveProperty and a " + role.getTypeName() + "Property");
            this.consistent = false;
        }
    }

    public void addFunctionalRole(ATerm r) {
        Role role = this.getRole(r);
        if (role != null) {
            role.setFunctional(true);
        } else {
            System.err.println(r + "is not defined as a property");
            this.consistent = false;
        }
    }

    public void addInverseFunctionalRole(ATerm r) {
        Role role = this.getRole(r);
        if (role != null) {
            role.setInverseFunctional(true);
        } else {
            System.err.println(r + "is not defined as a property");
            this.consistent = false;
        }
    }

    public void addDomainRestriction(ATerm r, ATerm c) {
        Role role = this.getRole(r);
        if (role != null) {
            role.addDomain(c);
        } else {
            System.err.println(r + "is not defined as a property");
            this.consistent = false;
        }
    }

    public void addRangeRestriction(ATerm r, ATerm c) {
        Role role = this.getRole(r);
        if (role != null) {
            role.addRange(c);
        } else {
            System.err.println(r + "is not defined as a property");
            this.consistent = false;
        }
    }

    public ATermList getGlobalRestrictions() {
        ATermList list = ATermUtils.makeList();
        Iterator i = this.roles.values().iterator();
        while (i.hasNext()) {
            Role role = (Role)i.next();
            ATerm r = role.getName();
            if (role.isFunctional()) {
                ATermAppl max1r = ATermUtils.makeMax1(r);
                list = list.insert((ATerm)max1r);
            }
            if (role.isInverseFunctional()) {
                ATerm invR = this.getInverseRole(r);
                ATermAppl max1invR = ATermUtils.makeMax1(invR);
                list = list.insert((ATerm)max1invR);
            }
            if (role.getRange().isEmpty()) continue;
            ATerm c = ATermUtils.normalize(ATermUtils.makeAnd(role.getRange()));
            ATermAppl allValues = ATermUtils.makeAllValues(r, c);
            list = list.insert((ATerm)allValues);
        }
        return list;
    }

    public Hashtable getDomainRestrictions() {
        if (this.domainRestrictions != null) {
            return this.domainRestrictions;
        }
        this.domainRestrictions = new Hashtable();
        Iterator i = this.roles.values().iterator();
        while (i.hasNext()) {
            Role role = (Role)i.next();
            ATerm r = role.getName();
            if (role.getDomain().isEmpty()) continue;
            ATerm c = ATermUtils.normalize(ATermUtils.makeAnd(role.getDomain()));
            this.domainRestrictions.put(r, c);
        }
        return this.domainRestrictions;
    }

    public void addSubRole(ATerm s, ATerm r) {
        Role roleS = this.getRole(s);
        Role roleR = this.getRole(r);
        if (roleS == null || roleR == null) {
            this.consistent = false;
        } else {
            roleR.addSubRole(s);
            roleS.addSuperRole(r);
        }
    }

    public void addInverseRole(ATerm s, ATerm r) {
        Role roleS = this.getRole(s);
        Role roleR = this.getRole(r);
        if (roleS == null || roleR == null) {
            this.consistent = false;
        } else {
            ATermAppl prevInvR = (ATermAppl)roleR.getInverse();
            ATermAppl prevInvS = (ATermAppl)roleS.getInverse();
            if (prevInvR.equals((Object)s) && prevInvS.equals((Object)r)) {
                return;
            }
            if (prevInvR.getArity() == 0) {
                System.err.println("Multiple inverse properties defined for " + r);
                if (prevInvS.getArity() == 0) {
                    System.err.println("Multiple inverse properties defined for " + s);
                }
            } else if (prevInvS.getArity() == 0) {
                System.err.println("Multiple inverse properties defined for " + s);
            } else {
                this.roles.remove(roleR.getInverse());
                this.roles.remove(roleS.getInverse());
                roleR.setInverse(s);
                roleS.setInverse(r);
            }
        }
    }

    public boolean isRole(ATerm r) {
        if (r instanceof ATermAppl) {
            ATermAppl a = (ATermAppl)r;
            if (a.getArity() == 0) {
                return this.roles.containsKey(r);
            }
            if (a.getArity() == 1) {
                return a.getAFun().equals((Object)ATermUtils.INVFUN) && this.isRole(a.getArgument(0));
            }
        }
        return false;
    }

    public HashSet getSubRoles(ATerm r) {
        Role role = this.getRole(r);
        if (role == null) {
            throw new RuntimeException(r + " is not a role");
        }
        return role.getSubRoles();
    }

    public HashSet getSuperRoles(ATerm r) {
        Role role = this.getRole(r);
        if (role == null) {
            throw new RuntimeException(r + " is not a role");
        }
        return role.getSuperRoles();
    }

    public void computeRoleHierarchy() {
        ATerm r;
        Role role;
        Iterator i = this.roles.values().iterator();
        while (i.hasNext()) {
            role = (Role)i.next();
            r = role.getName();
            if (role.getType() != 1 && role.getType() != 2) continue;
            role.subRoles = this.computeSubRoles(r, new HashSet());
        }
        i = this.roles.values().iterator();
        while (i.hasNext()) {
            role = (Role)i.next();
            r = role.getName();
            Iterator subs = role.subRoles.iterator();
            while (subs.hasNext()) {
                Role s = this.getRole((ATerm)subs.next());
                s.addSuperRole(r);
            }
        }
        i = this.roles.values().iterator();
        while (i.hasNext()) {
            role = (Role)i.next();
            r = role.getName();
            role.setTransitive(this.isTransitiveRole(r));
        }
    }

    private HashSet computeImmediateSubRoles(ATerm r) {
        Role role = this.getRole(r);
        ATerm invR = role.getInverse();
        Role invRole = invR == null ? null : this.getRole(invR);
        HashSet subs = role.getSubRoles();
        ATermList invSubs = ATermUtils.makeList();
        if (invRole != null) {
            subs.addAll(this.inverseRoleList(invRole.getSubRoles()));
        }
        return subs;
    }

    private HashSet computeSubRoles(ATerm r, HashSet list) {
        if (list.contains(r)) {
            return list;
        }
        list.add(r);
        Iterator i = this.computeImmediateSubRoles(r).iterator();
        while (i.hasNext()) {
            ATerm s = (ATerm)i.next();
            list.addAll(this.computeSubRoles(s, list));
        }
        return list;
    }

    public boolean isInverse(ATerm r, ATerm s) {
        return this.getInverseRole(r).equals((Object)s);
    }

    public boolean isSubRole(ATerm r, ATerm s) {
        if (r.equals((Object)s)) {
            return this.isRole(r);
        }
        return this.getSubRoles(s).contains(r);
    }

    public ATerm getInverseRole(ATerm r) {
        ATermAppl r1;
        if (r instanceof ATermAppl && (r1 = (ATermAppl)r).getArity() == 1 && r1.getAFun().equals((Object)ATermUtils.INVFUN)) {
            return r1.getArgument(0);
        }
        Role role = this.getRole(r);
        if (role == null) {
            return null;
        }
        return role.getInverse();
    }

    public boolean isObjectRole(ATerm r) {
        Role role = this.getRole(r);
        return role != null && role.getType() == 1;
    }

    public boolean isOntologyRole(ATerm r) {
        Role role = this.getRole(r);
        return role != null && role.getType() == 4;
    }

    public boolean isAnnotationRole(ATerm r) {
        Role role = this.getRole(r);
        return role != null && role.getType() == 3;
    }

    public boolean isDatatypeRole(ATerm r) {
        Role role = this.getRole(r);
        return role != null && role.getType() == 2;
    }

    public boolean isTransitive(ATerm r) {
        Role role = this.getRole(r);
        return role != null && role.isTransitive();
    }

    private boolean isTransitiveRole(ATerm r) {
        return this.isTransitiveRole(r, new HashSet());
    }

    private boolean isTransitiveRole(ATerm r, HashSet visited) {
        if (visited.contains(r)) {
            return false;
        }
        visited.add(r);
        return this.isTransitive(r) || this.isSubTransitiveRole(r, visited) || this.isInverseTransitiveRole(r, visited);
    }

    private boolean isSubTransitiveRole(ATerm r, HashSet visited) {
        Iterator sr = this.getSuperRoles(r).iterator();
        while (sr.hasNext()) {
            ATerm s = (ATerm)sr.next();
            if (!this.isTransitiveRole(s, visited)) continue;
            return true;
        }
        return false;
    }

    private boolean isInverseTransitiveRole(ATerm r, HashSet visited) {
        ATerm ir = this.getInverseRole(r);
        return ATermUtils.isPrimitive(ir) && this.isTransitiveRole(ir, visited);
    }

    public String toString() {
        return "[RBox " + this.roles.values() + "]";
    }

    public HashSet inverseRoleList(HashSet roles) {
        HashSet<ATerm> l = new HashSet<ATerm>();
        Iterator i = roles.iterator();
        while (i.hasNext()) {
            l.add(this.getInverseRole((ATerm)i.next()));
        }
        return l;
    }
}

