/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import org.mindswap.pellet.ATermUtils;
import org.mindswap.pellet.TBox;
import org.mindswap.pellet.TermDefinition;

public class TuBox
extends TBox {
    Hashtable unfoldedcache = new Hashtable();
    HashSet unfoldMisses = new HashSet();
    static int resets = 0;
    static int createtime = 0;

    public TuBox() {
    }

    public TuBox(ATermList termList) {
        super(termList);
    }

    public boolean addIfUnfoldable(ATermAppl term) {
        boolean result;
        block5: {
            ATermAppl name = (ATermAppl)term.getArgument(0);
            TermDefinition tdcopy = null;
            TermDefinition td = null;
            result = false;
            if (this.contains((ATerm)name)) {
                td = this.getTD((ATerm)name);
                tdcopy = new TermDefinition(td);
            } else {
                tdcopy = new TermDefinition();
            }
            tdcopy.addDef(term);
            if (!tdcopy.isGCI() && tdcopy.isUnique()) {
                this.termhash.put(name, tdcopy);
                this.resetCache();
                try {
                    this.unfoldTerm(name);
                    result = true;
                }
                catch (NotUnfoldableException e) {
                    this.resetCache();
                    this.termhash.remove(name);
                    if (td == null) break block5;
                    this.termhash.put(name, td);
                }
            }
        }
        return result;
    }

    public static void printStatistics() {
        System.out.println("\nTu Statistics:");
        System.out.println("Number of resets: " + resets);
        System.out.println("Time in createSplitTBox: " + createtime);
    }

    public boolean isUnfoldable() {
        this.resetCache();
        try {
            this.unfold();
            return true;
        }
        catch (NotUnfoldableException e) {
            this.resetCache();
            return false;
        }
    }

    public void resetCache() {
        this.unfoldedcache = new Hashtable();
        this.unfoldMisses = new HashSet();
        ++resets;
    }

    private void loopConstraintWrap(ATermAppl term, Hashtable seen, int negations) throws NotUnfoldableException {
        try {
            this.loopConstraint(term, seen, negations);
        }
        catch (NotUnfoldableException e) {
            if (this.termhash.containsKey(term) || term.getAFun().equals((Object)ATermUtils.NOTFUN)) {
                this.unfoldMisses.add(term);
                e.addTerm((ATerm)term);
            }
            throw e;
        }
    }

    private void loopConstraint(ATermAppl term, Hashtable seen, int negations) throws NotUnfoldableException {
        if (term.getArity() == 0) {
            int negationlevel;
            if (seen.containsKey(term) && (negations - (negationlevel = ((Integer)seen.get(term)).intValue())) % 2 != 0) {
                throw new NotUnfoldableException((ATerm)term, "Term " + term + " contains a loop (negations: " + (negations - negationlevel) + ").");
            }
        } else if (!(term.getAFun().equals((Object)ATermUtils.MINFUN) || term.getAFun().equals((Object)ATermUtils.MAXFUN) || term.getAFun().equals((Object)ATermUtils.DTFUN) || term.getAFun().equals((Object)ATermUtils.VALUEFUN))) {
            if (term.getAFun().equals((Object)ATermUtils.NOTFUN)) {
                this.loopConstraint((ATermAppl)term.getArgument(0), seen, negations + 1);
            } else if (term.getAFun().equals((Object)ATermUtils.SOMEFUN) || term.getAFun().equals((Object)ATermUtils.ALLFUN)) {
                this.loopConstraint((ATermAppl)term.getArgument(1), seen, negations);
            } else if (term.getAFun().equals((Object)ATermUtils.ANDFUN) || term.getAFun().equals((Object)ATermUtils.ORFUN)) {
                int i = 0;
                while (i < term.getArity()) {
                    ATerm arg = term.getArgument(i);
                    if (arg instanceof ATermAppl) {
                        this.loopConstraintWrap((ATermAppl)arg, seen, negations);
                    } else {
                        ATermList list;
                        ATermList l = list = (ATermList)arg;
                        while (!l.isEmpty()) {
                            this.loopConstraintWrap((ATermAppl)l.getFirst(), seen, negations);
                            l = l.getNext();
                        }
                    }
                    ++i;
                }
            } else {
                throw new RuntimeException("ATermAppl of unknown use in unfolding!: " + term);
            }
        }
    }

    public ATermAppl unfoldTermWrap(ATermAppl term, Hashtable seen, int negations) throws NotUnfoldableException {
        try {
            return this.unfoldTerm(term, seen, negations);
        }
        catch (NotUnfoldableException e) {
            if (this.termhash.containsKey(term) || term.getAFun().equals((Object)ATermUtils.NOTFUN)) {
                this.unfoldMisses.add(term);
                e.addTerm((ATerm)term);
            }
            throw e;
        }
    }

    public ATermAppl unfoldTerm(ATermAppl term) throws NotUnfoldableException {
        return this.unfoldTermWrap(term, new Hashtable(), 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ATermAppl unfoldTerm(ATermAppl term, Hashtable seen, int negations) throws NotUnfoldableException {
        ATermAppl unfoldedterm = null;
        if (this.unfoldMisses.contains(term)) {
            throw new NotUnfoldableException((ATerm)term, "Term already deemed not unfoldable.");
        }
        if (term.getArity() == 0) {
            if (seen.containsKey(term)) {
                this.loopConstraint(term, seen, negations);
                return term;
            }
            if (this.unfoldedcache.containsKey(term)) {
                unfoldedterm = (ATermAppl)this.unfoldedcache.get(term);
                this.loopConstraintWrap(unfoldedterm, seen, negations);
            } else if (this.termhash.containsKey(term)) {
                seen.put(term, new Integer(negations));
                TermDefinition td = (TermDefinition)this.termhash.get(term);
                if (!td.isUnique()) {
                    throw new NotUnfoldableException((ATerm)term, "Term " + td + " is not unique.");
                }
                if (td.isGCI()) {
                    throw new NotUnfoldableException((ATerm)term, "Term " + td + " is a GCI.");
                }
                ATermAppl termdef = td.getDef(0);
                if (termdef.getName().equals(ATermUtils.SAME)) {
                    ATermAppl newterm = this.unfoldTermWrap((ATermAppl)termdef.getArgument(1), seen, negations);
                    seen.remove(term);
                    unfoldedterm = newterm;
                } else {
                    ATermAppl intersection;
                    if (!termdef.getName().equals(ATermUtils.SUB)) throw new RuntimeException(String.valueOf(termdef.toString()) + " is not a subclass or sameclass definition");
                    ATermAppl newterm = this.unfoldTermWrap((ATermAppl)termdef.getArgument(1), seen, negations);
                    seen.remove(term);
                    ATermAppl aprime = ATermUtils.makeTermAppl("prime-" + term);
                    unfoldedterm = intersection = (ATermAppl)ATermUtils.makeAnd((ATerm)aprime, (ATerm)newterm);
                }
            } else {
                unfoldedterm = term;
            }
        } else {
            if (term.getAFun().equals((Object)ATermUtils.MINFUN)) return term;
            if (term.getAFun().equals((Object)ATermUtils.MAXFUN)) return term;
            if (term.getAFun().equals((Object)ATermUtils.DTFUN)) return term;
            if (term.getAFun().equals((Object)ATermUtils.VALUEFUN)) {
                return term;
            }
            if (term.getAFun().equals((Object)ATermUtils.NOTFUN)) {
                ATermAppl newterm = this.unfoldTermWrap((ATermAppl)term.getArgument(0), seen, negations + 1);
                return ATermUtils.makeNot((ATerm)newterm);
            }
            if (term.getAFun().equals((Object)ATermUtils.SOMEFUN) || term.getAFun().equals((Object)ATermUtils.ALLFUN)) {
                ATerm[] arglist = new ATerm[]{term.getArgument(0), this.unfoldTermWrap((ATermAppl)term.getArgument(1), seen, negations)};
                return TBox.factory.makeAppl(term.getAFun(), arglist);
            }
            if (!term.getAFun().equals((Object)ATermUtils.ANDFUN)) {
                if (!term.getAFun().equals((Object)ATermUtils.ORFUN)) throw new RuntimeException("ATermAppl of unknown use in unfolding!: " + term);
            }
            ATerm[] arglist = new ATerm[term.getArity()];
            int i = 0;
            while (i < term.getArity()) {
                ATerm arg = term.getArgument(i);
                if (arg instanceof ATermAppl) {
                    arglist[i] = this.unfoldTermWrap((ATermAppl)arg, seen, negations);
                } else {
                    ATermList list;
                    ATermList unfoldedList = ATermUtils.makeList();
                    ATermList l = list = (ATermList)arg;
                    while (!l.isEmpty()) {
                        unfoldedList = unfoldedList.insert((ATerm)this.unfoldTermWrap((ATermAppl)l.getFirst(), seen, negations));
                        l = l.getNext();
                    }
                    arglist[i] = unfoldedList;
                }
                ++i;
            }
            ATermAppl newterm = TBox.factory.makeAppl(term.getAFun(), arglist);
            return newterm;
        }
        this.unfoldedcache.put(term, unfoldedterm);
        return unfoldedterm;
    }

    public ATermList unfold() throws NotUnfoldableException {
        ATermList list = ATermUtils.makeList();
        this.resetCache();
        Enumeration e = this.termhash.elements();
        while (e.hasMoreElements()) {
            TermDefinition td = (TermDefinition)e.nextElement();
            list = list.insert((ATerm)this.unfoldTerm(td.getName()));
        }
        return list;
    }

    public class NotUnfoldableException
    extends TBox.TBoxException {
        ATerm offender;
        HashSet terms = new HashSet();
        ATermList termlist = ATermUtils.makeList();

        public NotUnfoldableException() {
        }

        public NotUnfoldableException(String e) {
            super(e);
        }

        public NotUnfoldableException(ATerm term) {
            this.setOffender(term);
        }

        public NotUnfoldableException(ATerm term, String e) {
            super(e);
            this.setOffender(term);
        }

        public void setOffender(ATerm term) {
            this.offender = term;
        }

        public void addTerm(ATerm term) {
            this.terms.add(term);
            this.termlist = this.termlist.insert(term);
        }

        public String toString() {
            StringBuffer retBuffer = new StringBuffer(super.toString());
            retBuffer.append("\nPath to problem:\n");
            ATermList list = this.termlist;
            while (!list.isEmpty()) {
                retBuffer.append("  " + list.getFirst() + "\n");
                list = list.getNext();
            }
            return retBuffer.toString();
        }
    }
}

