/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.impl.FileGraph;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class TestFileGraph
extends GraphTestBase {
    static /* synthetic */ Class class$com$hp$hpl$jena$graph$test$TestFileGraph;

    public TestFileGraph(String string) {
        super(string);
    }

    public static TestSuite suite() {
        TestSuite testSuite = new TestSuite(class$com$hp$hpl$jena$graph$test$TestFileGraph == null ? (class$com$hp$hpl$jena$graph$test$TestFileGraph = TestFileGraph.class$("com.hp.hpl.jena.graph.test.TestFileGraph")) : class$com$hp$hpl$jena$graph$test$TestFileGraph);
        testSuite.addTest((Test)new Case("x /R y", "xxxA", ".rdf"));
        testSuite.addTest((Test)new Case("x /R y", "xxxB", ".n3"));
        testSuite.addTest((Test)new Case("x /R y", "xxxC", ".nt"));
        testSuite.addTest((Test)new Case("x /R y; p /R q", "xxxD", ".rdf"));
        testSuite.addTest((Test)new Case("x /R y; p /R q", "xxxE", ".n3"));
        testSuite.addTest((Test)new Case("x /R y; p /R q", "xxxF", ".nt"));
        testSuite.addTest((Test)new Case("http://domain/S ftp:ftp/P O", "xxxG", ".rdf"));
        testSuite.addTest((Test)new Case("http://domain/S ftp:ftp/P O", "xxxH", ".nt"));
        testSuite.addTest((Test)new Case("http://domain/S ftp:ftp/P O", "xxxI", ".n3"));
        return testSuite;
    }

    public void testGuessLang() {
        TestFileGraph.assertEquals((String)"N3", (String)FileGraph.guessLang("simple.n3"));
        TestFileGraph.assertEquals((String)"N3", (String)FileGraph.guessLang("hello.there.n3"));
        TestFileGraph.assertEquals((String)"N-TRIPLE", (String)FileGraph.guessLang("simple.nt"));
        TestFileGraph.assertEquals((String)"N-TRIPLE", (String)FileGraph.guessLang("whats.up.nt"));
        TestFileGraph.assertEquals((String)"RDF/XML", (String)FileGraph.guessLang("poggle.rdf"));
        TestFileGraph.assertEquals((String)"RDF/XML", (String)FileGraph.guessLang("dotless"));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class Case
    extends TestFileGraph {
        String content;
        String prefix;
        String suffix;

        Case(String string, String string2, String string3) {
            super("Case: " + string + " in " + string2 + "*" + string3);
            this.content = string;
            this.prefix = string2;
            this.suffix = string3;
        }

        public void runTest() {
            File file = Case.tempFileName(this.prefix, this.suffix);
            Graph graph = Case.graphWith(this.content);
            FileGraph fileGraph = new FileGraph(file, true, true);
            fileGraph.getBulkUpdateHandler().add(graph);
            fileGraph.close();
            FileGraph fileGraph2 = new FileGraph(file, false, true);
            Case.assertEquals("", graph, fileGraph2);
            fileGraph2.close();
        }
    }
}

