/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.n3;

import com.hp.hpl.jena.n3.N3Parser;
import com.hp.hpl.jena.n3.N3ParserEventHandler;
import com.hp.hpl.jena.n3.N3toRDF;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.shared.JenaException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;

public class N3JenaReader
implements RDFReader {
    RDFErrorHandler errorHandler = null;

    public void read(Model model, Reader reader, String string) {
        this.read(model, reader, string, null);
    }

    public void read(Model model, String string) {
        try {
            URLConnection uRLConnection = new URL(string).openConnection();
            String string2 = uRLConnection.getContentEncoding();
            if (string2 == null) {
                this.read(model, new InputStreamReader(uRLConnection.getInputStream()), string, string);
            } else {
                this.read(model, new InputStreamReader(uRLConnection.getInputStream(), string2), string, string);
            }
        }
        catch (JenaException jenaException) {
            if (this.errorHandler == null) {
                throw jenaException;
            }
            this.errorHandler.error(jenaException);
        }
        catch (Exception exception) {
            if (this.errorHandler == null) {
                throw new JenaException(exception);
            }
            this.errorHandler.error(exception);
        }
    }

    public void read(Model model, Reader reader, String string, String string2) {
        try {
            N3toRDF n3toRDF = new N3toRDF(model, string);
            N3Parser n3Parser = new N3Parser(reader, (N3ParserEventHandler)n3toRDF);
            n3Parser.parse();
        }
        catch (JenaException jenaException) {
            if (this.errorHandler == null) {
                throw jenaException;
            }
            this.errorHandler.error(jenaException);
        }
        catch (Exception exception) {
            if (this.errorHandler == null) {
                throw new JenaException(exception);
            }
            this.errorHandler.error(exception);
        }
    }

    public void read(Model model, InputStream inputStream, String string) {
        this.read(model, inputStream, string, null);
    }

    public void read(Model model, InputStream inputStream, String string, String string2) {
        try {
            N3toRDF n3toRDF = new N3toRDF(model, string);
            N3Parser n3Parser = new N3Parser(inputStream, (N3ParserEventHandler)n3toRDF);
            n3Parser.parse();
        }
        catch (JenaException jenaException) {
            if (this.errorHandler == null) {
                throw jenaException;
            }
            this.errorHandler.error(jenaException);
        }
        catch (Exception exception) {
            if (this.errorHandler == null) {
                throw new JenaException(exception);
            }
            this.errorHandler.error(exception);
        }
    }

    public RDFErrorHandler setErrorHandler(RDFErrorHandler rDFErrorHandler) {
        RDFErrorHandler rDFErrorHandler2 = this.errorHandler;
        this.errorHandler = rDFErrorHandler;
        return rDFErrorHandler2;
    }

    public Object setProperty(String string, Object object) {
        return null;
    }
}

