/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.tidy;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.ontology.tidy.CGeneral;
import com.hp.hpl.jena.ontology.tidy.SyntaxProblem;
import com.hp.hpl.jena.ontology.tidy.Vocab;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;

class OneTwoImpl
extends CGeneral {
    private Triple[] seen = new Triple[3];
    private static String[] shortMsg = new String[]{"Illegal description/restriction/list/alldifferent structure", "Illegal restriction/list structure", "Node may not be object of multiple triples"};
    private static Node[] gProp = new Node[]{Vocab.firstPart, Vocab.secondPart, Vocab.objectOfTriple};

    OneTwoImpl(Node node, EnhGraph enhGraph) {
        super(node, enhGraph);
    }

    public void first(Triple triple) {
        this.check(0, triple);
    }

    public void second(Triple triple) {
        this.check(1, triple);
    }

    void check(int n, Triple triple) {
        Triple triple2 = this.get(n);
        if (triple2 != null) {
            if (triple2.equals(triple)) {
                return;
            }
            Graph graph = ModelFactory.createDefaultModel().getGraph();
            graph.add(triple2);
            graph.add(triple);
            this.getChecker().addProblem(new SyntaxProblem(shortMsg[n], graph, 2));
        } else {
            Graph graph = this.getGraph().asGraph();
            Reifier reifier = graph.getReifier();
            Node node = Node.createAnon();
            reifier.reifyAs(node, triple);
            this.getGraph().asGraph().add(new Triple(this.asNode(), gProp[n], node));
            this.seen[n] = triple;
        }
    }

    private Triple get(int n) {
        if (this.seen[n] == null) {
            Graph graph = this.getGraph().asGraph();
            ExtendedIterator extendedIterator = graph.find(this.asNode(), gProp[n], null);
            if (extendedIterator.hasNext()) {
                this.seen[n] = graph.getReifier().getTriple(((Triple)extendedIterator.next()).getObject());
            }
            extendedIterator.close();
        }
        return this.seen[n];
    }

    boolean incomplete(int n) {
        for (int i = 0; i < n; ++i) {
            if (this.get(i) != null) continue;
            return true;
        }
        return false;
    }
}

