/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp.test;

import com.hp.hpl.jena.rdf.arp.test.LazyURLInputStream;
import com.hp.hpl.jena.rdf.arp.test.LazyZipEntryInputStream;
import com.hp.hpl.jena.rdf.arp.test.URI;
import com.hp.hpl.jena.rdf.arp.test.WGTestSuite;
import com.hp.hpl.jena.shared.JenaException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipFile;

class ARPTestInputStreamFactory {
    private final URI base;
    private final URI mapBase;
    private final ZipFile zip;
    private final String property;
    String createMe = "error";

    ARPTestInputStreamFactory(URI uRI, URI uRI2) {
        this.base = uRI;
        this.mapBase = uRI2;
        this.zip = null;
        this.property = null;
    }

    ARPTestInputStreamFactory(URI uRI, ZipFile zipFile) {
        this.base = uRI;
        this.mapBase = null;
        this.zip = zipFile;
        this.property = null;
    }

    ARPTestInputStreamFactory(URI uRI, String string) {
        this.createMe = "new ARPTestInputStreamFactory(URI.create(\"" + uRI.toString() + "\"),\"" + string + "\")";
        this.base = uRI;
        this.mapBase = null;
        this.zip = null;
        this.property = string.endsWith("/") ? string : string + "/";
    }

    URI getBase() {
        return this.base;
    }

    InputStream open(String string) {
        return this.open(URI.create(string));
    }

    InputStream open(URI uRI) {
        return (InputStream)this.open(uRI, true);
    }

    boolean savable() {
        return this.mapBase != null && this.mapBase.getScheme().equalsIgnoreCase("file");
    }

    OutputStream openOutput(String string) {
        OutputStream outputStream = (OutputStream)this.open(URI.create(string), false);
        return outputStream;
    }

    private Object open(URI uRI, boolean bl) {
        URI uRI2;
        URI uRI3 = uRI2 = uRI.isAbsolute() ? this.base.relativize(uRI) : uRI;
        if (uRI2.isAbsolute()) {
            throw new IllegalArgumentException("This  ARPTestInputStreamFactory only knows about '" + this.base + "'.");
        }
        if (this.mapBase != null) {
            try {
                URL uRL = this.mapBase.resolve(uRI2).toURL();
                if (!bl) {
                    if (uRL.getProtocol().equalsIgnoreCase("file")) {
                        return new FileOutputStream(uRL.getFile());
                    }
                    throw new IllegalArgumentException("Can only save to file: scheme");
                }
                return new LazyURLInputStream(uRL);
            }
            catch (MalformedURLException malformedURLException) {
                throw new JenaException(malformedURLException);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new JenaException(iOException);
            }
        }
        if (!bl) {
            throw new IllegalArgumentException("Can only save to URLs");
        }
        if (this.zip != null) {
            return new LazyZipEntryInputStream(this.zip, uRI2.toString());
        }
        return WGTestSuite.getInputStream(this.property + uRI2.toString());
    }
}

