/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.xmloutput.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.mem.ModelMem;
import com.hp.hpl.jena.rdf.arp.URI;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.impl.RDFDefaultErrorHandler;
import com.hp.hpl.jena.rdf.model.impl.Util;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.shared.BadURIException;
import com.hp.hpl.jena.shared.InvalidPropertyURIException;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.TestLogger;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.xmloutput.test.PrettyWriterTest;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.oro.text.awk.AwkCompiler;
import org.apache.oro.text.awk.AwkMatcher;
import org.apache.oro.text.regex.MalformedPatternException;

public class TestXMLFeatures
extends TestCase {
    static AwkCompiler awk = PrettyWriterTest.awk;
    static AwkMatcher matcher = PrettyWriterTest.matcher;
    protected static Logger logger = Logger.getLogger((Class)(class$com$hp$hpl$jena$xmloutput$test$TestXMLFeatures == null ? (class$com$hp$hpl$jena$xmloutput$test$TestXMLFeatures = TestXMLFeatures.class$("com.hp.hpl.jena.xmloutput.test.TestXMLFeatures")) : class$com$hp$hpl$jena$xmloutput$test$TestXMLFeatures));
    private String base1 = "http://example/foobar";
    private String base2 = "http://example/barfoo";
    private String file1 = "testing/abbreviated/namespaces.rdf";
    private String lang;
    static final int BadPropURI = 1;
    static final int NoError = 0;
    static final int ExtraTriples = 2;
    static final int BadURI = 3;
    static String[][] rData1;
    static String[][] rData2;
    static String[][] rData3;
    private static String[] uris;
    static /* synthetic */ Class class$com$hp$hpl$jena$xmloutput$test$TestXMLFeatures;
    static /* synthetic */ Class class$com$hp$hpl$jena$xmloutput$impl$BaseXMLWriter;
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$arp$URI;

    TestXMLFeatures(String string, String string2) {
        super(string);
        this.lang = string2;
    }

    public String toString() {
        return this.getName() + " " + this.lang;
    }

    public static Test suite() {
        return new TestSuite(class$com$hp$hpl$jena$xmloutput$test$TestXMLFeatures == null ? (class$com$hp$hpl$jena$xmloutput$test$TestXMLFeatures = TestXMLFeatures.class$("com.hp.hpl.jena.xmloutput.test.TestXMLFeatures")) : class$com$hp$hpl$jena$xmloutput$test$TestXMLFeatures);
    }

    public void testBrokenPrefixing() throws Exception {
        Model model = ModelFactory.createDefaultModel();
        model.add(ModelTestBase.statement(model, "a http://bingle.bongle/booty#PP b"));
        model.add(ModelTestBase.statement(model, "c http://dingle.dongle/dooty#PP d"));
        StringWriter stringWriter = new StringWriter();
        model.write(stringWriter);
        Model model2 = ModelFactory.createDefaultModel();
        String string = stringWriter.toString();
        model2.read(new StringReader(string), "");
        StringWriter stringWriter2 = new StringWriter();
        model2.write(stringWriter2);
        String string2 = stringWriter2.toString();
        int n = string2.indexOf("xmlns:j.0=");
        int n2 = string2.lastIndexOf("xmlns:j.0=");
        TestXMLFeatures.assertEquals((int)n, (int)n2);
        System.out.println(stringWriter2.toString());
    }

    public void testBug696057() throws IOException {
        File file = File.createTempFile("jena", ".rdf");
        String string = file.getAbsolutePath();
        ModelMem modelMem = new ModelMem();
        modelMem.read(new FileInputStream("testing/wg/rdfms-syntax-incomplete/test001.rdf"), "");
        modelMem.write(new FileWriter(string), this.lang);
        ModelMem modelMem2 = new ModelMem();
        modelMem2.read(new FileInputStream(string), "");
        TestXMLFeatures.assertTrue((String)"Use of FileWriter", (boolean)modelMem.isIsomorphicWith(modelMem2));
        file.delete();
    }

    public void testXMLBase() throws IOException, MalformedPatternException {
        this.check(this.file1, "xml:base=['\"]" + this.base2 + "['\"]", new Change(){

            public void code(RDFWriter rDFWriter) {
                String string = (String)rDFWriter.setProperty("xmlbase", TestXMLFeatures.this.base1);
                Assert.assertTrue((String)"xmlbase valued non-null", (string == null ? (byte)1 : 0) != 0);
                string = (String)rDFWriter.setProperty("xmlbase", TestXMLFeatures.this.base2);
                Assert.assertEquals((String)"xmlbase valued incorrect.", (String)TestXMLFeatures.this.base1, (String)string);
            }
        });
    }

    public void testPropertyURI() throws IOException {
        this.doBadPropTest(this.lang);
    }

    private void check(String string, String string2, Change change) throws IOException, MalformedPatternException {
        this.check(string, string2, null, change);
    }

    private void check(String string, String string2, String string3, Change change) throws IOException, MalformedPatternException {
        this.check(string, null, string2, string3, false, change);
    }

    private void check(String string, String string2, String string3, String string4, Change change) throws IOException, MalformedPatternException {
        this.check(string, string2, string3, string4, false, change);
    }

    private void check(String string, String string2, Change change, String string3) throws IOException, MalformedPatternException {
        this.check(string, null, string2, null, false, new Change(){

            public void code(RDFWriter rDFWriter) {
            }
        }, string3);
        this.check(string, null, null, string2, false, change, string3);
    }

    private void check(String string, String string2, String string3, String string4, boolean bl, Change change) throws IOException, MalformedPatternException {
        this.check(string, string2, string3, string4, bl, change, "file:" + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check(String string, String string2, String string3, String string4, boolean bl, Change change, String string5) throws IOException, MalformedPatternException {
        boolean bl2;
        Writer writer;
        TestLogger testLogger = new TestLogger(class$com$hp$hpl$jena$xmloutput$impl$BaseXMLWriter == null ? (class$com$hp$hpl$jena$xmloutput$impl$BaseXMLWriter = TestXMLFeatures.class$("com.hp.hpl.jena.xmloutput.impl.BaseXMLWriter")) : class$com$hp$hpl$jena$xmloutput$impl$BaseXMLWriter);
        ModelMem modelMem = new ModelMem();
        FileInputStream fileInputStream = new FileInputStream(string);
        modelMem.read(fileInputStream, string5);
        ((InputStream)fileInputStream).close();
        ByteArrayOutputStream byteArrayOutputStream = null;
        if (string2 == null) {
            writer = new StringWriter();
        } else {
            byteArrayOutputStream = new ByteArrayOutputStream();
            writer = new OutputStreamWriter((OutputStream)byteArrayOutputStream, string2);
        }
        Properties properties = (Properties)System.getProperties().clone();
        RDFWriter rDFWriter = modelMem.getWriter(this.lang);
        change.code(modelMem, rDFWriter);
        rDFWriter.write((Model)modelMem, writer, string5);
        writer.close();
        String string6 = string2 == null ? writer.toString() : byteArrayOutputStream.toString(string2);
        try {
            ModelMem modelMem2 = new ModelMem();
            modelMem2.read(new StringReader(string6), string5);
            TestXMLFeatures.assertTrue((String)"Data got changed.", (boolean)modelMem.isIsomorphicWith(modelMem2));
            if (string3 != null) {
                TestXMLFeatures.assertTrue((String)("Should find /" + string3 + "/"), (boolean)matcher.contains(string6, awk.compile(string3)));
            }
            if (string4 != null) {
                TestXMLFeatures.assertTrue((String)("Should not find /" + string4 + "/"), (!matcher.contains(string6, awk.compile(string4)) ? (byte)1 : 0) != 0);
            }
            string6 = null;
            Object var19_17 = null;
            bl2 = !testLogger.end();
        }
        catch (Throwable throwable) {
            Object var19_18 = null;
            boolean bl3 = !testLogger.end();
            System.setProperties(properties);
            if (string6 != null) {
                System.err.println("===================");
                System.err.println("Offending content - " + this.toString());
                System.err.println("===================");
                System.err.println(string6);
                System.err.println("===================");
            }
            throw throwable;
        }
        System.setProperties(properties);
        if (string6 != null) {
            System.err.println("===================");
            System.err.println("Offending content - " + this.toString());
            System.err.println("===================");
            System.err.println(string6);
            System.err.println("===================");
        }
        TestXMLFeatures.assertEquals((String)"Errors (not) detected.", (boolean)bl, (boolean)bl2);
    }

    void doBadPropTest(String string) throws IOException {
        ModelMem modelMem = new ModelMem();
        modelMem.add(modelMem.createResource(), modelMem.createProperty("http://example/", "foo#"), "foo");
        File file = File.createTempFile("rdf", ".xml");
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            modelMem.write(fileOutputStream, string);
            fileOutputStream.close();
            TestXMLFeatures.fail((String)"Writer did not detect bad property URI");
        }
        catch (InvalidPropertyURIException invalidPropertyURIException) {
            // empty catch block
        }
        file.delete();
    }

    public void testUseNamespace() throws IOException, MalformedPatternException {
        this.check(this.file1, "xmlns:eg=['\"]http://example.org/#['\"]", new Change(){

            public void code(Model model) {
                model.setNsPrefix("eg", "http://example.org/#");
            }
        });
    }

    public void testSingleQuote() throws IOException, MalformedPatternException {
        this.check(this.file1, "'", "\"", new Change(){

            public void code(RDFWriter rDFWriter) {
                rDFWriter.setProperty("attributeQuoteChar", "'");
            }
        });
    }

    public void testDoubleQuote() throws IOException, MalformedPatternException {
        this.check(this.file1, "\"", "'", new Change(){

            public void code(RDFWriter rDFWriter) {
                rDFWriter.setProperty("attributeQuoteChar", "\"");
            }
        });
    }

    public void testUseDefaultNamespace() throws IOException, MalformedPatternException {
        this.check(this.file1, "xmlns=['\"]http://example.org/#['\"]", new Change(){

            public void code(Model model) {
                model.setNsPrefix("", "http://example.org/#");
            }
        });
    }

    public void testRDFNamespace() throws IOException, MalformedPatternException {
        this.check(this.file1, "xmlns:r=['\"]" + RDF.getURI() + "['\"]", "rdf:", new Change(){

            public void code(Model model) {
                model.setNsPrefix("r", RDF.getURI());
            }
        });
    }

    public void testTab() throws IOException, MalformedPatternException {
        this.check(this.file1, "          ", new Change(){

            public void code(RDFWriter rDFWriter) {
                rDFWriter.setProperty("tab", "5");
            }
        });
    }

    public void testNoTab() throws IOException, MalformedPatternException {
        this.check(this.file1, "  ", new Change(){

            public void code(RDFWriter rDFWriter) {
                rDFWriter.setProperty("tab", "0");
            }
        });
    }

    public void testNoLiteral() throws IOException, MalformedPatternException {
        this.check("testing/wg/rdfms-xml-literal-namespaces/test001.rdf", "#XMLLiteral", "[\"']Literal[\"']", new Change(){

            public void code(RDFWriter rDFWriter) {
                rDFWriter.setProperty("blockrules", "parseTypeLiteralPropertyElt");
            }
        });
    }

    public void testNoPropAttr() throws IOException, MalformedPatternException {
        this.check(this.file1, null, "prop1=", new Change(){

            public void code(RDFWriter rDFWriter) {
                rDFWriter.setProperty("blockrules", "propertyAttr");
            }
        });
    }

    public void testNoDamlCollection() throws IOException, MalformedPatternException {
        this.check("testing/abbreviated/daml.rdf", null, "[\"']daml:collection[\"']", new Change(){

            public void code(RDFWriter rDFWriter) {
                rDFWriter.setProperty("blockrules", "daml:collection");
            }
        });
    }

    public void testNoRdfCollection() throws IOException, MalformedPatternException {
        this.check("testing/abbreviated/collection.rdf", null, "[\"']Collection[\"']", new Change(){

            public void code(RDFWriter rDFWriter) {
                rDFWriter.setProperty("blockrules", "parseTypeCollectionPropertyElt");
            }
        });
    }

    public void testNoLi() throws IOException, MalformedPatternException {
        this.check("testing/abbreviated/container.rdf", null, "rdf:li", new Change(){

            public void code(RDFWriter rDFWriter) {
                rDFWriter.setProperty("blockrules", "section-List-Expand");
            }
        });
    }

    public void testNoID() throws IOException, MalformedPatternException {
        this.check("testing/abbreviated/container.rdf", "rdf:ID", new Change(){

            public void code(RDFWriter rDFWriter) {
                rDFWriter.setProperty("blockrules", "idAttr");
            }
        }, "http://example.org/foo");
    }

    public void testNoID2() throws IOException, MalformedPatternException {
        this.check("testing/abbreviated/container.rdf", "rdf:ID", new Change(){

            public void code(RDFWriter rDFWriter) {
                rDFWriter.setProperty("blockrules", "idAttr");
            }
        }, "http://example.org/foo#");
    }

    public void testNoResource() throws IOException, MalformedPatternException {
        this.check("testing/abbreviated/container.rdf", "['\"]Resource[\"']", new Change(){

            public void code(RDFWriter rDFWriter) {
                rDFWriter.setProperty("blockrules", "parseTypeResourcePropertyElt");
            }
        }, "http://example.org/foo#");
    }

    public void testNoReification() throws IOException, MalformedPatternException {
        String string = "testing/abbreviated/reification.rdf";
        String string2 = "http://example.org/foo";
        this.check(string, null, "rdf:subject", null, false, new Change(){

            public void code(RDFWriter rDFWriter) {
                rDFWriter.setProperty("blockrules", "section-Reification");
            }
        }, string2);
    }

    public void testNoStripes() throws IOException, MalformedPatternException {
        this.check("testing/abbreviated/collection.rdf", "                              <[a-zA-Z][-a-zA-Z0-9._]*:Class", new Change(){

            public void code(RDFWriter rDFWriter) {
                rDFWriter.setProperty("blockrules", "resourcePropertyElt");
            }
        }, "http://example.org/foo");
    }

    public void testRDFDefaultNamespace() throws IOException, MalformedPatternException {
        this.check(this.file1, "xmlns=['\"]" + RDF.getURI() + "['\"].*" + "xmlns:j.cook.up=['\"]" + RDF.getURI() + "['\"]", new Change(){

            public void code(Model model) {
                model.setNsPrefix("", RDF.getURI());
            }
        });
    }

    public void testBadPrefixNamespace() throws IOException, MalformedPatternException {
    }

    public void testDuplicateNamespace() throws IOException, MalformedPatternException {
        this.check(this.file1, "xmlns:eg[12]=['\"]http://example.org/#['\"]", "xmlns:eg[12]=['\"]http://example.org/#['\"].*xmlns:eg[12]=['\"]http://example.org/#['\"]", new Change(){

            public void code(Model model) {
                model.setNsPrefix("eg1", "http://example.org/#");
                model.setNsPrefix("eg2", "http://example.org/#");
            }
        });
    }

    public void testDuplicatePrefix() throws IOException, MalformedPatternException {
        this.check(this.file1, "xmlns:eg=['\"]http://example.org/file[12]#['\"]", null, new Change(){

            public void code(Model model) {
                model.setNsPrefix("eg", "http://example.org/file1#");
                model.setNsPrefix("eg", "http://example.org/file2#");
            }
        });
    }

    void setNsPrefixSysProp(String string, String string2) {
        System.setProperty("com.hp.hpl.jena.nsprefix." + string2, string);
    }

    public void testUseNamespaceSysProp() throws IOException, MalformedPatternException {
        this.check(this.file1, "xmlns:eg=['\"]http://example.org/#['\"]", new Change(){

            public void code(RDFWriter rDFWriter) {
                TestXMLFeatures.this.setNsPrefixSysProp("eg", "http://example.org/#");
            }
        });
    }

    public void testDefaultNamespaceSysProp() throws IOException, MalformedPatternException {
        this.check(this.file1, "xmlns=['\"]http://example.org/#['\"]", new Change(){

            public void code(RDFWriter rDFWriter) {
                TestXMLFeatures.this.setNsPrefixSysProp("", "http://example.org/#");
            }
        });
    }

    public void testDuplicateNamespaceSysProp() throws IOException, MalformedPatternException {
        this.check(this.file1, "xmlns:eg[12]=['\"]http://example.org/#['\"]", "xmlns:eg[12]=['\"]http://example.org/#['\"].*xmlns:eg[12]=['\"]http://example.org/#['\"]", new Change(){

            public void code(RDFWriter rDFWriter) {
                TestXMLFeatures.this.setNsPrefixSysProp("eg1", "http://example.org/#");
                TestXMLFeatures.this.setNsPrefixSysProp("eg2", "http://example.org/#");
            }
        });
    }

    public void testDuplicatePrefixSysProp() throws IOException, MalformedPatternException {
        this.check(this.file1, "xmlns:eg=['\"]http://example.org/file[12]#['\"]", null, new Change(){

            public void code(RDFWriter rDFWriter) {
                TestXMLFeatures.this.setNsPrefixSysProp("eg", "http://example.org/file1#");
                TestXMLFeatures.this.setNsPrefixSysProp("eg", "http://example.org/file2#");
            }
        });
    }

    public void testDuplicatePrefixSysPropAndExplicit() throws IOException, MalformedPatternException {
        this.check(this.file1, "xmlns:eg=['\"]http://example.org/file[12]#['\"]", null, new Change(){

            public void code(Model model) {
                model.setNsPrefix("eg", "http://example.org/file1#");
                TestXMLFeatures.this.setNsPrefixSysProp("eg", "http://example.org/file2#");
            }
        });
    }

    public void testUTF8DeclAbsent() throws IOException, MalformedPatternException {
        this.check(this.file1, "utf-8", null, "<\\?xml", new Change(){

            public void code(RDFWriter rDFWriter) {
            }
        });
    }

    public void testUTF16DeclAbsent() throws IOException, MalformedPatternException {
        this.check(this.file1, "utf-16", null, "<\\?xml", false, new Change(){

            public void code(RDFWriter rDFWriter) {
            }
        });
    }

    public void testUTF8DeclPresent() throws IOException, MalformedPatternException {
        this.check(this.file1, "utf-8", "<\\?xml", null, new Change(){

            public void code(RDFWriter rDFWriter) {
                rDFWriter.setProperty("showXmlDeclaration", Boolean.TRUE);
            }
        });
    }

    public void testUTF16DeclPresent() throws IOException, MalformedPatternException {
        this.check(this.file1, "utf-16", "<\\?xml", null, new Change(){

            public void code(RDFWriter rDFWriter) {
                rDFWriter.setProperty("showXmlDeclaration", Boolean.TRUE);
            }
        });
    }

    public void testISO8859_1_DeclAbsent() throws IOException, MalformedPatternException {
        this.check(this.file1, "iso-8859-1", null, "<\\?xml", new Change(){

            public void code(RDFWriter rDFWriter) {
                rDFWriter.setProperty("showXmlDeclaration", Boolean.FALSE);
            }
        });
    }

    public void testISO8859_1_DeclPresent() throws IOException, MalformedPatternException {
        this.check(this.file1, "iso-8859-1", "<\\?xml[^?]*ISO-8859-1", null, new Change(){

            public void code(RDFWriter rDFWriter) {
            }
        });
    }

    public void testStringDeclAbsent() throws IOException, MalformedPatternException {
        this.check(this.file1, null, "<\\?xml", new Change(){

            public void code(RDFWriter rDFWriter) {
            }
        });
    }

    public void testStringDeclPresent() throws IOException, MalformedPatternException {
        this.check(this.file1, "<\\?xml", "encoding", new Change(){

            public void code(RDFWriter rDFWriter) {
                rDFWriter.setProperty("showXmlDeclaration", Boolean.TRUE);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkPropURI(String string, String string2, Object object, int n) throws IOException {
        TestLogger testLogger = new TestLogger(class$com$hp$hpl$jena$xmloutput$impl$BaseXMLWriter == null ? (class$com$hp$hpl$jena$xmloutput$impl$BaseXMLWriter = TestXMLFeatures.class$("com.hp.hpl.jena.xmloutput.impl.BaseXMLWriter")) : class$com$hp$hpl$jena$xmloutput$impl$BaseXMLWriter);
        Node node = Node.createAnon();
        Node node2 = Node.createURI(string);
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(node, node2, node));
        Model model = ModelFactory.createModelForGraph(graphMem);
        StringWriter stringWriter = new StringWriter();
        RDFWriter rDFWriter = model.getWriter(this.lang);
        if (string2 != null) {
            rDFWriter.setProperty(string2, object);
        }
        try {
            rDFWriter.write(model, stringWriter, "http://example.org/");
            stringWriter.close();
            String string3 = stringWriter.toString();
            switch (n) {
                case 1: {
                    TestXMLFeatures.fail((String)("Bad property URI <" + string + "> was not detected."));
                }
                case 3: {
                    TestXMLFeatures.fail((String)("Bad URI <" + string + "> was not detected."));
                    break;
                }
            }
            ModelMem modelMem = new ModelMem();
            modelMem.read(new StringReader(string3), "http://example.org/", this.lang);
            switch (n) {
                case 2: {
                    TestXMLFeatures.assertTrue((String)"Expecting Brickley behaviour.", (modelMem.size() == 3L ? (byte)1 : 0) != 0);
                    return;
                }
                case 0: {
                    TestXMLFeatures.assertTrue((String)"Comparing Model written out and read in.", (boolean)model.isIsomorphicWith(modelMem));
                    return;
                }
            }
            return;
        }
        catch (BadURIException badURIException) {
            if (n != 3) throw badURIException;
            return;
        }
        catch (InvalidPropertyURIException invalidPropertyURIException) {
            if (n != 1) throw invalidPropertyURIException;
            return;
        }
        catch (JenaException jenaException) {
            throw jenaException;
        }
        finally {
            testLogger.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBadURIAsProperty1() throws IOException {
        try {
            RDFDefaultErrorHandler.logger.setLevel(Level.OFF);
            this.checkPropURI("_:aa", null, null, 3);
        }
        finally {
            RDFDefaultErrorHandler.logger.setLevel(Level.WARN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBadURIAsProperty2() throws IOException {
        try {
            RDFDefaultErrorHandler.logger.setLevel(Level.OFF);
            this.checkPropURI("_:aa", "allowBadURIs", "true", 0);
        }
        finally {
            RDFDefaultErrorHandler.logger.setLevel(Level.WARN);
        }
    }

    public void testLiAsProperty1() throws IOException {
        this.checkPropURI(RDF.getURI() + "li", null, null, 1);
    }

    public void testDescriptionAsProperty() throws IOException {
        this.checkPropURI(RDF.getURI() + "Description", null, null, 1);
    }

    public void testBadProperty1() throws IOException {
        this.checkPropURI("http:/a.b/", null, null, 1);
    }

    public void testRelativeAPI() {
        RDFWriter rDFWriter = new ModelMem().getWriter(this.lang);
        String string = (String)rDFWriter.setProperty("relativeURIs", "");
        TestXMLFeatures.assertEquals((String)"default value check", (String)string, (String)"same-document, absolute, relative, parent");
        rDFWriter.setProperty("relativeURIs", "network, grandparent,relative,  ");
        rDFWriter.setProperty("relativeURIs", "  parent, same-document, network, parent, absolute ");
        TestLogger testLogger = new TestLogger(class$com$hp$hpl$jena$rdf$arp$URI == null ? (class$com$hp$hpl$jena$rdf$arp$URI = TestXMLFeatures.class$("com.hp.hpl.jena.rdf.arp.URI")) : class$com$hp$hpl$jena$rdf$arp$URI);
        rDFWriter.setProperty("relativeURIs", "foo");
        TestXMLFeatures.assertTrue((String)"A warning should have been generated.", (!testLogger.end() ? (byte)1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void relative(String string, String string2, Collection collection, Collection collection2) throws IOException, MalformedPatternException {
        ModelMem modelMem = new ModelMem();
        modelMem.read("file:testing/abbreviated/relative-uris.rdf");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        RDFWriter rDFWriter = modelMem.getWriter(this.lang);
        rDFWriter.setProperty("relativeURIs", string);
        rDFWriter.write((Model)modelMem, byteArrayOutputStream, string2);
        byteArrayOutputStream.close();
        String string3 = byteArrayOutputStream.toString("UTF8");
        try {
            String string4;
            ModelMem modelMem2 = new ModelMem();
            modelMem2.read(new StringReader(string3), string2);
            TestXMLFeatures.assertTrue((boolean)modelMem.isIsomorphicWith(modelMem2));
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                string4 = (String)iterator.next();
                TestXMLFeatures.assertTrue((String)("Looking for /" + string4 + "/"), (boolean)matcher.contains(string3, awk.compile(Util.substituteStandardEntities(string4))));
            }
            iterator = collection2.iterator();
            while (iterator.hasNext()) {
                string4 = (String)iterator.next();
                TestXMLFeatures.assertTrue((String)("Looking for (not) /" + string4 + "/"), (!matcher.contains(string3, awk.compile("[\"']" + Util.substituteStandardEntities(string4) + "[\"']")) ? (byte)1 : 0) != 0);
            }
            string3 = null;
            Object var14_12 = null;
            if (string3 != null) {
                System.err.println("===================");
                System.err.println("Offending content - " + this.toString());
                System.err.println("===================");
                System.err.println(string3);
                System.err.println("===================");
            }
        }
        catch (Throwable throwable) {
            Object var14_13 = null;
            if (string3 != null) {
                System.err.println("===================");
                System.err.println("Offending content - " + this.toString());
                System.err.println("===================");
                System.err.println(string3);
                System.err.println("===================");
            }
            throw throwable;
        }
    }

    private void relative(int n, String string, String[][] stringArray) throws IOException, MalformedPatternException {
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (int i = 1; i < stringArray[n].length; ++i) {
            hashSet.add(stringArray[n][i] == null ? stringArray[0][i] : stringArray[n][i]);
            if (n == 0 || stringArray[n][i] == null) continue;
            hashSet2.add(stringArray[0][i]);
        }
        this.relative(stringArray[n][0], string, hashSet, hashSet2);
    }

    public void testRelative() throws Exception {
        for (int i = 0; i < 7; ++i) {
            this.relative(i, "http://www.example.org/a/b/c/d/", rData1);
            this.relative(i, "http://www.example.org/a/b/c/d", rData2);
            this.relative(i, "http://www.example.org/A/B#", rData3);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        String[] stringArray2 = new String[]{"http://www.example.org/a/b/c/d/", "http://www.example.org/a/b/c/d", "http://www.example.org/A/B#"};
        String[] stringArray3 = new String[]{"", "same-document", "absolute", "relative", "parent", "network", "grandparent"};
        for (int i = 0; i < stringArray2.length; ++i) {
            System.out.println("// " + stringArray2[i]);
            URI uRI = new URI(stringArray2[i]);
            for (int j = 0; j < stringArray3.length; ++j) {
                System.out.print(" { \"" + stringArray3[j] + "\", ");
                int n = URI.str2flags(stringArray3[j]);
                for (int k = 0; k < uris.length; ++k) {
                    String string = uRI.relativize(uris[k], n);
                    System.out.print(j != 0 && string.equals(uris[k]) ? "null, " : "\"" + string + "\"" + ", ");
                }
                System.out.println("},");
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        logger.setLevel(Level.OFF);
        rData1 = new String[][]{{"", "http://www.example.org/a/b/c/d/", "http://www.example.org/a/b/c/d/e/f/g/", "http://www.example.org/a/b/C/D", "http://www.example.org/A/B#foo/", "http://www.example.org/a/b/c/d/X#bar", "http://example.com/A", "http://www.example.org/a/b/c/d/z[?]x=a"}, {"same-document", "", null, null, null, null, null, null}, {"absolute", "/a/b/c/d/", "/a/b/c/d/e/f/g/", "/a/b/C/D", "/A/B#foo/", "/a/b/c/d/X#bar", null, "/a/b/c/d/z[?]x=a"}, {"relative", "[.]", "e/f/g/", null, null, "X#bar", null, "z[?]x=a"}, {"parent", "[.][.]/d/", "[.][.]/d/e/f/g/", null, null, "[.][.]/d/X#bar", null, "[.][.]/d/z[?]x=a"}, {"network", "//www.example.org/a/b/c/d/", "//www.example.org/a/b/c/d/e/f/g/", "//www.example.org/a/b/C/D", "//www.example.org/A/B#foo/", "//www.example.org/a/b/c/d/X#bar", "//example.com/A", "//www.example.org/a/b/c/d/z[?]x=a"}, {"grandparent", "[.][.]/[.][.]/c/d/", "[.][.]/[.][.]/c/d/e/f/g/", "[.][.]/[.][.]/C/D", null, "[.][.]/[.][.]/c/d/X#bar", null, "[.][.]/[.][.]/c/d/z[?]x=a"}};
        rData2 = new String[][]{{"", "http://www.example.org/a/b/c/d/", "http://www.example.org/a/b/c/d/e/f/g/", "http://www.example.org/a/b/C/D", "http://www.example.org/A/B#foo/", "http://www.example.org/a/b/c/d/X#bar", "http://example.com/A", "http://www.example.org/a/b/c/d/z[?]x=a"}, {"same-document", null, null, null, null, null, null, null}, {"absolute", "/a/b/c/d/", "/a/b/c/d/e/f/g/", "/a/b/C/D", "/A/B#foo/", "/a/b/c/d/X#bar", null, "/a/b/c/d/z[?]x=a"}, {"relative", "d/", "d/e/f/g/", null, null, "d/X#bar", null, "d/z[?]x=a"}, {"parent", "[.][.]/c/d/", "[.][.]/c/d/e/f/g/", "[.][.]/C/D", null, "[.][.]/c/d/X#bar", null, "[.][.]/c/d/z[?]x=a"}, {"network", "//www.example.org/a/b/c/d/", "//www.example.org/a/b/c/d/e/f/g/", "//www.example.org/a/b/C/D", "//www.example.org/A/B#foo/", "//www.example.org/a/b/c/d/X#bar", "//example.com/A", "//www.example.org/a/b/c/d/z[?]x=a"}, {"grandparent", "[.][.]/[.][.]/b/c/d/", "[.][.]/[.][.]/b/c/d/e/f/g/", "[.][.]/[.][.]/b/C/D", null, "[.][.]/[.][.]/b/c/d/X#bar", null, "[.][.]/[.][.]/b/c/d/z[?]x=a"}};
        rData3 = new String[][]{{"", "http://www.example.org/a/b/c/d/", "http://www.example.org/a/b/c/d/e/f/g/", "http://www.example.org/a/b/C/D", "http://www.example.org/A/B#foo/", "http://www.example.org/a/b/c/d/X#bar", "http://example.com/A", "http://www.example.org/a/b/c/d/z[?]x=a"}, {"same-document", null, null, null, "#foo/", null, null, null}, {"absolute", "/a/b/c/d/", "/a/b/c/d/e/f/g/", "/a/b/C/D", "/A/B#foo/", "/a/b/c/d/X#bar", null, "/a/b/c/d/z[?]x=a"}, {"relative", null, null, null, "B#foo/", null, null, null}, {"parent", "[.][.]/a/b/c/d/", "[.][.]/a/b/c/d/e/f/g/", "[.][.]/a/b/C/D", "[.][.]/A/B#foo/", "[.][.]/a/b/c/d/X#bar", null, "[.][.]/a/b/c/d/z[?]x=a"}, {"network", "//www.example.org/a/b/c/d/", "//www.example.org/a/b/c/d/e/f/g/", "//www.example.org/a/b/C/D", "//www.example.org/A/B#foo/", "//www.example.org/a/b/c/d/X#bar", "//example.com/A", "//www.example.org/a/b/c/d/z[?]x=a"}, {"grandparent", null, null, null, null, null, null, null}};
        uris = new String[]{"http://www.example.org/a/b/c/d/", "http://www.example.org/a/b/c/d/e/f/g/", "http://www.example.org/a/b/C/D", "http://www.example.org/A/B#foo/", "http://www.example.org/a/b/c/d/X#bar", "http://example.com/A", "http://www.example.org/a/b/c/d/z?x=a"};
    }

    private static class Change {
        private Change() {
        }

        void code(RDFWriter rDFWriter) {
        }

        void code(Model model) {
        }

        void code(Model model, RDFWriter rDFWriter) {
            this.code(model);
            this.code(rDFWriter);
        }
    }
}

