/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.owl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

public class OWLCache {
    protected static Properties cache = null;
    protected static String localCacheDirectory = null;

    public static void setLocalCacheDirectory(String dir) {
        localCacheDirectory = dir;
        if (dir == null) {
            cache = null;
            System.out.println("INFO: Local cache directory is disabled");
        } else {
            String indexFileName = String.valueOf(localCacheDirectory) + File.separator + "service.idx";
            try {
                File indexFile = new File(indexFileName);
                cache = new Properties();
                cache.load(new FileInputStream(indexFile));
                System.out.println("INFO: Cache has been initialized with " + cache.size() + " entries");
            }
            catch (FileNotFoundException e) {
                System.err.println("ERROR: Cache index file " + indexFileName + " cannot be found");
                localCacheDirectory = null;
            }
            catch (IOException e) {
                System.err.println("ERROR: Cache index file " + indexFileName + " has an invalid format");
                localCacheDirectory = null;
            }
        }
    }

    public static File getCachedFile(String fileURI) {
        File file = null;
        try {
            String localFileName;
            if (cache == null) {
                return null;
            }
            if (fileURI.endsWith("#")) {
                fileURI = fileURI.substring(0, fileURI.length() - 1);
            }
            if ((localFileName = cache.getProperty(fileURI)) != null && !(file = new File(String.valueOf(localCacheDirectory) + File.separator + localFileName)).exists()) {
                file = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return file;
    }
}

