/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.owl;

import aterm.ATermAppl;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.RDF;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.mindswap.pellet.ATermUtils;

public class Util {
    private static Model jena = ModelFactory.createDefaultModel();

    public static List createList(Resource r) {
        if (r.hasProperty(RDF.first)) {
            return Util.createList(r, RDF.first, RDF.rest, RDF.nil);
        }
        if (r.hasProperty(DAML_OIL.first)) {
            return Util.createList(r, DAML_OIL.first, DAML_OIL.rest, DAML_OIL.nil);
        }
        return null;
    }

    public static List createList(Resource r, Property listFirst, Property listRest, Resource listNil) {
        Resource rest;
        if (r.equals((Object)listNil)) {
            return new ArrayList();
        }
        Resource first = r.getProperty(listFirst).getResource();
        if (first == null | (rest = r.getProperty(listRest).getResource()) == null) {
            return null;
        }
        List restList = Util.createList(rest, listFirst, listRest, listNil);
        restList.add(0, first);
        return restList;
    }

    public static String getLocalName(URI uri) {
        return Util.getLocalName(uri.toString());
    }

    public static String getLocalName(String uri) {
        int index = Util.splitPos(uri);
        if (index == -1) {
            return null;
        }
        return uri.substring(index + 1);
    }

    public static String getNameSpace(URI uri) {
        return Util.getNameSpace(uri.toString());
    }

    public static String getNameSpace(String uri) {
        int index = uri.indexOf("#");
        if (index == -1) {
            return null;
        }
        return uri.substring(0, index);
    }

    private static int splitPos(String uri) {
        int pos = uri.indexOf("#");
        if (pos == -1) {
            pos = uri.lastIndexOf("/");
        }
        return pos;
    }

    public static URI toURI(String s) {
        try {
            return new URI(s.replaceAll(" ", "%20"));
        }
        catch (URISyntaxException e) {
            System.out.println("Invalid URI " + e);
            throw new RuntimeException(e);
        }
    }

    public static URI toURI(ATermAppl a) {
        return Util.toURI(a.getName());
    }

    public static URI toURI(Resource r) {
        return Util.toURI(r.getURI());
    }

    public static ATermAppl toATerm(URI uri) {
        return ATermUtils.makeTermAppl((String)uri.toString());
    }

    public static Property toProperty(URI uri) {
        return jena.createProperty(uri.toString());
    }

    public static Resource toResource(URI uri) {
        return jena.createResource(uri.toString());
    }

    public static Resource toResource(String uri) {
        return jena.createResource(uri);
    }
}

