/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.owls.examples;

import java.io.PrintWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.mindswap.owls.OWLSFactory;
import org.mindswap.owls.io.OWLSReader;
import org.mindswap.owls.io.OWLSReaderListener;
import org.mindswap.owls.service.Service;
import org.mindswap.pellet.OutputFormatter;
import org.mindswap.utils.OWLSPresentationWriter;

public class OWLSValidator
implements OWLSReaderListener {
    List serviceURIs = new ArrayList();
    Hashtable errors = new Hashtable();
    Hashtable warnings = new Hashtable();

    public boolean validate(String fileURI) throws Exception {
        return this.validate(fileURI, new PrintWriter(System.out));
    }

    public boolean validate(String fileURI, PrintWriter output) throws Exception {
        return this.validate(fileURI, output, false);
    }

    public boolean validate(String fileURI, PrintWriter output, boolean isHTML) throws Exception {
        return this.validate(fileURI, new OutputFormatter(output, isHTML));
    }

    public boolean validate(String fileURI, OutputFormatter out) throws Exception {
        int j;
        Object service;
        URI uri = new URI(fileURI);
        OWLSReader reader = OWLSFactory.createOWLSReader();
        OWLSPresentationWriter writer = new OWLSPresentationWriter();
        reader.setListener(this);
        List services = reader.readAll(uri);
        out.printBold("Number of services found: ").println(String.valueOf(this.serviceURIs.size()));
        out.printBold("Number of valid services: ").println(String.valueOf(services.size()));
        out.println();
        if (services != null) {
            int i = 0;
            while (i < services.size()) {
                service = (Service)services.get(i);
                out.printBold("Service: ").printLink(service.getURI().toString());
                out.print(" (Version: ").print(service.getOWLSVersion()).print(")").println();
                out.printBold("Name: ").println(service.getLabel());
                out.printBold("Description: ").println(service.getProfile().getTextDescription());
                List warningList = (List)this.warnings.get(service);
                if (warningList != null) {
                    out.printBold("Warnings: ").println();
                    j = 0;
                    while (j < warningList.size()) {
                        String warning = (String)warningList.get(j);
                        if (out.isFormatHTML()) {
                            out.println(this.format(warning));
                        } else {
                            out.println(warning);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        Iterator i = this.errors.keySet().iterator();
        while (i.hasNext()) {
            service = (String)i.next();
            out.printBold("Service: ").printLink((String)service).println();
            out.printBold("Errors: ").println();
            List errorList = (List)this.errors.get(service);
            j = 0;
            while (j < errorList.size()) {
                String error = (String)errorList.get(j);
                if (out.isFormatHTML()) {
                    out.println(this.format(error));
                } else {
                    out.println(error);
                }
                ++j;
            }
        }
        out.flush();
        return services.size() > 0 && this.errors.isEmpty();
    }

    public String format(String str) {
        return str.replaceAll("\n", "<br>").replaceAll(" ", "&nbsp;");
    }

    public String getServiceURI() {
        return (String)this.serviceURIs.get(this.serviceURIs.size() - 1);
    }

    public void put(Hashtable table, String key, String value) {
        ArrayList<String> list = (ArrayList<String>)table.get(key);
        if (list == null) {
            list = new ArrayList<String>();
            table.put(key, list);
        }
        list.add(value);
    }

    public void startService(String serviceURI) {
        this.serviceURIs.add(serviceURI);
    }

    public void finishService(String serviceUri) {
    }

    public void warning(String msg) {
        this.put(this.warnings, this.getServiceURI(), msg);
    }

    public void error(String msg) {
        this.put(this.errors, this.getServiceURI(), msg);
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            if (args.length < 1) {
                System.err.println("Not enough parameters");
            }
            if (args.length > 1) {
                System.err.println("Too many parameters");
            }
            System.err.println("usage: java OWLSValidator <serviceURI>");
            System.exit(0);
        }
        OWLSValidator validator = new OWLSValidator();
        System.out.println("Valid: " + validator.validate(args[0]));
    }
}

