/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.owls.examples;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.StringReader;
import java.net.URLDecoder;
import java.util.Properties;
import org.mindswap.owls.examples.OWLSValidator;
import org.mindswap.owls.examples.OWLSVersionTranslator;

public class RunCGI {
    public static void main(String[] args) {
        try {
            BufferedReader in = new BufferedReader(new StringReader(args[0]));
            String queryString = in.readLine();
            Properties params = RunCGI.parseArgs(queryString);
            if (params.getProperty("validate") != null) {
                RunCGI.printHeader();
                String uri = params.getProperty("uri");
                OWLSValidator validator = new OWLSValidator();
                validator.validate(uri);
                RunCGI.printFooter();
            } else if (params.getProperty("translate") != null) {
                String uri = params.getProperty("uri");
                String version = params.getProperty("version");
                OWLSVersionTranslator translator = new OWLSVersionTranslator();
                translator.translate(uri, version);
            }
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace(System.out);
        }
        System.out.flush();
    }

    public static Properties parseArgs(String queryString) throws Exception {
        Properties props = new Properties();
        String[] params = queryString.split("&");
        int i = 0;
        while (i < params.length) {
            String[] p = params[i].split("=");
            if (p.length == 2) {
                props.setProperty(p[0], URLDecoder.decode(p[1], "ISO-8859-1"));
            }
            ++i;
        }
        return props;
    }

    public static void printHeader() {
        System.out.println("Content-type: text/html\n\n");
        System.out.println("<H1>Results</H1>");
    }

    public static void printFooter() {
    }

    private static void printFile(String fileName) {
        try {
            String base = "/data/users/www/html/mindswap";
            BufferedReader in = new BufferedReader(new FileReader("/data/users/www/html/mindswap" + fileName));
            String line = in.readLine();
            while (line != null) {
                System.out.println(line);
                line = in.readLine();
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        System.out.flush();
    }
}

