/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.owls.grounding.impl;

import com.hp.hpl.jena.rdf.model.Resource;
import com.siemens.upnp.Action;
import com.siemens.upnp.Argument;
import com.siemens.upnp.ArgumentList;
import com.siemens.upnp.InvalidDescriptionException;
import com.siemens.upnp.SOAPException;
import com.siemens.upnp.controlpoint.ControlPoint;
import com.siemens.upnp.controlpoint.ProxyDevice;
import com.siemens.upnp.controlpoint.ProxyService;
import java.net.MalformedURLException;
import java.net.URL;
import org.mindswap.owls.OWLSFactory;
import org.mindswap.owls.grounding.MessageMap;
import org.mindswap.owls.grounding.UPnPAtomicGrounding;
import org.mindswap.owls.grounding.impl.AtomicGroundingImpl;
import org.mindswap.owls.process.Parameter;
import org.mindswap.owls.process.ValueMap;
import org.mindswap.utils.Utils;
import org.mindswap.utils.XSLTEngine;
import org.w3c.dom.Node;

public class UPnPAtomicGroundingImpl
extends AtomicGroundingImpl
implements UPnPAtomicGrounding {
    protected String upnpDescription;
    protected String upnpService;
    protected String upnpAction;

    public UPnPAtomicGroundingImpl(Resource resource) {
        super(resource);
    }

    public void setUPnPService(String service) {
        this.upnpService = service;
    }

    public String getUPnPService() {
        return this.upnpService;
    }

    public void setUPnPAction(String action) {
        this.upnpAction = action;
    }

    public String getUPnPAction() {
        return this.upnpAction;
    }

    public String getDescriptionURL() {
        try {
            ControlPoint cp = ControlPoint.getInstance();
            ProxyDevice device = cp.createDevice(new URL(this.upnpDescription));
            return device.getPresentationURL();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setUPnPDescription(String description) {
        this.upnpDescription = description;
    }

    public String getUPnPDescription() {
        return this.upnpDescription;
    }

    public ValueMap invoke(ValueMap values) throws MalformedURLException, InvalidDescriptionException, SOAPException {
        ControlPoint cp = ControlPoint.getInstance();
        ProxyDevice device = cp.createDevice(new URL(this.upnpDescription));
        ProxyService service = (ProxyService)device.getServiceByID(this.upnpService);
        Action action = service.getActionByName(this.upnpAction);
        ValueMap results = OWLSFactory.createValueMap();
        ArgumentList inArguments = action.getArguments().getInputArguments();
        int i = 0;
        while (i < inArguments.size()) {
            Object value;
            Argument in = inArguments.elementAt(i);
            MessageMap mp = this.getInputMap().getMessageMap(in.getName());
            Parameter param = mp.getOWLSParameter();
            Object inputValue = value = values.getValue(param);
            System.out.println("value = " + value);
            if (mp.getTransformation() != null) {
                value = XSLTEngine.transform(value.toString(), mp.getTransformation());
                Node node = Utils.getAsNode(value.toString());
                inputValue = node.getFirstChild().getNodeValue();
                System.out.println("input value = " + value);
            }
            inArguments.getArgumentByName(mp.getGroundingParameter()).setValue(inputValue.toString());
            ++i;
        }
        service.submitActionRequest(action);
        ArgumentList outArguments = action.getArguments().getOutputArguments();
        int i2 = 0;
        while (i2 < outArguments.size()) {
            Argument out = outArguments.elementAt(i2);
            MessageMap mp = this.getOutputMap().getMessageMap(out.getName());
            if (mp != null) {
                Parameter param = mp.getOWLSParameter();
                String outputValue = null;
                outputValue = mp.getTransformation() == null ? out.getValue() : XSLTEngine.transform(out.getValue().toString(), mp.getTransformation());
                results.setValue(param, outputValue);
            }
            ++i2;
        }
        return results;
    }
}

