/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.owls.io.impl;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mindswap.owl.Util;
import org.mindswap.owls.OWLSFactory;
import org.mindswap.owls.grounding.AtomicGrounding;
import org.mindswap.owls.grounding.Grounding;
import org.mindswap.owls.grounding.MessageMap;
import org.mindswap.owls.grounding.MessageMapList;
import org.mindswap.owls.grounding.UPnPAtomicGrounding;
import org.mindswap.owls.grounding.WSDLAtomicGrounding;
import org.mindswap.owls.io.impl.OWLSReaderImpl;
import org.mindswap.owls.process.AtomicProcess;
import org.mindswap.owls.process.Choice;
import org.mindswap.owls.process.CompositeProcess;
import org.mindswap.owls.process.ControlConstruct;
import org.mindswap.owls.process.DataFlow;
import org.mindswap.owls.process.DataFlowElement;
import org.mindswap.owls.process.Parameter;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.process.ProcessComponent;
import org.mindswap.owls.process.ProcessComponentList;
import org.mindswap.owls.process.ProcessModel;
import org.mindswap.owls.process.Sequence;
import org.mindswap.owls.process.Unordered;
import org.mindswap.owls.process.ValueMap;
import org.mindswap.owls.profile.Profile;
import org.mindswap.owls.service.Service;
import org.mindswap.owls.vocabulary.jena.DAMLS_0_7;
import org.mindswap.owls.vocabulary.jena.FLAServiceOnt;

public class DAMLSReader_0_7
extends OWLSReaderImpl {
    public static boolean DEBUG = false;

    public DAMLSReader_0_7() {
        this.version = "0.7";
    }

    public List readAll(URI fileURI) {
        List list = null;
        try {
            Model model = this.reader.read(fileURI);
            list = this.createService(fileURI, model);
        }
        catch (Exception e) {
            this.error("cannot create service " + fileURI);
            e.printStackTrace();
        }
        return list;
    }

    protected List createService(URI fileURI, Model model) {
        StmtIterator si = model.listStatements(null, RDF.type, (RDFNode)DAMLS_0_7.Service.Service);
        ArrayList<Service> list = new ArrayList<Service>();
        while (si.hasNext()) {
            Resource serviceInfo = si.nextStatement().getSubject();
            try {
                this.startService(serviceInfo.toString());
                Resource profileInfo = serviceInfo.getProperty(DAMLS_0_7.Service.presents).getResource();
                Resource processModelInfo = serviceInfo.getProperty(DAMLS_0_7.Service.describedBy).getResource();
                Resource groundingInfo = serviceInfo.getProperty(DAMLS_0_7.Service.supports).getResource();
                Service service = OWLSFactory.createService(serviceInfo);
                service.setFileURI(fileURI);
                service.setOWLSVersion(this.version);
                this.createProcessModel(service, processModelInfo);
                this.createProfile(service, profileInfo);
                this.createGrounding(service, groundingInfo);
                if (service != null) {
                    list.add(service);
                }
                this.finishService(serviceInfo.toString());
            }
            catch (Exception e) {
                this.error("cannot create service " + serviceInfo);
                e.printStackTrace();
            }
        }
        return list;
    }

    private void createProcessModel(Service service, Resource processModelInfo) {
        Resource processInfo = processModelInfo.getProperty(DAMLS_0_7.Process.hasProcess).getResource();
        ProcessModel processModel = OWLSFactory.createProcessModel(processModelInfo);
        Process process = this.createProcess(service, processInfo);
        processModel.setProcess(process);
        processModel.setService(service);
    }

    private boolean isProcess(Resource processInfo) {
        return processInfo.hasProperty(RDFS.subClassOf, (RDFNode)DAMLS_0_7.Process.AtomicProcess) || processInfo.hasProperty(RDFS.subClassOf, (RDFNode)DAMLS_0_7.Process.CompositeProcess) || processInfo.hasProperty(RDFS.subClassOf, (RDFNode)DAMLS_0_7.Process.SimpleProcess);
    }

    private Process createProcess(Service service, Resource processInfo) {
        if (!this.isProcess(processInfo)) {
            throw new RuntimeException("The process is neither atomic nor a sequence: " + processInfo.getURI());
        }
        Process process = null;
        if (processInfo.hasProperty(RDFS.subClassOf, (RDFNode)DAMLS_0_7.Process.AtomicProcess)) {
            process = this.createAtomicProcess(service, processInfo);
        }
        if (processInfo.hasProperty(RDFS.subClassOf, (RDFNode)DAMLS_0_7.Process.CompositeProcess)) {
            process = this.createCompositeProcess(service, processInfo);
        }
        this.createProcessParams(process, processInfo);
        this.createDefaultValues(process.getDefaultValues(), processInfo);
        this.createDataFlow(process, processInfo);
        process.setService(service);
        return process;
    }

    private AtomicProcess createAtomicProcess(Service service, Resource processInfo) {
        AtomicProcess process = OWLSFactory.createAtomicProcess(processInfo);
        return process;
    }

    private CompositeProcess createCompositeProcess(Service service, Resource processInfo) {
        Resource composedInfo = null;
        StmtIterator s = processInfo.listProperties(RDFS.subClassOf);
        while (s.hasNext()) {
            composedInfo = s.nextStatement().getResource();
            if (!composedInfo.hasProperty(DAML_OIL.onProperty, (RDFNode)DAMLS_0_7.Process.composedOf)) continue;
            composedInfo = composedInfo.getProperty(DAML_OIL.toClass).getResource();
            break;
        }
        ControlConstruct controlConstruct = this.createControlConstruct(service, composedInfo);
        CompositeProcess process = OWLSFactory.createCompositeProcess(processInfo);
        process.setComposedOf(controlConstruct);
        return process;
    }

    private ProcessComponent createProcessComponent(Service service, Resource processComponentInfo) {
        ProcessComponent processComponent = null;
        processComponent = this.isProcess(processComponentInfo) ? this.createProcess(service, processComponentInfo) : this.createControlConstruct(service, processComponentInfo);
        return processComponent;
    }

    private List getControlConstructs(Resource info) {
        ArrayList<Resource> list = new ArrayList<Resource>();
        StmtIterator i = info.listProperties(RDFS.subClassOf);
        while (i.hasNext()) {
            Statement stmt = i.nextStatement();
            list.add(stmt.getResource());
        }
        if (info.hasProperty(DAML_OIL.intersectionOf)) {
            list.addAll(Util.createList(info.getProperty(DAML_OIL.intersectionOf).getResource()));
        }
        return list;
    }

    private ControlConstruct createControlConstruct(Service service, Resource controlConstructInfo) {
        Resource componentsInfo = null;
        List list = this.getControlConstructs(controlConstructInfo);
        Iterator i = list.iterator();
        while (i.hasNext()) {
            Resource r = (Resource)i.next();
            if (!r.hasProperty(RDF.type, (RDFNode)DAML_OIL.Restriction) || !r.hasProperty(DAML_OIL.onProperty, (RDFNode)DAMLS_0_7.Process.components)) continue;
            componentsInfo = r.getProperty(DAML_OIL.toClass).getResource();
            break;
        }
        ControlConstruct cc = null;
        if (list.isEmpty()) {
            return null;
        }
        if (list.contains(DAMLS_0_7.Process.Sequence)) {
            cc = this.createSequence(service, componentsInfo);
        } else if (list.contains(DAMLS_0_7.Process.Choice)) {
            cc = this.createChoice(service, componentsInfo);
        } else if (list.contains(DAMLS_0_7.Process.Unordered)) {
            cc = this.createUnordered(service, componentsInfo);
        } else {
            this.error("Don't know how to read the control construct " + list);
        }
        return cc;
    }

    private Sequence createSequence(Service service, Resource sequenceInfo) {
        Sequence sequence = OWLSFactory.createSequence(sequenceInfo);
        this.createComponents(service, sequence, sequenceInfo);
        return sequence;
    }

    private Unordered createUnordered(Service service, Resource unorderedInfo) {
        Unordered unordered = OWLSFactory.createUnordered(unorderedInfo);
        this.createComponents(service, unordered, unorderedInfo);
        return unordered;
    }

    private Choice createChoice(Service service, Resource choiceInfo) {
        Choice choice = OWLSFactory.createChoice(choiceInfo);
        this.createComponents(service, choice, choiceInfo);
        return choice;
    }

    private void createComponents(Service service, ControlConstruct cc, Resource ccInfo) {
        Resource r = ccInfo.getProperty(DAMLS_0_7.Process.listOfInstancesOf).getResource();
        List list = Util.createList(r);
        int i = 0;
        while (i < list.size()) {
            Resource processComponentInfo = (Resource)list.get(i);
            ProcessComponent processComponent = this.createProcessComponent(service, processComponentInfo);
            if (processComponent == null) {
                this.error("Invalid ProcessComponent description " + processComponentInfo);
            } else {
                cc.getComponents().add(processComponent);
            }
            ++i;
        }
    }

    private void createDefaultValues(ValueMap defaultValues, Resource processComponentInfo) {
    }

    private void createDataFlow(Process process, Resource processComponentInfo) {
        DataFlow dataFlow = process.getDataFlow();
        StmtIterator i = processComponentInfo.listProperties(DAMLS_0_7.Process.sameValues);
        while (i.hasNext()) {
            Resource sameValuesList = i.nextStatement().getResource();
            Resource value1 = sameValuesList.getProperty(RDF.first).getResource();
            Resource value2 = sameValuesList.getProperty(RDF.rest).getResource().getProperty(RDF.first).getResource();
            Statement stmt = value1.getProperty(DAMLS_0_7.Process.theProperty);
            Resource paramName1 = stmt.getObject() instanceof Resource ? stmt.getResource() : Util.toResource(stmt.getObject().toString());
            stmt = value1.getProperty(DAMLS_0_7.Process.atClass);
            Resource processName1 = stmt.getObject() instanceof Resource ? stmt.getResource() : Util.toResource(stmt.getObject().toString());
            stmt = value2.getProperty(DAMLS_0_7.Process.theProperty);
            Resource paramName2 = stmt.getObject() instanceof Resource ? stmt.getResource() : Util.toResource(stmt.getObject().toString());
            stmt = value2.getProperty(DAMLS_0_7.Process.atClass);
            Resource processName2 = stmt.getObject() instanceof Resource ? stmt.getResource() : Util.toResource(stmt.getObject().toString());
            Process p1 = this.findProcess(process, Util.toURI(processName1));
            Process p2 = this.findProcess(process, Util.toURI(processName2));
            Parameter param1 = null;
            Parameter param2 = null;
            if (p1 == null) {
                this.error("Cannot find the process data flow refers to \n      process " + processName1 + "\n    parameter " + paramName1 + "\n data flow in " + process.getURI());
            } else {
                param1 = p1.getParameter(Util.toURI(paramName1));
                if (param1 == null) {
                    this.error("Cannot find the parameter data flow refers to \n      process " + processName1 + "\n    parameter " + paramName1 + "\n data flow in " + process.getURI());
                }
            }
            if (p2 == null) {
                this.error("Cannot find the process data flow refers to \n      process " + processName2 + "\n    parameter " + paramName2 + "\n data flow in " + process.getURI());
            } else {
                param2 = p2.getParameter(Util.toURI(paramName2));
                if (param2 == null) {
                    this.error("Cannot find the parameter data flow refers to \n      process " + processName2 + "\n    parameter " + paramName2 + "\n data flow in " + process.getURI());
                }
            }
            if (param1 == null || param2 == null) continue;
            DataFlowElement dfe = OWLSFactory.createDataFlowElement();
            dfe.add(param1);
            dfe.add(param2);
            dataFlow.add(dfe);
        }
    }

    private void createProcessParams(Process process, Resource processInfo) {
        StmtIterator i = processInfo.getModel().listStatements(null, RDFS.domain, (RDFNode)processInfo);
        while (i.hasNext()) {
            boolean isInvalid;
            Resource p = i.nextStatement().getSubject();
            boolean isInput = p.hasProperty(RDFS.subPropertyOf, (RDFNode)DAMLS_0_7.Process.input);
            boolean isOutput = p.hasProperty(RDFS.subPropertyOf, (RDFNode)DAMLS_0_7.Process.output);
            boolean isEffect = p.hasProperty(RDFS.subPropertyOf, (RDFNode)DAMLS_0_7.Process.effect);
            boolean isPrecondition = p.hasProperty(RDFS.subPropertyOf, (RDFNode)DAMLS_0_7.Process.precondition);
            boolean bl = isInvalid = !isInput && !isOutput && !isEffect && !isPrecondition;
            if (isInvalid) {
                System.err.println("WARNING: found a property of process which is neither an input nor an output\nparam " + p);
                continue;
            }
            Parameter param = null;
            if (isInput) {
                param = OWLSFactory.createInput(p);
                process.getInputs().add(param);
            } else {
                param = OWLSFactory.createOutput(p);
                process.getOutputs().add(param);
            }
            param.setProcess(process);
            param.setType(OWLSFactory.createOWLResource(p.getProperty(RDFS.range).getResource()));
            StmtIterator j = processInfo.listProperties(RDFS.subClassOf);
            while (j.hasNext()) {
                Resource r = j.nextStatement().getResource();
                if (!r.hasProperty(DAML_OIL.onProperty, (RDFNode)p) || !r.hasProperty(DAML_OIL.hasValue)) continue;
                Object value = null;
                RDFNode node = r.getProperty(DAML_OIL.hasValue).getObject();
                value = node instanceof Literal ? ((Literal)node).getValue() : ((Resource)node).getURI();
                process.getDefaultValues().setValue(param, value);
                break;
            }
            if (!DEBUG) continue;
            System.out.println("  Process   " + process.getURI() + "\n" + (isInput ? "  Input     " : "  Output    ") + param.getLabel() + "\n" + "  Type      " + param.getType() + "\n");
        }
    }

    private void createProfile(Service service, Resource profileInfo) {
        Profile profile = OWLSFactory.createProfile(profileInfo);
        Process process = service.getProcess();
        this.createProfileParams(profile, process, true, profileInfo);
        this.createProfileParams(profile, process, false, profileInfo);
        profile.setType(Util.toURI(profileInfo.getProperty(RDF.type).getResource()));
        this.copyPropertyValues(profileInfo, DAMLS_0_7.Profile.serviceName, RDFS.label);
        profile.setService(service);
    }

    private void createProfileParams(Profile profile, Process process, boolean isInput, Resource profileInfo) {
        Property prop = isInput ? DAMLS_0_7.Profile.input : DAMLS_0_7.Profile.output;
        StmtIterator i = profileInfo.getModel().listStatements(profileInfo, prop, null);
        while (i.hasNext()) {
            Parameter refersTo;
            Resource p = (Resource)i.nextStatement().getObject();
            String paramURI = p.getURI();
            String paramType = p.getProperty(DAMLS_0_7.Profile.restrictedTo).getObject().toString();
            String paramLabel = p.getProperty(DAMLS_0_7.Profile.parameterName).getObject().toString();
            URI refersURI = Util.toURI(p.getProperty(DAMLS_0_7.Profile.refersTo).getResource());
            Parameter parameter = refersTo = isInput ? process.getInputs().getParameter(refersURI) : process.getOutputs().getParameter(refersURI);
            if (refersTo == null) {
                this.error("Cannot find the target of refersTo for \n    parameter " + paramURI + "\n   in profile " + profile.getURI() + "\n    referring " + refersURI);
                continue;
            }
            if (!refersTo.getType().getURI().equals(Util.toURI(paramType))) {
                this.error("The parameter type defined in profile and process does not match \n    parameter " + paramURI + "\n         type " + paramType + "\n   in profile " + profile.getURI() + "\n    referring " + refersTo + "\n         type " + refersTo.getType());
                continue;
            }
            this.copyPropertyValues(p, DAMLS_0_7.Profile.parameterName, refersTo.getJenaResource(), RDFS.label);
            if (isInput) {
                profile.getInputs().add(refersTo);
            } else {
                profile.getOutputs().add(refersTo);
            }
            if (!DEBUG) continue;
            System.out.println("  Profile   " + profile.getURI() + "\n" + (isInput ? "  Input     " : "  Output    ") + paramURI + "\n" + "  Label     " + refersTo.getLabel() + "\n" + "  Type      " + paramType + "\n" + "  Refers to " + refersTo + "\n");
        }
    }

    private void createGrounding(Service service, Resource groundingInfo) {
        AtomicGrounding apGrounding;
        Resource apGroundingInfo;
        Grounding grounding = OWLSFactory.createGrounding(groundingInfo);
        StmtIterator i = groundingInfo.listProperties(DAMLS_0_7.Grounding.hasAtomicProcessGrounding);
        while (i.hasNext()) {
            apGroundingInfo = i.nextStatement().getResource();
            apGrounding = this.createAPGrounding(service, apGroundingInfo);
            if (apGrounding != null) {
                grounding.addGrounding(apGrounding);
                continue;
            }
            this.error("Invalid grounding " + apGroundingInfo);
        }
        i = groundingInfo.listProperties(FLAServiceOnt.hasUPnPAtomicProcessGrounding);
        while (i.hasNext()) {
            apGroundingInfo = i.nextStatement().getResource();
            apGrounding = this.createAPGrounding(service, apGroundingInfo);
            if (apGrounding != null) {
                grounding.addGrounding(apGrounding);
                continue;
            }
            this.error("Invalid grounding " + apGroundingInfo);
        }
        grounding.setService(service);
    }

    private AtomicGrounding createAPGrounding(Service service, Resource groundingInfo) {
        if (groundingInfo.hasProperty(RDF.type, (RDFNode)DAMLS_0_7.Grounding.WsdlAtomicProcessGrounding)) {
            return this.createWSDLGrounding(service, groundingInfo);
        }
        if (groundingInfo.hasProperty(RDF.type, (RDFNode)FLAServiceOnt.UPnPAtomicProcessGrounding)) {
            return this.createUPnPGrounding(service, groundingInfo);
        }
        return null;
    }

    private AtomicGrounding createWSDLGrounding(Service service, Resource groundingInfo) {
        URI processURI = Util.toURI(groundingInfo.getProperty(DAMLS_0_7.Grounding.damlsProcess).getResource());
        String wsdlLoc = groundingInfo.getProperty(DAMLS_0_7.Grounding.wsdlDocument).getObject().toString();
        String opName = groundingInfo.getProperty(DAMLS_0_7.Grounding.wsdlOperation).getObject().toString();
        AtomicProcess process = (AtomicProcess)this.findProcess(service.getProcess(), processURI);
        if (process == null) {
            this.error("The process specified in the grounding cannot be found \n    grounding " + groundingInfo + "\n      process " + processURI);
            return null;
        }
        WSDLAtomicGrounding g = OWLSFactory.createWSDLAtomicGrounding(groundingInfo);
        g.setProcess(process);
        g.setWSDL(wsdlLoc);
        g.setOperation(opName);
        if (groundingInfo.hasProperty(DAMLS_0_7.Grounding.wsdlInputMessage)) {
            g.setInputMessage(groundingInfo.getProperty(DAMLS_0_7.Grounding.wsdlInputMessage).getObject().toString());
        }
        if (groundingInfo.hasProperty(DAMLS_0_7.Grounding.wsdlOutputMessage)) {
            g.setOutputMessage(groundingInfo.getProperty(DAMLS_0_7.Grounding.wsdlOutputMessage).getObject().toString());
        }
        this.createMessageMapList(g, groundingInfo, true);
        this.createMessageMapList(g, groundingInfo, false);
        if (DEBUG) {
            System.out.println("  Process   " + process.getURI() + "\n" + "  WSDL file " + wsdlLoc + "\n" + "  Operation " + opName + "\n");
        }
        return g;
    }

    private AtomicGrounding createUPnPGrounding(Service service, Resource groundingInfo) {
        URI processURI = Util.toURI(groundingInfo.getProperty(DAMLS_0_7.Grounding.damlsProcess).getResource());
        String upnpDevice = groundingInfo.getProperty(FLAServiceOnt.upnpDeviceURL).getObject().toString();
        String upnpService = groundingInfo.getProperty(FLAServiceOnt.upnpServiceID).getObject().toString();
        String upnpAction = groundingInfo.getProperty(FLAServiceOnt.upnpCommand).getObject().toString();
        AtomicProcess process = (AtomicProcess)this.findProcess(service.getProcess(), processURI);
        UPnPAtomicGrounding g = OWLSFactory.createUPnPAtomicGrounding(groundingInfo);
        g.setProcess(process);
        g.setUPnPDescription(upnpDevice);
        g.setUPnPService(upnpService);
        g.setUPnPAction(upnpAction);
        this.createMessageMapList(g, groundingInfo, true);
        this.createMessageMapList(g, groundingInfo, false);
        if (DEBUG) {
            System.out.println("  Process " + process.getURI() + "\n" + "  Device  " + upnpDevice + "\n" + "  Service " + upnpService + "\n" + "  Action  " + upnpAction + "\n");
        }
        return g;
    }

    private void createMessageMapList(AtomicGrounding g, Resource groundingInfo, boolean isInput) {
        AtomicProcess process = g.getProcess();
        Property messageParts = null;
        Property messagePart = null;
        if (g instanceof UPnPAtomicGrounding) {
            messageParts = isInput ? FLAServiceOnt.UPnPInputMapping : FLAServiceOnt.UPnPOutputMapping;
            messagePart = FLAServiceOnt.upnpParameter;
        } else if (g instanceof WSDLAtomicGrounding) {
            messageParts = isInput ? DAMLS_0_7.Grounding.wsdlInputMessageParts : DAMLS_0_7.Grounding.wsdlOutputMessageParts;
            messagePart = DAMLS_0_7.Grounding.wsdlMessagePart;
        }
        if (!groundingInfo.hasProperty(messageParts)) {
            return;
        }
        Resource messageMapInfo = (Resource)groundingInfo.getProperty(messageParts).getObject();
        List messageMapList = Util.createList(messageMapInfo);
        MessageMapList mapList = isInput ? g.getInputMap() : g.getOutputMap();
        int i = 0;
        while (i < messageMapList.size()) {
            Resource messageMap = (Resource)messageMapList.get(i);
            MessageMap map = OWLSFactory.createMessageMap(messageMap);
            URI owlsParameterInfo = Util.toURI(messageMap.getProperty(DAMLS_0_7.Grounding.damlsParameter).getResource());
            Parameter owlsParameter = isInput ? process.getInputs().getParameter(owlsParameterInfo) : process.getOutputs().getParameter(owlsParameterInfo);
            map.setOWLSParameter(owlsParameter);
            String wsdlMessagePartInfo = messageMap.getProperty(messagePart).getObject().toString();
            map.setGroundingParameter(wsdlMessagePartInfo);
            String transformation = null;
            if (messageMap.hasProperty(DAMLS_0_7.Grounding.xsltTranformation)) {
                transformation = messageMap.getProperty(DAMLS_0_7.Grounding.xsltTranformation).getString();
                map.setTransformation(transformation);
            }
            if (owlsParameter == null) {
                this.error("Cannot find the target of message map for \n   wsdl parameter " + wsdlMessagePartInfo + "\n       in process " + process.getURI() + "\n        mapped to " + owlsParameterInfo);
            }
            if (DEBUG) {
                System.out.println("  Process   " + process.getURI() + "\n" + "  Param     " + owlsParameterInfo + "\n" + "  Grounding " + wsdlMessagePartInfo + "\n" + "  Transform " + transformation + "\n");
            }
            mapList.add(map);
            ++i;
        }
    }

    private Process findProcess(ProcessComponent process, URI processURI) {
        if (process == null) {
            return null;
        }
        if (process.getURI() != null && process.getURI().equals(processURI)) {
            if (process instanceof Process) {
                return (Process)process;
            }
        } else {
            if (process instanceof CompositeProcess) {
                return this.findProcess(((CompositeProcess)process).getComposedOf(), processURI);
            }
            if (process instanceof ControlConstruct) {
                ProcessComponentList list = ((ControlConstruct)process).getComponents();
                int i = 0;
                while (i < list.size()) {
                    ProcessComponent pc = list.processComponentAt(i);
                    Process p = this.findProcess(pc, processURI);
                    if (p != null) {
                        return p;
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    private void copyPropertyValues(Resource subj, Property srcProp, Property targetProp) {
        this.copyPropertyValues(subj, srcProp, subj, targetProp);
    }

    private void copyPropertyValues(Resource src, Property srcProp, Resource target, Property targetProp) {
        ArrayList<RDFNode> values = new ArrayList<RDFNode>();
        StmtIterator si = src.listProperties(srcProp);
        while (si.hasNext()) {
            values.add(si.nextStatement().getObject());
        }
        Iterator i = values.iterator();
        while (i.hasNext()) {
            target.addProperty(targetProp, (RDFNode)i.next());
        }
    }
}

