/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.owls.io.impl;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.vocabulary.RDF;
import java.net.URI;
import java.util.List;
import org.mindswap.owl.Util;
import org.mindswap.owls.OWLSFactory;
import org.mindswap.owls.io.OWLSReader;
import org.mindswap.owls.io.impl.OWLSReaderImpl;
import org.mindswap.owls.service.Service;

public class GenericOWLSReader
extends OWLSReaderImpl {
    public static boolean DEBUG = false;

    public GenericOWLSReader() {
        this.version = "X.X";
    }

    private OWLSReader findReader(URI fileURI) {
        try {
            Model model = this.reader.read(fileURI, false);
            int i = 0;
            while (i < OWLSFactory.supportedVersions.length) {
                String version = OWLSFactory.supportedVersions[i];
                URI service = OWLSFactory.getVocabulary((String)version).getService().Service;
                if (model.listStatements(null, RDF.type, (RDFNode)Util.toResource(service)).hasNext()) {
                    OWLSReader r = OWLSFactory.createOWLSReader(version);
                    r.setListener(this.listener);
                    return r;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.err.println("Warning: Cannot determine the OWL-S version of service " + fileURI);
        return OWLSFactory.createOWLSReader(OWLSFactory.getLatestVersion());
    }

    public Service read(URI fileURI) {
        OWLSReader reader = this.findReader(fileURI);
        return reader.read(fileURI);
    }

    public List readAll(URI fileURI) {
        OWLSReader reader = this.findReader(fileURI);
        return reader.readAll(fileURI);
    }

    protected List createService(URI fileURI, Model model) {
        throw new RuntimeException("Generic reader should find an appropriate reader");
    }
}

