/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.owls.io.impl;

import com.hp.hpl.jena.rdf.model.Model;
import java.net.URI;
import java.util.List;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLReader;
import org.mindswap.owls.io.OWLSReader;
import org.mindswap.owls.io.OWLSReaderListener;
import org.mindswap.owls.io.OWLSReaderListenerConsole;
import org.mindswap.owls.service.Service;

public abstract class OWLSReaderImpl
implements OWLSReader {
    protected OWLReader reader = OWLFactory.createOWLReader();
    protected String version;
    protected OWLSReaderListener listener = new OWLSReaderListenerConsole();
    protected boolean errorOccurred = false;

    public Service read(URI fileURI) {
        List services = this.readAll(fileURI);
        if (services == null || services.isEmpty()) {
            return null;
        }
        return (Service)services.get(0);
    }

    public List readAll(URI fileURI) {
        List list = null;
        try {
            Model model = this.reader.read(fileURI);
            list = this.createService(fileURI, model);
        }
        catch (Exception e) {
            System.err.println("ERROR: cannot create service " + fileURI);
            e.printStackTrace();
        }
        return list;
    }

    public void setListener(OWLSReaderListener listener) {
        this.listener = listener;
    }

    protected void startService(String serviceURI) {
        this.listener.startService(serviceURI);
        this.errorOccurred = false;
    }

    protected void finishService(String serviceURI) {
        this.listener.finishService(serviceURI);
    }

    protected void warning(String msg) {
        this.listener.warning(msg);
    }

    protected void error(String msg) {
        this.listener.error(msg);
        this.errorOccurred = true;
    }

    protected abstract List createService(URI var1, Model var2);
}

