/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.owls.profile.impl;

import com.hp.hpl.jena.rdf.model.Resource;
import java.net.URI;
import java.util.List;
import org.mindswap.owl.impl.OWLResourceImpl;
import org.mindswap.owls.OWLSFactory;
import org.mindswap.owls.process.ConditionList;
import org.mindswap.owls.process.EffectList;
import org.mindswap.owls.process.InputList;
import org.mindswap.owls.process.OutputList;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.profile.Actor;
import org.mindswap.owls.profile.Profile;
import org.mindswap.owls.profile.ServiceCategory;
import org.mindswap.owls.service.Service;
import org.mindswap.owls.vocabulary.OWLS;

public class ProfileImpl
extends OWLResourceImpl
implements Profile {
    Service service;
    URI type;
    InputList inputs = OWLSFactory.createInputList();
    OutputList outputs = OWLSFactory.createOutputList();
    ConditionList preconditions = OWLSFactory.createConditionList();
    EffectList effects = OWLSFactory.createEffectList();

    public ProfileImpl(Resource resource) {
        super(resource);
    }

    public Service getService() {
        return this.service;
    }

    public void setTextDescription(String desc) {
        this.setProperty(this.getVocabulary().getProfile().textDescription, desc);
    }

    public String getTextDescription() {
        return this.getProperty(this.getVocabulary().getProfile().textDescription);
    }

    public String getTextDescription(String lang) {
        return this.getProperty(this.getVocabulary().getProfile().textDescription, lang);
    }

    public InputList getInputs() {
        return this.inputs;
    }

    public OutputList getOutputs() {
        return this.outputs;
    }

    public ConditionList getPreconditions() {
        return this.preconditions;
    }

    public EffectList getEffects() {
        return this.effects;
    }

    public Process getProcess() {
        return this.service.getProcess();
    }

    public void setService(Service service) {
        this.service = service;
        if (service.getProfile() != this) {
            service.setProfile(this);
        }
    }

    private OWLS getVocabulary() {
        if (this.service != null) {
            return OWLSFactory.getVocabulary(this.service.getOWLSVersion());
        }
        return OWLSFactory.getVocabulary();
    }

    public URI getType() {
        if (this.type == null) {
            this.type = this.getVocabulary().getProfile().Profile;
        }
        return this.type;
    }

    public void setType(URI type) {
        this.type = type;
    }

    public String debugString() {
        String str = String.valueOf(this.getLabel()) + "  " + this.getURI() + " " + this.getType() + "\n";
        int i = 0;
        while (i < this.inputs.size()) {
            str = String.valueOf(str) + this.inputs.inputAt(i).debugString() + "\n";
            ++i;
        }
        i = 0;
        while (i < this.outputs.size()) {
            str = String.valueOf(str) + this.outputs.outputAt(i).debugString() + "\n";
            ++i;
        }
        return str;
    }

    public ServiceCategory getCategory() {
        throw new RuntimeException("Not implemented yet!");
    }

    public List getServiceParameters() {
        throw new RuntimeException("Not implemented yet!");
    }

    public Actor getContactInfo() {
        throw new RuntimeException("Not implemented yet!");
    }
}

