/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.owls.service.impl;

import com.hp.hpl.jena.rdf.model.Resource;
import java.net.URI;
import org.mindswap.owl.impl.OWLResourceImpl;
import org.mindswap.owls.grounding.Grounding;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.process.ProcessModel;
import org.mindswap.owls.profile.Profile;
import org.mindswap.owls.service.Service;

public class ServiceImpl
extends OWLResourceImpl
implements Service {
    protected URI fileURI;
    protected Profile profile;
    protected ProcessModel processModel;
    protected Grounding grounding;
    protected String version = "1.0";

    public ServiceImpl(Resource resource) {
        super(resource);
    }

    public Process getProcess() {
        return this.processModel.getProcess();
    }

    public Profile getProfile() {
        return this.profile;
    }

    public void setProcessModel(ProcessModel processModel) {
        this.processModel = processModel;
        processModel.setService(this);
    }

    public void setProfile(Profile profile) {
        this.profile = profile;
        if (profile.getService() != this) {
            profile.setService(this);
        }
    }

    public ProcessModel getProcessModel() {
        return this.processModel;
    }

    public Grounding getGrounding() {
        return this.grounding;
    }

    public void setGrounding(Grounding grounding) {
        this.grounding = grounding;
        grounding.setService(this);
    }

    public String debugString() {
        String str = "Service " + this.getLabel() + " " + this.getURI() + "\n";
        str = String.valueOf(str) + "Profile " + this.getProfile().debugString() + "\n";
        str = String.valueOf(str) + "Process " + this.getProcess().debugString() + "\n";
        return str;
    }

    public String toString() {
        return this.profile.getLabel();
    }

    public String getOWLSVersion() {
        return this.version;
    }

    public void setOWLSVersion(String version) {
        if (this.version.equals(version)) {
            return;
        }
        this.version = version;
    }

    public URI getFileURI() {
        return this.fileURI;
    }

    public void setFileURI(URI string) {
        this.fileURI = string;
    }

    public String getLabel() {
        return this.profile.getLabel();
    }

    public String getLabel(String lang) {
        return this.profile.getLabel(lang);
    }

    public void setLabel(String label) {
        this.profile.setLabel(label);
    }
}

