/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import org.mindswap.owls.io.OWLSWriter;
import org.mindswap.owls.process.InputList;
import org.mindswap.owls.process.Parameter;
import org.mindswap.owls.process.ParameterList;
import org.mindswap.owls.profile.Profile;
import org.mindswap.owls.service.Service;
import org.mindswap.utils.OutputFormatter;

public class OWLSPresentationWriter
implements OWLSWriter {
    public static boolean DEBUG = false;
    OutputFormatter formatter = null;
    private URI base = null;

    public void write(Service service, OutputStream out) throws IOException {
        this.write(service, new PrintWriter(out));
    }

    public void write(Service service, Writer out) {
        this.write(service, new PrintWriter(out));
    }

    public void write(Service service, PrintWriter out) {
        this.formatter = new OutputFormatter(out, true);
        this.writeService(service);
    }

    private void writeService(Service service) {
        this.formatter.printParagraph().println("Service {");
        this.formatter.printTab().print("presents ").printLink("#profile", "Profile").println();
        this.formatter.printTab().print("describedBy ").printLink("#processModel", "Process Model").println();
        this.formatter.printTab().print("supports ").printLink("#grounding", "Grounding").println();
        this.formatter.println("}");
        this.writeProfile(service.getProfile());
        this.formatter.flush();
    }

    private void writeProfile(Profile profile) {
        this.formatter.printParagraph().println("Profile {");
        this.formatter.printTab().print("type ").printLink(profile.getType().toString()).println();
        this.formatter.printTab().print("label \"").printItalic(profile.toString()).println("\"");
        if (profile.getTextDescription() != null) {
            this.formatter.printTab().print("description \"").printItalic(profile.getTextDescription()).println("\"");
        }
        this.writeProfileParams(profile, profile.getInputs());
        this.writeProfileParams(profile, profile.getOutputs());
        this.formatter.println("}");
    }

    private void writeProfileParams(Profile profile, ParameterList params) {
        if (params instanceof InputList) {
            this.formatter.printParagraph().printTab().print("Inputs {");
        } else {
            this.formatter.printParagraph().printTab().print("Outputs {");
        }
        if (params.size() > 0) {
            this.formatter.println();
        }
        int i = 0;
        while (i < params.size()) {
            Parameter param = params.parameterAt(i);
            this.formatter.printTab().printTab().print(String.valueOf(i + 1) + ") Name: ");
            this.formatter.printLink(param.getURI().toString(), param.toString());
            this.formatter.print(" Type: ");
            this.formatter.printLink(param.getType().getURI().toString(), param.getType().toString());
            this.formatter.println();
            ++i;
        }
        this.formatter.printTab().println(" }");
    }
}

