/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.utils;

import com.hp.hpl.jena.vocabulary.RDF;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.StringReader;
import java.net.URI;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.xml.namespace.QName;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Utils {
    static Hashtable ns = new Hashtable();
    public static final ActionListener windowCloserAction;
    public static final WindowAdapter systemExitAction;

    static {
        ns.put("http://www.w3.org/2001/XMLSchema", "xsd");
        ns.put("http://www.w3.org/1999/02/22-rdf-syntax-ns", "rdf");
        ns.put("http://www.w3.org/2000/01/rdf-schema", "rdfs");
        ns.put("http://schemas.xmlsoap.org/soap/envelope/", "soap-env");
        ns.put("http://schemas.xmlsoap.org/soap/encoding/", "soap_enc");
        ns.put("http://www.daml.org/2001/03/daml+oil", "daml");
        ns.put("http://www.flacp.fujitsulabs.com/~mhgrove/services/contactOnt.daml", "contactOnt");
        ns.put("http://www.flacp.fujitsulabs.com/~mhgrove/services/FLACP-ServiceOnt.daml", "fla");
        windowCloserAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComponent c = (JComponent)e.getSource();
                Window w = (Window)c.getTopLevelAncestor();
                w.dispose();
            }
        };
        systemExitAction = new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        };
    }

    public static URI getURI(String s) throws Exception {
        URI uri = URI.create(s);
        if (uri == null) {
            try {
                File file = new File(s);
                if (file.canRead()) {
                    uri = file.toURI();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (uri == null) {
            throw new FileNotFoundException(String.valueOf(s) + " is not a valid URI!");
        }
        return uri;
    }

    public static String getLocalName(String uri) {
        int index = uri.indexOf("#");
        if (index == -1) {
            index = uri.lastIndexOf("/");
        }
        if (index == -1) {
            return uri;
        }
        return uri.substring(index + 1);
    }

    public static String getNamespace(String uri) {
        int index = uri.indexOf("#");
        if (index == -1) {
            index = uri.lastIndexOf("/");
        }
        if (index == -1) {
            return null;
        }
        return uri.substring(0, index);
    }

    public static String getShortUri(String uri) {
        int index = uri.lastIndexOf("/");
        if (index == -1) {
            return uri;
        }
        return uri.substring(index + 1);
    }

    public static String toURI(QName qname) {
        return String.valueOf(qname.getNamespaceURI()) + "#" + qname.getLocalPart();
    }

    public static String getRDFAbbr(QName uri) {
        return Utils.getRDFAbbr(uri.getNamespaceURI(), uri.getLocalPart());
    }

    public static String getSHOPAbbr(QName uri) {
        return Utils.getSHOPAbbr(uri.getNamespaceURI(), uri.getLocalPart());
    }

    private static String getAbbr(String ns, String localName, String ch) {
        return String.valueOf(Utils.getNamespaceAbbr(ns)) + ch + localName;
    }

    public static String getSHOPAbbr(String ns, String localName) {
        return Utils.getAbbr(ns, localName, "_");
    }

    public static String getSHOPAbbr(String uri) {
        String[] t = Utils.split(uri, "#");
        return Utils.getSHOPAbbr(t[0], t[1]);
    }

    public static String getRDFAbbr(String ns, String localName) {
        return Utils.getAbbr(ns, localName, ":");
    }

    public static String getRDFAbbr(String uri) {
        String[] t = Utils.split(uri, "#");
        return Utils.getRDFAbbr(t[0], t[1]);
    }

    public static String getFullUri(String u) {
        if (u.indexOf(":") == -1) {
            return u;
        }
        String[] t = Utils.split(u, ":");
        String nsUri = (String)Utils.getHashtableKey(ns, t[0]);
        if (nsUri == null) {
            return u;
        }
        return String.valueOf(nsUri) + "#" + t[1];
    }

    public static boolean addNS(String uri, String abbr) {
        String nsValue = (String)ns.get(uri);
        if (nsValue != null || Utils.getHashtableKey(ns, abbr) != null) {
            return false;
        }
        ns.put(uri, abbr);
        return true;
    }

    public static String getNamespaceAbbr(String uri) {
        String nsValue = (String)ns.get(uri);
        if (nsValue == null) {
            nsValue = "ns" + (ns.size() + 1);
            ns.put(uri, nsValue);
        }
        return nsValue;
    }

    public static Hashtable getNamespaces() {
        return ns;
    }

    public static void printNamespaces() {
        Iterator e = ns.entrySet().iterator();
        while (e.hasNext()) {
            Map.Entry entry = e.next();
            String nsURI = (String)entry.getKey();
            String nsValue = (String)entry.getValue();
            System.out.println(String.valueOf(nsValue) + " -> " + nsURI);
        }
    }

    public static Object getHashtableKey(Hashtable h, Object value) {
        Iterator e = h.entrySet().iterator();
        while (e.hasNext()) {
            Map.Entry entry = e.next();
            if (!entry.getValue().equals(value)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static void centerFrame(Window frame) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = frame.getSize();
        screenSize.height /= 2;
        screenSize.width /= 2;
        size.height /= 2;
        size.width /= 2;
        int y = screenSize.height - size.height;
        int x = screenSize.width - size.width;
        frame.setLocation(x, y);
    }

    public static String replace(String str, String s1, String s2) {
        StringBuffer buffer = new StringBuffer();
        int start = 0;
        int index = str.indexOf(s1);
        while (index != -1) {
            buffer.append(str.substring(start, index));
            buffer.append(s2);
            start = index + s1.length();
            index = str.indexOf(s1, start);
        }
        buffer.append(str.substring(start));
        return buffer.toString();
    }

    public static String[] split(String s, String token) {
        Vector<String> result = new Vector<String>();
        int length = token.length();
        int pos = s.indexOf(token);
        int lastPos = 0;
        while (pos >= 0) {
            result.addElement(s.substring(lastPos, pos));
            lastPos = pos + length;
            pos = s.indexOf(token, lastPos);
        }
        if (lastPos < s.length()) {
            result.addElement(s.substring(lastPos));
        }
        Object[] r = new String[result.size()];
        result.copyInto(r);
        return r;
    }

    public static void printTime(String msg) {
        System.out.println("Time: (" + System.currentTimeMillis() + ") " + msg);
    }

    public static String toString(Object[] array) {
        String s = "[Array ";
        if (array != null && array.length > 0) {
            s = String.valueOf(s) + array[0];
            int i = 1;
            while (i < array.length) {
                s = String.valueOf(s) + "," + array[i];
                ++i;
            }
        }
        s = String.valueOf(s) + "]";
        return s;
    }

    public static void showMessage(String str) {
        str = Utils.decodeString(str);
        JFrame info = new JFrame("Result");
        JTextArea t = new JTextArea(str, 15, 40);
        t.setEditable(false);
        t.setLineWrap(true);
        t.setWrapStyleWord(true);
        JButton ok = new JButton("Close");
        ok.addActionListener(windowCloserAction);
        info.getContentPane().setLayout(new BoxLayout(info.getContentPane(), 1));
        info.getContentPane().add(new JScrollPane(t));
        info.getContentPane().add(ok);
        ok.setAlignmentX(0.5f);
        info.pack();
        Utils.centerFrame(info);
        info.show();
    }

    public static Node getAsNode(String in) {
        try {
            DOMParser parser = new DOMParser();
            parser.parse(new InputSource(new StringReader(in)));
            return parser.getDocument().getDocumentElement();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean getBoolean(String str) {
        return str == null ? false : str.toLowerCase().equals("true") || str.equals("1");
    }

    public static String toString(boolean b) {
        return b ? "true" : "false";
    }

    public static String decodeString(String str) {
        String string = new String(str);
        string = Utils.replace(string, "\u00c3\u0192\u00c2\u00a9", "\u00e9");
        string = Utils.replace(string, "\u00c3\u0192\u00c2\u00a0", "\u00e0");
        string = Utils.replace(string, "\u00c3\u0192\u00c2\u00a2", "\u00e2");
        string = Utils.replace(string, "\u00c3\u0192\u00c2\u00ae", "\u00ee");
        string = Utils.replace(string, "\u00c3\u0192\u00c2\u00a8", "\u00e8");
        string = Utils.replace(string, "\u00c3\u00a9", "\u00e9");
        string = Utils.replace(string, "\u00c3\u00a0", "\u00e0");
        string = Utils.replace(string, "\u00c3\u00a2", "\u00e2");
        string = Utils.replace(string, "\u00c3\u00ae", "\u00ee");
        string = Utils.replace(string, "\u00c3\u0161", "\u00e8");
        string = Utils.replace(string, "\u00c3\u00aa", "\u00ea");
        string = Utils.replace(string, "\u00c3\u00a7", "\u00e7");
        string = Utils.replace(string, "\u00c3?", "\u00ca");
        string = Utils.replace(string, "\u00c3\u00aa", "\u00ea");
        return string;
    }

    public static String readFile(String fileName) {
        StringBuffer buffer = new StringBuffer();
        try {
            int ch;
            FileReader isr = new FileReader(fileName);
            BufferedReader in = new BufferedReader(isr);
            while ((ch = in.read()) > -1) {
                buffer.append((char)ch);
            }
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return buffer.toString();
    }

    public static String formatRDF(String rdf) {
        Node node = Utils.getAsNode(rdf);
        if (node == null) {
            return rdf;
        }
        return Utils.formatNode(node, " ");
    }

    public static String formatNode(Node node, String indent) {
        String str = "";
        short type = node.getNodeType();
        if (type == 3) {
            str = node.getNodeValue();
        } else if (type == 1) {
            Node rdfResource;
            NodeList children;
            if (!(node.getParentNode() instanceof Document)) {
                str = "\n" + indent + node.getLocalName() + ": ";
            }
            int len = (children = node.getChildNodes()) != null ? children.getLength() : 0;
            int i = 0;
            while (i < len) {
                str = String.valueOf(str) + Utils.formatNode(children.item(i), String.valueOf(indent) + "  ");
                ++i;
            }
            if (len == 0 && (rdfResource = node.getAttributes().getNamedItemNS(RDF.getURI(), "resource")) instanceof Attr) {
                str = String.valueOf(str) + Utils.getLocalName(((Attr)rdfResource).getValue());
            }
        }
        return str;
    }
}

