/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.wsdl;

import java.io.StringWriter;
import java.net.URI;
import org.mindswap.owl.Util;
import org.mindswap.owls.OWLSFactory;
import org.mindswap.owls.grounding.Grounding;
import org.mindswap.owls.grounding.MessageMap;
import org.mindswap.owls.grounding.WSDLAtomicGrounding;
import org.mindswap.owls.io.OWLSWriter;
import org.mindswap.owls.process.AtomicProcess;
import org.mindswap.owls.process.Input;
import org.mindswap.owls.process.Output;
import org.mindswap.owls.process.ProcessModel;
import org.mindswap.owls.profile.Profile;
import org.mindswap.owls.service.Service;
import org.mindswap.wsdl.WSDLOperation;
import org.mindswap.wsdl.WSDLParameter;

public class WSDLTranslator {
    public String createOWLS(WSDLOperation op, String fileName, String serviceName, String textDescription, String[] inputNames, String[] inputTypes, String[] inputGroundings, String[] outputNames, String[] outputTypes, String[] outputGroundings) {
        try {
            MessageMap map;
            WSDLParameter p;
            String baseURI = "";
            Service service = OWLSFactory.createService(Util.toResource("#Service"));
            Profile profile = OWLSFactory.createProfile(Util.toResource("#Profile"));
            ProcessModel processModel = OWLSFactory.createProcessModel(Util.toResource("#ProcessModel"));
            AtomicProcess process = OWLSFactory.createAtomicProcess(Util.toResource("#Process"));
            Grounding grounding = OWLSFactory.createGrounding(Util.toResource("#Grounding"));
            WSDLAtomicGrounding ag = OWLSFactory.createWSDLAtomicGrounding(Util.toResource("#AtomicProcessGrounding"));
            service.setOWLSVersion("0.9");
            service.setProfile(profile);
            service.setProcessModel(processModel);
            processModel.setProcess(process);
            service.setGrounding(grounding);
            profile.setLabel(serviceName);
            profile.setTextDescription(textDescription);
            ag.setProcess(process);
            ag.setOperation(op.getName());
            ag.setWSDL(op.getService().getFileURI());
            ag.setPortType(op.getPortName());
            ag.setInputMessage(op.getInputMessageName());
            ag.setOutputMessage(op.getOutputMessageName());
            grounding.addGrounding(ag);
            int i = 0;
            while (i < inputNames.length) {
                p = (WSDLParameter)op.getInputs().get(i);
                Input input = OWLSFactory.createInput(Util.toResource("#in" + i));
                input.setLabel(inputNames[i]);
                input.setType(OWLSFactory.createOWLResource(new URI(inputTypes[i])));
                process.getInputs().add(input);
                profile.getInputs().add(input);
                map = OWLSFactory.createMessageMap();
                map.setGroundingParameter(p.getName());
                map.setOWLSParameter(input);
                if (inputGroundings[i] != null && !inputGroundings[i].trim().equals("")) {
                    map.setTransformation(inputGroundings[i]);
                }
                ag.getInputMap().add(map);
                ++i;
            }
            i = 0;
            while (i < outputNames.length) {
                p = (WSDLParameter)op.getOutputs().get(i);
                Output output = OWLSFactory.createOutput(Util.toResource("#out" + i));
                output.setLabel(outputNames[i]);
                output.setType(OWLSFactory.createOWLResource(new URI(outputTypes[i])));
                process.getInputs().add(output);
                profile.getInputs().add(output);
                map = OWLSFactory.createMessageMap();
                map.setGroundingParameter(p.getName());
                map.setOWLSParameter(output);
                if (outputGroundings[i] != null && !outputGroundings[i].trim().equals("")) {
                    map.setTransformation(outputGroundings[i]);
                }
                ag.getInputMap().add(map);
                ++i;
            }
            OWLSWriter writer = OWLSFactory.createOWLSWriter();
            StringWriter sw = new StringWriter(1024);
            writer.write(service, sw);
            return sw.toString();
        }
        catch (Exception x) {
            System.out.println(x);
            x.printStackTrace();
            return null;
        }
    }
}

