/*
 * Decompiled with CFR 0.152.
 */
package com.techtrader.modules.tools.bytecode;

import com.techtrader.modules.tools.bytecode.BCClass;
import com.techtrader.modules.tools.bytecode.BCField;
import com.techtrader.modules.tools.bytecode.BCHelper;
import com.techtrader.modules.tools.bytecode.BCMethod;
import com.techtrader.modules.tools.bytecode.Code;
import com.techtrader.modules.tools.bytecode.Instruction;
import com.techtrader.modules.tools.bytecode.JumpInstruction;
import com.techtrader.modules.tools.bytecode.LoadInstruction;
import com.techtrader.modules.tools.bytecode.ReturnInstruction;
import com.techtrader.modules.tools.bytecode.StoreInstruction;

public class ClassConstantInstruction {
    private Instruction _ins = null;
    private Code _code = null;
    private BCClass _class = null;
    private boolean _invalid = false;
    private static /* synthetic */ Class class$Ljava$lang$Class;
    private static /* synthetic */ Class class$Ljava$lang$String;
    private static /* synthetic */ Class class$Ljava$lang$NoClassDefFoundError;
    private static /* synthetic */ Class class$Ljava$lang$Throwable;
    private static /* synthetic */ Class class$Ljava$lang$ClassNotFoundException;

    public Instruction setClassType(Class clazz) {
        this.setClassName(clazz.getName());
        return this._ins;
    }

    public Instruction setClassName(String string) {
        this.setClassName(string, BCHelper.getWrapperClass(string));
        return this._ins;
    }

    private void setClassName(String string, Class clazz) {
        if (this._invalid) {
            throw new IllegalStateException();
        }
        Instruction instruction = this._code.hasNext() ? this._code.next() : null;
        this._code.before(this._ins);
        this._code.next();
        if (clazz != null) {
            this._code.getstatic().setField("TYPE", class$Ljava$lang$Class != null ? class$Ljava$lang$Class : (class$Ljava$lang$Class = ClassConstantInstruction.class$("java.lang.Class")), clazz);
        } else {
            this.setObject(string);
        }
        if (instruction != null) {
            this._code.before(instruction);
        } else {
            this._code.afterLast();
        }
        this._invalid = true;
    }

    private void setObject(String string) {
        BCField bCField = this.addClassField(string);
        BCMethod bCMethod = this.addClassLoadMethod();
        this._code.getstatic().setField(bCField);
        JumpInstruction jumpInstruction = this._code.if_null();
        this._code.getstatic().setField(bCField);
        JumpInstruction jumpInstruction2 = this._code.go2();
        jumpInstruction.setTarget(this._code.constant().setStringConstant(string));
        this._code.invokestatic().setMethod(bCMethod);
        this._code.dup();
        this._code.putstatic().setField(bCField);
        jumpInstruction2.setTarget(this._code.nop());
    }

    private BCField addClassField(String string) {
        String string2 = "class$L" + string.replace('.', '$').replace('[', '$').replace(';', '$');
        BCField bCField = this._class.getField(string2);
        if (bCField == null) {
            bCField = this._class.addField(string2, class$Ljava$lang$Class != null ? class$Ljava$lang$Class : (class$Ljava$lang$Class = ClassConstantInstruction.class$("java.lang.Class")));
            bCField.makePackage();
            bCField.setStatic(true);
            bCField.addAttribute("Synthetic");
        }
        return bCField;
    }

    private BCMethod addClassLoadMethod() {
        BCMethod bCMethod = this._class.getMethod("class$");
        if (bCMethod != null) {
            return bCMethod;
        }
        bCMethod = this._class.addMethod("class$", class$Ljava$lang$Class != null ? class$Ljava$lang$Class : (class$Ljava$lang$Class = ClassConstantInstruction.class$("java.lang.Class")), new Class[]{class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = ClassConstantInstruction.class$("java.lang.String"))});
        bCMethod.setStatic(true);
        bCMethod.makePackage();
        bCMethod.addAttribute("Synthetic");
        Code code = bCMethod.addCode();
        code.setMaxStack(3);
        code.setMaxLocals(2);
        LoadInstruction loadInstruction = code.aload_0();
        code.invokestatic().setMethod("forName", class$Ljava$lang$Class != null ? class$Ljava$lang$Class : (class$Ljava$lang$Class = ClassConstantInstruction.class$("java.lang.Class")), new Class[]{class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = ClassConstantInstruction.class$("java.lang.String"))}, class$Ljava$lang$Class != null ? class$Ljava$lang$Class : (class$Ljava$lang$Class = ClassConstantInstruction.class$("java.lang.Class")));
        ReturnInstruction returnInstruction = code.areturn();
        StoreInstruction storeInstruction = code.astore_1();
        code.newins().setClassType(class$Ljava$lang$NoClassDefFoundError != null ? class$Ljava$lang$NoClassDefFoundError : (class$Ljava$lang$NoClassDefFoundError = ClassConstantInstruction.class$("java.lang.NoClassDefFoundError")));
        code.dup();
        code.aload_1();
        code.invokevirtual().setMethod("getMessage", class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = ClassConstantInstruction.class$("java.lang.String")), null, class$Ljava$lang$Throwable != null ? class$Ljava$lang$Throwable : (class$Ljava$lang$Throwable = ClassConstantInstruction.class$("java.lang.Throwable")));
        code.invokespecial().setMethod("<init>", Void.TYPE, new Class[]{class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = ClassConstantInstruction.class$("java.lang.String"))}, class$Ljava$lang$NoClassDefFoundError != null ? class$Ljava$lang$NoClassDefFoundError : (class$Ljava$lang$NoClassDefFoundError = ClassConstantInstruction.class$("java.lang.NoClassDefFoundError")));
        code.athrow();
        code.addExceptionHandler((Instruction)loadInstruction, (Instruction)returnInstruction, (Instruction)storeInstruction, class$Ljava$lang$ClassNotFoundException != null ? class$Ljava$lang$ClassNotFoundException : (class$Ljava$lang$ClassNotFoundException = ClassConstantInstruction.class$("java.lang.ClassNotFoundException")));
        return bCMethod;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected ClassConstantInstruction(BCClass bCClass, Code code, Instruction instruction) {
        this._class = bCClass;
        this._code = code;
        this._ins = instruction;
    }
}

