/*
 * Decompiled with CFR 0.152.
 */
package com.techtrader.modules.tools.bytecode;

import com.techtrader.modules.tools.bytecode.Code;
import com.techtrader.modules.tools.bytecode.Instruction;
import com.techtrader.modules.tools.bytecode.visitor.BCVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ConstantInstruction
extends Instruction {
    private Object _value = null;
    private int _arg = -1;
    private static /* synthetic */ Class class$Ljava$lang$Object;
    private static /* synthetic */ Class class$Ljava$lang$Float;
    private static /* synthetic */ Class class$Ljava$lang$Double;
    private static /* synthetic */ Class class$Ljava$lang$Long;
    private static /* synthetic */ Class class$Ljava$lang$String;

    public ConstantInstruction setConstant(Object object) {
        this._value = object;
        this.calculateOpCode();
        return this;
    }

    public Object getConstant() {
        return this._value;
    }

    public Class getConstantType() {
        if (this._value == null) {
            return class$Ljava$lang$Object != null ? class$Ljava$lang$Object : (class$Ljava$lang$Object = ConstantInstruction.class$("java.lang.Object"));
        }
        Class<?> clazz = this._value.getClass();
        if (clazz.equals(class$Ljava$lang$Float != null ? class$Ljava$lang$Float : (class$Ljava$lang$Float = ConstantInstruction.class$("java.lang.Float")))) {
            return Float.TYPE;
        }
        if (clazz.equals(class$Ljava$lang$Double != null ? class$Ljava$lang$Double : (class$Ljava$lang$Double = ConstantInstruction.class$("java.lang.Double")))) {
            return Double.TYPE;
        }
        if (clazz.equals(class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = ConstantInstruction.class$("java.lang.Long")))) {
            return Long.TYPE;
        }
        if (clazz.equals(class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = ConstantInstruction.class$("java.lang.String")))) {
            return class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = ConstantInstruction.class$("java.lang.String"));
        }
        return Integer.TYPE;
    }

    public String getConstantTypeName() {
        return this.getConstantType().getName();
    }

    public ConstantInstruction setStringConstant(String string) {
        return this.setConstant(string);
    }

    public String getStringConstant() {
        return (String)this.getConstant();
    }

    public ConstantInstruction setIntConstant(int n) {
        return this.setConstant(new Integer(n));
    }

    public int getIntConstant() {
        return this._value == null ? 0 : ((Number)this._value).intValue();
    }

    public ConstantInstruction setFloatConstant(float f) {
        return this.setConstant(new Float(f));
    }

    public float getFloatConstant() {
        return this._value == null ? 0.0f : ((Number)this._value).floatValue();
    }

    public ConstantInstruction setLongConstant(long l) {
        return this.setConstant(new Long(l));
    }

    public long getLongConstant() {
        return this._value == null ? 0L : ((Number)this._value).longValue();
    }

    public ConstantInstruction setDoubleConstant(double d) {
        return this.setConstant(new Double(d));
    }

    public double getDoubleConstant() {
        return this._value == null ? 0.0 : ((Number)this._value).doubleValue();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ConstantInstruction)) {
            return false;
        }
        ConstantInstruction constantInstruction = (ConstantInstruction)object;
        Object object2 = this.getConstant();
        Object object3 = constantInstruction.getConstant();
        return object2 == null && !(class$Ljava$lang$Object != null ? class$Ljava$lang$Object : (class$Ljava$lang$Object = ConstantInstruction.class$("java.lang.Object"))).equals(this.getConstantType()) || object3 == null && !(class$Ljava$lang$Object != null ? class$Ljava$lang$Object : (class$Ljava$lang$Object = ConstantInstruction.class$("java.lang.Object"))).equals(constantInstruction.getConstantType()) || object2 == null && object3 == null || object2 != null && object2.equals(object3);
    }

    public int getLength() {
        switch (this._opcode) {
            case 16: 
            case 18: {
                return super.getLength() + 1;
            }
            case 17: 
            case 19: 
            case 20: {
                return super.getLength() + 2;
            }
        }
        return super.getLength();
    }

    public int getStackChange() {
        if (this._value instanceof Long || this._value instanceof Double) {
            return 2;
        }
        return 1;
    }

    protected void copy(Instruction instruction) {
        super.copy(instruction);
        this.setConstant(((ConstantInstruction)instruction).getConstant());
    }

    protected void readData(DataInput dataInput) throws IOException {
        switch (this._opcode) {
            case 16: {
                this._value = new Integer(dataInput.readUnsignedByte());
                break;
            }
            case 17: {
                this._value = new Integer(dataInput.readUnsignedShort());
                break;
            }
            case 18: {
                this._arg = dataInput.readUnsignedByte();
                this._value = this._owner.getPool().getConstant(this._arg);
                break;
            }
            case 19: 
            case 20: {
                this._arg = dataInput.readUnsignedShort();
                this._value = this._owner.getPool().getConstant(this._arg);
                break;
            }
        }
    }

    protected void writeData(DataOutput dataOutput) throws IOException {
        switch (this._opcode) {
            case 16: {
                dataOutput.writeByte(this.getIntConstant());
                break;
            }
            case 17: {
                dataOutput.writeShort(this.getIntConstant());
                break;
            }
            case 18: {
                dataOutput.writeByte(this._arg);
                break;
            }
            case 19: 
            case 20: {
                dataOutput.writeShort(this._arg);
                break;
            }
        }
    }

    private void calculateOpCode() {
        Class clazz = this.getConstantType();
        double d = 0.0;
        if (this._value instanceof Number) {
            d = this.getDoubleConstant();
        } else if (this._value instanceof Boolean) {
            d = (Boolean)this._value != false ? 1 : 0;
        }
        this._arg = -1;
        if (clazz.equals(class$Ljava$lang$Object != null ? class$Ljava$lang$Object : (class$Ljava$lang$Object = ConstantInstruction.class$("java.lang.Object")))) {
            this._opcode = 1;
        } else if (clazz.equals(Float.TYPE) && (d == 0.0 || d == 1.0 || d == 2.0)) {
            this._opcode = 11 + (int)d;
        } else if (clazz.equals(Long.TYPE) && d > -1.0 && d < 2.0) {
            this._opcode = 9 + (int)d;
        } else if (clazz.equals(Double.TYPE) && (d == 0.0 || d == 1.0 || d == 2.0)) {
            this._opcode = 14 + (int)d;
        } else if (clazz.equals(Integer.TYPE) && d >= -65536.0 && d < 65536.0) {
            this._opcode = d >= -1.0 && d <= 5.0 ? 3 + (int)d : (d >= -256.0 && d < 256.0 ? 16 : 17);
        } else {
            this._arg = this._owner.getPool().setConstant(0, this._value);
            this._opcode = clazz.equals(Long.TYPE) || clazz.equals(Double.TYPE) ? 20 : (this._arg > 255 ? 19 : 18);
        }
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterConstantInstruction(this);
        bCVisitor.exitConstantInstruction(this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected ConstantInstruction(Code code) {
        super(code);
    }

    protected ConstantInstruction(Code code, int n, Object object) {
        super(code);
        this._opcode = n;
        this._value = object;
    }
}

