/*
 * Decompiled with CFR 0.152.
 */
package com.techtrader.modules.tools.bytecode;

import com.techtrader.modules.tools.bytecode.BCClass;
import com.techtrader.modules.tools.bytecode.BCHelper;
import com.techtrader.modules.tools.bytecode.BCMethod;
import com.techtrader.modules.tools.bytecode.Code;
import com.techtrader.modules.tools.bytecode.Instruction;
import com.techtrader.modules.tools.bytecode.visitor.BCVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class MethodInstruction
extends Instruction {
    private int _index = 0;
    private static /* synthetic */ Class class$Lcom$techtrader$modules$tools$bytecode$lowlevel$InterfaceMethodEntry;
    private static /* synthetic */ Class class$Lcom$techtrader$modules$tools$bytecode$lowlevel$MethodEntry;

    public int getMethodIndex() {
        return this._index;
    }

    public void setMethodIndex(int n) {
        this._index = n;
    }

    public MethodInstruction setMethod(BCMethod bCMethod) {
        BCClass bCClass = bCMethod.getOwner();
        return this.setMethod(bCMethod.getName(), bCMethod.getReturnTypeName(), bCMethod.getParamTypeNames(), bCClass.getName());
    }

    public MethodInstruction setMethod(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        String[] stringArray = new String[classArray.length];
        int n = 0;
        while (n < classArray.length) {
            stringArray[n] = classArray[n].getName();
            ++n;
        }
        return this.setMethod(method.getName(), method.getReturnType().getName(), stringArray, method.getDeclaringClass().getName());
    }

    public MethodInstruction setMethod(Constructor constructor) {
        Class<?>[] classArray = constructor.getParameterTypes();
        String[] stringArray = new String[classArray.length];
        int n = 0;
        while (n < classArray.length) {
            stringArray[n] = classArray[n].getName();
            ++n;
        }
        return this.setMethod("<init>", "void", stringArray, constructor.getDeclaringClass().getName());
    }

    public MethodInstruction setMethod(String string, String string2, String[] stringArray, String string3) {
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        while (n < stringArray2.length) {
            stringArray2[n] = BCHelper.getInternalForm(stringArray[n], true);
            ++n;
        }
        String string4 = BCHelper.getInternalForm(string3, false);
        String string5 = BCHelper.getDescriptor(BCHelper.getInternalForm(string2, true), stringArray2);
        Class clazz = this._opcode == 185 ? (class$Lcom$techtrader$modules$tools$bytecode$lowlevel$InterfaceMethodEntry != null ? class$Lcom$techtrader$modules$tools$bytecode$lowlevel$InterfaceMethodEntry : (class$Lcom$techtrader$modules$tools$bytecode$lowlevel$InterfaceMethodEntry = MethodInstruction.class$("com.techtrader.modules.tools.bytecode.lowlevel.InterfaceMethodEntry"))) : (class$Lcom$techtrader$modules$tools$bytecode$lowlevel$MethodEntry != null ? class$Lcom$techtrader$modules$tools$bytecode$lowlevel$MethodEntry : (class$Lcom$techtrader$modules$tools$bytecode$lowlevel$MethodEntry = MethodInstruction.class$("com.techtrader.modules.tools.bytecode.lowlevel.MethodEntry")));
        this._index = this._owner.getPool().setComplex(0, string, string5, string4, clazz);
        return this;
    }

    public MethodInstruction setMethod(String string, Class clazz, Class[] classArray, String string2) {
        String[] stringArray = null;
        if (classArray != null) {
            stringArray = new String[classArray.length];
            int n = 0;
            while (n < classArray.length) {
                stringArray[n] = classArray[n].getName();
                ++n;
            }
        }
        String string3 = clazz == null ? null : clazz.getName();
        return this.setMethod(string, string3, stringArray, string2);
    }

    public MethodInstruction setMethod(String string, Class clazz, Class[] classArray, Class clazz2) {
        String[] stringArray = null;
        if (classArray != null) {
            stringArray = new String[classArray.length];
            int n = 0;
            while (n < classArray.length) {
                stringArray[n] = classArray[n].getName();
                ++n;
            }
        }
        String string2 = clazz == null ? null : clazz.getName();
        String string3 = clazz2 == null ? null : clazz2.getName();
        return this.setMethod(string, string2, stringArray, string3);
    }

    public MethodInstruction setMethodName(String string) {
        return this.setMethod(string, this.getMethodReturnTypeName(), this.getMethodParamTypeNames(), this.getMethodOwnerTypeName());
    }

    public MethodInstruction setMethodOwnerTypeName(String string) {
        return this.setMethod(this.getMethodName(), this.getMethodReturnTypeName(), this.getMethodParamTypeNames(), string);
    }

    public MethodInstruction setMethodReturnTypeName(String string) {
        return this.setMethod(this.getMethodName(), string, this.getMethodParamTypeNames(), this.getMethodOwnerTypeName());
    }

    public MethodInstruction setMethodParamTypeNames(String[] stringArray) {
        return this.setMethod(this.getMethodName(), this.getMethodReturnTypeName(), stringArray, this.getMethodOwnerTypeName());
    }

    public boolean isMethodInCurrentClass() {
        BCClass bCClass = ((BCMethod)this._owner.getOwner()).getOwner();
        return bCClass.getName().equals(this.getMethodOwnerTypeName());
    }

    public BCMethod getMethod() {
        if (!this.isMethodInCurrentClass()) {
            return null;
        }
        return ((BCMethod)this._owner.getOwner()).getOwner().getMethod(this.getMethodName(), this.getMethodParamTypeNames());
    }

    public String getMethodName() {
        return this._owner.getPool().getComplexName(this._index);
    }

    public String getMethodReturnTypeName() {
        return BCHelper.getExternalForm(BCHelper.getReturnType(this._owner.getPool().getComplexTypeName(this._index)), true);
    }

    public Class getMethodReturnType() throws ClassNotFoundException {
        return BCHelper.classForName(BCHelper.getReturnType(this._owner.getPool().getComplexTypeName(this._index)));
    }

    public String[] getMethodParamTypeNames() {
        String[] stringArray = BCHelper.getParamTypes(this._owner.getPool().getComplexTypeName(this._index));
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[n] = BCHelper.getExternalForm(stringArray[n], true);
            ++n;
        }
        return stringArray2;
    }

    public Class[] getMethodParamTypes() throws ClassNotFoundException {
        String[] stringArray = BCHelper.getParamTypes(this._owner.getPool().getComplexTypeName(this._index));
        Class[] classArray = new Class[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            classArray[n] = BCHelper.classForName(stringArray[n]);
            ++n;
        }
        return classArray;
    }

    public String getMethodOwnerTypeName() {
        return BCHelper.getExternalForm(this._owner.getPool().getComplexOwnerTypeName(this._index), true);
    }

    public Class getMethodOwnerType() throws ClassNotFoundException {
        return BCHelper.classForName(this._owner.getPool().getComplexOwnerTypeName(this._index));
    }

    public boolean equals(Object object) {
        String[] stringArray;
        if (object == this) {
            return true;
        }
        if (!(object instanceof MethodInstruction)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        MethodInstruction methodInstruction = (MethodInstruction)object;
        String string = this.getMethodName();
        String string2 = methodInstruction.getMethodName();
        if (string.length() != 0 && string2.length() != 0 && !string.equals(string2)) {
            return false;
        }
        string = this.getMethodReturnTypeName();
        string2 = methodInstruction.getMethodReturnTypeName();
        if (string.length() != 0 && string2.length() != 0 && !string.equals(string2)) {
            return false;
        }
        string = this.getMethodOwnerTypeName();
        string2 = methodInstruction.getMethodOwnerTypeName();
        if (string.length() != 0 && string2.length() != 0 && !string.equals(string2)) {
            return false;
        }
        String[] stringArray2 = this.getMethodParamTypeNames();
        if (stringArray2.length != (stringArray = methodInstruction.getMethodParamTypeNames()).length) {
            return false;
        }
        int n = 0;
        while (n < stringArray2.length) {
            if (!stringArray2[n].equals(stringArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int getLength() {
        if (this._opcode == 185) {
            return super.getLength() + 4;
        }
        return super.getLength() + 2;
    }

    public int getStackChange() {
        int n = 0;
        if (this._opcode != 184) {
            --n;
        }
        String[] stringArray = this.getMethodParamTypeNames();
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].equals("long") || stringArray[n2].equals("double")) {
                --n;
            }
            ++n2;
            --n;
        }
        String string = this.getMethodReturnTypeName();
        if (!string.equals("void")) {
            ++n;
        }
        if (string.equals("long") || string.equals("double")) {
            ++n;
        }
        return n;
    }

    protected void copy(Instruction instruction) {
        super.copy(instruction);
        MethodInstruction methodInstruction = (MethodInstruction)instruction;
        this.setMethod(methodInstruction.getMethodName(), methodInstruction.getMethodReturnTypeName(), methodInstruction.getMethodParamTypeNames(), methodInstruction.getMethodOwnerTypeName());
    }

    protected void readData(DataInput dataInput) throws IOException {
        this._index = dataInput.readUnsignedShort();
        if (this._opcode == 185) {
            dataInput.readByte();
            dataInput.readByte();
        }
    }

    protected void writeData(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this._index);
        if (this._opcode == 185) {
            String[] stringArray = this.getMethodParamTypeNames();
            int n = 1;
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2].equals("long") || stringArray[n2].equals("double")) {
                    ++n;
                }
                ++n2;
                ++n;
            }
            dataOutput.writeByte(n);
            dataOutput.writeByte(0);
        }
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterMethodInstruction(this);
        bCVisitor.exitMethodInstruction(this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected MethodInstruction(Code code, int n) {
        super(code);
        this._opcode = n;
    }
}

