/*
 * Decompiled with CFR 0.152.
 */
package ix.applet;

import ix.applet.AppletMessage;
import ix.applet.MessageServer;
import ix.util.Debug;
import ix.util.IPC;
import ix.util.Parameters;
import ix.util.Strings;
import ix.util.ipc.ServiceAddress;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.LinkedList;

public class CGIRelay {
    ServiceAddress serverAddr = new ServiceAddress(Parameters.getParameter("server-address"));
    MessageServer.Strategy strategy = new MessageServer.Strategy(this.serverAddr);

    public static void main(String[] stringArray) {
        Debug.off();
        Parameters.processCommandLineArguments(stringArray);
        try {
            new CGIRelay().handleRequest();
        }
        catch (Throwable throwable) {
            Debug.noteException(throwable);
            System.exit(1);
        }
        System.exit(0);
    }

    void handleRequest() throws Exception {
        String string;
        String string2 = this.getInput();
        AppletMessage appletMessage = new AppletMessage();
        appletMessage.setCommand(string2);
        appletMessage.setRemoteHost(System.getProperty("cgi.remote_host"));
        appletMessage.setRemoteAddr(System.getProperty("cgi.remote_addr"));
        try {
            string = this.askMessageServer(appletMessage);
        }
        catch (Exception exception) {
            string = "Exception: " + Debug.describeException(exception);
        }
        try {
            this.printReply(string);
            this.sendStatusToMessageServer("ok");
        }
        catch (Exception exception) {
            this.sendStatusToMessageServer("Exception: " + Debug.describeException(exception));
            throw exception;
        }
    }

    String getInput() throws IOException, UnsupportedEncodingException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in, "utf-8"));
        LinkedList<String> linkedList = new LinkedList<String>();
        while ((string = bufferedReader.readLine()) != null) {
            linkedList.add(string);
        }
        return Strings.joinLines(linkedList);
    }

    String askMessageServer(AppletMessage appletMessage) {
        return (String)this.strategy.sendRequest("message-server", appletMessage);
    }

    void printReply(String string) throws IOException, UnsupportedEncodingException {
        System.out.println("");
        if (System.out.checkError()) {
            throw new IPC.IPCException("Error before printing reply.");
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)System.out, "utf-8");
        outputStreamWriter.write(string);
        ((Writer)outputStreamWriter).flush();
        if (System.out.checkError()) {
            throw new IPC.IPCException("Error after printing reply.");
        }
        ((Writer)outputStreamWriter).close();
    }

    void sendStatusToMessageServer(String string) {
        this.strategy.sendObject("message-server", string);
    }
}

