/*
 * Decompiled with CFR 0.152.
 */
package ix.http;

import ix.http.HttpCommunicationStrategy;
import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.Parameters;
import ix.util.TextAreaFrame;
import ix.util.Util;
import ix.util.ipc.ServiceAddress;
import ix.util.lisp.Lisp;
import ix.util.lisp.LispPrinter;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public class HttpNameServer {
    public static String DEFAULT_ADDRESS = "localhost:5555";
    private Map<String, ServiceAddress> nameToAddrMap = new Hashtable<String, ServiceAddress>();
    private Syntax syntax = new Syntax();
    private LispPrinter lispPrinter = new LispPrinter();
    private TextAreaFrame transcriptFrame;

    public HttpNameServer() {
        this.lispPrinter.setPrintUnprintablesUsingToString(true);
    }

    public static void main(String[] stringArray) {
        Parameters.processCommandLineArguments(stringArray);
        new HttpNameServer().start();
    }

    private void start() {
        ServiceAddress serviceAddress = new ServiceAddress(Parameters.getParameter("name-server", DEFAULT_ADDRESS));
        NSCommStrategy nSCommStrategy = new NSCommStrategy(serviceAddress.getPort());
        nSCommStrategy.setupServer("name-server", null);
        this.transcriptFrame = new TranscriptFrame(serviceAddress);
    }

    private Object handleRequest(Object object) {
        Debug.noteln("NS request:", object);
        if (this.syntax.isLookupMessage(object)) {
            List list = (List)object;
            String string = (String)list.get(1);
            ServiceAddress serviceAddress = this.nameToAddrMap.get(string);
            if (serviceAddress == null) {
                return "unknown";
            }
            return serviceAddress;
        }
        if (this.syntax.isRegisterMessage(object)) {
            List list = (List)object;
            String string = (String)list.get(1);
            ServiceAddress serviceAddress = (ServiceAddress)list.get(2);
            this.nameToAddrMap.put(string, serviceAddress);
            this.transcript(object);
            return "OK";
        }
        throw new IllegalArgumentException("Invalid name-server request: " + object);
    }

    private void transcript(Object object) {
        this.transcript(this.lispPrinter.elementsToString(object));
    }

    private void transcript(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                HttpNameServer.this.transcriptFrame.appendLine(string);
                if (!HttpNameServer.this.transcriptFrame.getFrame().isShowing()) {
                    HttpNameServer.this.transcriptFrame.setVisible(true);
                }
            }
        });
    }

    public static class Syntax {
        public static Object makeRegisterMessage(String string, ServiceAddress serviceAddress) {
            return Lisp.list("register", string, serviceAddress);
        }

        public static Object makeLookupMessage(String string) {
            return Lisp.list("lookup", string);
        }

        public boolean isRegisterMessage(Object object) {
            return this.hasForm(object, Lisp.list("register", String.class, ServiceAddress.class));
        }

        public boolean isLookupMessage(Object object) {
            return this.hasForm(object, Lisp.list("lookup", String.class));
        }

        private boolean hasForm(Object object, List list) {
            if (!(object instanceof List)) {
                return false;
            }
            Iterator iterator = ((List)object).iterator();
            Iterator iterator2 = list.iterator();
            while (iterator.hasNext() && iterator2.hasNext()) {
                Object e = iterator2.next();
                if (e instanceof String) {
                    if (e.equals(iterator.next())) continue;
                    return false;
                }
                if (e instanceof Class) {
                    if (((Class)e).isInstance(iterator.next())) continue;
                    return false;
                }
                throw new ConsistencyException("Bad hasForm syntax: " + list);
            }
            return !iterator.hasNext() && !iterator2.hasNext();
        }
    }

    private class TranscriptFrame
    extends TextAreaFrame {
        private TranscriptFrame(ServiceAddress serviceAddress) {
            super("I-X HTTP Name-Server at " + serviceAddress);
        }

        public void whenClosed() {
            if (Util.dialogConfirms(this, "Exit name-server?")) {
                System.exit(0);
            }
        }
    }

    private class NSCommStrategy
    extends HttpCommunicationStrategy {
        private NSCommStrategy(int n) {
            super(n);
        }

        protected Object handleInput(Object object) {
            return HttpNameServer.this.handleRequest(object);
        }

        protected void registerWithNameServer() {
        }
    }
}

