/*
 * Decompiled with CFR 0.152.
 */
package ix.icore;

import ix.ichat.ChatMessage;
import ix.icore.Activity;
import ix.icore.IXAgentExtension;
import ix.icore.Issue;
import ix.icore.Report;
import ix.icore.ReportType;
import ix.icore.Sendable;
import ix.icore.TaskItem;
import ix.icore.YesNo;
import ix.icore.domain.Constraint;
import ix.icore.event.AgentNameEvent;
import ix.icore.event.AgentNameListener;
import ix.icore.log.EventLogger;
import ix.icore.log.HistoryEvent;
import ix.iface.util.IFUtil;
import ix.iface.util.Reporting;
import ix.iface.util.ToolController;
import ix.isim.ISimTimer;
import ix.ispace.ContactManager;
import ix.util.Debug;
import ix.util.Gensym;
import ix.util.IPC;
import ix.util.Name;
import ix.util.Parameters;
import ix.util.RethrownException;
import ix.util.TextAreaFrame;
import ix.util.Util;
import ix.util.lisp.ItemVar;
import ix.util.lisp.LList;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IXAgent {
    protected static IXAgent thisAgent = null;
    protected static Map<IXAgent, Boolean> knownAgents = new WeakHashMap<IXAgent, Boolean>();
    protected String ipcName = "anonymous";
    protected String displayName = "I-X Agent";
    protected String symbolName = "anonymous";
    protected String initialDisplayName = "not a display name";
    protected ContactManager contactManager = new ContactManager();
    protected EventLogger eventLogger = new EventLogger(this);
    protected ISimTimer iSimTimer = null;
    protected String ipcStrategyName = null;
    protected List startupHooks = new LinkedList();
    protected List exitHooks = new LinkedList();
    protected List nameListeners = new LinkedList();
    protected Date startupDate = new Date();
    protected TextAreaFrame textFrame = null;

    public IXAgent() {
        this(true);
    }

    protected IXAgent(boolean bl) {
        Debug.noteln("Creating I-X agent, standalone = " + bl);
        if (bl) {
            if (thisAgent != null) {
                throw new Error("Attempt to create multiple IX Agents in one VM");
            }
            thisAgent = this;
        }
        knownAgents.put(this, Boolean.TRUE);
    }

    public void mainStartup(String[] stringArray) {
        block2: {
            try {
                this.do_mainStartup(stringArray);
            }
            catch (Throwable throwable) {
                Debug.displayException(throwable);
                if (this == thisAgent && Parameters.isInteractive()) break block2;
                throw new RethrownException(throwable);
            }
        }
    }

    protected void do_mainStartup(String[] stringArray) {
        Parameters.processCommandLineArguments(stringArray);
        this.processCommandLineArguments();
        this.startup();
        if (this.ipcStrategyName != null) {
            this.startServer(this.getAgentIPCName(), this.ipcStrategyName);
        }
        if (Parameters.haveParameter("log-directory") && this == thisAgent) {
            this.eventLogger.install();
            this.eventLogger.startLogging();
        }
        this.setupISimTimer();
        Util.runHooks("startup", this.startupHooks);
        Parameters.checkParameterUse();
    }

    protected void setupISimTimer() {
        block3: {
            if (Parameters.haveParameter("isim-agent-name") && this == thisAgent) {
                try {
                    this.iSimTimer = ISimTimer.getISimTimer(this);
                }
                catch (Throwable throwable) {
                    Debug.displayException("Can't set up I-Sim timer", throwable);
                    if (Parameters.isInteractive()) break block3;
                    throw new RethrownException(throwable);
                }
            }
        }
    }

    protected void startup() {
    }

    protected void processCommandLineArguments() {
        String string;
        IFUtil.adjustLookAndFeel();
        Debug.on = Parameters.getBoolean("debug", Debug.on);
        if (Parameters.haveParameter("ipc-name")) {
            this.ipcName = Parameters.getParameter("ipc-name");
            Debug.noteln("Using ipc name", (Object)this.ipcName);
        } else if (Parameters.haveParameter("symbol-name")) {
            this.ipcName = Parameters.getParameter("symbol-name");
            Debug.noteln("Using symbol name " + this.ipcName + " as ipc name");
        } else {
            try {
                this.ipcName = Util.getUserName() + "@" + Util.getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                this.ipcName = Util.getUserName();
                Util.displayAndWait(null, "Can't get host name; using ipc-name=" + this.ipcName);
            }
        }
        this.symbolName = Parameters.getParameter("symbol-name", this.ipcName);
        this.initialDisplayName = this.displayName;
        String string2 = this.displayName = Parameters.haveParameter("display-name") ? Parameters.getParameter("display-name") : this.symbolName + " " + this.displayName;
        if (Parameters.haveParameter("ipc") && !(string = Parameters.getParameter("ipc")).equals("false") && !string.equals("none")) {
            this.ipcStrategyName = string;
        }
        if (Parameters.getBoolean("use-long-ids", true)) {
            Gensym.useUniquePrefix();
        }
        this.eventLogger.processCommandLineArguments();
        this.contactManager.processCommandLineArguments();
    }

    public void addStartupHook(Runnable runnable) {
        this.startupHooks.add(runnable);
    }

    public void addExitHook(Runnable runnable) {
        this.exitHooks.add(runnable);
    }

    public void installAgentExtensions() {
        this.installAgentExtensions(Parameters.getList("extension-classes"));
    }

    protected void installAgentExtensions(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            Debug.noteln("Installing agent extension", (Object)string);
            try {
                Class<?> clazz = Class.forName(string);
                IXAgentExtension iXAgentExtension = (IXAgentExtension)Util.makeInstance(clazz, this);
                iXAgentExtension.installExtension();
            }
            catch (Exception exception) {
                throw new RethrownException(exception);
            }
        }
    }

    public static IXAgent getAgent() {
        return thisAgent;
    }

    public static Set<IXAgent> getKnownAgents() {
        return knownAgents.keySet();
    }

    public Object getAgentIPCName() {
        return this.ipcName;
    }

    public String getAgentSymbolName() {
        return this.symbolName;
    }

    public void setAgentSymbolName(String string) {
        String string2 = this.symbolName;
        this.ipcName = string;
        this.symbolName = string;
        this.displayName = Parameters.haveParameter("display-name") ? Parameters.getParameter("display-name") : this.symbolName + " " + this.initialDisplayName;
        this.fireSymbolNameChanged(string2, this.symbolName);
    }

    public void addAgentNameListener(AgentNameListener agentNameListener) {
        this.nameListeners.add(agentNameListener);
    }

    public void fireSymbolNameChanged(String string, String string2) {
        AgentNameEvent agentNameEvent = new AgentNameEvent(this, string, string2);
        Iterator iterator = this.nameListeners.iterator();
        while (iterator.hasNext()) {
            ((AgentNameListener)iterator.next()).symbolNameChanged(agentNameEvent);
        }
    }

    public String getAgentDisplayName() {
        return this.displayName;
    }

    public Date getAgentStartupDate() {
        return this.startupDate;
    }

    public ContactManager getContactManager() {
        return this.contactManager;
    }

    public EventLogger getEventLogger() {
        return this.eventLogger;
    }

    public void log(HistoryEvent historyEvent) {
        this.eventLogger.log(historyEvent);
    }

    public ISimTimer getISimTimer() {
        return this.iSimTimer;
    }

    public void addTool(ToolController toolController) {
        Debug.noteln("Attempt to add tool " + toolController.getToolName());
        throw new UnsupportedOperationException("This agent does not allow tools to be added.");
    }

    public Object ensureTool(String string) {
        Debug.noteln("Attempt to ensure tool", (Object)string);
        throw new UnsupportedOperationException("This agent does not support GUI tools.");
    }

    protected void startServer(Object object, String string) {
        IPC.setCommunicationStrategy(string);
        if (Parameters.getBoolean("enqueue-incoming-messages", false)) {
            IPC.setupServer(object, new IPC.BufferedMessageListener(){

                public void handleMessage(IPC.InputMessage inputMessage) {
                    IXAgent.this.pre_handleInput(inputMessage);
                }
            });
        } else {
            IPC.setupServer(object, new IPC.MessageListener(){

                public synchronized void messageReceived(IPC.InputMessage inputMessage) {
                    IXAgent.this.pre_handleInput(inputMessage);
                }
            });
        }
    }

    protected synchronized void pre_handleInput(final IPC.InputMessage inputMessage) {
        inputMessage.setAnnotation("is-external", Boolean.TRUE);
        Util.swingAndWait(new Runnable(){

            public void run() {
                try {
                    Debug.expect(SwingUtilities.isEventDispatchThread(), "Message handling begins in wrong thread");
                    IXAgent.this.notePossibleNewContact(inputMessage);
                    IPC.fireMessageReceived(inputMessage);
                    IXAgent.this.handleInput(IXAgent.this.preprocessInput(inputMessage));
                }
                catch (Throwable throwable) {
                    Debug.noteException(throwable);
                    IXAgent.this.reportInputException(inputMessage, throwable);
                }
            }
        });
    }

    protected IPC.InputMessage preprocessInput(IPC.InputMessage inputMessage) {
        TaskItem taskItem;
        LList lList;
        if (!Parameters.getBoolean("rename-variables-in-input", true)) {
            return inputMessage;
        }
        if (inputMessage.getContents() instanceof TaskItem && (lList = (taskItem = (TaskItem)inputMessage.getContents()).getPattern()) != null) {
            LList lList2 = (LList)ItemVar.renameItemVars(lList);
            taskItem.setPattern(lList2);
        }
        return inputMessage;
    }

    protected void reportInputException(IPC.InputMessage inputMessage, Throwable throwable) {
        Sendable sendable;
        Object object = inputMessage.getContents();
        String string = "unknown sender";
        if (object instanceof Sendable && (sendable = (Sendable)object).getSenderId() != null) {
            string = sendable.getSenderId().toString();
        }
        JOptionPane.showMessageDialog(null, new Object[]{"Problem handling message from " + string, "Contents class " + object.getClass().getName(), Debug.describeException(throwable)}, "Error during message handling", 0);
    }

    public void notePossibleNewContact(IPC.InputMessage inputMessage) {
        Name name;
        Object object = inputMessage.getContents();
        if (object instanceof Sendable && (name = ((Sendable)object).getSenderId()) != null) {
            this.contactManager.noteAgent(name.toString());
        }
    }

    public void handleInput(IPC.InputMessage inputMessage) {
        Object object = inputMessage.getContents();
        if (object instanceof Issue) {
            this.handleNewIssue((Issue)object);
        } else if (object instanceof Activity) {
            this.handleNewActivity((Activity)object);
        } else if (object instanceof Constraint) {
            this.handleNewConstraint((Constraint)object);
        } else if (object instanceof Report) {
            this.handleNewReport((Report)object);
        } else if (object instanceof ChatMessage) {
            this.handleNewChatMessage((ChatMessage)object);
        } else {
            this.displayMessage("Unexpected message contents " + object);
        }
    }

    public void handleNewIssue(Issue issue) {
        this.displayMessage(Reporting.issueDescription(issue));
    }

    public void handleNewActivity(Activity activity) {
        this.displayMessage(Reporting.activityDescription(activity));
    }

    public void handleNewConstraint(Constraint constraint) {
        this.displayMessage(Reporting.constraintDescription(constraint));
    }

    public void handleNewReport(Report report) {
        this.displayMessage(Reporting.reportDescription(report));
    }

    protected void handleReceivedReport(TaskItem taskItem) {
        if (!Parameters.getBoolean("send-received-reports", true)) {
            return;
        }
        if (taskItem.getReportBack() == YesNo.YES) {
            Name name = Name.valueOf(this.getAgentIPCName());
            Report report = new Report();
            report.setReportType(ReportType.PROGRESS);
            report.setText("Received by " + name + ", " + Reporting.dateString());
            report.setRef(taskItem.getRef());
            report.setSenderId(name);
            IPC.sendObject(taskItem.getSenderId().toString(), report);
        }
    }

    public void handleNewChatMessage(ChatMessage chatMessage) {
        this.displayMessage(Reporting.chatMessageDescription(chatMessage));
    }

    protected void displayMessage(String string) {
        if (this.textFrame == null) {
            this.textFrame = new TextAreaFrame("Messages to " + this.getAgentIPCName());
        }
        this.textFrame.appendLine(string);
        this.textFrame.setVisible(true);
    }
}

