/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.ui;

import ix.icore.IXAgent;
import ix.icore.domain.Domain;
import ix.icore.plan.Plan;
import ix.iface.ui.util.UIUtil;
import ix.iface.util.IFUtil;
import ix.iface.util.IXHtmlEditorKit;
import ix.ip2.Ip2;
import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.xml.FileSyntaxManager;
import ix.util.xml.XML;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HTMLPanel
extends JPanel
implements HyperlinkListener {
    private final JEditorPane htmlPane = new JEditorPane();
    private final JTextField urlField = new JTextField("          ");
    private URL currentURL;
    private ArrayList history = new ArrayList();
    private int currentHistory = 0;
    MouseEvent mostRecentMouseEvent;

    public HTMLPanel() {
        super(new BorderLayout());
        this.setSize(550, 650);
        AbstractAction abstractAction = new AbstractAction("Open URL"){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = HTMLPanel.this.urlField.getText();
                try {
                    HTMLPanel.this.displayURL(new URL(string));
                }
                catch (MalformedURLException malformedURLException) {
                    String string2 = string + " is not a URL this panel can display.";
                    JOptionPane.showMessageDialog(HTMLPanel.this, string2);
                }
            }
        };
        InputMap inputMap = this.urlField.getInputMap();
        ActionMap actionMap = this.urlField.getActionMap();
        actionMap.put("open", abstractAction);
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "open");
        JButton jButton = new JButton(abstractAction);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 3.0, 0.0, 17, 2, new Insets(0, 4, 0, 0), 0, 0);
        jPanel.add((Component)this.urlField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0);
        jPanel.add((Component)jButton, gridBagConstraints);
        this.add("North", jPanel);
        this.htmlPane.setEditable(false);
        this.htmlPane.setEditorKitForContentType("text/html", new IXHtmlEditorKit());
        this.htmlPane.addHyperlinkListener(this);
        this.htmlPane.addMouseListener(new LinkMouseListener());
        JScrollPane jScrollPane = new JScrollPane(this.htmlPane);
        this.add("Center", jScrollPane);
    }

    public HTMLPanel(URL uRL) {
        this();
        this.displayURL(uRL);
    }

    public HTMLPanel(String string) {
        this();
        try {
            URL uRL = UIUtil.resourceURL(string);
            this.displayURL(uRL);
        }
        catch (Exception exception) {
            Debug.noteException(exception);
        }
    }

    public URL currentURL() {
        return this.currentURL;
    }

    private boolean setURL(URL uRL) {
        this.urlField.setText(uRL.toString());
        try {
            this.htmlPane.setPage(uRL);
            this.currentURL = uRL;
            return true;
        }
        catch (IOException iOException) {
            UIUtil.warning(this, Debug.foldException(iOException));
            return false;
        }
    }

    public boolean displayURL(URL uRL) {
        boolean bl = false;
        Debug.noteln("Displaying url", (Object)uRL.toString());
        Cursor cursor = this.getCursor();
        this.setCursor(new Cursor(3));
        if (this.setURL(uRL)) {
            bl = true;
            while (this.currentHistory > 0) {
                --this.currentHistory;
                this.history.remove(this.currentHistory);
            }
            this.history.add(0, uRL);
        }
        this.setCursor(cursor);
        return bl;
    }

    public boolean back() {
        try {
            ++this.currentHistory;
            if (this.setURL((URL)this.history.get(this.currentHistory))) {
                return true;
            }
            --this.currentHistory;
            return false;
        }
        catch (Exception exception) {
            try {
                this.setURL((URL)this.history.get(this.currentHistory));
                return false;
            }
            catch (Exception exception2) {
                this.setURL(this.currentURL);
                int n = this.history.indexOf(this.currentURL);
                if (0 <= n) {
                    this.currentHistory = n;
                }
                return false;
            }
        }
    }

    public boolean forward() {
        try {
            --this.currentHistory;
            if (this.setURL((URL)this.history.get(this.currentHistory))) {
                return true;
            }
            ++this.currentHistory;
            return false;
        }
        catch (Exception exception) {
            try {
                this.setURL((URL)this.history.get(this.currentHistory));
                return false;
            }
            catch (Exception exception2) {
                this.setURL(this.currentURL);
                int n = this.history.indexOf(this.currentURL);
                if (0 <= n) {
                    this.currentHistory = n;
                }
                return false;
            }
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            URL uRL = this.htmlPane.getPage();
            if (this.loadFromURL(hyperlinkEvent.getURL())) {
                return;
            }
            if (!this.displayURL(hyperlinkEvent.getURL())) {
                Debug.noteln("The bad link's description is", (Object)hyperlinkEvent.getDescription());
                this.displayURL(uRL);
            }
        }
    }

    protected boolean loadFromURL(URL uRL) {
        IXAgent iXAgent = IXAgent.getAgent();
        if (iXAgent == null || !(iXAgent instanceof Ip2)) {
            return false;
        }
        Ip2 ip2 = (Ip2)iXAgent;
        FileSyntaxManager fileSyntaxManager = XML.fileSyntaxManager();
        String string = fileSyntaxManager.getType(uRL.getFile());
        boolean bl = fileSyntaxManager.getInputTypesForClass(Plan.class).contains(string);
        boolean bl2 = fileSyntaxManager.getInputTypesForClass(Domain.class).contains(string);
        if (!bl && !bl2) {
            return false;
        }
        LinkPopupMenu linkPopupMenu = new LinkPopupMenu(ip2, uRL, bl, bl2);
        if (this.mostRecentMouseEvent == null) {
            return false;
        }
        MouseEvent mouseEvent = this.mostRecentMouseEvent;
        linkPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        return true;
    }

    class LinkPopupMenu
    extends JPopupMenu
    implements ActionListener {
        Ip2 ip2;
        URL url;

        LinkPopupMenu(Ip2 ip2, URL uRL, boolean bl, boolean bl2) {
            this.ip2 = ip2;
            this.url = uRL;
            if (bl) {
                this.add(IFUtil.makeMenuItem("Load Plan", this));
            }
            if (bl2) {
                this.add(IFUtil.makeMenuItem("Load Domain", this));
            }
            this.add(IFUtil.makeMenuItem("View Page", this));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            Debug.noteln("Link popup command", (Object)string);
            if (string.equals("Load Plan")) {
                this.loadPlan();
            } else if (string.equals("Load Domain")) {
                this.loadDomain();
            } else if (string.equals("View Page")) {
                URL uRL = HTMLPanel.this.htmlPane.getPage();
                if (!HTMLPanel.this.displayURL(this.url)) {
                    HTMLPanel.this.displayURL(uRL);
                }
            } else {
                throw new ConsistencyException("Noting to do for " + string);
            }
        }

        void loadPlan() {
            this.ip2.loadPlan(this.url.toString());
        }

        void loadDomain() {
            this.ip2.readDomain(this.ip2.getDomain(), this.url.toString());
        }
    }

    class LinkMouseListener
    extends MouseAdapter {
        LinkMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            HTMLPanel.this.mostRecentMouseEvent = mouseEvent;
        }
    }
}

