/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.ui;

import ix.iface.ui.JPreferencesDialog;
import ix.iface.ui.PropertiesApplication;
import ix.iface.ui.util.UIUtil;
import ix.util.Debug;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;

public abstract class JPropertiesManager {
    protected PropertiesApplication application;
    protected Properties properties;
    protected JPreferencesDialog preferencesDialog;
    public HashSet noEditComponents = new HashSet();

    public JPropertiesManager(PropertiesApplication propertiesApplication) {
        this.application = propertiesApplication;
    }

    public abstract void setDefaultProperties(Properties var1);

    public abstract JPreferencesDialog makePreferencesDialog();

    public void noteNoEditable(String string) {
        this.noEditComponents.add(string);
    }

    public boolean isEditable(String string) {
        return !this.noEditComponents.contains(string);
    }

    public File getPropertiesFile() {
        return this.getDefaultPropertiesFile();
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProperty(String string) {
        return this.properties.getProperty(string);
    }

    public void setProperty(String string, String string2) {
        this.properties.setProperty(string, string2);
    }

    public void editPreferences() {
        try {
            this.ensurePreferencesDialog();
            this.preferencesDialog.setVisible(true);
        }
        catch (Exception exception) {
            Debug.noteException(exception);
        }
    }

    public JPreferencesDialog ensurePreferencesDialog() {
        if (this.preferencesDialog == null) {
            this.preferencesDialog = this.makePreferencesDialog();
            this.preferencesDialog.addPropertyChangeListener((PropertyChangeListener)((Object)this.application));
        }
        return this.preferencesDialog;
    }

    public File getDefaultPropertiesFile() {
        String string = ".";
        String string2 = System.getProperty("file.separator");
        String string3 = string + string2 + this.application.getName() + ".prefs";
        return new File(string3);
    }

    public void initProperties() {
        Debug.noteln("PropertyManager: loading properties");
        Properties properties = new Properties();
        this.setDefaultProperties(properties);
        this.properties = new Properties(properties);
        this.loadProperties(this.properties);
        this.updateApplicationFromProperties(this.application);
    }

    public void saveProperties() {
        this.saveProperties(this.properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveProperties(Properties properties) {
        Debug.noteln("Prop fields:", (Object)UIUtil.show(properties.propertyNames()));
        FileOutputStream fileOutputStream = null;
        try {
            File file = this.getPropertiesFile();
            fileOutputStream = new FileOutputStream(file);
            properties.store(fileOutputStream, "--------- properties (preferences)  ---------");
            Debug.noteln("Wrote properties to file", (Object)file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileOutputStream = null;
            Debug.noteln("Warning:");
            Debug.noteln("Can't find properties file. Can't save.");
            Debug.noteln("");
        }
        catch (IOException iOException) {
            Debug.noteln("Can't save properties.");
            Debug.noteException(iOException);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public Properties loadProperties() {
        this.loadProperties(this.properties);
        return this.properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties loadProperties(Properties properties) {
        FileInputStream fileInputStream = null;
        try {
            File file = this.getPropertiesFile();
            Debug.noteln("Props file is", (Object)file);
            if (file == null || !file.exists()) {
                Debug.noteln("Can't find properties file. Trying default file", (Object)this.getDefaultPropertiesFile());
                file = this.getDefaultPropertiesFile();
            }
            fileInputStream = new FileInputStream(file);
            properties.load(fileInputStream);
            Properties properties2 = properties;
            return properties2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileInputStream = null;
            Debug.noteln("Warning:");
            Debug.noteln("Can't find properties file. Can't load.");
            Debug.noteln("");
            Properties properties3 = null;
            return properties3;
        }
        catch (IOException iOException) {
            Debug.noteln("Warning:");
            Debug.noteln("Can't read properties file. Can't load.");
            Debug.noteln("");
            Properties properties4 = null;
            return properties4;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                    return properties;
                }
                catch (IOException iOException) {
                    return properties;
                }
            }
        }
    }

    public void saveApplicationProperties() {
        this.updatePropertiesFromApplication();
        this.saveProperties(this.properties);
    }

    public void updateApplicationFromProperties() {
        this.updateApplicationFromProperties(this.application);
    }

    public void updateApplicationFromProperties(PropertiesApplication propertiesApplication) {
        Enumeration<?> enumeration = this.properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.properties.getProperty(string);
            propertiesApplication.setProperty(string, string2);
        }
    }

    public void updatePropertiesFromApplication() {
        this.updatePropertiesFromApplication(this.application);
    }

    public void updatePropertiesFromApplication(PropertiesApplication propertiesApplication) {
        Enumeration<?> enumeration = this.properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = propertiesApplication.getProperty(string);
            this.properties.setProperty(string, string2);
        }
    }

    public static boolean isBooleanProperty(String string, String string2) {
        Boolean bl = new Boolean(string2);
        if (bl.booleanValue()) {
            return true;
        }
        return bl.toString().equals(string2);
    }
}

