/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.util;

import ix.iface.util.HtmlDescriber;
import ix.iface.util.IXHtmlEditorKit;
import ix.util.Debug;
import javax.swing.JEditorPane;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class HtmlTableEditorPane
extends JEditorPane {
    protected HTMLEditorKit tableEditorKit = new TableEditorKit();
    protected boolean settingText = false;

    public HtmlTableEditorPane() {
        this.setEditorKitForContentType("text/html", this.tableEditorKit);
        this.setContentType("text/html");
        this.setDocText("");
        Debug.expectSame(this.tableEditorKit, this.getEditorKit());
        this.setEditable(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDocText(String string) {
        try {
            this.settingText = true;
            this.setDocument(this.tableEditorKit.createDefaultDocument());
            this.setText(string);
            Debug.expectSame(this.tableEditorKit, this.getEditorKit());
        }
        finally {
            this.settingText = false;
        }
    }

    protected void editedElement(Element element) {
    }

    public void describeHtmlDocument() {
        new HtmlDescriber(System.out).describe((HTMLDocument)this.getDocument());
    }

    class TableDocumentFilter
    extends DocumentFilter {
        Element editing = null;

        TableDocumentFilter() {
        }

        public void remove(DocumentFilter.FilterBypass filterBypass, int n, int n2) throws BadLocationException {
            if (!this.editIsAllowed(n, n2)) {
                throw new BadLocationException("No", n);
            }
            super.remove(filterBypass, n, n2);
            if (!HtmlTableEditorPane.this.settingText) {
                HtmlTableEditorPane.this.editedElement(this.editing);
            }
        }

        public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            if (!this.editIsAllowed(n, n2)) {
                throw new BadLocationException("No", n);
            }
            super.replace(filterBypass, n, n2, string, attributeSet);
            if (!HtmlTableEditorPane.this.settingText) {
                HtmlTableEditorPane.this.editedElement(this.editing);
            }
        }

        boolean editIsAllowed(int n, int n2) {
            Element element = this.getTableCell(n);
            Element element2 = this.getTableCell(n + n2);
            this.editing = element;
            return HtmlTableEditorPane.this.settingText || element != null && element2 != null && element == element2;
        }

        Element getTableCell(int n) {
            Document document = HtmlTableEditorPane.this.getDocument();
            Element element = document.getDefaultRootElement();
            while (!element.isLeaf()) {
                Object object = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
                if (object == HTML.Tag.TD) {
                    return element;
                }
                element = element.getElement(element.getElementIndex(n));
            }
            return null;
        }
    }

    class TableEditorKit
    extends IXHtmlEditorKit {
        TableEditorKit() {
        }

        public Document createDefaultDocument() {
            AbstractDocument abstractDocument = (AbstractDocument)super.createDefaultDocument();
            abstractDocument.setDocumentFilter(new TableDocumentFilter());
            return abstractDocument;
        }
    }
}

