/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.Priority;
import ix.icore.Report;
import ix.icore.Status;
import ix.icore.process.PNode;
import ix.iface.ui.DefaultColourField;
import ix.iface.ui.EditableColourField;
import ix.iface.ui.FourField;
import ix.iface.ui.table.AbstractTreeTableModel;
import ix.iface.ui.table.IXTreeTableNode;
import ix.ip2.AgendaItem;
import ix.ip2.AgendaTableViewer;
import ix.ip2.HandlerAction;
import ix.ip2.event.AgendaEvent;
import ix.ip2.event.AgendaItemEvent;
import ix.ip2.event.AgendaItemListener;
import ix.iview.util.EditablePriority;
import ix.util.Debug;
import ix.util.Strings;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.tree.TreeNode;

public class AgendaItemTableModel
extends AbstractTreeTableModel {
    protected AgendaTableViewer table;
    private int offset = 2;
    public int DESCRIPTION_COL = 0 + this.offset;
    public int COMMENTS_COL = 1 + this.offset;
    public int PRIORITY_COL = 2 + this.offset;
    public int ACTION_COL = 3 + this.offset;
    private Color newColour = new Color(0xFFCCCC);
    private HashSet items = new HashSet();
    private HashSet disabled = new HashSet();

    public AgendaItemTableModel(AgendaTableViewer agendaTableViewer) {
        super(false);
        this.setColumnVars();
        this.table = agendaTableViewer;
        Class[] classArray = new Class[]{FourField.class, String.class, Priority.class, FourField.class};
        String[] stringArray = new String[]{"Description", "Annotations", "Priority", "Action"};
        this.setColumnClasses(classArray);
        this.setColumnNames(stringArray);
    }

    public void setColumnVars() {
        this.offset = this.rowsMarkable ? 2 : 1;
        this.DESCRIPTION_COL = 0 + this.offset;
        this.COMMENTS_COL = 1 + this.offset;
        this.PRIORITY_COL = 2 + this.offset;
        this.ACTION_COL = 3 + this.offset;
    }

    public synchronized void itemAdded(AgendaItem agendaItem) {
        if (agendaItem == null) {
            return;
        }
        AgendaItem agendaItem2 = agendaItem.getParent();
        IXTreeTableNode iXTreeTableNode = null;
        if (agendaItem2 == null) {
            this.addData(agendaItem);
        } else {
            iXTreeTableNode = (IXTreeTableNode)this.getTreeNode(agendaItem2);
            int n = this.rows.indexOf(iXTreeTableNode);
            if (n == -1) {
                n = this.getObjectRow(agendaItem2);
            }
            this.expandNode(iXTreeTableNode, n);
        }
        TreeAgendaItem treeAgendaItem = (TreeAgendaItem)this.getTreeNode(agendaItem);
        agendaItem.addItemListener(treeAgendaItem);
        this.items.add(agendaItem);
        this.fireNodeStructureChanged(iXTreeTableNode);
    }

    public synchronized void itemRemoved(AgendaItem agendaItem) {
        Debug.noteln("Agenda Model removing item", (Object)agendaItem);
        TreeAgendaItem treeAgendaItem = (TreeAgendaItem)this.nodeMap.get(agendaItem);
        if (treeAgendaItem == null) {
            Debug.noteln("Removing item: no such item", (Object)agendaItem);
        } else {
            super.removeData(agendaItem);
            this.nodeMap.remove(agendaItem);
            this.items.remove(agendaItem);
            this.disabled.remove(agendaItem);
        }
    }

    public void clearData() {
        this.items.clear();
        super.clearData();
    }

    public String getNameString(TreeNode treeNode) {
        return ((TreeAgendaItem)treeNode).node.getShortDescription();
    }

    protected Object getTreeValueAt(IXTreeTableNode iXTreeTableNode) {
        AgendaItem agendaItem = ((TreeAgendaItem)iXTreeTableNode).node;
        DefaultColourField defaultColourField = (DefaultColourField)super.getTreeValueAt(iXTreeTableNode);
        if (agendaItem.isNew()) {
            defaultColourField.setColour(this.newColour);
        }
        return defaultColourField;
    }

    public Object getCellValueAt(Object object, int n) {
        AgendaItem agendaItem = ((TreeAgendaItem)object).node;
        if (n == this.COMMENTS_COL - this.offset) {
            Object object2;
            String string;
            List list = agendaItem.getReports();
            if (list == null || list.isEmpty()) {
                string = agendaItem.getComments();
            } else {
                object2 = (Report)list.get(list.size() - 1);
                string = ((Report)object2).getText();
            }
            object2 = Strings.firstLine(string).trim();
            return object2;
        }
        if (n == this.PRIORITY_COL - this.offset) {
            TreeAgendaItem treeAgendaItem = (TreeAgendaItem)object;
            boolean bl = treeAgendaItem.takesPriority();
            return new EditablePriority(agendaItem.getPriority(), bl);
        }
        if (n == this.ACTION_COL - this.offset) {
            List list;
            TreeAgendaItem treeAgendaItem = (TreeAgendaItem)object;
            HandlerAction handlerAction = treeAgendaItem.handlerAction;
            Color color = agendaItem.getStatus().getColor();
            if (handlerAction == null && (list = agendaItem.getActions()) != null && !list.isEmpty()) {
                handlerAction = (HandlerAction)list.get(0);
            }
            String string = handlerAction == null ? "No Action" : handlerAction.getActionDescription();
            boolean bl = treeAgendaItem.takesAction();
            return new EditableColourField(string, color, bl);
        }
        return null;
    }

    public boolean isCellEditable(int n, int n2) {
        if (n2 == this.DESCRIPTION_COL || n2 == this.COMMENTS_COL) {
            return true;
        }
        return super.isCellEditable(n, n2);
    }

    public boolean takesPriority(int n) {
        TreeAgendaItem treeAgendaItem = (TreeAgendaItem)this.getRowNode(n);
        return treeAgendaItem.takesPriority();
    }

    public boolean takesAction(int n) {
        TreeAgendaItem treeAgendaItem = (TreeAgendaItem)this.getRowNode(n);
        return treeAgendaItem.takesAction();
    }

    public void setValueAt(Object object, int n, int n2) {
        if (object == null) {
            this.fireTableCellUpdated(n, n2);
            return;
        }
        AgendaItem agendaItem = (AgendaItem)this.getRowObject(n);
        if (n2 == this.PRIORITY_COL) {
            this.setPriorityValue(agendaItem, object, n, n2);
        } else if (n2 == this.ACTION_COL) {
            String string = object.toString();
            this.actionSelected(agendaItem, string);
        } else {
            super.setValueAt(object, n, n2);
        }
        this.fireTableCellUpdated(n, n2);
    }

    public void setPriorityValue(AgendaItem agendaItem, Object object, int n, int n2) {
        try {
            Priority priority = Priority.valueOf(Strings.uncapitalize(object.toString()));
            if (!priority.equals(agendaItem.getPriority())) {
                agendaItem.setPriority(priority);
                this.fireTableCellUpdated(n, n2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Debug.noteException(illegalArgumentException);
        }
    }

    public void setPriorityValue(Object object, int n, int n2) {
        this.setPriorityValue((AgendaItem)this.getRowObject(n), object, n, n2);
    }

    private void actionSelected(AgendaItem agendaItem, String string) {
        this.table.actionSelected(agendaItem, string);
    }

    public void itemHandled(AgendaEvent agendaEvent, AgendaItem agendaItem, HandlerAction handlerAction) {
        Debug.noteln("AITM: Handled item", (Object)agendaItem.getShortDescription());
        TreeAgendaItem treeAgendaItem = (TreeAgendaItem)this.getTreeNode(agendaItem);
        treeAgendaItem.setHandlerAction(handlerAction);
    }

    public void setHandlerAction(AgendaItem agendaItem, HandlerAction handlerAction) {
        TreeAgendaItem treeAgendaItem = (TreeAgendaItem)this.getTreeNode(agendaItem);
        treeAgendaItem.setHandlerAction(handlerAction);
    }

    public HandlerAction getHandlerAction(AgendaItem agendaItem) {
        TreeAgendaItem treeAgendaItem = (TreeAgendaItem)this.getTreeNode(agendaItem);
        return treeAgendaItem.handlerAction;
    }

    public void fireTableStructureChanged() {
    }

    public void fireTableChanged() {
        this.fireTableDataChanged();
    }

    public void fireItemChanged(TreeAgendaItem treeAgendaItem) {
        int n;
        if (treeAgendaItem == null) {
            return;
        }
        int n2 = this.getObjectRow(treeAgendaItem.node);
        if (this.table.isDummyEditing(n2, n = this.table.getEditingColumn())) {
            this.fireTableRowsUpdated(n2, n2);
            this.table.editCellAt(n2, n);
        } else {
            this.fireTableRowsUpdated(n2, n2);
        }
    }

    public void fireActionSelected(AgendaItem agendaItem, HandlerAction handlerAction) {
        if (agendaItem == null) {
            return;
        }
        int n = this.getObjectRow(agendaItem);
        TableModelEvent tableModelEvent = new TableModelEvent(this, n, n, this.ACTION_COL);
        this.fireTableChanged(tableModelEvent);
    }

    public void fireItemDeleted(AgendaItem agendaItem) {
        int n = this.getObjectRow(agendaItem);
        this.fireTableRowsDeleted(n, n);
    }

    public IXTreeTableNode makeIXTreeTableNode(Object object) {
        if (object == null) {
            Debug.noteln("AITM: Cannot make a table node for null objects");
            return null;
        }
        return new TreeAgendaItem(this, (AgendaItem)object);
    }

    protected class TreeAgendaItem
    extends IXTreeTableNode
    implements AgendaItemListener {
        public AgendaItem node;
        public HandlerAction handlerAction;
        public List handlerActions;
        private boolean takesAction;
        private boolean takesPriority;

        public TreeAgendaItem(AgendaItemTableModel agendaItemTableModel2, AgendaItem agendaItem) {
            super(agendaItemTableModel2, agendaItem);
            this.takesAction = true;
            this.takesPriority = true;
            this.node = agendaItem;
            if (agendaItem == null) {
                Debug.noteln("Making TreeAgendaItem with null AgendaItem");
                new Throwable().printStackTrace();
            } else {
                this.noticeStatus();
            }
            if (AgendaItemTableModel.this.items.contains(agendaItem)) {
                agendaItem.addItemListener(this);
            }
        }

        public boolean takesAction() {
            return this.takesAction;
        }

        public void disableActions() {
            this.takesAction = false;
        }

        public void enableActions() {
            this.takesAction = true;
        }

        public boolean takesPriority() {
            return this.takesPriority;
        }

        public void disablePriority() {
            this.takesPriority = false;
        }

        public void enablePriority() {
            this.takesPriority = true;
        }

        protected void loadHandlerActions() {
            this.handlerActions = new ArrayList();
            for (HandlerAction handlerAction : this.node.getActions()) {
                String string = handlerAction.getActionDescription();
                if (this.handlerActions.contains(handlerAction = AgendaItemTableModel.this.table.findHandlerAction(this.node, string))) continue;
                this.handlerActions.add(handlerAction);
            }
        }

        protected void noticeStatus() {
            Status status = this.node.getStatus();
            if ((status == Status.COMPLETE || status == Status.EXECUTING || status == Status.IMPOSSIBLE) && AgendaItemTableModel.this.disabled.contains(this.node)) {
                this.disableActions();
                this.disablePriority();
            }
        }

        public void setHandlerAction(HandlerAction handlerAction) {
            this.handlerAction = handlerAction;
            AgendaItemTableModel.this.fireItemChanged(this);
        }

        public Enumeration children() {
            final List<PNode> list = this.node.getChildren();
            return new Enumeration(){
                int i;
                {
                    this.i = list.size() - 1;
                }

                public boolean hasMoreElements() {
                    return this.i >= 0;
                }

                public Object nextElement() {
                    return list.get(this.i--);
                }
            };
        }

        public boolean getAllowsChildren() {
            return true;
        }

        public TreeNode getChildAt(int n) {
            PNode pNode = this.node.getChildren().get(n);
            return this.model.getTreeNode(pNode);
        }

        public int getChildCount() {
            if (this.node.getChildren() == null) {
                return 0;
            }
            return this.node.getChildren().size();
        }

        public int getIndex(TreeNode treeNode) {
            List<PNode> list = this.node.getChildren();
            return list.lastIndexOf(((IXTreeTableNode)treeNode).node);
        }

        public TreeNode getParent() {
            return this.model.getTreeNode(this.node.getParent());
        }

        public boolean isLeaf() {
            if (this.node == null) {
                Debug.noteln("AITM: null node - should not happen!");
                return true;
            }
            if (this.node.getChildren() == null) {
                return true;
            }
            return this.node.getChildren().size() == 0;
        }

        public void statusChanged(AgendaItemEvent agendaItemEvent) {
            AgendaItemTableModel.this.disabled.add(this.node);
            this.noticeStatus();
            AgendaItemTableModel.this.fireItemChanged(this);
        }

        public void priorityChanged(AgendaItemEvent agendaItemEvent) {
            AgendaItemTableModel.this.fireItemChanged(this);
        }

        public void newHandlerAction(AgendaItemEvent agendaItemEvent, HandlerAction handlerAction) {
            AgendaItemTableModel.this.table.newHandlerAction(this.node, handlerAction);
        }

        public void handlerActionsChanged(AgendaItemEvent agendaItemEvent) {
            AgendaItemTableModel.this.fireItemChanged(this);
        }

        public void newReport(AgendaItemEvent agendaItemEvent, Report report) {
            AgendaItemTableModel.this.fireItemChanged(this);
        }

        public void agendaItemEdited(AgendaItemEvent agendaItemEvent) {
            AgendaItemTableModel.this.fireItemChanged(this);
        }
    }
}

