/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.Variable;
import ix.icore.domain.Constraint;
import ix.icore.domain.LinkedListOfConstraint;
import ix.icore.domain.ListOfConstraint;
import ix.icore.domain.PatternAssignment;
import ix.icore.process.PNode;
import ix.ip2.Ip2ModelManager;
import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.StableHashMap;
import ix.util.context.ContextHashMap;
import ix.util.context.ContextMap;
import ix.util.context.ContextMultiHashMap;
import ix.util.context.ContextMultiMap;
import ix.util.lisp.LList;
import ix.util.lisp.Symbol;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Ip2WorldStateManager {
    public static final Symbol S_WORLD_STATE = Symbol.intern("world-state");
    public static final Symbol S_CONDITION = Symbol.intern("condition");
    public static final Symbol S_EFFECT = Symbol.intern("effect");
    protected Ip2ModelManager modelManager;
    protected ContextMultiMap nodeToConditions = this.makeNodeConstraintsMap();
    protected ContextMultiMap nodeToEffects = this.makeNodeConstraintsMap();
    protected ContextMap worldStateMap = this.makeWorldStateMap();

    public Ip2WorldStateManager(Ip2ModelManager ip2ModelManager) {
        this.modelManager = ip2ModelManager;
    }

    public void reset() {
        this.nodeToConditions.clearCompletely();
        this.nodeToEffects.clearCompletely();
        this.worldStateMap.clearCompletely();
    }

    public void clear() {
        this.nodeToConditions.clear();
        this.nodeToEffects.clear();
        this.worldStateMap.clear();
    }

    protected ContextMap makeWorldStateMap() {
        return new ContextHashMap();
    }

    protected ContextMultiMap makeNodeConstraintsMap() {
        return new ContextMultiHashMap();
    }

    public ListOfConstraint getNodeConditions(PNode pNode) {
        List list = (List)this.nodeToConditions.get(pNode);
        if (list != null) {
            return new LinkedListOfConstraint((Collection)list);
        }
        return new LinkedListOfConstraint();
    }

    public List getNodeEffects(PNode pNode) {
        return (List)this.nodeToEffects.get(pNode);
    }

    public Map getWorldStateMap() {
        return this.worldStateMap;
    }

    public Object getPatternValue(LList lList) {
        return this.worldStateMap.get(lList);
    }

    public void addConstraint(PNode pNode, Constraint constraint) {
        Symbol symbol = constraint.getType();
        Symbol symbol2 = constraint.getRelation();
        Debug.expect(symbol == S_WORLD_STATE);
        PatternAssignment patternAssignment = (PatternAssignment)constraint.getParameter(0);
        if (symbol2 == S_CONDITION) {
            this.nodeToConditions.addValue(pNode, constraint);
        } else if (symbol2 == S_EFFECT) {
            this.nodeToEffects.addValue(pNode, patternAssignment);
        } else {
            throw new ConsistencyException("Unexpected constraint " + constraint);
        }
    }

    public Map handleEffects(PNode pNode, List list) {
        StableHashMap stableHashMap = new StableHashMap();
        for (PatternAssignment patternAssignment : list) {
            Debug.noteln("Effect", (Object)patternAssignment);
            LList lList = patternAssignment.getPattern();
            Object object = patternAssignment.getValue();
            Debug.expect(Variable.isFullyBound(lList));
            Debug.expect(Variable.isFullyBound(object));
            LList lList2 = (LList)Variable.removeVars(lList);
            Object object2 = Variable.removeVars(object);
            stableHashMap.put(lList2, object2);
            this.assign(lList2, object2, pNode);
        }
        return stableHashMap;
    }

    public Map handleEffects(List list) {
        return this.handleEffects(null, list);
    }

    public void deleteEffect(PatternAssignment patternAssignment) {
        Set set = Variable.varsAnywhereIn(patternAssignment);
        Set set2 = Variable.unboundVarsIn(set);
        if (!set2.isEmpty()) {
            throw new IllegalArgumentException("Can't delete effect that is not fully bound: " + patternAssignment);
        }
        Object object = this.getPatternValue(patternAssignment.getPattern());
        if (!patternAssignment.getValue().equals(object)) {
            throw new IllegalArgumentException("Can't delete effect " + patternAssignment + " when the current " + "value of the pattern, " + object + ", is " + "different.");
        }
        this.worldStateMap.remove(patternAssignment.getPattern());
        Debug.expect(this.getPatternValue(patternAssignment.getPattern()) == null);
    }

    protected void assign(LList lList, Object object, PNode pNode) {
        this.worldStateMap.put(lList, object);
    }
}

