/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.HasStatus;
import ix.icore.IXAgent;
import ix.icore.Report;
import ix.icore.Status;
import ix.icore.Variable;
import ix.icore.domain.ListOfConstraint;
import ix.icore.process.PNodeEnd;
import ix.iface.util.CatchingActionListener;
import ix.iface.util.IconImage;
import ix.iface.util.ToolFrame;
import ix.ip2.ActionUnreadyReason;
import ix.ip2.AgendaItem;
import ix.ip2.AgendaViewer;
import ix.ip2.HandlerAction;
import ix.ip2.Ip2;
import ix.ip2.event.AgendaItemEvent;
import ix.ip2.event.AgendaItemListener;
import ix.util.Debug;
import ix.util.Function1;
import ix.util.PatternParser;
import ix.util.Strings;
import ix.util.TextAreaFrame;
import ix.util.Util;
import ix.util.lisp.LList;
import ix.util.lisp.LListCollector;
import ix.util.xml.XML;
import ix.util.xml.XMLTranslator;
import ix.util.xml.XMLTreeViewFrame;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.plaf.metal.MetalLookAndFeel;

public abstract class ItemEditor
implements ActionListener {
    protected String title;
    protected JFrame frame;
    protected Container contentPane;
    protected JMenu fileMenu = new JMenu("File");
    protected JMenu viewMenu = new JMenu("View");
    protected AgendaViewer agendaViewer;
    protected String itemType = "Unknown";
    protected EditPanel editPanel;
    protected TextViewFrame textView;
    protected TreeViewFrame treeView;
    protected TextViewFrame statusView;
    protected XMLTranslator viewXMLTranslator = this.makeViewXMLTranslator();
    protected Ip2 agent = (Ip2)IXAgent.getAgent();

    ItemEditor(AgendaViewer agendaViewer, String string) {
        this.agendaViewer = agendaViewer;
        this.title = string;
        this.setUpFrame();
    }

    protected void setUpFrame() {
        this.frame = new ToolFrame(this.title);
        this.frame.setIconImage(IconImage.getIconImage(this));
        this.frame.setSize(500, 300);
        this.frame.setJMenuBar(this.makeMenuBar());
        this.contentPane = this.frame.getContentPane();
        this.editPanel = this.makeEditPanel();
        this.contentPane.add(this.editPanel);
        this.frame.pack();
    }

    protected abstract EditPanel makeEditPanel();

    public void setVisible(boolean bl) {
        this.frame.setVisible(bl);
    }

    public void showItem(AgendaItem agendaItem) {
        this.editPanel.showItem(agendaItem);
        this.setVisible(true);
    }

    public void showNewItem() {
        this.editPanel.showNewItem();
        this.setVisible(true);
    }

    protected JMenuBar makeMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        this.fileMenu.add(this.makeMenuItem("Close"));
        jMenuBar.add(this.fileMenu);
        this.viewMenu.add(this.makeMenuItem("As XML"));
        this.viewMenu.add(this.makeMenuItem("As Tree"));
        this.viewMenu.add(this.makeMenuItem("Status Information"));
        jMenuBar.add(this.viewMenu);
        return jMenuBar;
    }

    protected JMenuItem makeMenuItem(String string) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(CatchingActionListener.listener(this));
        return jMenuItem;
    }

    public abstract void actionPerformed(ActionEvent var1);

    public boolean handleViewCommand(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("As XML")) {
            AgendaItem agendaItem = this.editPanel.getItem();
            if (agendaItem != null) {
                this.ensureTextView();
                this.textView.setVisible(true);
                this.showTextIfVisible(agendaItem);
            }
        } else if (string.equals("As Tree")) {
            AgendaItem agendaItem = this.editPanel.getItem();
            if (agendaItem != null) {
                this.ensureTreeView();
                this.treeView.setVisible(true);
                this.showTreeIfVisible(agendaItem);
            }
        } else if (string.equals("Status Information")) {
            AgendaItem agendaItem = this.editPanel.getEditingItem();
            if (agendaItem == null) {
                Util.displayAndWait(this.frame, new String[]{"The item has not been given to the panel,", "so no status information is available."});
            } else {
                this.ensureStatusView();
                this.statusView.setVisible(true);
                this.showStatusIfVisible(agendaItem);
            }
        } else {
            return false;
        }
        return true;
    }

    void showViewsIfVisible(AgendaItem agendaItem) {
        this.showTextIfVisible(agendaItem);
        this.showTreeIfVisible(agendaItem);
        this.showStatusIfVisible(agendaItem);
    }

    void clearViews() {
        if (this.textView != null) {
            this.textView.setText("");
        }
        if (this.treeView != null) {
            this.treeView.clear();
        }
        if (this.statusView != null) {
            this.statusView.setText("");
        }
    }

    protected void ensureTextView() {
        if (this.textView == null) {
            this.textView = new TextViewFrame();
        }
    }

    protected void showTextIfVisible(AgendaItem agendaItem) {
        if (this.textView != null && this.textView.isVisible()) {
            this.textView.setText(this.viewXMLTranslator.objectToXMLString(agendaItem.getAbout()));
        }
    }

    protected void ensureTreeView() {
        if (this.treeView == null) {
            this.treeView = new TreeViewFrame();
        }
    }

    protected void showTreeIfVisible(AgendaItem agendaItem) {
        if (this.treeView != null && this.treeView.isVisible()) {
            this.treeView.editObject(agendaItem.getAbout());
        }
    }

    XMLTranslator makeViewXMLTranslator() {
        XMLTranslator xMLTranslator = XML.config().makeXMLTranslator();
        xMLTranslator.setOmitImplAttributes(true);
        xMLTranslator.setPrefilter(new Function1(){

            public Object funcall(Object object) {
                return object instanceof Variable ? this.filterVariable((Variable)object) : object;
            }

            Object filterVariable(Variable variable) {
                Object object = variable.getValue();
                return object != null ? object : variable.getName();
            }
        });
        return xMLTranslator;
    }

    protected void ensureStatusView() {
        if (this.statusView == null) {
            this.statusView = new TextViewFrame();
        }
    }

    protected void showStatusIfVisible(AgendaItem agendaItem) {
        if (this.statusView != null && this.statusView.isVisible()) {
            this.statusView.setText(this.makeStatusText(agendaItem));
        }
    }

    protected String makeStatusText(AgendaItem agendaItem) {
        LinkedList linkedList = new LinkedList();
        this.addStatus(linkedList, "Status: ", agendaItem);
        if (agendaItem.getBegin() != null) {
            this.addEndStatus(linkedList, agendaItem.getBegin());
        }
        if (agendaItem.getEnd() != null) {
            this.addEndStatus(linkedList, agendaItem.getEnd());
        }
        this.addHandlerActionStatus(linkedList, agendaItem);
        this.addItemConditons(linkedList, agendaItem);
        return Strings.joinLines(linkedList);
    }

    protected void addStatus(List list, String string, HasStatus hasStatus) {
        list.add(string + this.upStatus(hasStatus) + " " + hasStatus);
    }

    private String upStatus(HasStatus hasStatus) {
        return hasStatus.getStatus().toString().toUpperCase();
    }

    protected void addEndStatus(List list, PNodeEnd pNodeEnd) {
        list.add("");
        list.add("Status of " + pNodeEnd.getEnd() + " end: " + this.upStatus(pNodeEnd));
        List list2 = pNodeEnd.getPredecessors();
        if (list2.isEmpty()) {
            list.add("Has no predecessors.");
        } else {
            list.add("Has predecessors:");
            for (PNodeEnd pNodeEnd2 : list2) {
                if (pNodeEnd2.getNode() == pNodeEnd.getNode()) {
                    list.add("   " + this.upStatus(pNodeEnd2) + " " + pNodeEnd2.getEnd() + "_of same item");
                    continue;
                }
                this.addStatus(list, "   ", pNodeEnd2);
            }
        }
    }

    protected void addHandlerActionStatus(List list, AgendaItem agendaItem) {
        list.add("");
        list.add("Handler actions:");
        for (HandlerAction handlerAction : agendaItem.getActions()) {
            if (handlerAction.isReady()) {
                list.add(handlerAction.toString() + " ready");
                continue;
            }
            list.add(handlerAction.toString() + " not ready");
            ActionUnreadyReason actionUnreadyReason = handlerAction.getUnreadyReason();
            if (actionUnreadyReason == null) {
                list.add("   Reason unknown");
                continue;
            }
            String[] stringArray = actionUnreadyReason.getExplanation();
            for (int i = 0; i < stringArray.length; ++i) {
                list.add("   " + stringArray[i]);
            }
        }
    }

    protected void addItemConditons(List list, AgendaItem agendaItem) {
        list.add("");
        ListOfConstraint listOfConstraint = agendaItem.getModelManager().getNodeConditions(agendaItem);
        if (listOfConstraint == null || listOfConstraint.isEmpty()) {
            list.add("No conditions");
        } else {
            list.add("Conditions:");
            Iterator iterator = listOfConstraint.iterator();
            while (iterator.hasNext()) {
                list.add(iterator.next().toString());
            }
        }
    }

    protected static class ItemTextArea
    extends JTextArea {
        ItemTextArea(int n, int n2) {
            super(n, n2);
        }

        public void setEditable(boolean bl) {
            super.setEditable(bl);
            this.setForeground(bl ? MetalLookAndFeel.getBlack() : MetalLookAndFeel.getControlDisabled());
        }
    }

    protected abstract class EditPanel
    extends JPanel
    implements ActionListener,
    AgendaItemListener {
        int textCols = 50;
        int commentRows = 6;
        JTextArea itemText = new ItemTextArea(3, this.textCols);
        JTextArea commentText = new JTextArea(this.commentRows, this.textCols);
        JButton modifyButton;
        Box newItemButtons = Box.createHorizontalBox();
        Box editItemButtons = Box.createHorizontalBox();
        AgendaItem editingItem = null;

        EditPanel() {
            this.setLayout(new BoxLayout(this, 1));
        }

        protected abstract void setUp();

        protected Box makeLeftLabel(String string) {
            return this.makeLeftLabel(new JLabel(string));
        }

        protected Box makeLeftLabel(JLabel jLabel) {
            Box box = Box.createHorizontalBox();
            box.add(jLabel);
            box.add(Box.createHorizontalGlue());
            return box;
        }

        protected JButton makeButton(String string) {
            JButton jButton = new JButton(string);
            jButton.addActionListener(CatchingActionListener.listener(this));
            return jButton;
        }

        AgendaItem getEditingItem() {
            return this.editingItem;
        }

        void setEditingItem(AgendaItem agendaItem) {
            this.editingItem = agendaItem;
        }

        void showItem(AgendaItem agendaItem) {
            this.setEditingItem(agendaItem);
            agendaItem.addItemListener(this);
            this.itemText.setText(PatternParser.unparse(agendaItem.getPattern()));
            this.itemText.setEditable(false);
            this.commentText.setText(agendaItem.getComments());
            this.commentText.setEnabled(true);
            this.ensureButtons(this.editItemButtons);
            Status status = agendaItem.getStatus();
            if (status == Status.BLANK || status == Status.POSSIBLE) {
                this.modifyButton.setEnabled(true);
            }
            ItemEditor.this.frame.validate();
            ItemEditor.this.showViewsIfVisible(agendaItem);
        }

        void showNewItem() {
            this.setEditingItem(null);
            this.itemText.setText("");
            this.itemText.setEditable(true);
            this.commentText.setText("");
            this.commentText.setEnabled(true);
            this.ensureButtons(this.newItemButtons);
            ItemEditor.this.frame.validate();
            ItemEditor.this.clearViews();
        }

        void ensureButtons(Box box) {
            Component component = this.getComponent(this.getComponentCount() - 1);
            Debug.expect(component == this.newItemButtons || component == this.editItemButtons);
            if (component != box) {
                this.remove(component);
                this.add(box);
                this.repaint();
            }
        }

        public abstract void actionPerformed(ActionEvent var1);

        void addItem() {
            Debug.expect(this.editingItem == null);
            try {
                AgendaItem agendaItem = this.getItem();
                if (agendaItem != null) {
                    ItemEditor.this.agendaViewer.addItem(agendaItem);
                    this.showItem(agendaItem);
                }
            }
            catch (Exception exception) {
                Debug.displayException("Cannot add the item", exception);
            }
        }

        AgendaItem getItem() {
            if (this.editingItem != null) {
                return this.editingItem;
            }
            String string = this.itemText.getText().trim();
            String string2 = this.commentText.getText();
            if (string.length() == 0) {
                JOptionPane.showMessageDialog(ItemEditor.this.frame, "Empty item text", "Invalid item", 0);
                return null;
            }
            LList lList = PatternParser.parse(string);
            if (lList.length() < 1) {
                throw new RuntimeException("Empty item pattern");
            }
            AgendaItem agendaItem = ItemEditor.this.agendaViewer.makeItem(lList);
            if (!string2.trim().equals("")) {
                agendaItem.setComments(string2);
            }
            return agendaItem;
        }

        void modifyItem() {
            Debug.expect(this.editingItem != null);
            this.editingItem.setComments(this.commentText.getText());
        }

        void copyItem() {
            Debug.noteln("Copying item");
            Debug.expect(this.editingItem != null, "no item being edited");
            Debug.expect(this.editingItem.getAbout() != null, "no edited item about");
            LList lList = (LList)Variable.revertVars(this.editingItem.getAbout().getPattern());
            this.itemText.setText(PatternParser.unparse(lList));
            this.setEditingItem(null);
            this.itemText.setEditable(true);
            this.commentText.setEnabled(true);
            this.ensureButtons(this.newItemButtons);
            ItemEditor.this.frame.validate();
        }

        public void statusChanged(AgendaItemEvent agendaItemEvent) {
            AgendaItem agendaItem = (AgendaItem)agendaItemEvent.getSource();
            if (agendaItem != this.editingItem) {
                return;
            }
            Debug.noteln("Status change while editing item", (Object)agendaItem);
            Status status = agendaItem.getStatus();
            if (status == Status.BLANK || status != Status.POSSIBLE) {
                // empty if block
            }
        }

        public void priorityChanged(AgendaItemEvent agendaItemEvent) {
            AgendaItem agendaItem = (AgendaItem)agendaItemEvent.getSource();
            if (agendaItem != this.editingItem) {
                return;
            }
            Debug.noteln("Priority change while editing item", (Object)agendaItem);
        }

        public void handlerActionsChanged(AgendaItemEvent agendaItemEvent) {
            AgendaItem agendaItem = (AgendaItem)agendaItemEvent.getSource();
            if (agendaItem != this.editingItem) {
                return;
            }
            Debug.noteln("Handler actions changed while editing item", (Object)agendaItem);
        }

        public void newHandlerAction(AgendaItemEvent agendaItemEvent, HandlerAction handlerAction) {
            AgendaItem agendaItem = (AgendaItem)agendaItemEvent.getSource();
            if (agendaItem != this.editingItem) {
                return;
            }
            Debug.noteln("New handler action while editing item", (Object)agendaItem);
        }

        public void newReport(AgendaItemEvent agendaItemEvent, Report report) {
            AgendaItem agendaItem = (AgendaItem)agendaItemEvent.getSource();
            if (agendaItem != this.editingItem) {
                return;
            }
            Debug.noteln("New report while editing item", (Object)agendaItem);
            this.takeChangedComments();
        }

        public void agendaItemEdited(AgendaItemEvent agendaItemEvent) {
            AgendaItem agendaItem = (AgendaItem)agendaItemEvent.getSource();
            if (agendaItem != this.editingItem) {
                return;
            }
            Debug.noteln("Item edited while editing", (Object)agendaItem);
            this.takeChangedComments();
        }

        private void takeChangedComments() {
            String string = this.editingItem.getComments();
            this.commentText.setText(string);
            this.commentText.setCaretPosition(string.length());
            ItemEditor.this.frame.validate();
        }
    }

    class TreeViewFrame
    extends XMLTreeViewFrame {
        TreeViewFrame() {
            super(ItemEditor.this.agent, ItemEditor.this.agent.getAgentSymbolName() + " " + ItemEditor.this.itemType);
        }

        public void editObject(Object object) {
            this.editPanel.editDocument(ItemEditor.this.viewXMLTranslator.objectToDocument(object));
        }

        public void clear() {
            this.reset();
        }

        protected String makeHelpText() {
            LListCollector lListCollector = new LListCollector();
            lListCollector.add("This view shows a tree that exactly matches the XML.");
            lListCollector.add("");
            lListCollector.add("");
            return Strings.joinLines(lListCollector) + super.makeHelpText();
        }
    }

    class TextViewFrame
    extends TextAreaFrame {
        TextViewFrame() {
            super(ItemEditor.this.agent.getAgentSymbolName() + " " + ItemEditor.this.itemType, new String[]{"Cancel"});
        }

        public void setText(String string) {
            super.setText(string);
            this.setCaretPosition(0);
        }
    }
}

